/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTFullScreenVideoAd;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.fpangolin.ToutiaoInterstitialCallbackRouter;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class ToutiaoInterstitialAdapter
extends TPInterstitialAdapter {
    public static final String TAG = "PangleInterstitial";
    public static final float EXPRESSVIEW_WIDTH1 = 300.0f;
    public static final float EXPRESSVIEW_HEIGHT1 = 300.0f;
    public static final float EXPRESSVIEW_WIDTH2 = 300.0f;
    public static final float EXPRESSVIEW_HEIGHT2 = 450.0f;
    public static final float EXPRESSVIEW_WIDTH3 = 450.0f;
    public static final float EXPRESSVIEW_HEIGHT3 = 300.0f;
    private TTAdNative ttAdNative;
    private TTNativeExpressAd ttNativeExpressAd;
    private ToutiaoInterstitialCallbackRouter mCallbackRouter;
    private String placementId;
    private int mIsTemplateRending;
    private int fullScreenType;
    private TTAdManager mTTAdManager;
    private TTFullScreenVideoAd mFullScreenVideoAd;
    TTAdNative.FullScreenVideoAdListener fullScreenVideoAdListener = new TTAdNative.FullScreenVideoAdListener(){

        public void onError(int errorCode, String errorMsg) {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)("onError: " + errorCode + ":msg:" + errorMsg));
            if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId).loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
            }
        }

        public void onFullScreenVideoAdLoad(TTFullScreenVideoAd ttFullScreenVideoAd) {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onFullScreenVideoAdLoad: ");
            ToutiaoInterstitialAdapter.this.mFullScreenVideoAd = ttFullScreenVideoAd;
            if (ttFullScreenVideoAd != null) {
                ttFullScreenVideoAd.setFullScreenVideoAdInteractionListener(ToutiaoInterstitialAdapter.this.fullScreenVideoAdInteractionListener);
            }
            ToutiaoInterstitialAdapter.this.setFirstLoadedTime();
        }

        public void onFullScreenVideoCached() {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onFullScreenVideoCached: ");
            if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                ToutiaoInterstitialAdapter.this.setNetworkObjectAd(ToutiaoInterstitialAdapter.this.mFullScreenVideoAd);
                ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId).loadAdapterLoaded(null);
            }
        }
    };
    TTFullScreenVideoAd.FullScreenVideoAdInteractionListener fullScreenVideoAdInteractionListener = new TTFullScreenVideoAd.FullScreenVideoAdInteractionListener(){

        public void onAdShow() {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdShow: ");
            if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId).onAdShown();
                ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId).onAdVideoStart();
            }
        }

        public void onAdVideoBarClick() {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdVideoBarClick: ");
            if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId).onAdClicked();
            }
        }

        public void onAdClose() {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdClose: ");
            if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId).onAdClosed();
            }
        }

        public void onVideoComplete() {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onVideoComplete: ");
            if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId).onAdVideoEnd();
            }
        }

        public void onSkippedVideo() {
            Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onSkippedVideo: ");
        }
    };

    public void loadCustomAd(final Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        String payload;
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (this.extrasAreValid(serverExtras)) {
            this.placementId = serverExtras.get("placementId");
            payload = serverExtras.get("Bidding-Payload");
            this.fullScreenType = Integer.parseInt(serverExtras.get("full_screen_type"));
            String template = serverExtras.get("is_template_rendering");
            if (!TextUtils.isEmpty((CharSequence)template)) {
                this.mIsTemplateRending = Integer.parseInt(template);
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.mCallbackRouter = ToutiaoInterstitialCallbackRouter.getInstance();
        this.mCallbackRouter.addListener(this.placementId, this.mLoadAdapterListener);
        this.mTTAdManager = TTAdSdk.getAdManager();
        this.ttAdNative = this.mTTAdManager.createAdNative(context);
        if (!TTAdSdk.isInitSuccess()) {
            PangleInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    ToutiaoInterstitialAdapter.this.intFullScreen(context, payload);
                }

                public void onFailed(String code, String msg) {
                    if (ToutiaoInterstitialAdapter.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Third-party network SDK failed to init");
                        tpError.setErrorCode(code);
                        tpError.setErrorMessage(msg);
                        ToutiaoInterstitialAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                }
            });
        } else {
            this.intFullScreen(context, payload);
        }
    }

    private void intFullScreen(Context context, String payload) {
        Log.i((String)TAG, (String)"intFullScreen: \u5168\u5c4f\u89c6\u9891");
        int orientation = context.getResources().getConfiguration().orientation;
        AdSlot.Builder builder = new AdSlot.Builder().setCodeId(this.placementId).setSupportDeepLink(true);
        if (!TextUtils.isEmpty((CharSequence)payload)) {
            builder.withBid(payload);
        }
        if (this.mIsTemplateRending == 1) {
            Log.i((String)TAG, (String)("intFullScreen: " + this.mIsTemplateRending));
            builder.setExpressViewAcceptedSize(500.0f, 500.0f);
        }
        if (this.ttAdNative == null) {
            if (this.mCallbackRouter.getListener(this.placementId) != null) {
                this.mCallbackRouter.getListener(this.placementId).loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
            }
            return;
        }
        this.ttAdNative.loadFullScreenVideoAd(builder.build(), this.fullScreenVideoAdListener);
    }

    public void showAd() {
        Activity activity;
        if (this.mCallbackRouter != null && this.mShowListener != null) {
            this.mCallbackRouter.addShowListener(this.placementId, this.mShowListener);
        }
        if ((activity = GlobalTradPlus.getInstance().getActivity()) == null) {
            if (this.mCallbackRouter.getShowListener(this.placementId) != null) {
                this.mCallbackRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.mFullScreenVideoAd == null) {
            if (this.mCallbackRouter.getShowListener(this.placementId) != null) {
                this.mCallbackRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            }
            return;
        }
        this.mFullScreenVideoAd.showFullScreenVideoAd(activity);
    }

    public void clean() {
        super.clean();
        if (this.mFullScreenVideoAd != null) {
            this.mFullScreenVideoAd.setFullScreenVideoAdInteractionListener(null);
            this.mFullScreenVideoAd = null;
        }
        if (this.placementId != null) {
            this.mCallbackRouter.removeListeners(this.placementId);
        }
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId");
    }

    private void bindAdListener(final TTNativeExpressAd ad) {
        ad.setExpressInteractionListener(new TTNativeExpressAd.AdInteractionListener(){

            public void onAdDismiss() {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdDismiss: ");
                if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                    ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId).onAdClosed();
                }
            }

            public void onAdClicked(View view, int type) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdClicked: ");
                if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                    ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId).onAdClicked();
                }
            }

            public void onAdShow(View view, int type) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdShow: ");
                if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                    ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId).onAdShown();
                }
            }

            public void onRenderFail(View view, String msg, int code) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)("onRenderFail: code:" + code + ", msg:" + msg));
                if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                    ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId).loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(code, msg));
                }
            }

            public void onRenderSuccess(View view, float width, float height) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onRenderSuccess: ");
                ToutiaoInterstitialAdapter.this.setFirstLoadedTime();
                if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                    ToutiaoInterstitialAdapter.this.setNetworkObjectAd(ad);
                    ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId).loadAdapterLoaded(null);
                }
            }
        });
        if (ad.getInteractionType() != 4) {
            return;
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        return TTAdSdk.getAdManager().getSDKVersion();
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        PangleInitManager.getInstance().initSDK(context, localParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onSuccess: ");
                PangleInitManager.getInstance().sendInitRequest(true, "2");
                onS2STokenListener.onTokenResult(TTAdSdk.getAdManager().getBiddingToken());
            }

            public void onFailed(String code, String msg) {
                PangleInitManager.getInstance().sendInitRequest(false, "2");
                onS2STokenListener.onTokenResult("");
            }
        });
    }
}

