/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTAppOpenAd;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.splash.TPSplashAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class ToutiaoSplash
extends TPSplashAdapter {
    private static final String TAG = "PangleSplash";
    private String placementId;
    private TTAdManager mTTAdManager;
    private TTAppOpenAd appOpenAd;
    private int timeout = 5000;
    private int mOrientation = 1;

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams == null || tpParams.size() <= 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.placementId = tpParams.get("placementId");
        if (userParams != null && userParams.size() > 0) {
            int localTimeOut;
            if (userParams.containsKey("time_out") && (localTimeOut = ((Integer)userParams.get("time_out")).intValue()) >= 3000) {
                this.timeout = localTimeOut;
                Log.i((String)TAG, (String)("timeout: " + this.timeout));
            }
            if (userParams.containsKey("pangle_splash_orientation")) {
                this.mOrientation = (Integer)userParams.get("pangle_splash_orientation");
            }
        }
        if (!TTAdSdk.isInitSuccess()) {
            PangleInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    ToutiaoSplash.this.requestSplash(context);
                }

                public void onFailed(String code, String msg) {
                    if (ToutiaoSplash.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Third-party network SDK failed to init");
                        tpError.setErrorCode(code);
                        tpError.setErrorMessage(msg);
                        ToutiaoSplash.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                }
            });
        } else {
            this.requestSplash(context);
        }
    }

    private void requestSplash(Context context) {
        TTAdManager mTTAdManager = TTAdSdk.getAdManager();
        TTAdNative ttAdNative = mTTAdManager.createAdNative(context);
        AdSlot adSlot = new AdSlot.Builder().setCodeId(this.placementId).build();
        TTAdNative.AppOpenAdListener loadCallback = new TTAdNative.AppOpenAdListener(){

            public void onError(int code, String message) {
                Log.i((String)ToutiaoSplash.TAG, (String)("errorCode: " + code + " errorMessage: " + message));
                if (ToutiaoSplash.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network failed to provide an ad.");
                    tpError.setErrorCode(code + "");
                    tpError.setErrorMessage(message);
                    ToutiaoSplash.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }

            public void onAppOpenAdLoaded(TTAppOpenAd ttAppOpenAd) {
                Log.i((String)ToutiaoSplash.TAG, (String)"onAppOpenAdLoaded: ");
                ToutiaoSplash.this.appOpenAd = ttAppOpenAd;
                if (ToutiaoSplash.this.mLoadAdapterListener != null) {
                    ToutiaoSplash.this.setNetworkExtObj(ttAppOpenAd);
                    ToutiaoSplash.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }
        };
        ttAdNative.loadAppOpenAd(adSlot, loadCallback, this.timeout);
    }

    public void showAd() {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.appOpenAd == null) {
            if (this.mShowListener != null) {
                TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                tpError.setErrorMessage("appOpenAd == null");
                this.mShowListener.onAdVideoError(tpError);
            }
            return;
        }
        this.appOpenAd.setOpenAdInteractionListener(new TTAppOpenAd.AppOpenAdInteractionListener(){

            public void onAdShow() {
                Log.i((String)ToutiaoSplash.TAG, (String)"onAdShow: ");
                if (ToutiaoSplash.this.mShowListener != null) {
                    ToutiaoSplash.this.mShowListener.onAdShown();
                }
            }

            public void onAdClicked() {
                Log.i((String)ToutiaoSplash.TAG, (String)"onAdClicked: ");
                if (ToutiaoSplash.this.mShowListener != null) {
                    ToutiaoSplash.this.mShowListener.onAdClicked();
                }
            }

            public void onAdSkip() {
                Log.i((String)ToutiaoSplash.TAG, (String)"onAdSkip: ");
                if (ToutiaoSplash.this.mShowListener != null) {
                    ToutiaoSplash.this.mShowListener.onAdClosed();
                }
            }

            public void onAdCountdownToZero() {
                Log.i((String)ToutiaoSplash.TAG, (String)"onAdCountdownToZero: ");
                if (ToutiaoSplash.this.mShowListener != null) {
                    ToutiaoSplash.this.mShowListener.onAdClosed();
                }
            }
        });
        this.appOpenAd.showAppOpenAd(activity);
    }

    public void clean() {
        if (this.appOpenAd != null) {
            this.appOpenAd.setOpenAdInteractionListener(null);
            this.appOpenAd = null;
        }
    }

    public boolean isReady() {
        return true;
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        return TTAdSdk.getAdManager().getSDKVersion();
    }
}

