/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTRewardVideoAd;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.fpangolin.ToutiaoAdsInterstitialListener;
import com.tradplus.ads.fpangolin.ToutiaoInterstitialCallbackRouter;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class ToutiaoRewardVideoAdapter
extends TPRewardAdapter {
    private static final String TAG = "PangleRewardedVideo";
    private TTAdNative ttAdNative;
    private TTRewardVideoAd mttRewardVideoAd;
    private ToutiaoInterstitialCallbackRouter mCallbackRouter;
    private String appId;
    private String placementId;
    private String userId;
    private String customData;
    private int mIsTemplateRending;
    private TTAdManager mTTAdManager;

    public void loadCustomAd(final Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        String payload;
        String appId;
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (serverExtras != null && serverExtras.size() > 0) {
            appId = serverExtras.get("appId");
            this.placementId = serverExtras.get("placementId");
            String template = serverExtras.get("is_template_rendering");
            payload = serverExtras.get("Bidding-Payload");
            if (!TextUtils.isEmpty((CharSequence)template)) {
                this.mIsTemplateRending = Integer.parseInt(template);
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (localExtras != null && localExtras.size() > 0) {
            if (localExtras.containsKey("user_id")) {
                this.userId = (String)localExtras.get("user_id");
                if (TextUtils.isEmpty((CharSequence)this.userId)) {
                    this.userId = "";
                }
            }
            if (localExtras.containsKey("custom_data")) {
                this.customData = (String)localExtras.get("custom_data");
                if (TextUtils.isEmpty((CharSequence)this.customData)) {
                    this.customData = "";
                }
            }
        }
        Log.i((String)TAG, (String)("loadInterstitial appId: " + appId + ":PId:" + this.placementId + ":adm:" + payload));
        this.mCallbackRouter = ToutiaoInterstitialCallbackRouter.getInstance();
        this.mCallbackRouter.addListener(this.placementId, this.mLoadAdapterListener);
        this.mTTAdManager = TTAdSdk.getAdManager();
        this.ttAdNative = this.mTTAdManager.createAdNative(context);
        if (!TTAdSdk.isInitSuccess()) {
            final String ttAdm = payload;
            PangleInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    ToutiaoRewardVideoAdapter.this.requestInterstitial(context, ttAdm);
                }

                public void onFailed(String code, String msg) {
                    if (ToutiaoRewardVideoAdapter.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Third-party network SDK failed to init");
                        tpError.setErrorCode(code);
                        tpError.setErrorMessage(msg);
                        ToutiaoRewardVideoAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                }
            });
        } else {
            this.requestInterstitial(context, payload);
        }
    }

    private void requestInterstitial(Context context, String payload) {
        int ori = context.getResources().getConfiguration().orientation;
        Log.i((String)TAG, (String)("RewardData: userId : " + this.userId + ", customData :" + this.customData));
        AdSlot.Builder builder = new AdSlot.Builder().setCodeId(this.placementId).setSupportDeepLink(true).setAdCount(1).setImageAcceptedSize(1080, 1920).setUserID(TextUtils.isEmpty((CharSequence)this.userId) ? "" : this.userId).setMediaExtra(TextUtils.isEmpty((CharSequence)this.customData) ? "" : this.customData);
        if (!TextUtils.isEmpty((CharSequence)payload)) {
            builder.withBid(payload);
        }
        if (this.mIsTemplateRending == 1) {
            Log.i((String)"ToutiaoRewardVideo", (String)("initRewardVideo: " + this.mIsTemplateRending));
            builder.setExpressViewAcceptedSize(500.0f, 500.0f);
        }
        if (this.ttAdNative == null) {
            if (this.mCallbackRouter.getListener(this.placementId) != null) {
                this.mCallbackRouter.getListener(this.placementId).loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
            }
            return;
        }
        this.ttAdNative.loadRewardVideoAd(builder.build(), new TTAdNative.RewardVideoAdListener(){

            public void onError(int i, String s) {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)("onError: " + i + ":msg:" + s));
                if (ToutiaoRewardVideoAdapter.this.mCallbackRouter.getListener(ToutiaoRewardVideoAdapter.this.placementId) != null) {
                    ToutiaoRewardVideoAdapter.this.mCallbackRouter.getListener(ToutiaoRewardVideoAdapter.this.placementId).loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(i, s));
                }
            }

            public void onRewardVideoAdLoad(TTRewardVideoAd ttRewardVideoAd) {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)"onRewardVideoAdLoad: ");
                ToutiaoRewardVideoAdapter.this.setFirstLoadedTime();
                ToutiaoRewardVideoAdapter.this.mttRewardVideoAd = ttRewardVideoAd;
            }

            public void onRewardVideoCached() {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)"onRewardVideoCached: ");
                ToutiaoRewardVideoAdapter.this.mttRewardVideoAd.setRewardAdInteractionListener((TTRewardVideoAd.RewardAdInteractionListener)new ToutiaoAdsInterstitialListener(ToutiaoRewardVideoAdapter.this.placementId));
                if (ToutiaoRewardVideoAdapter.this.mCallbackRouter.getListener(ToutiaoRewardVideoAdapter.this.placementId) != null) {
                    ToutiaoRewardVideoAdapter.this.setNetworkObjectAd(ToutiaoRewardVideoAdapter.this.mttRewardVideoAd);
                    ToutiaoRewardVideoAdapter.this.mCallbackRouter.getListener(ToutiaoRewardVideoAdapter.this.placementId).loadAdapterLoaded(null);
                }
            }
        });
    }

    public void showAd() {
        Activity activity;
        if (this.mCallbackRouter != null && this.mShowListener != null) {
            this.mCallbackRouter.addShowListener(this.placementId, this.mShowListener);
        }
        if ((activity = GlobalTradPlus.getInstance().getActivity()) == null) {
            if (this.mCallbackRouter.getShowListener(this.placementId) != null) {
                this.mCallbackRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.mttRewardVideoAd == null) {
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Didn't find valid adv.Show Failed"));
            }
            return;
        }
        this.mttRewardVideoAd.showRewardVideoAd(activity);
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    public void clean() {
        super.clean();
        if (this.mttRewardVideoAd != null) {
            this.mttRewardVideoAd.setRewardAdInteractionListener(null);
            this.mttRewardVideoAd = null;
        }
        if (this.placementId != null) {
            this.mCallbackRouter.removeListeners(this.placementId);
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        return TTAdSdk.getAdManager().getSDKVersion();
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        PangleInitManager.getInstance().initSDK(context, localParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)"onSuccess: ");
                PangleInitManager.getInstance().sendInitRequest(true, "2");
                onS2STokenListener.onTokenResult(TTAdSdk.getAdManager().getBiddingToken());
            }

            public void onFailed(String code, String msg) {
                PangleInitManager.getInstance().sendInitRequest(false, "2");
                onS2STokenListener.onTokenResult("");
            }
        });
    }
}

