/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.bytedance.sdk.openadsdk.api.init.PAGSdk;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenAd;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenAdLoadListener;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenRequest;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.splash.TPSplashAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class ToutiaoSplash
extends TPSplashAdapter {
    private static final String TAG = "PangleSplash";
    private String placementId;
    private int timeout = 5000;
    private PAGAppOpenAd mPAGAppOpenAd;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams == null || tpParams.size() <= 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.placementId = tpParams.get("placementId");
        if (userParams != null && userParams.size() > 0) {
            int localTimeOut;
            if (userParams.containsKey("time_out") && (localTimeOut = ((Integer)userParams.get("time_out")).intValue()) >= 3000) {
                this.timeout = localTimeOut;
                Log.i((String)TAG, (String)("timeout: " + this.timeout));
            }
            if (userParams.containsKey("pangle_splash_orientation")) {
                // empty if block
            }
        }
        PangleInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                ToutiaoSplash.this.requestSplash();
            }

            public void onFailed(String code, String msg) {
                if (ToutiaoSplash.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    ToutiaoSplash.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestSplash() {
        PAGAppOpenRequest request = new PAGAppOpenRequest();
        request.setTimeout(this.timeout);
        PAGAppOpenAd.loadAd((String)this.placementId, (PAGAppOpenRequest)request, (PAGAppOpenAdLoadListener)new PAGAppOpenAdLoadListener(){

            public void onError(int code, String message) {
                Log.i((String)ToutiaoSplash.TAG, (String)("onError: code \uff1a" + code + ", message \uff1a" + message));
                if (ToutiaoSplash.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network failed to provide an ad.");
                    tpError.setErrorCode(code + "");
                    tpError.setErrorMessage(message);
                    ToutiaoSplash.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }

            public void onAdLoaded(PAGAppOpenAd pagAppOpenAd) {
                ToutiaoSplash.this.mPAGAppOpenAd = pagAppOpenAd;
                Log.i((String)ToutiaoSplash.TAG, (String)"onAdLoaded: ");
                if (ToutiaoSplash.this.mLoadAdapterListener != null) {
                    ToutiaoSplash.this.setNetworkExtObj(pagAppOpenAd);
                    ToutiaoSplash.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }
        });
    }

    public void showAd() {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            Log.i((String)TAG, (String)"showAd, activity == null");
            return;
        }
        if (this.mPAGAppOpenAd == null) {
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
            }
            Log.i((String)TAG, (String)"showAd, PAGAppOpenAd == null");
            return;
        }
        this.mPAGAppOpenAd.setAdInteractionListener(new PAGAppOpenAdInteractionListener(){

            public void onAdShowed() {
                Log.i((String)ToutiaoSplash.TAG, (String)"onAdShow: ");
                if (ToutiaoSplash.this.mShowListener != null) {
                    ToutiaoSplash.this.mShowListener.onAdShown();
                }
            }

            public void onAdClicked() {
                Log.i((String)ToutiaoSplash.TAG, (String)"onAdClicked: ");
                if (ToutiaoSplash.this.mShowListener != null) {
                    ToutiaoSplash.this.mShowListener.onAdClicked();
                }
            }

            public void onAdDismissed() {
                Log.i((String)ToutiaoSplash.TAG, (String)"onAdDismissed: ");
                if (ToutiaoSplash.this.mShowListener != null) {
                    ToutiaoSplash.this.mShowListener.onAdClosed();
                }
            }
        });
        this.mPAGAppOpenAd.show(activity);
    }

    public void clean() {
        if (this.mPAGAppOpenAd != null) {
            this.mPAGAppOpenAd.setAdInteractionListener(null);
            this.mPAGAppOpenAd = null;
        }
    }

    public boolean isReady() {
        return true;
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        return PAGSdk.getSDKVersion();
    }
}

