/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAd;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdLoadListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerRequest;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerSize;
import com.bytedance.sdk.openadsdk.api.init.PAGSdk;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class TouTiaoBanner
extends TPBannerAdapter {
    private String mPlacementId;
    private PAGBannerAd mBannerAd;
    private TPBannerAdImpl mTpBannerAd;
    private String mAdSize = "1";
    private static final String TAG = "PangleBanner";
    private String payload;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams != null && tpParams.size() > 0) {
            this.mPlacementId = tpParams.get("placementId");
            this.payload = tpParams.get("Bidding-Payload");
            if (tpParams.containsKey("ad_size" + this.mPlacementId)) {
                this.mAdSize = tpParams.get("ad_size" + this.mPlacementId);
            }
        }
        this.setAdHeightAndWidthByUser(userParams);
        final String ttAdm = this.payload;
        PangleInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                TouTiaoBanner.this.requestBanner(ttAdm);
            }

            public void onFailed(String code, String msg) {
                if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestBanner(String bidAdm) {
        PAGBannerRequest bannerRequest = new PAGBannerRequest(this.calculateAdSize(this.mAdSize));
        if (!TextUtils.isEmpty((CharSequence)bidAdm)) {
            bannerRequest.setAdString(bidAdm);
        }
        PAGBannerAd.loadAd((String)this.mPlacementId, (PAGBannerRequest)bannerRequest, (PAGBannerAdLoadListener)new PAGBannerAdLoadListener(){

            public void onError(int code, String message) {
                Log.i((String)TouTiaoBanner.TAG, (String)("onError: code \uff1a" + code + ", message \uff1a" + message));
                if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                    TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(code, message));
                }
            }

            public void onAdLoaded(PAGBannerAd bannerAd) {
                if (bannerAd == null) {
                    if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                        TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
                    }
                    Log.i((String)TouTiaoBanner.TAG, (String)"onAdLoaded, but bannerAd == null");
                    return;
                }
                TouTiaoBanner.this.mBannerAd = bannerAd;
                View bannerView = bannerAd.getBannerView();
                if (bannerView == null) {
                    if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                        TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
                    }
                    Log.i((String)TouTiaoBanner.TAG, (String)"onAdLoaded, but bannerView == null");
                    return;
                }
                bannerAd.setAdInteractionListener(new PAGBannerAdInteractionListener(){

                    public void onAdShowed() {
                        Log.i((String)TouTiaoBanner.TAG, (String)"onAdShowed: ");
                        if (TouTiaoBanner.this.mTpBannerAd != null) {
                            TouTiaoBanner.this.mTpBannerAd.adShown();
                        }
                    }

                    public void onAdClicked() {
                        Log.i((String)TouTiaoBanner.TAG, (String)"onAdClicked: ");
                        if (TouTiaoBanner.this.mTpBannerAd != null) {
                            TouTiaoBanner.this.mTpBannerAd.adClicked();
                        }
                    }

                    public void onAdDismissed() {
                        Log.i((String)TouTiaoBanner.TAG, (String)"onAdDismissed: ");
                        if (TouTiaoBanner.this.mTpBannerAd != null) {
                            TouTiaoBanner.this.mTpBannerAd.adClosed();
                        }
                    }
                });
                TouTiaoBanner.this.mTpBannerAd = new TPBannerAdImpl((Object)bannerAd, bannerView);
                if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                    TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)TouTiaoBanner.this.mTpBannerAd);
                }
            }
        });
    }

    public void clean() {
        if (this.mBannerAd != null) {
            this.mBannerAd.destroy();
            this.mBannerAd = null;
        }
    }

    private PAGBannerSize calculateAdSize(String adSize) {
        if (adSize.equals("1")) {
            return PAGBannerSize.BANNER_W_320_H_50;
        }
        if (adSize.equals("2")) {
            return PAGBannerSize.BANNER_W_300_H_250;
        }
        if (adSize.equals("3")) {
            return PAGBannerSize.BANNER_W_728_H_90;
        }
        return PAGBannerSize.BANNER_W_320_H_50;
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        return PAGSdk.getSDKVersion();
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        PangleInitManager.getInstance().initSDK(context, localParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                Log.i((String)TouTiaoBanner.TAG, (String)"onSuccess: ");
                PangleInitManager.getInstance().sendInitRequest(true, "2");
                onS2STokenListener.onTokenResult(PAGSdk.getBiddingToken());
            }

            public void onFailed(String code, String msg) {
                PangleInitManager.getInstance().sendInitRequest(false, "2");
                onS2STokenListener.onTokenResult("");
            }
        });
    }
}

