/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.sdk.openadsdk.api.init.PAGSdk;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardItem;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAd;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAdLoadListener;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedRequest;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.fpangolin.ToutiaoInterstitialCallbackRouter;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ToutiaoRewardVideoAdapter
extends TPRewardAdapter {
    private static final String TAG = "PangleRewardedVideo";
    private ToutiaoInterstitialCallbackRouter mCallbackRouter;
    private PAGRewardedAd mPAGRewardedAd;
    private String placementId;
    private String userId;
    private String customData;
    private boolean hasGrantedReward = false;
    private boolean alwaysRewardUser;

    public void loadCustomAd(final Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        String payload;
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (serverExtras != null && serverExtras.size() > 0) {
            this.placementId = serverExtras.get("placementId");
            payload = serverExtras.get("Bidding-Payload");
            if (!TextUtils.isEmpty((CharSequence)serverExtras.get("always_reward"))) {
                int rewardUser = Integer.parseInt(serverExtras.get("always_reward"));
                this.alwaysRewardUser = rewardUser == 1;
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (localExtras != null && localExtras.size() > 0) {
            if (localExtras.containsKey("user_id")) {
                this.userId = (String)localExtras.get("user_id");
                if (TextUtils.isEmpty((CharSequence)this.userId)) {
                    this.userId = "";
                }
            }
            if (localExtras.containsKey("custom_data")) {
                this.customData = (String)localExtras.get("custom_data");
                if (TextUtils.isEmpty((CharSequence)this.customData)) {
                    this.customData = "";
                }
            }
        }
        this.mCallbackRouter = ToutiaoInterstitialCallbackRouter.getInstance();
        this.mCallbackRouter.addListener(this.placementId, this.mLoadAdapterListener);
        final String ttAdm = payload;
        PangleInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                ToutiaoRewardVideoAdapter.this.requestInterstitial(context, ttAdm);
            }

            public void onFailed(String code, String msg) {
                if (ToutiaoRewardVideoAdapter.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    ToutiaoRewardVideoAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestInterstitial(Context context, String payload) {
        PAGRewardedRequest pagRewardedRequest = new PAGRewardedRequest();
        if (!TextUtils.isEmpty((CharSequence)payload)) {
            pagRewardedRequest.setAdString(payload);
        }
        JSONObject jsonObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.customData) || !TextUtils.isEmpty((CharSequence)this.userId)) {
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                jsonObject = new JSONObject();
                if (!TextUtils.isEmpty((CharSequence)this.userId)) {
                    jsonObject.put("user_id", (Object)this.userId);
                }
                if (!TextUtils.isEmpty((CharSequence)this.customData)) {
                    jsonObject.put("custom_data", (Object)this.customData);
                }
                map.put("media_extra", jsonObject.toString());
                Log.i((String)TAG, (String)("RewardData: userId : " + this.userId + ", customData :" + this.customData));
                pagRewardedRequest.setExtraInfo(map);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        PAGRewardedAd.loadAd((String)this.placementId, (PAGRewardedRequest)pagRewardedRequest, (PAGRewardedAdLoadListener)new PAGRewardedAdLoadListener(){

            public void onError(int code, String message) {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)("onError: code \uff1a" + code + ", message \uff1a" + message));
                if (ToutiaoRewardVideoAdapter.this.mCallbackRouter.getListener(ToutiaoRewardVideoAdapter.this.placementId) != null) {
                    ToutiaoRewardVideoAdapter.this.mCallbackRouter.getListener(ToutiaoRewardVideoAdapter.this.placementId).loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(code, message));
                }
            }

            public void onAdLoaded(PAGRewardedAd pagRewardedAd) {
                if (pagRewardedAd == null) {
                    if (ToutiaoRewardVideoAdapter.this.mCallbackRouter.getListener(ToutiaoRewardVideoAdapter.this.placementId) != null) {
                        ToutiaoRewardVideoAdapter.this.mCallbackRouter.getListener(ToutiaoRewardVideoAdapter.this.placementId).loadAdapterLoadFailed(new TPError("Unspecified error."));
                    }
                    Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)"onAdLoaded ,but pagRewardedAd == null");
                    return;
                }
                ToutiaoRewardVideoAdapter.this.mPAGRewardedAd = pagRewardedAd;
                if (ToutiaoRewardVideoAdapter.this.mCallbackRouter.getListener(ToutiaoRewardVideoAdapter.this.placementId) != null) {
                    ToutiaoRewardVideoAdapter.this.setNetworkObjectAd(pagRewardedAd);
                    ToutiaoRewardVideoAdapter.this.mCallbackRouter.getListener(ToutiaoRewardVideoAdapter.this.placementId).loadAdapterLoaded(null);
                }
            }
        });
    }

    public void showAd() {
        Activity activity;
        if (this.mCallbackRouter != null && this.mShowListener != null) {
            this.mCallbackRouter.addShowListener(this.placementId, this.mShowListener);
        }
        if ((activity = GlobalTradPlus.getInstance().getActivity()) == null) {
            if (this.mCallbackRouter.getShowListener(this.placementId) != null) {
                this.mCallbackRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            Log.i((String)TAG, (String)"showAd, activity == null");
            return;
        }
        if (this.mPAGRewardedAd == null) {
            if (this.mCallbackRouter.getShowListener(this.placementId) != null) {
                this.mCallbackRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Unspecified error."));
            }
            Log.i((String)TAG, (String)"showAd, PAGRewardedAd == null");
            return;
        }
        this.mPAGRewardedAd.setAdInteractionListener(new PAGRewardedAdInteractionListener(){

            public void onUserEarnedReward(PAGRewardItem pagRewardItem) {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)"onUserEarnedReward: ");
                ToutiaoRewardVideoAdapter.this.hasGrantedReward = true;
            }

            public void onUserEarnedRewardFail(int i, String s) {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)("onUserEarnedRewardFail: code :" + i + ",msg :" + s));
            }

            public void onAdShowed() {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)"onAdShowed: ");
                if (ToutiaoRewardVideoAdapter.this.mCallbackRouter.getShowListener(ToutiaoRewardVideoAdapter.this.placementId) != null) {
                    ToutiaoRewardVideoAdapter.this.mCallbackRouter.getShowListener(ToutiaoRewardVideoAdapter.this.placementId).onAdVideoStart();
                    ToutiaoRewardVideoAdapter.this.mCallbackRouter.getShowListener(ToutiaoRewardVideoAdapter.this.placementId).onAdShown();
                }
            }

            public void onAdClicked() {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)"onAdClicked: ");
                if (ToutiaoRewardVideoAdapter.this.mCallbackRouter.getShowListener(ToutiaoRewardVideoAdapter.this.placementId) != null) {
                    ToutiaoRewardVideoAdapter.this.mCallbackRouter.getShowListener(ToutiaoRewardVideoAdapter.this.placementId).onAdClicked();
                }
            }

            public void onAdDismissed() {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)"onAdDismissed: ");
                if (ToutiaoRewardVideoAdapter.this.mCallbackRouter.getShowListener(ToutiaoRewardVideoAdapter.this.placementId) != null) {
                    ToutiaoRewardVideoAdapter.this.mCallbackRouter.getShowListener(ToutiaoRewardVideoAdapter.this.placementId).onAdVideoEnd();
                    if (ToutiaoRewardVideoAdapter.this.hasGrantedReward || ToutiaoRewardVideoAdapter.this.alwaysRewardUser) {
                        ToutiaoRewardVideoAdapter.this.mCallbackRouter.getShowListener(ToutiaoRewardVideoAdapter.this.placementId).onReward();
                    }
                    ToutiaoRewardVideoAdapter.this.mCallbackRouter.getShowListener(ToutiaoRewardVideoAdapter.this.placementId).onAdClosed();
                }
            }
        });
        this.mPAGRewardedAd.show(activity);
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    public void clean() {
        super.clean();
        if (this.mPAGRewardedAd != null) {
            this.mPAGRewardedAd.setAdInteractionListener(null);
            this.mPAGRewardedAd = null;
        }
        if (this.placementId != null) {
            this.mCallbackRouter.removeListeners(this.placementId);
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        return PAGSdk.getSDKVersion();
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        final boolean initSuccess = PAGSdk.isInitSuccess();
        PangleInitManager.getInstance().initSDK(context, localParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                Log.i((String)ToutiaoRewardVideoAdapter.TAG, (String)("onSuccess: " + initSuccess));
                if (!initSuccess) {
                    PangleInitManager.getInstance().sendInitRequest(true, "2");
                }
                onS2STokenListener.onTokenResult(PAGSdk.getBiddingToken());
            }

            public void onFailed(String code, String msg) {
                PangleInitManager.getInstance().sendInitRequest(false, "2");
                onS2STokenListener.onTokenResult("");
            }
        });
    }
}

