/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.adapter.banner;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.common.AdapterCheckTimeOut;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import java.util.Map;

public abstract class TPBannerAdapter
extends TPBaseAdapter {
    private static final long TIME_DELTA = 30000L;
    private static final String TAG = "BannerSize";
    private AdapterCheckTimeOut mCheckTimeOut;
    public ViewGroup mAdContainerView;
    protected int mAdHeight;
    protected int mAdWidth;
    protected int mAdViewWidth;
    protected int mAdViewHeight;

    @Override
    public void init() {
        AdapterCheckTimeOut adapterCheckTimeOut;
        AdapterCheckTimeOut adapterCheckTimeOut2;
        ConfigResponse.WaterfallBean waterfallBean = this.getWaterfallBean();
        if (waterfallBean == null) {
            return;
        }
        long l = waterfallBean.getAdValidTime();
        if (l <= 0L) {
            return;
        }
        AdapterCheckTimeOut adapterCheckTimeOut3 = adapterCheckTimeOut2 = adapterCheckTimeOut;
        adapterCheckTimeOut3(30000L);
        this.mCheckTimeOut = adapterCheckTimeOut3;
        adapterCheckTimeOut.setValidTime(l * 1000L);
    }

    public void setFirstLoadedTime() {
        AdapterCheckTimeOut adapterCheckTimeOut = ((TPBannerAdapter)((Object)adapterCheckTimeOut)).mCheckTimeOut;
        if (adapterCheckTimeOut != null) {
            adapterCheckTimeOut.setFirstLoadTime();
        }
    }

    public boolean isAdsTimeOut() {
        AdapterCheckTimeOut adapterCheckTimeOut = ((TPBannerAdapter)((Object)adapterCheckTimeOut)).mCheckTimeOut;
        if (adapterCheckTimeOut != null) {
            return adapterCheckTimeOut.checkIsTimeOut();
        }
        return false;
    }

    public int getmAdViewWidth() {
        return this.mAdViewWidth;
    }

    public void setmAdViewWidth(int n) {
        this.mAdViewWidth = n;
    }

    public int getmAdViewHeight() {
        return this.mAdViewHeight;
    }

    public void setmAdViewHeight(int n) {
        this.mAdViewHeight = n;
    }

    @Override
    public boolean isReady() {
        return false;
    }

    public void setAdContainerView(ViewGroup viewGroup) {
        this.mAdContainerView = viewGroup;
    }

    public void setAdHeightAndWidthByService(String string, Map<String, String> map) {
        try {
            this.mAdHeight = Integer.parseInt(map.get("ad_size_info_y" + string));
            this.mAdWidth = Integer.parseInt(map.get("ad_size_info_x" + string));
            Log.i((String)TAG, (String)("setAdHeightAndWidthByService -- AdHeight : " + this.mAdHeight + " -- AdWidth : " + this.mAdWidth));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setDefaultAdSize(int n, int n2) {
        if (this.mAdWidth == 0 || this.mAdHeight == 0) {
            TPBannerAdapter tPBannerAdapter = this;
            tPBannerAdapter.mAdWidth = n;
            tPBannerAdapter.mAdHeight = n2;
        }
    }

    public void setDefaultAdViewSize(int n, int n2) {
        if (this.mAdViewWidth == 0 || this.mAdViewHeight == 0) {
            TPBannerAdapter tPBannerAdapter = this;
            tPBannerAdapter.mAdViewWidth = n;
            tPBannerAdapter.mAdViewHeight = n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAdHeightAndWidthByUser(Map<String, Object> map) {
        if (map == null) return;
        try {
            if (map.size() <= 0) return;
            if (map.containsKey("width")) {
                this.mAdViewWidth = (Integer)map.get("width");
            }
            if (!map.containsKey("height")) return;
            this.mAdViewHeight = (Integer)map.get("height");
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void printSize() {
        LogUtil.ownShow("TradPlusLog mAdViewWidth = " + this.mAdViewWidth + " mAdViewHeight = " + this.mAdViewHeight + " mAdWidth = " + this.mAdWidth + " mAdHeight = " + this.mAdHeight);
    }

    public void setBannerLayoutParams(View view) {
        if (view == null) {
            return;
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        if (this.mAdViewWidth > 0 && this.mAdViewHeight > 0) {
            int n = DeviceUtils.dip2px(context, this.mAdViewWidth);
            view.setLayoutParams(new ViewGroup.LayoutParams(n, DeviceUtils.dip2px(context, this.mAdViewHeight)));
        } else if (this.mAdWidth > 0 && this.mAdHeight > 0) {
            int n = DeviceUtils.dip2px(context, this.mAdWidth);
            view.setLayoutParams(new ViewGroup.LayoutParams(n, DeviceUtils.dip2px(context, this.mAdHeight)));
        }
    }

    public ViewGroup.LayoutParams getBannerParams() {
        Context context = GlobalTradPlus.getInstance().getContext();
        if (this.mAdViewWidth > 0 && this.mAdViewHeight > 0) {
            int n = DeviceUtils.dip2px(context, this.mAdViewWidth);
            return new ViewGroup.LayoutParams(n, DeviceUtils.dip2px(context, this.mAdViewHeight));
        }
        if (this.mAdWidth > 0 && this.mAdHeight > 0) {
            int n = DeviceUtils.dip2px(context, this.mAdWidth);
            return new ViewGroup.LayoutParams(n, DeviceUtils.dip2px(context, this.mAdHeight));
        }
        return new ViewGroup.LayoutParams(-2, -2);
    }
}

