/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.base.bean.TPImpCallbackInfo;
import com.tradplus.ads.base.bean.TPRewardCallbackInfo;
import com.tradplus.ads.base.common.OnCallbackPrintListener;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.network.BaseHttpRequest;
import com.tradplus.ads.base.network.TPRequestManager;
import com.tradplus.ads.base.network.TPUrlGenerator;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.TypeReference;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.util.LogUtil;
import java.util.Map;

public class TPCallbackManager
implements BaseHttpRequest.OnHttpLoaderListener {
    public static final int CALLBACK_REWARD = 0;
    public static final int CALLBACK_IMP = 1;
    private static OnCallbackPrintListener onCallbackPrintListener;
    private String url;
    private int restartCount;
    private TPAdInfo tpAdInfo;
    private ConfigResponse.WaterfallBean waterfallBean;
    private String unitId;
    private int callbackType;
    private TPBaseAdapter baseAdapter;

    public TPCallbackManager(String string, int n, TPBaseAdapter tPBaseAdapter, TPAdInfo tPAdInfo) {
        this.tpAdInfo = tPAdInfo;
        this.callbackType = n;
        this.unitId = string;
        this.waterfallBean = tPBaseAdapter.getWaterfallBean();
        this.url = this.getCallbackUrl(string, tPBaseAdapter);
        this.baseAdapter = tPBaseAdapter;
    }

    public static void setOnCallbackPrintListener(OnCallbackPrintListener onCallbackPrintListener) {
        TPCallbackManager.onCallbackPrintListener = onCallbackPrintListener;
    }

    public void startCallbackRequest() {
        TPUrlGenerator tPUrlGenerator;
        Object object = ConfigLoadManager.getInstance().getLocalConfigResponse(this.unitId);
        if (object == null) {
            return;
        }
        int n = this.callbackType;
        if (n == 0) {
            if (((ConfigResponse)object).getIs_server_callback() == 0) {
                return;
            }
        } else if (n == 1) {
            TPBaseAdapter tPBaseAdapter;
            OnCallbackPrintListener onCallbackPrintListener = TPCallbackManager.onCallbackPrintListener;
            if (onCallbackPrintListener != null && (tPBaseAdapter = this.baseAdapter) != null) {
                try {
                    onCallbackPrintListener.onPrint(tPBaseAdapter, this.tpAdInfo);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (((ConfigResponse)object).getIs_server_imp_callback() == 0) {
                return;
            }
        }
        object = tPUrlGenerator;
        ((TPUrlGenerator)object)(GlobalTradPlus.getInstance().getContext());
        tPUrlGenerator.generateCallback(this.getCallbackParams());
        TPRequestManager.getInstance().requestCallback(this.url, (TPUrlGenerator)object, this);
    }

    public Map<String, String> getCallbackParams() {
        Map<String, String> map = null;
        int n = this.callbackType;
        if (n == 0) {
            TPCallbackManager tPCallbackManager = this;
            map = tPCallbackManager.unitId;
            TPBaseAdapter tPBaseAdapter = tPCallbackManager.baseAdapter;
            TPAdInfo tPAdInfo = tPCallbackManager.tpAdInfo;
            map = JSON.parseObject(JSON.toJSONString(new TPRewardCallbackInfo((String)((Object)map), tPBaseAdapter, tPAdInfo)), new TypeReference<Map<String, String>>(){}, new Feature[0]);
        } else if (n == 1) {
            TPCallbackManager tPCallbackManager = this;
            map = tPCallbackManager.unitId;
            TPBaseAdapter tPBaseAdapter = tPCallbackManager.baseAdapter;
            TPAdInfo tPAdInfo = tPCallbackManager.tpAdInfo;
            map = JSON.parseObject(JSON.toJSONString(new TPImpCallbackInfo((String)((Object)map), tPBaseAdapter, tPAdInfo)), new TypeReference<Map<String, String>>(){}, new Feature[0]);
        }
        return map;
    }

    public String getCallbackUrl(String string, TPBaseAdapter tPBaseAdapter) {
        TPCallbackManager tPCallbackManager = object;
        Object object = "";
        int n = tPCallbackManager.callbackType;
        if (n == 0) {
            object = TPURLManager.getInstance().getRewardCallbackHost();
        } else if (n == 1) {
            object = TPURLManager.getInstance().getImpCallbackHost();
        }
        LogUtil.ownShow("callback url = " + (String)object);
        return object;
    }

    public void loadSuccess(Object object) {
    }

    @Override
    public void loadError(int n, String string) {
        if (++this.restartCount <= 2) {
            this.startCallbackRequest();
        }
    }

    @Override
    public void loadCanceled() {
    }
}

