/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.util.ACache;
import com.tradplus.ads.base.util.TradPlusDataConstants;
import com.tradplus.ads.pushcenter.utils.SendMessageUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.json.JSONArray;

public class TPCrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "CrashHandler";
    private static TPCrashHandler INSTANCE = new TPCrashHandler();
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private Context mContext;
    private volatile boolean hasInit = false;
    public CrashHandlerCallback callback;

    private TPCrashHandler() {
    }

    public static TPCrashHandler getInstance() {
        return INSTANCE;
    }

    private void clearDB() {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    StoreManager.clearConfigResponse();
                    StoreManager.clearUvaConfig();
                    ACache.get(TPCrashHandler.this.mContext, TradPlusDataConstants.CACHETRADPLUSCONFIGTYPE).clear();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        };
        new Thread(runnable2).start();
    }

    private void saveExMessage(String string) {
        Log.i((String)"CrashHandlerPrint", (String)string);
        StoreManager.saveKeyEntity("crash_message", string);
    }

    private void sendEx(final Throwable throwable) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                block5: {
                    PrintWriter printWriter;
                    StringWriter stringWriter;
                    if (stringWriter2.TPCrashHandler.this.callback == null) break block5;
                    2 v0 = stringWriter2;
                    2 v1 = v0;
                    2 v2 = v0;
                    StringWriter stringWriter2 = stringWriter;
                    stringWriter = new StringWriter();
                    PrintWriter printWriter2 = printWriter;
                    try {
                        printWriter = new PrintWriter(stringWriter2);
                        v1.throwable.printStackTrace(printWriter2);
                        v2.TPCrashHandler.this.callback.crashMsg(((Object)stringWriter2).toString());
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                }
            }
        };
        new Thread(runnable2).start();
    }

    public void init(Context context) {
        if (this.hasInit) {
            return;
        }
        this.hasInit = true;
        this.mContext = context;
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        JSONArray jSONArray;
        Throwable throwable2 = throwable;
        JSONArray jSONArray2 = jSONArray;
        jSONArray2();
        jSONArray.put((Object)throwable.toString());
        StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n; ++i) {
            jSONArray2.put((Object)stackTraceElementArray[i].toString());
        }
        try {
            super.saveExMessage(jSONArray2.toString());
        }
        catch (Throwable throwable3) {
            throwable3.printStackTrace();
        }
        TPCrashHandler tPCrashHandler = uncaughtExceptionHandler;
        tPCrashHandler.clearDB();
        tPCrashHandler.sendEx(throwable);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = tPCrashHandler.mDefaultHandler;
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.uncaughtException(thread, throwable);
        } else {
            Process.killProcess((int)Process.myPid());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pushExMessage() {
        String string;
        try {
            string = this.getExMessage();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Log.i((String)TAG, (String)("pushExMessage Throwable: " + throwable.getLocalizedMessage()));
            return;
        }
        {
            byte[] byArray;
            if (TextUtils.isEmpty((CharSequence)string)) {
                return;
            }
            if (!string.toLowerCase(Locale.ENGLISH).contains("tradplus")) return;
            byte[] byArray2 = byArray = Build.VERSION.SDK_INT >= 19 ? string.getBytes(StandardCharsets.UTF_8) : string.getBytes("utf-8");
            if (byArray.length >= 100000) {
                string = string.substring(0, 100000);
            }
            SendMessageUtil.getInstance().sendCrashMessage(this.mContext, string);
            return;
        }
    }

    public String getExMessage() {
        TPCrashHandler tPCrashHandler = object;
        Object object = "";
        object = StoreManager.getLocalKeyEntity("crash_message");
        try {
            tPCrashHandler.saveExMessage("");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return object;
    }

    public static interface CrashHandlerCallback {
        public void crashMsg(String var1);
    }
}

