/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.content.Context;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.tradplus.ads.base.Const;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.SPCacheUtil;
import com.tradplus.ads.base.util.OaidUtil;
import com.tradplus.ads.base.util.oaid.OaidCallback;
import com.tradplus.ads.common.AdvertisingIdClient;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.Dips;
import com.tradplus.ads.common.util.LogUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Locale;

public class TPDataCenter {
    private static final int TYPE_ETHERNET = 9;
    private static final String DEVICE_ORIENTATION_PORTRAIT = "p";
    private static final String DEVICE_ORIENTATION_LANDSCAPE = "l";
    private static final String DEVICE_ORIENTATION_SQUARE = "s";
    private static final String DEVICE_ORIENTATION_UNKNOWN = "u";
    private static final String IFA_PREFIX = "ifa:";
    private static final String SHA_PREFIX = "sha:";
    private static final int UNKNOWN_NETWORK = -1;
    private static volatile TPDataCenter sInstance;
    public static final int NETWORK_TYPE_UNAVAILABLE = -1;
    public static final int NETWORK_TYPE_WIFI = -101;
    public static final int NETWORK_CLASS_UNAVAILABLE = -1;
    public static final int NETWORK_CLASS_UNKNOWN = 0;
    public static final int NETWORK_CLASS_WIFI = 1;
    public static final int NETWORK_CLASS_2_G = 2;
    public static final int NETWORK_CLASS_3_G = 3;
    public static final int NETWORK_CLASS_4_G = 4;
    public static final int NETWORK_CLASS_5_G = 5;
    public static final int NETWORK_CLASS_CP_WIFI = 2;
    public static final int NETWORK_CLASS_CP_2_G = 4;
    public static final int NETWORK_CLASS_CP_3_G = 5;
    public static final int NETWORK_CLASS_CP_4_G = 6;
    public static final int NETWORK_CLASS_CP_5_G = 7;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public static final int NETWORK_TYPE_NR = 20;
    private final Context mContext;
    private final ConnectivityManager mConnectivityManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPDataCenter getInstance(Context context) {
        TPDataCenter tPDataCenter = sInstance;
        if (tPDataCenter != null) return tPDataCenter;
        Class<TPDataCenter> clazz = TPDataCenter.class;
        synchronized (TPDataCenter.class) {
            TPDataCenter tPDataCenter2;
            tPDataCenter = sInstance;
            if (tPDataCenter != null) return tPDataCenter;
            tPDataCenter = tPDataCenter2;
            sInstance = new TPDataCenter(context);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tPDataCenter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TPDataCenter getInstance() {
        TPDataCenter tPDataCenter = sInstance;
        if (tPDataCenter == null) {
            Class<TPDataCenter> clazz = TPDataCenter.class;
            synchronized (TPDataCenter.class) {
                tPDataCenter = sInstance;
            }
        }
        return tPDataCenter;
    }

    public TPDataCenter(Context context) {
        this.mContext = context.getApplicationContext();
        this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void setInstance(TPDataCenter tPDataCenter) {
        Class<TPDataCenter> clazz = TPDataCenter.class;
        synchronized (clazz) {
            sInstance = tPDataCenter;
            // ** MonitorExit[com.tradplus.ads.base.common.TPDataCenter.class] (shouldn't be in output)
            return;
        }
    }

    public static void clearForTesting() {
        sInstance = null;
    }

    public String getInstallTime(Context context) {
        StringBuilder stringBuilder;
        long l;
        try {
            l = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime / 1000L;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        return stringBuilder.append(l).append("").toString();
    }

    public String getAppVersionFromContext(Context context) {
        Context context2;
        try {
            Context context3 = context;
            context2 = context3;
            String string = context3.getPackageName();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            LogUtil.show("Failed to retrieve PackageInfo#versionName.");
            return null;
        }
        return context2.getPackageManager().getPackageInfo((String)string, (int)0).versionName;
    }

    public String getAppPackageNameFromContext(Context context) {
        Context context2;
        try {
            Context context3 = context;
            context2 = context3;
            String string = context3.getPackageName();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            LogUtil.show("Failed to retrieve PackageInfo#versionName.");
            return null;
        }
        return context2.getPackageManager().getPackageInfo((String)string, (int)0).packageName;
    }

    public void getOaid(Context object, final OnTPAdIdListener onTPAdIdListener) {
        OaidCallback oaidCallback;
        Context context = object;
        object = oaidCallback;
        oaidCallback = new OaidCallback(){

            @Override
            public void onSuccuss(String string, boolean bl) {
                Log.i((String)"tradplus", (String)("oaid = " + string + " isOaidTrackLimited = " + bl));
                OnTPAdIdListener onTPAdIdListener2 = onTPAdIdListener2.onTPAdIdListener;
                if (onTPAdIdListener2 != null) {
                    onTPAdIdListener2.onResult(string, bl);
                }
            }

            @Override
            public void onFail(String string) {
                Log.i((String)"tradplus", (String)("oaid errMsg = " + string));
            }
        };
        OaidUtil.initOaidServerAndGetOaid(context, (OaidCallback)object);
    }

    public void getAdvertisingInfo(Context context, OnTPAdIdListener onTPAdIdListener) {
        if (TradPlus.isEUTraffic(context) && TradPlus.getGDPRDataCollection(context) != 0) {
            if (onTPAdIdListener != null) {
                onTPAdIdListener.onResult("", false);
            }
        } else {
            this.getAdertisingId(context, onTPAdIdListener);
        }
    }

    public void getAdertisingId(final Context context, final OnTPAdIdListener onTPAdIdListener) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                block14: {
                    boolean bl;
                    String string;
                    block13: {
                        block12: {
                            block10: {
                                block11: {
                                    try {
                                        if (!TradPlus.isEUTraffic(onTPAdIdListener2.context)) break block10;
                                    }
                                    catch (Throwable throwable) {}
                                    if (TradPlus.getGDPRDataCollection(onTPAdIdListener2.context) == 1) break block11;
                                    if (TradPlus.getGDPRDataCollection(onTPAdIdListener2.context) != 2) break block10;
                                }
                                return;
                            }
                            if (TradPlus.invoker().isAllowTracking()) break block12;
                            return;
                        }
                        AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(onTPAdIdListener2.context);
                        AdvertisingIdClient.AdInfo adInfo2 = adInfo;
                        string = adInfo.getId();
                        bl = adInfo2.isLimitAdTrackingEnabled();
                        if (!bl) break block13;
                        string = "";
                    }
                    OnTPAdIdListener onTPAdIdListener2 = onTPAdIdListener2.onTPAdIdListener;
                    if (onTPAdIdListener2 == null) break block14;
                    onTPAdIdListener2.onResult(string, bl);
                }
            }
        };
        new Thread(runnable2).start();
    }

    public void getAdertisingIdM(final Context context, final OnTPAdIdListener onTPAdIdListener) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                block16: {
                    boolean bl;
                    String string;
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        try {
                                            if (TradPlus.invoker().isDevAllowTracking()) break block11;
                                            return;
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                    if (SPCacheUtil.getInt(onTPAdIdListener2.context, Const.SPU_NAME, "UPLOAD_DATA_LEVEL", 2) != 1) break block12;
                                    return;
                                }
                                if (!TradPlus.getGDPRChild(onTPAdIdListener2.context)) break block13;
                                return;
                            }
                            if (TradPlus.isCOPPAAgeRestrictedUser(onTPAdIdListener2.context) != 1) break block14;
                            return;
                        }
                        AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(onTPAdIdListener2.context);
                        AdvertisingIdClient.AdInfo adInfo2 = adInfo;
                        string = adInfo.getId();
                        bl = adInfo2.isLimitAdTrackingEnabled();
                        LogUtil.ownShow("mAdvertisingIdm = " + string);
                        LogUtil.ownShow("mAdvertisingLimitedm = " + bl);
                        if (!bl) break block15;
                        string = "";
                    }
                    OnTPAdIdListener onTPAdIdListener2 = onTPAdIdListener2.onTPAdIdListener;
                    if (onTPAdIdListener2 == null) break block16;
                    onTPAdIdListener2.onResult(string, bl);
                }
            }
        };
        new Thread(runnable2).start();
    }

    public String getTotalRam() {
        FileReader fileReader;
        String string = "/proc/meminfo";
        String string2 = null;
        int n = 0;
        FileReader fileReader2 = fileReader;
        fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader2, 4096);
        BufferedReader bufferedReader2 = bufferedReader;
        string2 = bufferedReader.readLine().split("\\s+")[1];
        try {
            bufferedReader2.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (string2 != null) {
            n = (int)Math.ceil(new Float(Float.valueOf(string2).floatValue() / 1048576.0f).doubleValue());
        }
        return n + "";
    }

    public int getScreenWidth(Context context) {
        DisplayMetrics displayMetrics;
        TPDataCenter tPDataCenter = displayMetrics;
        tPDataCenter();
        ((WindowManager)context.getApplicationContext().getSystemService("window")).getDefaultDisplay().getMetrics((DisplayMetrics)tPDataCenter);
        return displayMetrics.widthPixels;
    }

    public int getScreenHeight(Context context) {
        DisplayMetrics displayMetrics;
        TPDataCenter tPDataCenter = displayMetrics;
        tPDataCenter();
        ((WindowManager)context.getApplicationContext().getSystemService("window")).getDefaultDisplay().getMetrics((DisplayMetrics)tPDataCenter);
        return displayMetrics.heightPixels;
    }

    public String getLanguageCode(Context object) {
        Object object2 = Locale.getDefault().getLanguage();
        object = object.getResources().getConfiguration().locale;
        if (object != null && !((Locale)object).getLanguage().trim().isEmpty()) {
            object2 = ((Locale)object).getLanguage().trim();
        }
        return object2;
    }

    public String getOrientationString() {
        int n = this.mContext.getResources().getConfiguration().orientation;
        String string = DEVICE_ORIENTATION_UNKNOWN;
        if (n == 1) {
            string = DEVICE_ORIENTATION_PORTRAIT;
        } else if (n == 2) {
            string = DEVICE_ORIENTATION_LANDSCAPE;
        } else if (n == 3) {
            string = DEVICE_ORIENTATION_SQUARE;
        }
        return string;
    }

    public int getOrientationInt(Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    public TPNetworkType getActiveNetworkType() {
        TPDataCenter tPDataCenter = tPDataCenter.mConnectivityManager.getActiveNetworkInfo();
        return TPNetworkType.fromAndroidNetworkType(tPDataCenter != null ? tPDataCenter.getType() : -1);
    }

    public void getNetworkType(final OnTPNetworkTypeListener onTPNetworkTypeListener) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                block11: {
                    int n;
                    block10: {
                        block9: {
                            n = 0;
                            NetworkInfo networkInfo = onTPNetworkTypeListener2.TPDataCenter.this.mConnectivityManager.getActiveNetworkInfo();
                            if (networkInfo == null) break block9;
                            if (!networkInfo.isAvailable()) break block9;
                            if (!networkInfo.isConnected()) break block9;
                            int n2 = networkInfo.getType();
                            if (n2 == 1) {
                                n = -101;
                                break block10;
                            }
                            if (n2 != 0) break block10;
                            n = ((TelephonyManager)onTPNetworkTypeListener2.TPDataCenter.this.mContext.getSystemService("phone")).getNetworkType();
                            break block10;
                        }
                        n = -1;
                    }
                    OnTPNetworkTypeListener onTPNetworkTypeListener2 = onTPNetworkTypeListener2.onTPNetworkTypeListener;
                    if (onTPNetworkTypeListener2 == null) break block11;
                    try {
                        onTPNetworkTypeListener2.onResult(n);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        };
        new Thread(runnable2).start();
    }

    public float getDensity() {
        return this.mContext.getResources().getDisplayMetrics().density;
    }

    public int getDpi() {
        return this.mContext.getResources().getDisplayMetrics().densityDpi;
    }

    public String getNetworkOperator() {
        return "";
    }

    public Locale getDeviceLocale() {
        return this.mContext.getResources().getConfiguration().locale;
    }

    public int getDeviceScreenWidthDip() {
        return Dips.screenWidthAsIntDips(this.mContext);
    }

    public int getDeviceScreenHeightDip() {
        return Dips.screenHeightAsIntDips(this.mContext);
    }

    public Point getDeviceDimensions() {
        if (Preconditions.NoThrow.checkNotNull(this.mContext)) {
            return DeviceUtils.getDeviceDimensions(this.mContext);
        }
        return new Point(0, 0);
    }

    public String getDeviceType(Context context) {
        if ((context.getResources().getConfiguration().screenLayout & 0xF) >= 3) {
            return "2";
        }
        return "1";
    }

    public static interface OnTPNetworkTypeListener {
        public void onResult(int var1);
    }

    public static interface OnTPAdIdListener {
        public void onResult(String var1, boolean var2);
    }

    public static final class TPNetworkType
    extends Enum<TPNetworkType> {
        public static final /* enum */ TPNetworkType UNKNOWN;
        public static final /* enum */ TPNetworkType ETHERNET;
        public static final /* enum */ TPNetworkType WIFI;
        public static final /* enum */ TPNetworkType MOBILE;
        private static final /* synthetic */ TPNetworkType[] $VALUES;
        private final int mId;

        public static TPNetworkType[] values() {
            return (TPNetworkType[])$VALUES.clone();
        }

        public static TPNetworkType valueOf(String string) {
            return Enum.valueOf(TPNetworkType.class, string);
        }

        private TPNetworkType(int n2) {
            this.mId = n2;
        }

        private static TPNetworkType fromAndroidNetworkType(int n) {
            if (n != 9) {
                switch (n) {
                    default: {
                        return UNKNOWN;
                    }
                    case 1: {
                        return WIFI;
                    }
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                }
                return MOBILE;
            }
            return ETHERNET;
        }

        static {
            TPNetworkType tPNetworkType;
            TPNetworkType tPNetworkType2;
            TPNetworkType tPNetworkType3;
            TPNetworkType tPNetworkType4;
            TPNetworkType tPNetworkType5 = tPNetworkType4;
            UNKNOWN = new TPNetworkType(0);
            TPNetworkType tPNetworkType6 = tPNetworkType3;
            ETHERNET = new TPNetworkType(1);
            TPNetworkType tPNetworkType7 = tPNetworkType2;
            WIFI = new TPNetworkType(2);
            TPNetworkType tPNetworkType8 = tPNetworkType;
            MOBILE = new TPNetworkType(3);
            $VALUES = new TPNetworkType[]{tPNetworkType5, tPNetworkType6, tPNetworkType7, tPNetworkType8};
        }

        public String toString() {
            return Integer.toString(this.mId);
        }

        public int getId() {
            return this.mId;
        }
    }
}

