/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.tradplus.ads.base.Const;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.SPCacheUtil;
import com.tradplus.ads.base.common.TPDataCenter;
import com.tradplus.ads.base.util.OaidUtil;
import com.tradplus.ads.base.util.TestDeviceUtil;
import com.tradplus.ads.base.util.oaid.OaidCallback;
import com.tradplus.ads.common.util.CMData;
import com.tradplus.ads.pushcenter.event.utils.CPIds;
import com.tradplus.ads.pushcenter.event.utils.SegmentIds;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class TPDataManager {
    private static TPDataManager instance;
    private static final String DEBUG_MODE = "tp_debug_mode.flag";
    private static final String TEST_MODE = "tp_test_env.flag";
    private static final String CHECK_CHINA_PLUGIN = "check_china_plugin.flag";
    private TPDataCenter tpDataCenter;
    private Context context;
    private String uuId;
    private String tpGuid;
    private boolean testModeFile;
    private boolean debugModeFile;
    private boolean chinaPluginFile;
    private String mIsoCountryCode;
    private int mWidthPixels;
    private int mHeightPixels;
    private String mLanguageCode;
    private int discardconf;
    private Map<String, CPIds> cpIdsMap;
    private Map<String, SegmentIds> segmentIdsMap;
    private String mDeviceOsVersion;
    private String mSdkVersion;
    private String mAppVersion;
    private String mAppPackageName;
    private String mAppName;
    private String mDeviceType;
    private String firstInstallTime;
    private String mRam;
    private String ip;
    private String iso;
    public String mAdvertisingId;
    public boolean mAdvertisingLimited;
    private String mOaid;
    private boolean mOaidLimited;
    private int mNetworkType;

    public TPDataManager() {
        Object object;
        TPDataManager tPDataManager = string;
        tPDataManager.mNetworkType = 0;
        tPDataManager.context = object = GlobalTradPlus.getInstance().getContext();
        tPDataManager.tpDataCenter = TPDataCenter.getInstance(object);
        tPDataManager.cpIdsMap = new HashMap<String, CPIds>();
        tPDataManager.segmentIdsMap = new HashMap<String, SegmentIds>();
        tPDataManager.testModeFile = tPDataManager.checkTestMode();
        tPDataManager.debugModeFile = tPDataManager.checkDebugMode();
        tPDataManager.chinaPluginFile = tPDataManager.checkChinaPlugin();
        tPDataManager.mIsoCountryCode = tPDataManager.context.getResources().getConfiguration().locale.getCountry();
        tPDataManager.mWidthPixels = tPDataManager.tpDataCenter.getScreenWidth(((TPDataManager)((Object)string)).context);
        tPDataManager.mHeightPixels = tPDataManager.tpDataCenter.getScreenHeight(((TPDataManager)((Object)string)).context);
        tPDataManager.mDeviceOsVersion = Build.VERSION.RELEASE;
        tPDataManager.mSdkVersion = "12.2.0.1";
        tPDataManager.mAppPackageName = tPDataManager.context.getPackageName();
        object = null;
        Object object2 = tPDataManager.context.getPackageManager();
        try {
            object = object2.getApplicationInfo(((TPDataManager)((Object)string)).mAppPackageName, 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (object != null) {
            ((TPDataManager)((Object)string)).mAppName = (String)object2.getApplicationLabel((ApplicationInfo)object);
        }
        TPDataManager tPDataManager2 = string;
        tPDataManager2.mDeviceType = tPDataManager2.tpDataCenter.getDeviceType(((TPDataManager)((Object)string)).context);
        tPDataManager2.mAppVersion = tPDataManager2.tpDataCenter.getAppVersionFromContext(((TPDataManager)((Object)string)).context);
        tPDataManager2.mLanguageCode = tPDataManager2.tpDataCenter.getLanguageCode(((TPDataManager)((Object)string)).context);
        tPDataManager2.firstInstallTime = tPDataManager2.tpDataCenter.getInstallTime(((TPDataManager)((Object)string)).context);
        tPDataManager2.mRam = tPDataManager2.tpDataCenter.getTotalRam();
        tPDataManager2.tpDataCenter.getNetworkType(new TPDataCenter.OnTPNetworkTypeListener(){

            @Override
            public void onResult(int n) {
                TPDataManager.access$002(TPDataManager.this, n);
            }
        });
        object = Const.SPU_NAME;
        tPDataManager2.discardconf = SPCacheUtil.getInt(tPDataManager2.context, (String)object, "discardconf", 0);
        object2 = SPCacheUtil.getString(tPDataManager2.context, (String)object, "uid", "");
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            ((TPDataManager)((Object)string)).uuId = object2;
        } else {
            TPDataManager tPDataManager3 = string;
            String string = "UID-" + UUID.randomUUID().toString();
            tPDataManager3.uuId = string;
            SPCacheUtil.putString(tPDataManager3.context, (String)object, "uid", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPDataManager getInstance() {
        TPDataManager tPDataManager = instance;
        if (tPDataManager != null) return tPDataManager;
        Class<TPDataManager> clazz = TPDataManager.class;
        synchronized (TPDataManager.class) {
            TPDataManager tPDataManager2;
            tPDataManager = instance;
            if (tPDataManager != null) return tPDataManager;
            tPDataManager = tPDataManager2;
            instance = new TPDataManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tPDataManager;
        }
    }

    private static File getDiskCacheDir(Context object, String string) {
        object = !"mounted".equals(Environment.getExternalStorageState()) && Environment.isExternalStorageRemovable() ? object.getCacheDir().getPath() : Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
        return new File((String)object + File.separator + string);
    }

    static /* synthetic */ int access$002(TPDataManager tPDataManager, int n) {
        tPDataManager.mNetworkType = n;
        return n;
    }

    static /* synthetic */ String access$102(TPDataManager tPDataManager, String string) {
        tPDataManager.mOaid = string;
        return string;
    }

    static /* synthetic */ boolean access$202(TPDataManager tPDataManager, boolean bl) {
        tPDataManager.mOaidLimited = bl;
        return bl;
    }

    public boolean checkChinaPlugin() {
        return TPDataManager.getDiskCacheDir(this.context, CHECK_CHINA_PLUGIN).exists();
    }

    public boolean checkDebugMode() {
        return TPDataManager.getDiskCacheDir(this.context, DEBUG_MODE).exists();
    }

    public boolean checkTestMode() {
        return TPDataManager.getDiskCacheDir(this.context, TEST_MODE).exists();
    }

    public String getIsoCountryCode() {
        return this.mIsoCountryCode;
    }

    public String getUuId() {
        return this.uuId;
    }

    public void setUuId(String string) {
        this.uuId = string;
    }

    public String getAmazonAdId() {
        Object object;
        block4: {
            object = "";
            Context context = GlobalTradPlus.getInstance().getContext();
            if (context == null) break block4;
            try {
                object = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"advertising_id");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = "";
        }
        return object;
    }

    public String getGaidValue() {
        return this.getAdvertisingId();
    }

    public void setAdvertisingId(String string) {
        this.mAdvertisingId = string;
    }

    public String getGaidInfo() {
        if (TextUtils.isEmpty((CharSequence)this.mAdvertisingId)) {
            this.tpDataCenter.getAdvertisingInfo(this.context, new TPDataCenter.OnTPAdIdListener(){

                @Override
                public void onResult(String string, boolean bl) {
                    TPDataManager.this.putGaid(string);
                    TPDataManager.this.mAdvertisingLimited = bl;
                }
            });
        }
        return "";
    }

    public String getAdvertisingId() {
        String string = ((TPDataManager)this).getOaidValue();
        String string2 = TestDeviceUtil.getInstance().getTestModeId();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        if (!TradPlus.invoker().isAllowTracking()) {
            ((TPDataManager)this).putEmptyGaid();
            return "";
        }
        if (!TextUtils.isEmpty((CharSequence)(this = ((TPDataManager)this).getGaidBySP()))) {
            return this;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return "";
    }

    public void getGaidM() {
        if (!TextUtils.isEmpty((CharSequence)this.getGaidMBySP())) {
            return;
        }
        try {
            this.tpDataCenter.getAdertisingIdM(this.context, new TPDataCenter.OnTPAdIdListener(){

                @Override
                public void onResult(String string, boolean bl) {
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        3 v0 = string2;
                        String string2 = CMData.getHexM(string);
                        v0.TPDataManager.this.putGaidM(string2);
                    } else {
                        string2.TPDataManager.this.putGaidM("");
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void getOaidInfo() {
        if (GlobalTradPlus.getInstance().isAllowGetOaid() && TextUtils.isEmpty((CharSequence)this.mOaid)) {
            this.tpDataCenter.getOaid(this.context, new TPDataCenter.OnTPAdIdListener(){

                @Override
                public void onResult(String string, boolean bl) {
                    4 v0 = this;
                    TPDataManager.access$102(v0.TPDataManager.this, string);
                    TPDataManager.access$202(v0.TPDataManager.this, bl);
                }
            });
        }
    }

    public String getOaidValue() {
        if (!GlobalTradPlus.getInstance().isAllowGetOaid()) {
            this.putOaidM("");
            return "";
        }
        if (!this.isOaidLimited() && !TextUtils.isEmpty((CharSequence)this.mOaid)) {
            TPDataManager tPDataManager = this;
            tPDataManager.putOaidM(tPDataManager.mOaid);
            return tPDataManager.mOaid;
        }
        return "";
    }

    public boolean isOaidLimited() {
        return this.mOaidLimited;
    }

    public void getOaidM(OaidCallback oaidCallback) {
        if (!TestDeviceUtil.getInstance().isNeedTPAdId()) {
            oaidCallback.onFail("");
        }
        if (!TextUtils.isEmpty((CharSequence)(this = ((TPDataManager)this).getOaidMBySP()))) {
            oaidCallback.onSuccuss((String)this, true);
        }
        OaidUtil.initOaidServerAndGetOaid(GlobalTradPlus.getInstance().getContext(), oaidCallback);
    }

    public int getAdvertisingLimited() {
        if (this.mAdvertisingLimited) {
            return 1;
        }
        return 0;
    }

    public int getWidthPixels() {
        return this.mWidthPixels;
    }

    public int getHeightPixels() {
        return this.mHeightPixels;
    }

    public int getDiscardconf() {
        return this.discardconf;
    }

    public void setDiscardconf(int n) {
        this.discardconf = n;
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    public String getLanguageCode() {
        return this.mLanguageCode;
    }

    public String getDeviceOsVersion() {
        return this.mDeviceOsVersion;
    }

    public String getSdkVersion() {
        return this.mSdkVersion;
    }

    public String getAppVersion() {
        return this.mAppVersion;
    }

    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public String getDeviceType() {
        return this.mDeviceType;
    }

    public String getRam() {
        return this.mRam;
    }

    public void setRam(String string) {
        this.mRam = string;
    }

    public String getTpGuid() {
        return this.tpGuid;
    }

    public void setTpGuid(String string) {
        this.tpGuid = string;
    }

    public String getTpAdId() {
        if (!TestDeviceUtil.getInstance().isNeedTPAdId()) {
            return "";
        }
        if (!TextUtils.isEmpty((CharSequence)(this = ((TPDataManager)this).getGaidMBySP()))) {
            return this;
        }
        return "";
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public int getNetworkClassByType() {
        int n = this.mNetworkType;
        if (n != -101) {
            if (n != -1) {
                switch (n) {
                    default: {
                        return 5;
                    }
                    case 13: {
                        return 4;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 3;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                }
                return 2;
            }
            return -1;
        }
        return 1;
    }

    public int getDeviceCounByType() {
        int n = this.mNetworkType;
        if (n != -101) {
            if (n != 4 && n != 7 && n != 11) {
                if (n != 13) {
                    if (n != 20) {
                        switch (n) {
                            default: {
                                return 5;
                            }
                            case 0: {
                                return 0;
                            }
                            case -1: {
                                return -1;
                            }
                            case 1: 
                            case 2: {
                                return 4;
                            }
                        }
                    }
                    return 7;
                }
                return 6;
            }
            return 4;
        }
        return 2;
    }

    public int getOrientationInt() {
        return this.tpDataCenter.getOrientationInt(this.context);
    }

    public float getScreenSizeOfPPI() {
        TPDataManager tPDataManager = this;
        DisplayMetrics displayMetrics = tPDataManager.context.getResources().getDisplayMetrics();
        return (float)Math.sqrt(Math.pow((float)tPDataManager.getWidthPixels() / displayMetrics.xdpi, 2.0) + Math.pow((float)this.getHeightPixels() / displayMetrics.ydpi, 2.0));
    }

    public float getDensity() {
        return this.tpDataCenter.getDensity();
    }

    public int getDpi() {
        return this.tpDataCenter.getDpi();
    }

    public String getIso() {
        return this.iso;
    }

    public void setIso(String string) {
        this.iso = string;
    }

    public void putIds(String string) {
        CPIds cPIds;
        CPIds cPIds2 = cPIds;
        cPIds = new CPIds();
        ((TPDataManager)((Object)cPIds2)).cpIdsMap.put(string, cPIds2);
    }

    public CPIds getIds(String string) {
        return this.cpIdsMap.get(string);
    }

    public void putSegmentIds(String string, String string2, String string3) {
        SegmentIds segmentIds;
        SegmentIds segmentIds2 = segmentIds;
        segmentIds = new SegmentIds(string2, string3);
        ((TPDataManager)((Object)segmentIds2)).segmentIdsMap.put(string, segmentIds2);
    }

    public SegmentIds getSegmentIds(String string) {
        return this.segmentIdsMap.get(string);
    }

    public void putEmptyGaid() {
        this.mAdvertisingId = "";
        this.putGaidM("");
        SPCacheUtil.putString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "gaid", "");
    }

    public String getFirstInstallTime() {
        return this.firstInstallTime;
    }

    public void putGaid(String string) {
        SPCacheUtil.putString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "gaid", string);
    }

    public String getGaidBySP() {
        if (!TradPlus.invoker().isAllowTracking()) {
            return "";
        }
        return SPCacheUtil.getString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "gaid", "");
    }

    public void putGaidM(String string) {
        SPCacheUtil.putString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "gaidM", string);
    }

    public String getGaidMBySP() {
        return SPCacheUtil.getString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "gaidM", "");
    }

    public void putOaidM(String string) {
        SPCacheUtil.putString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "oaidM", string);
    }

    public String getOaidMBySP() {
        return SPCacheUtil.getString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "oaidM", "");
    }

    public void setDebugMode(boolean bl) {
        this.debugModeFile = bl;
    }

    public boolean isTestMode() {
        return this.testModeFile;
    }

    public boolean isDebugMode() {
        return this.debugModeFile;
    }

    public boolean isChinaPluginFile() {
        return this.chinaPluginFile;
    }
}

