/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.os.Environment;
import android.os.StatFs;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.pushcenter.reqeust.BaseRequest;
import com.tradplus.ads.pushcenter.reqeust.DBStatusRequest;
import java.io.File;

public class TPDiskManager {
    private static final long DB_PATH_MAX_SIZE = 0x1400000L;
    private static final long MIN_DISK_SIZE = 0xA00000L;
    private static TPDiskManager instance;
    private final String TAG;
    private long maxDatabaseSize = 0x1400000L;

    public TPDiskManager() {
        this.TAG = "TPDiskManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPDiskManager getInstance() {
        if (instance != null) return instance;
        Class<TPDiskManager> clazz = TPDiskManager.class;
        synchronized (TPDiskManager.class) {
            if (instance != null) return instance;
            instance = new TPDiskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteDBFile() {
        File file;
        String string = GlobalTradPlus.getInstance().getContext().getDatabasePath("tradplus.db").getPath();
        File file2 = file;
        if (!new File(string).exists()) return;
        if (!file2.isFile()) return;
        try {
            file2.delete();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return;
    }

    public long getStorageAvailableSize() {
        long l;
        StatFs statFs;
        TPDiskManager tPDiskManager = statFs;
        try {
            l = new StatFs(Environment.getExternalStorageDirectory().getPath()).getBlockSize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
        return l * (long)tPDiskManager.getAvailableBlocks();
    }

    public boolean checkStorageSize() {
        long l = this.getStorageAvailableSize() / 5L;
        if (l <= this.maxDatabaseSize) {
            this.maxDatabaseSize = l;
            if (0xA00000L >= l) {
                TPPushCenter.getInstance().setEnable(false);
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public int checkDatabaseSizeWillDelete(boolean var1_1) {
        block6: {
            block5: {
                if (!this.checkStorageSize()) break block6;
                if (!var1_1) ** GOTO lbl6
                try {
                    StoreManager.clearAll();
                    break block5;
lbl6:
                    // 1 sources

                    this.deleteDBFile();
                }
                catch (Throwable v0) {
                    v0.printStackTrace();
                }
            }
            this = v1;
            v1 = new DBStatusRequest("1");
            TPPushCenter.getInstance().saveEvent((BaseRequest)this);
            return 1;
        }
        if (this.getDBSize() > this.maxDatabaseSize) {
            try {
                StoreManager.clearAll();
            }
            catch (Throwable v2) {
                v2.printStackTrace();
            }
            this = v3;
            v3 = new DBStatusRequest("2");
            TPPushCenter.getInstance().saveEvent((BaseRequest)this);
            return 2;
        }
        return 0;
    }

    public long getDBSize() {
        block6: {
            File file;
            String string = GlobalTradPlus.getInstance().getContext().getDatabasePath("tradplus.db").getPath();
            File file2 = file;
            if (!new File(string).exists()) break block6;
            if (!file2.isFile()) break block6;
            try {
                return file2.length();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return 0L;
    }

    public long getMaxDatabaseSize() {
        return this.maxDatabaseSize;
    }

    public void setMaxDatabaseSize(long l) {
        if (l > this.maxDatabaseSize) {
            return;
        }
        this.maxDatabaseSize = l;
    }
}

