/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import com.tradplus.ads.base.Const;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.SPCacheUtil;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.common.JSONHelper;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.Json;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.event.request.SimplifyEvent;
import com.tradplus.ads.pushcenter.http.Listener;
import com.tradplus.ads.pushcenter.http.PushCenterHttpUtils;
import com.tradplus.ads.pushcenter.reqeust.BaseRequest;
import com.tradplus.ads.pushcenter.reqeust.UseTimeRequest;
import com.tradplus.ads.pushcenter.response.BaseResponse;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONObject;

public class TPUseTimeManager {
    private static final int REFRESHTIME = 5000;
    private static TPUseTimeManager instance;
    private volatile long startTime;
    private HandlerThread handlerThread;
    private Handler handler;
    private ExecutorService mSinglePool;
    private int refreshTime;
    private boolean isTrackUseTimeAllow;
    private Runnable timeRunnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPUseTimeManager getInstance() {
        if (instance != null) return instance;
        Class<TPUseTimeManager> clazz = TPUseTimeManager.class;
        synchronized (TPUseTimeManager.class) {
            if (instance != null) return instance;
            instance = new TPUseTimeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public TPUseTimeManager() {
        TPUseTimeManager tPUseTimeManager = this;
        tPUseTimeManager.refreshTime = 5000;
        tPUseTimeManager.isTrackUseTimeAllow = false;
        tPUseTimeManager.timeRunnable = new Runnable(){

            @Override
            public void run() {
                TPUseTimeManager.this.sendUseTimeRequest();
            }
        };
        tPUseTimeManager.setRefreshTime(tPUseTimeManager.refreshTime);
        tPUseTimeManager.setTrackUseTimeAllow(tPUseTimeManager.isTrackUseTimeAllow);
        this.handlerThread = new HandlerThread("tp-usetime-thread-" + System.currentTimeMillis());
        this.handlerThread.start();
        TPUseTimeManager tPUseTimeManager2 = this;
        tPUseTimeManager.handler = new Handler(tPUseTimeManager2.handlerThread.getLooper()){

            public void handleMessage(Message message) {
                super.handleMessage(message);
                int n = message.what;
                if (n != 0) {
                    if (n == 1) {
                        1 v0 = this;
                        v0.TPUseTimeManager.this.saveAppUsedStartTime(System.currentTimeMillis() - TPUseTimeManager.this.startTime);
                        TPUseTimeManager.access$202(v0.TPUseTimeManager.this, 0L);
                        v0.TPUseTimeManager.this.handler.postDelayed(TPUseTimeManager.this.timeRunnable, (long)TPUseTimeManager.this.refreshTime);
                    }
                } else {
                    1 v1 = this;
                    v1.TPUseTimeManager.this.handler.removeCallbacks(TPUseTimeManager.this.timeRunnable);
                    if (v1.TPUseTimeManager.this.startTime == 0L) {
                        1 v2 = this;
                        TPUseTimeManager.access$202(v2.TPUseTimeManager.this, System.currentTimeMillis());
                        long l = v2.TPUseTimeManager.this.getAppUsedTime();
                        if (l > 0L) {
                            TPUseTimeManager.access$222(TPUseTimeManager.this, l);
                        }
                    }
                }
            }
        };
        tPUseTimeManager.startTime = System.currentTimeMillis();
        tPUseTimeManager.mSinglePool = Executors.newSingleThreadExecutor();
    }

    public static String pushSingleMessage(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(JSONHelper.toJSON(object));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String getEventUrl(boolean bl) {
        return bl ? TPURLManager.getInstance().getTPSimplifyEventUrl() : TPURLManager.getInstance().getTPEventUrl();
    }

    static /* synthetic */ long access$202(TPUseTimeManager tPUseTimeManager, long l) {
        tPUseTimeManager.startTime = l;
        return l;
    }

    static /* synthetic */ long access$222(TPUseTimeManager tPUseTimeManager, long l) {
        tPUseTimeManager.startTime = l = tPUseTimeManager.startTime - l;
        return l;
    }

    public void onResume() {
        if (!this.isTrackUseTimeAllow) {
            return;
        }
        this.handler.sendEmptyMessage(0);
    }

    public void onPause() {
        if (!this.isTrackUseTimeAllow) {
            return;
        }
        this.handler.sendEmptyMessage(1);
    }

    public void saveUseTimeRequest() {
        Object object;
        long l = ((TPUseTimeManager)object).getAppUsedTime();
        if (l == 0L) {
            return;
        }
        if (TPPushCenter.getInstance().isSimplify()) {
            StringBuilder stringBuilder;
            SimplifyEvent simplifyEvent;
            object = simplifyEvent;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2();
            new SimplifyEvent(PushMessageUtils.PushStatus.EV_REQ_APP_USED_TIME.getValue()).setUse_time(stringBuilder.append(l).append("").toString());
            TPPushCenter.getInstance().saveEvent((SimplifyEvent)object);
        } else {
            UseTimeRequest useTimeRequest;
            object = useTimeRequest;
            useTimeRequest = new UseTimeRequest(GlobalTradPlus.getInstance().getContext(), PushMessageUtils.PushStatus.EV_REQ_APP_USED_TIME.getValue(), l);
            TPPushCenter.getInstance().saveEvent((BaseRequest)object);
        }
    }

    public void saveAppUsedStartTime(long l) {
        SPCacheUtil.putLong(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "usetime", l);
    }

    public long getAppUsedTime() {
        try {
            return SPCacheUtil.getLong(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "usetime", 0L);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
    }

    public void sendUseTimeRequest() {
        if (((TPUseTimeManager)((Object)stringBuilder2)).isTrackUseTimeAllow && TPPushCenter.getInstance().isEnable()) {
            long l = ((TPUseTimeManager)((Object)stringBuilder2)).getAppUsedTime();
            if (l == 0L) {
                return;
            }
            if (TPPushCenter.getInstance().isSimplify()) {
                StringBuilder stringBuilder;
                TPUseTimeManager tPUseTimeManager = stringBuilder2;
                SimplifyEvent simplifyEvent = new SimplifyEvent(PushMessageUtils.PushStatus.EV_REQ_APP_USED_TIME.getValue());
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2();
                simplifyEvent.setUse_time(stringBuilder.append(l).append("").toString());
                tPUseTimeManager.pushSingleEvent(simplifyEvent, true);
            } else {
                ((TPUseTimeManager)((Object)stringBuilder2)).pushSingleEvent(new UseTimeRequest(GlobalTradPlus.getInstance().getContext(), PushMessageUtils.PushStatus.EV_REQ_APP_USED_TIME.getValue(), l), false);
            }
            return;
        }
    }

    public void pushSingleEvent(Object object, boolean bl) {
        Listener listener;
        JSONObject jSONObject;
        block6: {
            JSONArray jSONArray;
            if (!this.isTrackUseTimeAllow) {
                return;
            }
            jSONObject = this.putHeaderData();
            if (!bl) break block6;
            if (jSONObject == null) {
                return;
            }
            JSONArray jSONArray2 = jSONArray;
            try {
                new JSONArray().put((Object)new JSONObject(JSON.toJSONString(object)));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                jSONObject.putOpt("cb", (Object)jSONArray2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        String string = this.getEventUrl(bl);
        object = bl ? jSONObject.toString() : TPUseTimeManager.pushSingleMessage(object);
        Object object2 = object;
        LogUtil.ownShow("eid 20 data = " + (String)object + " url = " + string);
        object = listener;
        listener = new Listener(){

            @Override
            public void onSuccess(BaseResponse baseResponse) {
                TPUseTimeManager.this.saveAppUsedStartTime(0L);
            }

            @Override
            public void oError(int n, String string) {
            }
        };
        PushCenterHttpUtils.push(string, (String)object2, (Listener)object);
    }

    public JSONObject putHeaderData() {
        JSONObject jSONObject;
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2;
        Object object = TPDataManager.getInstance();
        Object object2 = null;
        HashMap<String, String> hashMap3 = hashMap2 = hashMap;
        HashMap<String, String> hashMap4 = hashMap2;
        HashMap<String, String> hashMap5 = hashMap2;
        hashMap5();
        hashMap5.put("suuid", UUID.randomUUID().toString());
        hashMap2.put("did", ((TPDataManager)object).getUuId());
        hashMap4.put("iso", ((TPDataManager)object).getIsoCountryCode());
        hashMap4.put("app_id", TradPlus.getAppId());
        hashMap2.put("package", ((TPDataManager)object).getAppPackageName());
        hashMap3.put("sdk_ver", ((TPDataManager)object).getSdkVersion());
        hashMap3.put("os", "1");
        hashMap2.put("app_ver", ((TPDataManager)object).getAppVersion());
        hashMap2.put("device_oaid", ((TPDataManager)object).getOaidValue());
        hashMap2.put("device_osv", ((TPDataManager)object).getDeviceOsVersion());
        String string = ((TPDataManager)object).getGaidValue();
        hashMap.put("device_gaid", string);
        if (TextUtils.isEmpty((CharSequence)string)) {
            hashMap2.put("fire_adid", ((TPDataManager)object).getAmazonAdId());
        }
        object = jSONObject;
        try {
            jSONObject = new JSONObject(Json.mapToJsonString(hashMap2));
            object2 = object;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return object2;
    }

    public boolean isTrackUseTimeAllow() {
        return this.isTrackUseTimeAllow;
    }

    public void setTrackUseTimeAllow(boolean bl) {
        this.isTrackUseTimeAllow = bl;
    }

    public void setRefreshTime(int n) {
        this.refreshTime = n;
    }
}

