/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db;

import android.text.TextUtils;
import com.tradplus.ads.base.db.TableUtils;
import com.tradplus.ads.base.db.annotation.Column;
import java.lang.reflect.Field;

public final class ColumnEntity {
    private static final String PRIMARY_KEY = " primary key";
    private static final String AUTOINCREMENT = " autoincrement";
    private final String name;
    private final boolean isId;
    private final boolean isAutoId;
    private final String sql;

    ColumnEntity(Field field, Column column) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        String string = null;
        if (column == null) {
            ColumnEntity columnEntity = this;
            columnEntity.name = field.getName();
            columnEntity.isId = false;
            columnEntity.isAutoId = false;
        } else {
            string = TextUtils.isEmpty((CharSequence)column.name()) ? field.getName() : column.name();
            this.name = string;
            this.isId = column.isId();
            boolean bl = this.isId && column.autoGen();
            this.isAutoId = bl;
            string = column.property();
        }
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4();
        stringBuilder4.append("\"");
        stringBuilder3.append(this.name);
        stringBuilder3.append("\"");
        stringBuilder3.append(" ");
        stringBuilder.append(TableUtils.getTypeText(field.getType()));
        if (!TextUtils.isEmpty((CharSequence)string)) {
            StringBuilder stringBuilder5 = stringBuilder2;
            stringBuilder5.append(" default ");
            stringBuilder5.append(string);
        }
        if (this.isId) {
            stringBuilder2.append(PRIMARY_KEY);
            if (column.autoGen()) {
                stringBuilder2.append(AUTOINCREMENT);
            }
        }
        this.sql = stringBuilder2.toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isAutoId() {
        return this.isAutoId;
    }

    public String getSql() {
        return this.sql;
    }
}

