/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db;

import android.database.sqlite.SQLiteDatabase;
import com.tradplus.ads.base.db.ColumnEntity;
import com.tradplus.ads.base.db.TableUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public final class TableEntity<T> {
    private final LinkedHashMap<String, ColumnEntity> columnMap;
    private final String name;
    private final Class<T> entityType;
    private ColumnEntity id;
    private volatile boolean isExists;

    public TableEntity(Class<T> object) {
        this.entityType = object;
        this.name = ((Class)object).getSimpleName();
        object = TableUtils.findColumns(object);
        this.columnMap = object;
        for (ColumnEntity columnEntity : ((LinkedHashMap)object).values()) {
            if (!columnEntity.isId()) continue;
            this.id = columnEntity;
            break;
        }
    }

    private String createSql() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        stringBuilder3();
        stringBuilder3.append("create table if not exists ");
        stringBuilder3.append("\"");
        stringBuilder.append(((TableEntity)((Object)iterator)).name);
        stringBuilder.append("\"");
        stringBuilder.append("(");
        Iterator<ColumnEntity> iterator = ((TableEntity)((Object)iterator)).columnMap.values().iterator();
        while (iterator.hasNext()) {
            stringBuilder2.append(((ColumnEntity)iterator.next()).getSql());
            if (!iterator.hasNext()) continue;
            stringBuilder2.append(",");
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4.append(")");
        return stringBuilder4.toString();
    }

    private boolean tableExists(boolean bl, SQLiteDatabase sQLiteDatabase) {
        if (this.isExists && !bl) {
            return this.isExists;
        }
        this.isExists = TableUtils.tableExists(sQLiteDatabase, this.name);
        return this.isExists;
    }

    private void checkColumn(String[] object, SQLiteDatabase sQLiteDatabase) {
        StringBuilder stringBuilder;
        HashMap<String, ColumnEntity> hashMap;
        HashMap<String, ColumnEntity> hashMap2 = hashMap;
        hashMap = new HashMap<String, ColumnEntity>(((TableEntity)((Object)iterator)).columnMap);
        if (object != null && ((String[])object).length > 0) {
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                hashMap2.remove(object[i]);
            }
        }
        if (hashMap2.size() == 0) {
            return;
        }
        Object object2 = object = stringBuilder;
        ((StringBuilder)object2)();
        ((StringBuilder)object2).append("ALTER TABLE ");
        stringBuilder.append(((TableEntity)((Object)iterator)).name);
        stringBuilder.append(" ADD ");
        Iterator<ColumnEntity> iterator = hashMap2.values().iterator();
        while (iterator.hasNext()) {
            sQLiteDatabase.execSQL(new StringBuffer((CharSequence)object).append(((ColumnEntity)iterator.next()).getSql()).toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public ColumnEntity getId() {
        return this.id;
    }

    public void createTableIfNotExists(SQLiteDatabase sQLiteDatabase) {
        String[] stringArray = TableUtils.getColumnNames(sQLiteDatabase, this.name);
        if (stringArray == null) {
            sQLiteDatabase.execSQL(this.createSql());
            return;
        }
        try {
            this.checkColumn(stringArray, sQLiteDatabase);
        }
        catch (Exception exception) {
            TableEntity tableEntity = this;
            tableEntity.removeTableByName(sQLiteDatabase);
            sQLiteDatabase.execSQL(tableEntity.createSql());
        }
    }

    public void removeTableByName(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("drop table " + this.name);
    }
}

