/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.os.Build;
import android.text.TextUtils;
import com.tradplus.ads.base.db.TableEntity;
import com.tradplus.ads.base.db.TableUtils;
import com.tradplus.ads.base.db.api.cache.Store;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDao<T>
implements Store<String, T> {
    private SQLiteDatabase db;
    protected String id_name;
    protected String table_name;

    public BaseDao() {
        this.table_name = "null";
        this.id_name = "null";
    }

    public BaseDao(SQLiteDatabase sQLiteDatabase) {
        TableEntity tableEntity;
        BaseDao baseDao = type;
        BaseDao baseDao2 = type;
        Type type = ((ParameterizedType)baseDao2.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        TableEntity tableEntity2 = tableEntity;
        tableEntity2((Class)type);
        tableEntity.createTableIfNotExists(sQLiteDatabase);
        baseDao.db = sQLiteDatabase;
        baseDao.table_name = tableEntity2.getName();
        baseDao.id_name = tableEntity2.getId().getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void beginTransaction() {
        try {
            if (Build.VERSION.SDK_INT >= 16 && this.db.isWriteAheadLoggingEnabled()) {
                this.db.beginTransactionNonExclusive();
                return;
            }
            this.db.beginTransaction();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void setTransactionSuccessful() {
        try {
            this.db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void endTransaction() {
        try {
            this.db.endTransaction();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void save(T ... TArray) {
        block13: {
            block14: {
                if (TArray == null || TArray.length == 0) break block13;
                if (TArray.length != 1) break block14;
                SQLiteDatabase sQLiteDatabase = ((BaseDao)((Object)string)).db;
                BaseDao baseDao = string;
                T[] TArray2 = TArray;
                String string = ((BaseDao)((Object)string)).table_name;
                TArray = null;
                ContentValues contentValues = baseDao.convert(TArray2[0]);
                try {
                    sQLiteDatabase.replace(string, TArray, contentValues);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                return;
            }
            T[] TArray3 = TArray;
            BaseDao baseDao = string;
            baseDao.beginTransaction();
            SQLiteStatement sQLiteStatement = baseDao.db.compileStatement(((BaseDao)((Object)string)).createInsertStateMentSql());
            int n = TArray3.length;
            for (int i = 0; i < n; ++i) {
                ((BaseDao)((Object)string)).bindStateMent(sQLiteStatement, TArray[i]);
                sQLiteStatement.executeInsert();
            }
            try {
                String string = string;
                super.setTransactionSuccessful();
                super.endTransaction();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return;
            {
                finally {
                    ((BaseDao)((Object)string)).endTransaction();
                }
            }
        }
    }

    public void update(T ... TArray) {
        block13: {
            block14: {
                if (TArray == null || TArray.length == 0) break block13;
                if (TArray.length != 1) break block14;
                SQLiteDatabase sQLiteDatabase = ((BaseDao)((Object)string)).db;
                BaseDao baseDao = string;
                T[] TArray2 = TArray;
                String string = ((BaseDao)((Object)string)).table_name;
                TArray = null;
                ContentValues contentValues = baseDao.convert(TArray2[0]);
                try {
                    sQLiteDatabase.insertWithOnConflict(string, TArray, contentValues, 5);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                return;
            }
            T[] TArray3 = TArray;
            BaseDao baseDao = string;
            baseDao.beginTransaction();
            SQLiteStatement sQLiteStatement = baseDao.db.compileStatement(((BaseDao)((Object)string)).createUpdateStatementSql());
            int n = TArray3.length;
            for (int i = 0; i < n; ++i) {
                ((BaseDao)((Object)string)).bindUpdateStatement(sQLiteStatement, TArray[i]);
                sQLiteStatement.executeUpdateDelete();
            }
            try {
                String string = string;
                super.setTransactionSuccessful();
                super.endTransaction();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return;
            {
                finally {
                    ((BaseDao)((Object)string)).endTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T get(String string) {
        BaseDao<T> baseDao;
        Cursor cursor;
        block7: {
            String[] stringArray;
            String string2;
            SQLiteDatabase sQLiteDatabase;
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            cursor = null;
            baseDao = null;
            try {
                sQLiteDatabase = this.db;
                string2 = this.table_name;
                stringArray = null;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    break block7;
                }
                catch (Throwable throwable2) {
                    TableUtils.closeCursor(cursor);
                    throw throwable2;
                }
            }
            {
                cursor = sQLiteDatabase.query(string2, stringArray, this.id_name + "=?", new String[]{string}, null, null, null, "1");
            }
            {
                if (!cursor.moveToNext()) break block7;
                baseDao = this = this.parseCursor(cursor);
            }
        }
        TableUtils.closeCursor(cursor);
        return (T)baseDao;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> getList(int n) {
        ArrayList<T> arrayList;
        Cursor cursor;
        block6: {
            ArrayList<T> arrayList2;
            String string = null;
            if (n > 0) {
                string = String.valueOf(n);
            }
            cursor = null;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<T>();
            try {
                cursor = this.db.query(this.table_name, null, null, null, null, null, null, string);
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    break block6;
                }
                catch (Throwable throwable2) {
                    TableUtils.closeCursor(cursor);
                    throw throwable2;
                }
            }
            while (cursor.moveToNext()) {
                arrayList.add(this.parseCursor(cursor));
            }
        }
        TableUtils.closeCursor(cursor);
        return arrayList;
    }

    @Override
    public int count() {
        Cursor cursor = null;
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.db;
        String string = this.table_name;
        String[] stringArray = new String[1];
        stringArray[0] = "count(*)";
        cursor = sQLiteDatabase.query(string, stringArray, null, null, null, null, null, null);
        cursor.moveToNext();
        try {
            n = cursor.getInt(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        TableUtils.closeCursor(cursor);
        return n;
        {
            finally {
                TableUtils.closeCursor(cursor);
            }
        }
    }

    public void delete(String ... stringArray) {
        block13: {
            block14: {
                if (stringArray == null || stringArray.length == 0) break block13;
                if (stringArray.length != 1) break block14;
                SQLiteDatabase sQLiteDatabase = this.db;
                String string = this.table_name;
                String string2 = this.id_name + "=?";
                String[] stringArray2 = new String[1];
                int n = 0;
                try {
                    stringArray2[n] = stringArray[0];
                    sQLiteDatabase.delete(string, string2, stringArray2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                return;
            }
            String[] stringArray3 = stringArray;
            BaseDao baseDao = this;
            baseDao.beginTransaction();
            SQLiteStatement sQLiteStatement = baseDao.db.compileStatement("delete from " + this.table_name + " where " + this.id_name + "=?");
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                SQLiteStatement sQLiteStatement2 = sQLiteStatement;
                int n2 = 1;
                sQLiteStatement2.bindString(n2, stringArray[i]);
                sQLiteStatement2.execute();
                continue;
            }
            try {
                BaseDao baseDao2 = this;
                baseDao2.setTransactionSuccessful();
                baseDao2.endTransaction();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return;
            {
                finally {
                    this.endTransaction();
                }
            }
        }
    }

    @Override
    public void clear() {
        try {
            this.db.execSQL("delete from " + this.table_name);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected String safeText(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "";
        }
        return string;
    }

    protected abstract String getId(T var1);

    protected abstract T parseCursor(Cursor var1);

    protected abstract ContentValues convert(T var1);

    protected abstract String createInsertStateMentSql();

    protected abstract void bindStateMent(SQLiteStatement var1, T var2);

    protected abstract String createUpdateStatementSql();

    protected abstract void bindUpdateStatement(SQLiteStatement var1, T var2);
}

