/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.event.push;

import android.content.Context;
import android.util.Pair;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.event.TPMessageUtils;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.base.event.push.EventBasePushUtil;
import com.tradplus.ads.pushcenter.event.EventBaseRequest;

public class EventCrossPushUtil
extends EventBasePushUtil {
    private static String getCrossUrl() {
        return TPURLManager.getInstance().getCrossProEventUrl();
    }

    @Override
    public Pair<String[], String[]> getEvents(int n) {
        EventCrossPushUtil eventCrossPushUtil = GlobalTradPlus.getInstance().getContext();
        if (eventCrossPushUtil == null) {
            return null;
        }
        return TPMessageUtils.getCrossEvent((Context)eventCrossPushUtil, n);
    }

    @Override
    public String getPushUrl() {
        return EventCrossPushUtil.getCrossUrl();
    }

    @Override
    public void removeEvent(String ... stringArray) {
        TPMessageUtils.removeCrossEvent(stringArray);
        TPPushCenter.getInstance().pushCrossEvent();
    }

    @Override
    public void saveEvent(Object object) {
        if (object instanceof EventBaseRequest) {
            TPMessageUtils.saveCrossEvent((EventBaseRequest)object);
        }
    }

    @Override
    public void setEventTime(Object object) {
        if (object instanceof EventBaseRequest) {
            long l;
            EventBaseRequest eventBaseRequest = (EventBaseRequest)object;
            try {
                l = System.currentTimeMillis() - eventBaseRequest.getCreateTime();
            }
            catch (Exception exception) {}
            int n = (int)(l / 1000L);
            eventBaseRequest.setTime(n);
        }
    }

    @Override
    public String getLogType() {
        return "CrossPro";
    }
}

