/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.filter;

import android.text.TextUtils;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.network.TPOpenResponse;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.DateAndTime;
import java.io.Serializable;
import java.util.ArrayList;

public class NetWorkFrequencyUtils {
    private static NetWorkFrequencyUtils instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetWorkFrequencyUtils getInstance() {
        if (instance == null) {
            Class<NetWorkFrequencyUtils> clazz = NetWorkFrequencyUtils.class;
            synchronized (NetWorkFrequencyUtils.class) {
                instance = new NetWorkFrequencyUtils();
            }
        }
        return instance;
    }

    private String getFrequencyId(ConfigResponse.WaterfallBean waterfallBean) {
        if (waterfallBean.getConfig() == null) {
            return waterfallBean.getAdsource_placement_id();
        }
        return waterfallBean.getAdsource_placement_id() + waterfallBean.getConfigBean().getPlacementId();
    }

    public boolean checkAdSourceFilter(ConfigResponse.WaterfallBean object) {
        if (object == null) {
            return true;
        }
        String string = ((ConfigResponse.WaterfallBean)object).getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        object = StoreManager.getLocalTPOpenResponse(true);
        if (object != null && (object = ((TPOpenResponse)object).getAdsourceImpConfig()) != null && ((ArrayList)object).size() > 0) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                Object object2 = (TPOpenResponse.AdsourceImpConfigBean)object.next();
                if (object2 == null) continue;
                TPOpenResponse.AdsourceImpConfigBean adsourceImpConfigBean = object2;
                object2 = String.valueOf(adsourceImpConfigBean.getAdsource_id());
                int n = adsourceImpConfigBean.getLimit();
                if (TextUtils.isEmpty((CharSequence)object2) || n <= 0 || !string.equals(object2) || n > StoreManager.checkNetworkIdFrequencyShowCount((String)object2)) continue;
                CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.NETWORK_FREQUENCYLIMIT, "\u9650\u5236\u5e7f\u544a\u5e73\u53f0ID\u662f\uff1a" + (String)string);
                return false;
            }
        }
        return true;
    }

    public void addAdSourceIdShowCount(ConfigResponse.WaterfallBean waterfallBean) {
        if (waterfallBean == null) {
            return;
        }
        String string = waterfallBean.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        StoreManager.addNetworkIdFrequencyShowCount(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkNetworkFrequency(ConfigResponse.WaterfallBean serializable) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        block9: {
            block8: {
                if (serializable == null) {
                    return true;
                }
                bl3 = false;
                bl2 = false;
                bl = false;
                NetworkFrequencyBean networkFrequencyBean = StoreManager.getNetworkFrequency(this.getFrequencyId((ConfigResponse.WaterfallBean)serializable), false);
                if (networkFrequencyBean == null) {
                    NetworkFrequencyBean networkFrequencyBean2;
                    networkFrequencyBean = networkFrequencyBean2;
                    networkFrequencyBean2 = new NetworkFrequencyBean();
                }
                if ((serializable = ((ConfigResponse.WaterfallBean)serializable).getFrequency()) == null) {
                    return true;
                }
                if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day() <= 0 || !TextUtils.equals((CharSequence)networkFrequencyBean.getDayTime(), (CharSequence)DateAndTime.getDate(0)) || ((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day() > networkFrequencyBean.getDayCount()) {
                    bl3 = true;
                }
                if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour() <= 0 || !TextUtils.equals((CharSequence)networkFrequencyBean.getHourTime(), (CharSequence)DateAndTime.getDate(1)) || ((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour() > networkFrequencyBean.getHourCount()) {
                    bl2 = true;
                }
                if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min() <= 0) break block8;
                long l = System.currentTimeMillis();
                if (networkFrequencyBean.getShowTime() >= l || l - networkFrequencyBean.getShowTime() < (long)(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min() * 60000)) break block9;
            }
            bl = true;
        }
        if (!bl3) return false;
        if (!bl2) return false;
        if (!bl) return false;
        return true;
    }

    public void saveNetworkFrequency(ConfigResponse.WaterfallBean serializable) {
        if (serializable == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)(this = ((NetWorkFrequencyUtils)this).getFrequencyId((ConfigResponse.WaterfallBean)serializable)))) {
            return;
        }
        NetworkFrequencyBean networkFrequencyBean = StoreManager.getNetworkFrequency((String)this, false);
        if (networkFrequencyBean == null) {
            NetworkFrequencyBean networkFrequencyBean2;
            networkFrequencyBean = networkFrequencyBean2;
            networkFrequencyBean2 = new NetworkFrequencyBean();
        }
        if ((serializable = ((ConfigResponse.WaterfallBean)serializable).getFrequency()) == null) {
            return;
        }
        networkFrequencyBean.setCapping_day(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day());
        networkFrequencyBean.setCapping_hour(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour());
        networkFrequencyBean.setPacing_min(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min());
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day() > 0) {
            if (!TextUtils.equals((CharSequence)networkFrequencyBean.getDayTime(), (CharSequence)DateAndTime.getDate(0))) {
                NetworkFrequencyBean networkFrequencyBean3 = networkFrequencyBean;
                networkFrequencyBean3.setDayCount(1);
                networkFrequencyBean3.setDayTime(DateAndTime.getDate(0));
            } else {
                NetworkFrequencyBean networkFrequencyBean4 = networkFrequencyBean;
                networkFrequencyBean4.setDayCount(networkFrequencyBean4.getDayCount() + 1);
            }
        } else {
            networkFrequencyBean.setDayCount(0);
        }
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour() > 0) {
            if (!TextUtils.equals((CharSequence)networkFrequencyBean.getHourTime(), (CharSequence)DateAndTime.getDate(1))) {
                NetworkFrequencyBean networkFrequencyBean5 = networkFrequencyBean;
                networkFrequencyBean5.setHourCount(1);
                networkFrequencyBean5.setHourTime(DateAndTime.getDate(1));
            } else {
                NetworkFrequencyBean networkFrequencyBean6 = networkFrequencyBean;
                networkFrequencyBean6.setHourCount(networkFrequencyBean6.getHourCount() + 1);
            }
        } else {
            networkFrequencyBean.setHourCount(0);
        }
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min() > 0) {
            networkFrequencyBean.setShowTime(System.currentTimeMillis());
        }
        StoreManager.saveNetworkFrequency((String)this, networkFrequencyBean);
    }

    public void saveGroupFrequency(ConfigResponse.FrequencyBean frequencyBean, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        Object object = StoreManager.getGroupFrequency(string);
        if (object == null) {
            NetworkFrequencyBean networkFrequencyBean;
            object = networkFrequencyBean;
            networkFrequencyBean = new NetworkFrequencyBean();
        }
        if (frequencyBean == null) {
            Object object2 = object;
            ((NetworkFrequencyBean)object2).setCapping_day(0);
            ((NetworkFrequencyBean)object2).setDayCount(0);
            ((NetworkFrequencyBean)object2).setCapping_hour(0);
            ((NetworkFrequencyBean)object2).setHourCount(0);
            ((NetworkFrequencyBean)object2).setPacing_min(0);
            StoreManager.saveGroupFrequency(string, (NetworkFrequencyBean)object);
            return;
        }
        ((NetworkFrequencyBean)object).setCapping_day(frequencyBean.getCapping_day());
        ((NetworkFrequencyBean)object).setCapping_hour(frequencyBean.getCapping_hour());
        ((NetworkFrequencyBean)object).setPacing_min(frequencyBean.getPacing_min());
        if (frequencyBean.getCapping_day() > 0) {
            if (!TextUtils.equals((CharSequence)((NetworkFrequencyBean)object).getDayTime(), (CharSequence)DateAndTime.getDate(0))) {
                Object object3 = object;
                ((NetworkFrequencyBean)object3).setDayCount(0);
                ((NetworkFrequencyBean)object3).setDayTime(DateAndTime.getDate(0));
            }
        } else {
            ((NetworkFrequencyBean)object).setDayCount(0);
        }
        if (frequencyBean.getCapping_hour() > 0) {
            if (!TextUtils.equals((CharSequence)((NetworkFrequencyBean)object).getHourTime(), (CharSequence)DateAndTime.getDate(1))) {
                Object object4 = object;
                ((NetworkFrequencyBean)object4).setHourCount(0);
                ((NetworkFrequencyBean)object4).setHourTime(DateAndTime.getDate(1));
            }
        } else {
            ((NetworkFrequencyBean)object).setHourCount(0);
        }
        StoreManager.saveGroupFrequency(string, (NetworkFrequencyBean)object);
    }

    public void addGroupFrequencyShowCount(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        NetworkFrequencyBean networkFrequencyBean = StoreManager.getGroupFrequency(string);
        if (networkFrequencyBean == null) {
            return;
        }
        if (networkFrequencyBean.getCapping_day() > 0) {
            if (!TextUtils.equals((CharSequence)networkFrequencyBean.getDayTime(), (CharSequence)DateAndTime.getDate(0))) {
                NetworkFrequencyBean networkFrequencyBean2 = networkFrequencyBean;
                networkFrequencyBean2.setDayCount(1);
                networkFrequencyBean2.setDayTime(DateAndTime.getDate(0));
            } else {
                NetworkFrequencyBean networkFrequencyBean3 = networkFrequencyBean;
                networkFrequencyBean3.setDayCount(networkFrequencyBean3.getDayCount() + 1);
            }
        }
        if (networkFrequencyBean.getCapping_hour() > 0) {
            if (!TextUtils.equals((CharSequence)networkFrequencyBean.getHourTime(), (CharSequence)DateAndTime.getDate(1))) {
                Object object = networkFrequencyBean;
                ((NetworkFrequencyBean)object).setHourCount(1);
                ((NetworkFrequencyBean)object).setHourTime(DateAndTime.getDate(1));
            } else {
                NetworkFrequencyBean networkFrequencyBean4 = networkFrequencyBean;
                networkFrequencyBean4.setHourCount(networkFrequencyBean4.getHourCount() + 1);
            }
        }
        if (networkFrequencyBean.getPacing_min() > 0) {
            networkFrequencyBean.setShowTime(System.currentTimeMillis());
        }
        StoreManager.saveGroupFrequency(string, networkFrequencyBean);
    }

    public boolean checkGroupFrequency(String string) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        block8: {
            block7: {
                if (TextUtils.isEmpty((CharSequence)string)) {
                    return true;
                }
                bl3 = false;
                bl2 = false;
                bl = false;
                NetworkFrequencyBean networkFrequencyBean = StoreManager.getGroupFrequency(string);
                if (networkFrequencyBean == null) {
                    return true;
                }
                int n = networkFrequencyBean.getCapping_day();
                if (n <= 0 || !TextUtils.equals((CharSequence)networkFrequencyBean.getDayTime(), (CharSequence)DateAndTime.getDate(0)) || n > networkFrequencyBean.getDayCount()) {
                    bl3 = true;
                }
                if ((n = networkFrequencyBean.getCapping_hour()) <= 0 || !TextUtils.equals((CharSequence)networkFrequencyBean.getHourTime(), (CharSequence)DateAndTime.getDate(1)) || n > networkFrequencyBean.getHourCount()) {
                    bl2 = true;
                }
                if ((n = networkFrequencyBean.getPacing_min()) <= 0) break block7;
                long l = System.currentTimeMillis();
                if (networkFrequencyBean.getShowTime() >= l || l - networkFrequencyBean.getShowTime() < (long)(n * 60000)) break block8;
            }
            bl = true;
        }
        return bl3 && bl2 && bl;
    }

    public static class NetworkFrequencyBean
    implements Serializable {
        private String dayTime;
        private String hourTime;
        private long showTime;
        private int dayCount;
        private int hourCount;
        private int capping_hour;
        private int capping_day;
        private int pacing_min;

        public String getDayTime() {
            return this.dayTime;
        }

        public void setDayTime(String string) {
            this.dayTime = string;
        }

        public String getHourTime() {
            return this.hourTime;
        }

        public void setHourTime(String string) {
            this.hourTime = string;
        }

        public long getShowTime() {
            return this.showTime;
        }

        public void setShowTime(long l) {
            this.showTime = l;
        }

        public int getDayCount() {
            return this.dayCount;
        }

        public void setDayCount(int n) {
            this.dayCount = n;
        }

        public int getHourCount() {
            return this.hourCount;
        }

        public void setHourCount(int n) {
            this.hourCount = n;
        }

        public int getCapping_hour() {
            return this.capping_hour;
        }

        public void setCapping_hour(int n) {
            this.capping_hour = n;
        }

        public int getCapping_day() {
            return this.capping_day;
        }

        public void setCapping_day(int n) {
            this.capping_day = n;
        }

        public int getPacing_min() {
            return this.pacing_min;
        }

        public void setPacing_min(int n) {
            this.pacing_min = n;
        }

        public String toString() {
            return "NetworkFrequencyBean{dayTime='" + this.dayTime + '\'' + ", hourTime='" + this.hourTime + '\'' + ", showTime=" + this.showTime + ", dayCount=" + this.dayCount + ", hourCount=" + this.hourCount + ", capping_hour=" + this.capping_hour + ", capping_day=" + this.capping_day + ", pacing_min=" + this.pacing_min + '}';
        }
    }
}

