/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.network.util.ImageLruCache;
import com.tradplus.ads.base.network.util.ImageUrlLoader;
import com.tradplus.ads.base.network.util.ResourceEntry;
import com.tradplus.ads.common.util.LogUtil;
import java.lang.ref.WeakReference;
import java.util.AbstractSequentialList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class ImageLoader {
    private static final String TAG = "ImageLoader";
    private static final int MESSAGE_WHAT_SUCCESS = 1;
    private static final int MESSAGE_WHAT_FAILED = 2;
    private static final String MESSAGE_DATA_URL = "image_key";
    private static final String MESSAGE_DATA_DESC = "image_message";
    private static ImageLoader mInstance;
    private ImageLruCache<String, WeakReference<Bitmap>> mMemoryCache;
    private final Object mDiskCacheLock;
    Context mContext;
    private LinkedHashMap<String, List<ImageLoaderListener>> mListenerMap;
    private Handler handler;

    private ImageLoader(Context context) {
        ImageLoader imageLoader = this;
        this.mDiskCacheLock = new Object();
        this.mListenerMap = new LinkedHashMap();
        this.handler = new Handler(Looper.getMainLooper()){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public void handleMessage(Message object) {
                void var1_3;
                block4: {
                    Object object2;
                    String string;
                    String string2;
                    block6: {
                        Object object3;
                        Bitmap bitmap;
                        String string3;
                        block5: {
                            int n;
                            block3: {
                                n = object.what;
                                if (n != 1) break block3;
                                1 v0 = this;
                                string3 = object.getData().getString(ImageLoader.MESSAGE_DATA_URL);
                                bitmap = v0.ImageLoader.this.getBitmapFromMemCache(string3);
                                object3 = (LinkedList)v0.ImageLoader.this.mListenerMap.get(string3);
                                if (object3 == null) break block4;
                                object3 = ((AbstractSequentialList)object3).iterator();
                                break block5;
                            }
                            if (n != 2) return;
                            Object object4 = object;
                            string2 = object4.getData().getString(ImageLoader.MESSAGE_DATA_URL);
                            string = object4.getData().getString(ImageLoader.MESSAGE_DATA_DESC);
                            object2 = (LinkedList)ImageLoader.this.mListenerMap.get(string2);
                            if (object2 == null) break block4;
                            object2 = ((AbstractSequentialList)object2).iterator();
                            break block6;
                        }
                        while (object3.hasNext()) {
                            ImageLoaderListener imageLoaderListener = (ImageLoaderListener)object3.next();
                            if (imageLoaderListener == null) continue;
                            if (bitmap != null) {
                                imageLoaderListener.onSuccess(string3, bitmap);
                                continue;
                            }
                            imageLoaderListener.onFail(string3, "Bitmap load fail");
                        }
                        break block4;
                    }
                    while (object2.hasNext()) {
                        ImageLoaderListener imageLoaderListener = (ImageLoaderListener)object2.next();
                        if (imageLoaderListener == null) continue;
                        imageLoaderListener.onFail(string2, string);
                    }
                }
                ImageLoader.this.mListenerMap.remove(var1_3);
            }
        };
        imageLoader.mContext = context.getApplicationContext();
        int n = (int)Runtime.getRuntime().maxMemory() / 5;
        LogUtil.ownShow("ImageLoad init cache size: " + n + "B");
        imageLoader.mMemoryCache = new ImageLruCache<String, WeakReference<Bitmap>>(n){

            @Override
            protected int sizeOf(String string, WeakReference<Bitmap> weakReference) {
                2 this_ = weakReference != null ? (Bitmap)weakReference.get() : null;
                int n = this_ != null ? this_.getRowBytes() * this_.getHeight() : 0;
                LogUtil.ownShow("sizeOf: Bitmap size:" + n + "B.");
                return n;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected void entryRemoved(boolean bl, String string, WeakReference<Bitmap> weakReference, WeakReference<Bitmap> weakReference2) {
                Exception exception2;
                block5: {
                    block4: {
                        2 this_;
                        super.entryRemoved(bl, string, weakReference, weakReference2);
                        if (weakReference != null) {
                            try {
                                this_ = (Bitmap)weakReference.get();
                                break block4;
                            }
                            catch (Exception exception2) {
                                break block5;
                            }
                        }
                        this_ = null;
                    }
                    if (this_ == null) {
                        LogUtil.ownShow("entryRemoved: Bitmap has been release.");
                    }
                    if (weakReference == null) return;
                    if (weakReference.equals(weakReference2)) return;
                    if (this_ == null) return;
                    if (this_.isRecycled()) return;
                    this_.recycle();
                    LogUtil.ownShow("entryRemoved: Bitmap recycle.");
                    return;
                }
                if (!TPDataManager.getInstance().isDebugMode()) return;
                exception2.printStackTrace();
            }
        };
    }

    public static ImageLoader getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new ImageLoader(context);
        }
        return mInstance;
    }

    private void loadFormUrl(ResourceEntry resourceEntry, final int n, final int n2, ImageLoaderListener imageLoaderListener) {
        if (!((ImageLoader)((Object)linkedList)).mListenerMap.containsKey(resourceEntry.resourceUrl)) {
            LinkedList<ImageLoaderListener> linkedList;
            LinkedList<ImageLoaderListener> linkedList2 = linkedList;
            linkedList2();
            linkedList.add(imageLoaderListener);
            ((ImageLoader)((Object)linkedList)).mListenerMap.put(resourceEntry.resourceUrl, linkedList2);
            ImageUrlLoader imageUrlLoader = new ImageUrlLoader(resourceEntry);
            imageUrlLoader.setListener(new ImageUrlLoader.HttpLoadListener(){

                @Override
                public void onLoadSuccess(ResourceEntry resourceEntry) {
                    3 v0 = this;
                    LogUtil.ownShow("Load Success:" + resourceEntry.resourceUrl);
                    Message message = v0.ImageLoader.this.handler.obtainMessage();
                    message.what = 1;
                    Bundle bundle = new Bundle();
                    bundle.putString(ImageLoader.MESSAGE_DATA_URL, resourceEntry.resourceUrl);
                    message.setData(bundle);
                    3 v2 = this;
                    int n3 = v2.n;
                    Bitmap bitmap = v0.ImageLoader.this.getBitmapFromDiskCache(resourceEntry, n3, v2.n2);
                    if (bitmap != null) {
                        ImageLoader.this.addBitmapToMemoryCache(resourceEntry.resourceUrl, bitmap);
                    }
                    ImageLoader.this.handler.sendMessage(message);
                }

                @Override
                public void onLoadFail(ResourceEntry resourceEntry, String string) {
                    3 v0 = this_;
                    3 this_ = v0.ImageLoader.this.handler.obtainMessage();
                    ((Message)this_).what = 2;
                    Bundle bundle = new Bundle();
                    bundle.putString(ImageLoader.MESSAGE_DATA_URL, resourceEntry.resourceUrl);
                    this_.setData(bundle);
                    v0.ImageLoader.this.handler.sendMessage((Message)this_);
                }
            });
            imageUrlLoader.start();
        } else {
            LinkedList linkedList = (LinkedList)((ImageLoader)((Object)linkedList)).mListenerMap.get(resourceEntry.resourceUrl);
            if (linkedList != null && !linkedList.contains(imageLoaderListener)) {
                linkedList.add(imageLoaderListener);
            }
        }
    }

    public void addBitmapToMemoryCache(String string, Bitmap bitmap) {
        if (((ImageLoader)((Object)weakReference2)).getBitmapFromMemCache(string) == null && bitmap != null) {
            WeakReference<Bitmap> weakReference;
            WeakReference<Bitmap> weakReference2 = weakReference;
            weakReference = new WeakReference<Bitmap>(bitmap);
            ((ImageLoader)((Object)weakReference2)).mMemoryCache.put(string, weakReference2);
        }
    }

    public Bitmap getBitmapFromMemCache(String string) {
        WeakReference<Bitmap> weakReference = ((ImageLoader)((Object)weakReference)).mMemoryCache.get(string);
        return weakReference != null ? (Bitmap)weakReference.get() : null;
    }

    /*
     * Exception decompiling
     */
    public Bitmap getBitmapFromDiskCache(ResourceEntry var1_1, int var2_3, int var3_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [6 : 86->90)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void load(ResourceEntry resourceEntry, ImageLoaderListener imageLoaderListener) {
        this.load(resourceEntry, -1, -1, imageLoaderListener);
    }

    public void load(ResourceEntry resourceEntry, int n, int n2, ImageLoaderListener imageLoaderListener) {
        if (resourceEntry != null && !TextUtils.isEmpty((CharSequence)resourceEntry.resourceUrl)) {
            Bitmap bitmap = this.getBitmapFromMemCache(resourceEntry.resourceUrl);
            if (bitmap != null) {
                imageLoaderListener.onSuccess(resourceEntry.resourceUrl, bitmap);
                return;
            }
            bitmap = this.getBitmapFromDiskCache(resourceEntry, n, n2);
            if (bitmap != null) {
                imageLoaderListener.onSuccess(resourceEntry.resourceUrl, bitmap);
            } else {
                this.loadFormUrl(resourceEntry, n, n2, imageLoaderListener);
            }
            return;
        }
        if (imageLoaderListener != null) {
            imageLoaderListener.onFail("", "No url info.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recycle() {
        try {
            ImageLruCache<String, WeakReference<Bitmap>> imageLruCache = ((ImageLoader)this).mMemoryCache;
            if (imageLruCache != null) {
                imageLruCache.evictAll();
            }
            if ((this = ((ImageLoader)this).mListenerMap) == null) return;
            ((LinkedHashMap)this).clear();
            return;
        }
        catch (Exception exception) {
            if (!TPDataManager.getInstance().isDebugMode()) return;
            exception.printStackTrace();
        }
    }

    public static interface ImageLoaderListener {
        public void onSuccess(String var1, Bitmap var2);

        public void onFail(String var1, String var2);
    }
}

