/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.os.SystemClock;
import com.tradplus.ads.common.util.LogUtil;

public class DoubleTimeTracker {
    private volatile State state;
    private long startedTimestamp;
    private long interval;
    private final Clock mClock;

    public DoubleTimeTracker() {
        SystemClockClock systemClockClock;
        DoubleTimeTracker doubleTimeTracker = systemClockClock2;
        SystemClockClock systemClockClock2 = systemClockClock;
        systemClockClock = new SystemClockClock();
        doubleTimeTracker(systemClockClock2);
    }

    public DoubleTimeTracker(Clock clock) {
        DoubleTimeTracker doubleTimeTracker = this;
        doubleTimeTracker.mClock = clock;
        doubleTimeTracker.state = State.PAUSED;
    }

    private synchronized long computeIntervalDiff() {
        if (this.state == State.PAUSED) {
            return 0L;
        }
        return this.mClock.elapsedRealTime() - this.startedTimestamp;
    }

    public synchronized void start() {
        State state = State.STARTED;
        if (this.state == state) {
            LogUtil.show("DoubleTimeTracker already started.");
            return;
        }
        this.state = state;
        this.startedTimestamp = this.mClock.elapsedRealTime();
    }

    public synchronized void pause() {
        State state = State.PAUSED;
        if (this.state == state) {
            LogUtil.show("DoubleTimeTracker already paused.");
            return;
        }
        this.interval += this.computeIntervalDiff();
        this.startedTimestamp = 0L;
        this.state = state;
    }

    public synchronized double getInterval() {
        return this.interval + this.computeIntervalDiff();
    }

    private static class SystemClockClock
    implements Clock {
        private SystemClockClock() {
        }

        @Override
        public long elapsedRealTime() {
            return SystemClock.elapsedRealtime();
        }
    }

    private static final class State
    extends Enum<State> {
        public static final /* enum */ State STARTED;
        public static final /* enum */ State PAUSED;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }

        static {
            State state;
            State state2;
            State state3 = state2;
            STARTED = new State();
            State state4 = state;
            PAUSED = new State();
            $VALUES = new State[]{state3, state4};
        }
    }

    public static interface Clock {
        public long elapsedRealTime();
    }
}

