/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.util.WebViews;
import com.tradplus.ads.common.BrowserWebViewClient;
import com.tradplus.ads.common.DoubleTimeTracker;
import com.tradplus.ads.common.util.Drawables;

public class TPBrowser
extends Activity {
    public static final String DESTINATION_URL_KEY = "URL";
    public static final String DSP_CREATIVE_ID = "tp-dsp-creative-id";
    private static final int INNER_LAYOUT_ID = 1;
    private WebView mWebView;
    private ImageButton mBackButton;
    private ImageButton mForwardButton;
    private ImageButton mRefreshButton;
    private ImageButton mCloseButton;
    private DoubleTimeTracker dwellTimeTracker;
    private String mDspCreativeId;

    private void initializeWebView() {
        TPBrowser tPBrowser = this;
        WebSettings webSettings = tPBrowser.mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setAllowFileAccessFromFileURLs(false);
        webSettings.setAllowFileAccess(false);
        webSettings.setSavePassword(false);
        tPBrowser.mDspCreativeId = tPBrowser.getIntent().getStringExtra(DSP_CREATIVE_ID);
        tPBrowser.mWebView.removeJavascriptInterface("searchBoxJavaBridge_");
        tPBrowser.mWebView.removeJavascriptInterface("accessibility");
        tPBrowser.mWebView.removeJavascriptInterface("accessibilityTraversal");
        tPBrowser.mWebView.loadUrl(this.getIntent().getStringExtra(DESTINATION_URL_KEY));
        tPBrowser.mWebView.setWebViewClient((WebViewClient)new BrowserWebViewClient(this));
        tPBrowser.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView webView, int n) {
                1 v0 = this;
                v0.TPBrowser.this.setTitle("Loading...");
                v0.TPBrowser.this.setProgress(n * 100);
                if (n == 100) {
                    TPBrowser.this.setTitle(webView.getUrl());
                }
            }
        });
    }

    private void initializeButtons() {
        TPBrowser tPBrowser = this;
        tPBrowser.mBackButton.setBackgroundColor(0);
        tPBrowser.mBackButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TPBrowser.this.mWebView.canGoBack()) {
                    TPBrowser.this.mWebView.goBack();
                }
            }
        });
        tPBrowser.mForwardButton.setBackgroundColor(0);
        tPBrowser.mForwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TPBrowser.this.mWebView.canGoForward()) {
                    TPBrowser.this.mWebView.goForward();
                }
            }
        });
        tPBrowser.mRefreshButton.setBackgroundColor(0);
        tPBrowser.mRefreshButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TPBrowser.this.mWebView.reload();
            }
        });
        tPBrowser.mCloseButton.setBackgroundColor(0);
        tPBrowser.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TPBrowser.this.finish();
            }
        });
    }

    private void enableCookies() {
        CookieSyncManager.createInstance((Context)this);
        CookieSyncManager.getInstance().startSync();
    }

    private View getTPBrowserView() {
        RelativeLayout.LayoutParams layoutParams;
        LinearLayout linearLayout;
        RelativeLayout relativeLayout;
        LinearLayout linearLayout2;
        LinearLayout linearLayout3 = linearLayout2;
        linearLayout2 = new LinearLayout((Context)tPBrowser3);
        linearLayout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        linearLayout2.setOrientation(1);
        RelativeLayout relativeLayout2 = relativeLayout;
        TPBrowser tPBrowser = tPBrowser3;
        RelativeLayout relativeLayout3 = relativeLayout2;
        relativeLayout3((Context)tPBrowser3);
        relativeLayout3.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout3.addView((View)relativeLayout3);
        linearLayout3 = linearLayout;
        TPBrowser tPBrowser2 = tPBrowser3;
        LinearLayout linearLayout4 = linearLayout3;
        linearLayout4((Context)tPBrowser3);
        linearLayout4.setId(1);
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams2.addRule(12);
        linearLayout4.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        linearLayout4.setBackgroundDrawable(Drawables.BACKGROUND.createDrawable((Context)tPBrowser3));
        relativeLayout2.addView((View)linearLayout4);
        tPBrowser2.mBackButton = tPBrowser2.getButton(Drawables.LEFT_ARROW.createDrawable((Context)tPBrowser3));
        tPBrowser2.mForwardButton = tPBrowser2.getButton(Drawables.RIGHT_ARROW.createDrawable((Context)tPBrowser3));
        tPBrowser2.mRefreshButton = tPBrowser2.getButton(Drawables.REFRESH.createDrawable((Context)tPBrowser3));
        tPBrowser2.mCloseButton = tPBrowser2.getButton(Drawables.CLOSE.createDrawable((Context)tPBrowser3));
        linearLayout3.addView((View)tPBrowser2.mBackButton);
        linearLayout3.addView((View)tPBrowser3.mForwardButton);
        linearLayout3.addView((View)tPBrowser3.mRefreshButton);
        linearLayout.addView((View)tPBrowser3.mCloseButton);
        TPBrowser tPBrowser3 = layoutParams;
        new RelativeLayout.LayoutParams(-1, -1).addRule(2, 1);
        tPBrowser.mWebView.setLayoutParams((ViewGroup.LayoutParams)tPBrowser3);
        relativeLayout.addView((View)tPBrowser.mWebView);
        return linearLayout2;
    }

    private ImageButton getButton(Drawable drawable) {
        LinearLayout.LayoutParams layoutParams;
        ImageButton imageButton = new ImageButton((Context)tPBrowser);
        TPBrowser tPBrowser = layoutParams;
        new LinearLayout.LayoutParams((int)-2, (int)-2, (float)1.0f).gravity = 16;
        imageButton.setLayoutParams((ViewGroup.LayoutParams)tPBrowser);
        imageButton.setImageDrawable(drawable);
        return imageButton;
    }

    public ImageButton getBackButton() {
        return this.mBackButton;
    }

    public ImageButton getCloseButton() {
        return this.mCloseButton;
    }

    public ImageButton getForwardButton() {
        return this.mForwardButton;
    }

    public ImageButton getRefreshButton() {
        return this.mRefreshButton;
    }

    public WebView getWebView() {
        return this.mWebView;
    }

    public void onCreate(Bundle bundle) {
        TPBrowser tPBrowser = this;
        super.onCreate(bundle);
        tPBrowser.setResult(-1);
        tPBrowser.getWindow().requestFeature(2);
        tPBrowser.getWindow().setFeatureInt(2, -1);
        tPBrowser.dwellTimeTracker = new DoubleTimeTracker();
        tPBrowser.initializeWebView();
        tPBrowser.initializeButtons();
        tPBrowser.enableCookies();
    }

    protected void onPause() {
        TPBrowser tPBrowser = this;
        super.onPause();
        CookieSyncManager.getInstance().stopSync();
        WebViews.onPause(tPBrowser.mWebView, this.isFinishing());
        tPBrowser.dwellTimeTracker.pause();
    }

    protected void onResume() {
        TPBrowser tPBrowser = this;
        super.onResume();
        CookieSyncManager.getInstance().startSync();
        WebViews.onResume(tPBrowser.mWebView);
        tPBrowser.dwellTimeTracker.start();
    }

    public void finish() {
        TPBrowser tPBrowser = this;
        ((ViewGroup)tPBrowser.getWindow().getDecorView()).removeAllViews();
        super.finish();
    }

    protected void onDestroy() {
        TPBrowser tPBrowser = this;
        super.onDestroy();
        tPBrowser.mWebView.destroy();
        tPBrowser.mWebView = null;
    }

    @Deprecated
    void setWebView(WebView webView) {
        this.mWebView = webView;
    }
}

