/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.tradplus.ads.base.network.TrackingRequest;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.UrlHandler;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.util.Intents;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.exceptions.IntentNotResolvableException;
import com.tradplus.ads.exceptions.UrlParseException;
import java.net.URISyntaxException;
import java.util.List;

public abstract class UrlAction
extends Enum<UrlAction> {
    public static final /* enum */ UrlAction HANDLE_TP_SCHEME;
    public static final /* enum */ UrlAction IGNORE_ABOUT_SCHEME;
    public static final /* enum */ UrlAction HANDLE_PHONE_SCHEME;
    public static final /* enum */ UrlAction OPEN_NATIVE_BROWSER;
    public static final /* enum */ UrlAction OPEN_APP_MARKET;
    public static final /* enum */ UrlAction OPEN_IN_APP_BROWSER;
    public static final /* enum */ UrlAction HANDLE_SHARE_TWEET;
    public static final /* enum */ UrlAction FOLLOW_DEEP_LINK_WITH_FALLBACK;
    public static final /* enum */ UrlAction FOLLOW_DEEP_LINK;
    public static final /* enum */ UrlAction NOOP;
    private static final /* synthetic */ UrlAction[] $VALUES;
    private final boolean mRequiresUserInteraction;

    public static UrlAction[] values() {
        return (UrlAction[])$VALUES.clone();
    }

    public static UrlAction valueOf(String string) {
        return Enum.valueOf(UrlAction.class, string);
    }

    private UrlAction(boolean bl) {
        this.mRequiresUserInteraction = bl;
    }

    static {
        UrlAction urlAction;
        UrlAction urlAction2;
        UrlAction urlAction3;
        UrlAction urlAction4;
        UrlAction urlAction5;
        UrlAction urlAction6;
        UrlAction urlAction7;
        UrlAction urlAction8;
        UrlAction urlAction9;
        UrlAction urlAction10;
        UrlAction urlAction11 = urlAction10;
        HANDLE_TP_SCHEME = new UrlAction(false){

            @Override
            public boolean shouldTryHandlingUrl(Uri uri) {
                return "tp".equalsIgnoreCase(uri.getScheme());
            }

            @Override
            protected void performAction(Context object, Uri uri, UrlHandler urlHandler, String string) {
                block5: {
                    block3: {
                        block4: {
                            block2: {
                                Object object2 = uri.getHost();
                                object = urlHandler.getTPSchemeListener();
                                if (!"finishLoad".equalsIgnoreCase((String)object2)) break block2;
                                object.onFinishLoad();
                                break block3;
                            }
                            if (!"close".equalsIgnoreCase((String)object2)) break block4;
                            object.onClose();
                            break block3;
                        }
                        if (!"failLoad".equalsIgnoreCase((String)object2)) break block5;
                        object.onFailLoad();
                    }
                    return;
                }
                throw new IntentNotResolvableException("Could not handle TradPlus Scheme url: " + uri);
            }
        };
        UrlAction urlAction12 = urlAction9;
        IGNORE_ABOUT_SCHEME = new UrlAction(false){

            @Override
            public boolean shouldTryHandlingUrl(Uri uri) {
                return "about".equalsIgnoreCase(uri.getScheme());
            }

            @Override
            protected void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
                LogUtil.show("Link to about page ignored.");
            }
        };
        UrlAction urlAction13 = urlAction8;
        HANDLE_PHONE_SCHEME = new UrlAction(true){

            @Override
            public boolean shouldTryHandlingUrl(Uri uri) {
                Object object = uri.getScheme();
                return "tel".equalsIgnoreCase((String)object) || "voicemail".equalsIgnoreCase((String)object) || "sms".equalsIgnoreCase((String)object) || "mailto".equalsIgnoreCase((String)object) || "geo".equalsIgnoreCase((String)object) || "google.streetview".equalsIgnoreCase((String)object);
            }

            @Override
            protected void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
                Intents.launchActionViewIntent(context, uri, "Could not handle intent with URI: " + uri + "\n\tIs this intent supported on your phone?");
            }
        };
        UrlAction urlAction14 = urlAction7;
        OPEN_NATIVE_BROWSER = new UrlAction(true){

            @Override
            public boolean shouldTryHandlingUrl(Uri uri) {
                return "tpnativebrowser".equalsIgnoreCase(uri.getScheme());
            }

            @Override
            protected void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
                Object object = "Unable to load tp native browser url: " + uri;
                try {
                    Intents.launchIntentForUserClick(context, Intents.intentForNativeBrowserScheme(uri), (String)object);
                    return;
                }
                catch (UrlParseException urlParseException) {
                    throw new IntentNotResolvableException((String)object + "\n\t" + urlParseException.getMessage());
                }
            }
        };
        UrlAction urlAction15 = urlAction6;
        OPEN_APP_MARKET = new UrlAction(true){

            @Override
            public boolean shouldTryHandlingUrl(Uri uri) {
                Uri uri2 = uri;
                Object object = uri2.getScheme();
                String string = uri2.getHost();
                return "play.google.com".equalsIgnoreCase(string) || "market.android.com".equalsIgnoreCase(string) || "market".equalsIgnoreCase((String)object) || uri.toString().toLowerCase().startsWith("play.google.com/") || uri.toString().toLowerCase().startsWith("market.android.com/");
            }

            @Override
            protected void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
                Intents.launchApplicationUrl(context, uri);
            }
        };
        UrlAction urlAction16 = urlAction5;
        OPEN_IN_APP_BROWSER = new UrlAction(true){

            @Override
            public boolean shouldTryHandlingUrl(Uri uri) {
                Object object = uri.getScheme();
                return "http".equalsIgnoreCase((String)object) || "https".equalsIgnoreCase((String)object);
            }

            @Override
            protected void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
                if (!urlHandler.shouldskipShowTpBrowser()) {
                    Intents.showTPBrowserForUrl(context, uri, string);
                }
            }
        };
        UrlAction urlAction17 = urlAction4;
        HANDLE_SHARE_TWEET = new UrlAction(true){

            @Override
            public boolean shouldTryHandlingUrl(Uri uri) {
                Uri uri2 = uri;
                Preconditions.checkNotNull(uri2);
                return "tpshare".equalsIgnoreCase(uri2.getScheme()) && "tweet".equalsIgnoreCase(uri.getHost());
            }

            @Override
            protected void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
                Uri uri2 = uri;
                Preconditions.checkNotNull(context);
                Preconditions.checkNotNull(uri2);
                Object object = "Could not handle share tweet intent with URI " + uri;
                try {
                    Intents.launchIntentForUserClick(context, Intent.createChooser((Intent)Intents.intentForShareTweet(uri2), (CharSequence)"Share via"), (String)object);
                    return;
                }
                catch (UrlParseException urlParseException) {
                    throw new IntentNotResolvableException((String)object + "\n\t" + urlParseException.getMessage());
                }
            }
        };
        UrlAction urlAction18 = urlAction3;
        FOLLOW_DEEP_LINK_WITH_FALLBACK = new UrlAction(true){

            @Override
            public boolean shouldTryHandlingUrl(Uri uri) {
                return "deeplink+".equalsIgnoreCase(uri.getScheme());
            }

            @Override
            protected void performAction(Context context, Uri object, UrlHandler urlHandler, String string) {
                if ("navigate".equalsIgnoreCase(object.getHost())) {
                    block11: {
                        try {
                            string = object.getQueryParameter("primaryUrl");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            throw new IntentNotResolvableException("Deeplink+ URL was not a hierarchical URI.");
                        }
                        Uri uri = object;
                        Uri uri2 = uri;
                        Uri uri3 = uri;
                        object = uri.getQueryParameters("primaryTrackingUrl");
                        String string2 = uri3.getQueryParameter("fallbackUrl");
                        List list = uri2.getQueryParameters("fallbackTrackingUrl");
                        if (string == null) break block11;
                        if (!this.shouldTryHandlingUrl((Uri)(string = Uri.parse((String)string)))) {
                            try {
                                Intents.launchApplicationUrl(context, (Uri)string);
                                TrackingRequest.makeTrackingHttpRequest((Iterable<String>)object, context, BaseEvent.Name.CLICK_REQUEST);
                                return;
                            }
                            catch (IntentNotResolvableException intentNotResolvableException) {
                                if (string2 != null) {
                                    if (!this.shouldTryHandlingUrl(Uri.parse((String)string2))) {
                                        urlHandler.handleUrl(context, string2, true, list);
                                        return;
                                    }
                                    throw new IntentNotResolvableException("Deeplink+ URL had another Deeplink+ URL as the 'fallbackUrl'.");
                                }
                                throw new IntentNotResolvableException("Unable to handle 'primaryUrl' for Deeplink+ and 'fallbackUrl' was missing.");
                            }
                        }
                        throw new IntentNotResolvableException("Deeplink+ had another Deeplink+ as the 'primaryUrl'.");
                    }
                    throw new IntentNotResolvableException("Deeplink+ did not have 'primaryUrl' query param.");
                }
                throw new IntentNotResolvableException("Deeplink+ URL did not have 'navigate' as the host.");
            }
        };
        UrlAction urlAction19 = urlAction2;
        FOLLOW_DEEP_LINK = new UrlAction(true){

            @Override
            public boolean shouldTryHandlingUrl(Uri uri) {
                return TextUtils.isEmpty((CharSequence)uri.getScheme()) ^ true;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
                if (!"intent".equalsIgnoreCase(uri.getScheme())) {
                    Intents.launchApplicationUrl(context, uri);
                    return;
                }
                try {
                    9 this_ = Intent.parseUri((String)uri.toString(), (int)1);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IntentNotResolvableException("Intent uri had invalid syntax: " + uri.toString());
                }
                {
                    this_.addCategory("android.intent.category.BROWSABLE");
                }
                {
                    this_.setComponent(null);
                }
                {
                    if (Build.VERSION.SDK_INT >= 15) {
                        this_.setSelector(null);
                    }
                    Intents.launchApplicationIntent(context, (Intent)this_);
                    return;
                }
            }
        };
        UrlAction urlAction20 = urlAction;
        NOOP = new UrlAction(false){

            @Override
            public boolean shouldTryHandlingUrl(Uri uri) {
                return false;
            }

            @Override
            protected void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
            }
        };
        $VALUES = new UrlAction[]{urlAction11, urlAction12, urlAction13, urlAction14, urlAction15, urlAction16, urlAction17, urlAction18, urlAction19, urlAction20};
    }

    public void handleUrl(UrlHandler urlHandler, Context context, Uri uri, boolean bl, String string) {
        LogUtil.show("Ad event URL: " + uri);
        if (this.mRequiresUserInteraction && !bl) {
            throw new IntentNotResolvableException("Attempted to handle action without user interaction.");
        }
        this.performAction(context, uri, urlHandler, string);
    }

    public abstract boolean shouldTryHandlingUrl(Uri var1);

    protected abstract void performAction(Context var1, Uri var2, UrlHandler var3, String var4);
}

