/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.tradplus.ads.base.network.TrackingRequest;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.UrlResolutionTask;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.exceptions.IntentNotResolvableException;
import java.util.EnumSet;

public class UrlHandler {
    private static final ResultActions EMPTY_CLICK_LISTENER = new ResultActions(){

        @Override
        public void urlHandlingSucceeded(String string, UrlAction urlAction) {
        }

        @Override
        public void urlHandlingFailed(String string, UrlAction urlAction) {
        }
    };
    private static final TPSchemeListener EMPTY_MOPUB_SCHEME_LISTENER = new TPSchemeListener(){

        @Override
        public void onFinishLoad() {
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onFailLoad() {
        }
    };
    private EnumSet<UrlAction> mSupportedUrlActions;
    private ResultActions mResultActions;
    private TPSchemeListener mTPSchemeListener;
    private String mDspCreativeId;
    private boolean mskipShowTpBrowser;
    private boolean mAlreadySucceeded;
    private boolean mTaskPending;

    private UrlHandler(EnumSet<UrlAction> enumSet, ResultActions resultActions, TPSchemeListener tPSchemeListener, boolean bl, String string) {
        UrlHandler urlHandler = this;
        this.mSupportedUrlActions = EnumSet.copyOf(enumSet);
        this.mResultActions = resultActions;
        this.mTPSchemeListener = tPSchemeListener;
        this.mskipShowTpBrowser = bl;
        urlHandler.mDspCreativeId = string;
        urlHandler.mAlreadySucceeded = false;
        urlHandler.mTaskPending = false;
    }

    private void failUrlHandling(String string, UrlAction urlAction, String string2, Throwable throwable) {
        Preconditions.checkNotNull(string2);
        if (urlAction == null) {
            urlAction = UrlAction.NOOP;
        }
        LogUtil.show(string2, throwable);
        this.mResultActions.urlHandlingFailed(string, urlAction);
    }

    static /* synthetic */ ResultActions access$000() {
        return EMPTY_CLICK_LISTENER;
    }

    static /* synthetic */ TPSchemeListener access$100() {
        return EMPTY_MOPUB_SCHEME_LISTENER;
    }

    static /* synthetic */ boolean access$302(UrlHandler urlHandler, boolean bl) {
        urlHandler.mTaskPending = bl;
        return bl;
    }

    EnumSet<UrlAction> getSupportedUrlActions() {
        return EnumSet.copyOf(this.mSupportedUrlActions);
    }

    ResultActions getResultActions() {
        return this.mResultActions;
    }

    TPSchemeListener getTPSchemeListener() {
        return this.mTPSchemeListener;
    }

    boolean shouldskipShowTpBrowser() {
        return this.mskipShowTpBrowser;
    }

    public void handleUrl(Context context, String string) {
        Preconditions.checkNotNull(context);
        this.handleUrl(context, string, true);
    }

    public void handleUrl(Context context, String string, boolean bl) {
        Preconditions.checkNotNull(context);
        this.handleUrl(context, string, bl, null);
    }

    public void handleUrl(final Context context, final String string, final boolean bl, final Iterable<String> iterable) {
        UrlResolutionTask.UrlResolutionListener urlResolutionListener;
        Preconditions.checkNotNull(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.failUrlHandling(string, null, "Attempted to handle empty url.", null);
            return;
        }
        UrlResolutionTask.UrlResolutionListener urlResolutionListener2 = urlResolutionListener;
        urlResolutionListener = new UrlResolutionTask.UrlResolutionListener(){

            @Override
            public void onSuccess(String string2) {
                3 v0 = this_;
                UrlHandler.access$302(v0.UrlHandler.this, false);
                3 v1 = this_;
                3 this_ = v1.context;
                boolean bl2 = v1.bl;
                Iterable iterable2 = v1.iterable;
                v0.UrlHandler.this.handleResolvedUrl((Context)this_, string2, bl2, iterable2);
            }

            @Override
            public void onFailure(String string2, Throwable throwable) {
                3 v0 = this;
                UrlHandler.access$302(v0.UrlHandler.this, false);
                v0.UrlHandler.this.failUrlHandling(string, null, string2, throwable);
            }
        };
        UrlResolutionTask.getResolvedUrl(string, urlResolutionListener2);
        this.mTaskPending = true;
    }

    public boolean handleResolvedUrl(Context context, String string, boolean bl, Iterable<String> iterable) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.failUrlHandling(string, null, "Attempted to handle empty url.", null);
            return false;
        }
        UrlAction urlAction = UrlAction.NOOP;
        Uri uri = Uri.parse((String)string);
        for (UrlAction urlAction2 : this.mSupportedUrlActions) {
            block8: {
                if (!urlAction2.shouldTryHandlingUrl(uri)) continue;
                try {
                    urlAction2.handleUrl(this, context, uri, bl, this.mDspCreativeId);
                    if (this.mAlreadySucceeded) break block8;
                }
                catch (IntentNotResolvableException intentNotResolvableException) {
                    LogUtil.show(intentNotResolvableException.getMessage(), intentNotResolvableException);
                    urlAction = urlAction2;
                    continue;
                }
                if (this.mTaskPending) break block8;
                if (UrlAction.IGNORE_ABOUT_SCHEME.equals((Object)urlAction2)) break block8;
                if (UrlAction.HANDLE_TP_SCHEME.equals((Object)urlAction2)) break block8;
                TrackingRequest.makeTrackingHttpRequest(iterable, context, BaseEvent.Name.CLICK_REQUEST);
                this.mResultActions.urlHandlingSucceeded(uri.toString(), urlAction2);
                this.mAlreadySucceeded = true;
            }
            return true;
        }
        this.failUrlHandling(string, urlAction, "Link ignored. Unable to handle url: " + string, null);
        return false;
    }

    public static class Builder {
        private EnumSet<UrlAction> supportedUrlActions = EnumSet.of(UrlAction.NOOP);
        private ResultActions resultActions = UrlHandler.access$000();
        private TPSchemeListener TPSchemeListener = UrlHandler.access$100();
        private boolean skipShowTpBrowser = false;
        private String creativeId;

        public Builder withSupportedUrlActions(UrlAction urlAction, UrlAction ... urlActionArray) {
            this.supportedUrlActions = EnumSet.of(urlAction, urlActionArray);
            return this;
        }

        public Builder withSupportedUrlActions(EnumSet<UrlAction> enumSet) {
            this.supportedUrlActions = EnumSet.copyOf(enumSet);
            return this;
        }

        public Builder withResultActions(ResultActions resultActions) {
            this.resultActions = resultActions;
            return this;
        }

        public Builder withTPSchemeListener(TPSchemeListener tPSchemeListener) {
            this.TPSchemeListener = tPSchemeListener;
            return this;
        }

        public Builder withoutTPBrowser() {
            this.skipShowTpBrowser = true;
            return this;
        }

        public Builder withDspCreativeId(String string) {
            this.creativeId = string;
            return this;
        }

        public UrlHandler build() {
            Builder builder = enumSet;
            EnumSet<UrlAction> enumSet = builder.supportedUrlActions;
            ResultActions resultActions = builder.resultActions;
            TPSchemeListener tPSchemeListener = builder.TPSchemeListener;
            boolean bl = builder.skipShowTpBrowser;
            String string = builder.creativeId;
            return new UrlHandler(enumSet, resultActions, tPSchemeListener, bl, string);
        }
    }

    public static interface TPSchemeListener {
        public void onFinishLoad();

        public void onClose();

        public void onFailLoad();
    }

    public static interface ResultActions {
        public void urlHandlingSucceeded(String var1, UrlAction var2);

        public void urlHandlingFailed(String var1, UrlAction var2);
    }
}

