/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.common.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class BaseEvent {
    private final ScribeCategory mScribeCategory;
    private final Name mName;
    private final Category mCategory;
    private final SdkProduct mSdkProduct;
    private final String mAdUnitId;
    private final String mAdCreativeId;
    private final String mAdType;
    private final String mAdNetworkType;
    private final Double mAdWidthPx;
    private final Double mAdHeightPx;
    private final String mDspCreativeId;
    private final Double mGeoLat;
    private final Double mGeoLon;
    private final Double mGeoAccuracy;
    private final String mIsoCountryCode;
    private final Double mPerformanceDurationMs;
    private final String mRequestId;
    private final Integer mRequestStatusCode;
    private final String mRequestUri;
    private final Integer mRequestRetries;
    private final long mTimestampUtcMs;
    private TPDataManager tpDataManager;
    private final double mSamplingRate;

    public BaseEvent(Builder object) {
        BaseEvent baseEvent = this;
        Builder builder = object;
        Preconditions.checkNotNull(builder);
        this.mScribeCategory = builder.mScribeCategory;
        this.mName = ((Builder)object).mName;
        this.mCategory = ((Builder)object).mCategory;
        this.mSdkProduct = ((Builder)object).mSdkProduct;
        this.mAdUnitId = ((Builder)object).mAdUnitId;
        this.mAdCreativeId = ((Builder)object).mAdCreativeId;
        this.mAdType = ((Builder)object).mAdType;
        this.mAdNetworkType = ((Builder)object).mAdNetworkType;
        this.mAdWidthPx = ((Builder)object).mAdWidthPx;
        this.mAdHeightPx = ((Builder)object).mAdHeightPx;
        this.mDspCreativeId = ((Builder)object).mDspCreativeId;
        this.mGeoLat = ((Builder)object).mGeoLat;
        this.mGeoLon = ((Builder)object).mGeoLon;
        this.mGeoAccuracy = ((Builder)object).mGeoAccuracy;
        this.mPerformanceDurationMs = ((Builder)object).mPerformanceDurationMs;
        this.mRequestId = ((Builder)object).mRequestId;
        this.mRequestStatusCode = ((Builder)object).mRequestStatusCode;
        this.mRequestUri = ((Builder)object).mRequestUri;
        this.mRequestRetries = ((Builder)object).mRequestRetries;
        baseEvent.mSamplingRate = ((Builder)object).mSamplingRate;
        baseEvent.mTimestampUtcMs = System.currentTimeMillis();
        this.tpDataManager = object = TPDataManager.getInstance();
        this.mIsoCountryCode = object != null ? ((TPDataManager)object).getIsoCountryCode() : null;
    }

    public ScribeCategory getScribeCategory() {
        return this.mScribeCategory;
    }

    public Name getName() {
        return this.mName;
    }

    public Category getCategory() {
        return this.mCategory;
    }

    public SdkProduct getSdkProduct() {
        return this.mSdkProduct;
    }

    public String getSdkVersion() {
        TPDataManager tPDataManager = ((BaseEvent)((Object)tPDataManager)).tpDataManager;
        return tPDataManager == null ? null : tPDataManager.getSdkVersion();
    }

    public String getAdUnitId() {
        return this.mAdUnitId;
    }

    public String getAdCreativeId() {
        return this.mAdCreativeId;
    }

    public String getDspCreativeId() {
        return this.mDspCreativeId;
    }

    public String getAdType() {
        return this.mAdType;
    }

    public String getAdNetworkType() {
        return this.mAdNetworkType;
    }

    public Double getAdWidthPx() {
        return this.mAdWidthPx;
    }

    public Double getAdHeightPx() {
        return this.mAdHeightPx;
    }

    public AppPlatform getAppPlatform() {
        return AppPlatform.ANDROID;
    }

    public String getAppName() {
        TPDataManager tPDataManager = ((BaseEvent)((Object)tPDataManager)).tpDataManager;
        return tPDataManager == null ? null : tPDataManager.getAppName();
    }

    public String getAppPackageName() {
        TPDataManager tPDataManager = ((BaseEvent)((Object)tPDataManager)).tpDataManager;
        return tPDataManager == null ? null : tPDataManager.getAppPackageName();
    }

    public String getAppVersion() {
        TPDataManager tPDataManager = ((BaseEvent)((Object)tPDataManager)).tpDataManager;
        return tPDataManager == null ? null : tPDataManager.getAppVersion();
    }

    public String getObfuscatedClientAdvertisingId() {
        return "ifa:XXXX";
    }

    public String getDeviceOsVersion() {
        TPDataManager tPDataManager = ((BaseEvent)((Object)tPDataManager)).tpDataManager;
        return tPDataManager == null ? null : tPDataManager.getDeviceOsVersion();
    }

    public Double getGeoLat() {
        return this.mGeoLat;
    }

    public Double getGeoLon() {
        return this.mGeoLon;
    }

    public Double getGeoAccuracy() {
        return this.mGeoAccuracy;
    }

    public Double getPerformanceDurationMs() {
        return this.mPerformanceDurationMs;
    }

    public String getNetworkIsoCountryCode() {
        return this.mIsoCountryCode;
    }

    public String getRequestId() {
        return this.mRequestId;
    }

    public Integer getRequestStatusCode() {
        return this.mRequestStatusCode;
    }

    public String getRequestUri() {
        return this.mRequestUri;
    }

    public Integer getRequestRetries() {
        return this.mRequestRetries;
    }

    public double getSamplingRate() {
        return this.mSamplingRate;
    }

    public Long getTimestampUtcMs() {
        return this.mTimestampUtcMs;
    }

    public String toString() {
        return "BaseEvent\nScribeCategory: " + (Object)((Object)this.getScribeCategory()) + "\nName: " + (Object)((Object)this.getName()) + "\nCategory: " + (Object)((Object)this.getCategory()) + "\nSdkProduct: " + (Object)((Object)this.getSdkProduct()) + "\nSdkVersion: " + this.getSdkVersion() + "\nAdUnitId: " + this.getAdUnitId() + "\nAdCreativeId: " + this.getAdCreativeId() + "\nAdType: " + this.getAdType() + "\nAdNetworkType: " + this.getAdNetworkType() + "\nAdWidthPx: " + this.getAdWidthPx() + "\nAdHeightPx: " + this.getAdHeightPx() + "\nDspCreativeId: " + this.getDspCreativeId() + "\nAppPlatform: " + (Object)((Object)this.getAppPlatform()) + "\nAppName: " + this.getAppName() + "\nAppPackageName: " + this.getAppPackageName() + "\nAppVersion: " + this.getAppVersion() + "\nDeviceOsVersion: " + this.getDeviceOsVersion() + "\nGeoLat: " + this.getGeoLat() + "\nGeoLon: " + this.getGeoLon() + "\nGeoAccuracy: " + this.getGeoAccuracy() + "\nPerformanceDurationMs: " + this.getPerformanceDurationMs() + "\nNetworkIsoCountryCode: " + this.getNetworkIsoCountryCode() + "\nRequestId: " + this.getRequestId() + "\nRequestStatusCode: " + this.getRequestStatusCode() + "\nRequestUri: " + this.getRequestUri() + "\nRequestRetries: " + this.getRequestRetries() + "\nSamplingRate: " + this.getSamplingRate() + "\nTimestampUtcMs: " + new SimpleDateFormat().format(new Date(this.getTimestampUtcMs())) + "\n";
    }

    public static abstract class Builder {
        private ScribeCategory mScribeCategory;
        private Name mName;
        private Category mCategory;
        private SdkProduct mSdkProduct;
        private String mAdUnitId;
        private String mAdCreativeId;
        private String mAdType;
        private String mAdNetworkType;
        private Double mAdWidthPx;
        private Double mAdHeightPx;
        private String mDspCreativeId;
        private Double mGeoLat;
        private Double mGeoLon;
        private Double mGeoAccuracy;
        private Double mPerformanceDurationMs;
        private String mRequestId;
        private Integer mRequestStatusCode;
        private String mRequestUri;
        private Integer mRequestRetries;
        private double mSamplingRate;

        public Builder(ScribeCategory scribeCategory, Name name, Category category, double d) {
            Preconditions.checkNotNull((Object)scribeCategory);
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)category);
            Preconditions.checkArgument(d >= 0.0 && d <= 1.0);
            Builder builder = this;
            builder.mScribeCategory = scribeCategory;
            builder.mName = name;
            builder.mCategory = category;
            builder.mSamplingRate = d;
        }

        public Builder withSdkProduct(SdkProduct sdkProduct) {
            this.mSdkProduct = sdkProduct;
            return this;
        }

        public Builder withAdUnitId(String string) {
            this.mAdUnitId = string;
            return this;
        }

        public Builder withAdCreativeId(String string) {
            this.mAdCreativeId = string;
            return this;
        }

        public Builder withAdType(String string) {
            this.mAdType = string;
            return this;
        }

        public Builder withAdNetworkType(String string) {
            this.mAdNetworkType = string;
            return this;
        }

        public Builder withAdWidthPx(Double d) {
            this.mAdWidthPx = d;
            return this;
        }

        public Builder withAdHeightPx(Double d) {
            this.mAdHeightPx = d;
            return this;
        }

        public Builder withDspCreativeId(String string) {
            this.mDspCreativeId = string;
            return this;
        }

        public Builder withGeoLat(Double d) {
            this.mGeoLat = d;
            return this;
        }

        public Builder withGeoLon(Double d) {
            this.mGeoLon = d;
            return this;
        }

        public Builder withGeoAccuracy(Double d) {
            this.mGeoAccuracy = d;
            return this;
        }

        public Builder withPerformanceDurationMs(Double d) {
            this.mPerformanceDurationMs = d;
            return this;
        }

        public Builder withRequestId(String string) {
            this.mRequestId = string;
            return this;
        }

        public Builder withRequestStatusCode(Integer n) {
            this.mRequestStatusCode = n;
            return this;
        }

        public Builder withRequestUri(String string) {
            this.mRequestUri = string;
            return this;
        }

        public Builder withRequestRetries(Integer n) {
            this.mRequestRetries = n;
            return this;
        }

        public abstract BaseEvent build();
    }

    public static final class SamplingRate
    extends Enum<SamplingRate> {
        public static final /* enum */ SamplingRate AD_REQUEST;
        public static final /* enum */ SamplingRate NATIVE_VIDEO;
        public static final /* enum */ SamplingRate AD_INTERACTIONS;
        private static final /* synthetic */ SamplingRate[] $VALUES;
        private final double mSamplingRate;

        public static SamplingRate[] values() {
            return (SamplingRate[])$VALUES.clone();
        }

        public static SamplingRate valueOf(String string) {
            return Enum.valueOf(SamplingRate.class, string);
        }

        private SamplingRate(double d) {
            this.mSamplingRate = d;
        }

        static {
            SamplingRate samplingRate;
            SamplingRate samplingRate2;
            SamplingRate samplingRate3;
            SamplingRate samplingRate4 = samplingRate3;
            AD_REQUEST = new SamplingRate(0.1);
            SamplingRate samplingRate5 = samplingRate2;
            NATIVE_VIDEO = new SamplingRate(0.1);
            SamplingRate samplingRate6 = samplingRate;
            AD_INTERACTIONS = new SamplingRate(0.1);
            $VALUES = new SamplingRate[]{samplingRate4, samplingRate5, samplingRate6};
        }

        public double getSamplingRate() {
            return this.mSamplingRate;
        }
    }

    public static final class Category
    extends Enum<Category> {
        public static final /* enum */ Category REQUESTS;
        public static final /* enum */ Category NATIVE_VIDEO;
        public static final /* enum */ Category AD_INTERACTIONS;
        private static final /* synthetic */ Category[] $VALUES;
        private final String mCategory;

        public static Category[] values() {
            return (Category[])$VALUES.clone();
        }

        public static Category valueOf(String string) {
            return Enum.valueOf(Category.class, string);
        }

        private Category(String string2) {
            this.mCategory = string2;
        }

        static {
            Category category;
            Category category2;
            Category category3;
            Category category4 = category3;
            REQUESTS = new Category("requests");
            Category category5 = category2;
            NATIVE_VIDEO = new Category("native_video");
            Category category6 = category;
            AD_INTERACTIONS = new Category("ad_interactions");
            $VALUES = new Category[]{category4, category5, category6};
        }

        public String getCategory() {
            return this.mCategory;
        }
    }

    public static final class Name
    extends Enum<Name> {
        public static final /* enum */ Name AD_REQUEST;
        public static final /* enum */ Name REQ_REQUEST;
        public static final /* enum */ Name IMPRESSION_REQUEST;
        public static final /* enum */ Name CLICK_REQUEST;
        public static final /* enum */ Name VIDEOFIN_REQUEST;
        public static final /* enum */ Name DOWNLOAD_START;
        public static final /* enum */ Name DOWNLOAD_VIDEO_READY;
        public static final /* enum */ Name DOWNLOAD_BUFFERING;
        public static final /* enum */ Name DOWNLOAD_FINISHED;
        public static final /* enum */ Name ERROR_DURING_PLAYBACK;
        public static final /* enum */ Name ERROR_FAILED_TO_PLAY;
        public static final /* enum */ Name AD_DWELL_TIME;
        private static final /* synthetic */ Name[] $VALUES;
        private final String mName;

        public static Name[] values() {
            return (Name[])$VALUES.clone();
        }

        public static Name valueOf(String string) {
            return Enum.valueOf(Name.class, string);
        }

        private Name(String string2) {
            this.mName = string2;
        }

        static {
            Name name;
            Name name2;
            Name name3;
            Name name4;
            Name name5;
            Name name6;
            Name name7;
            Name name8;
            Name name9;
            Name name10;
            Name name11;
            Name name12;
            Name name13 = name12;
            AD_REQUEST = new Name("ad_request");
            Name name14 = name11;
            REQ_REQUEST = new Name("req_request");
            Name name15 = name10;
            IMPRESSION_REQUEST = new Name("impression_request");
            Name name16 = name9;
            CLICK_REQUEST = new Name("click_request");
            Name name17 = name8;
            VIDEOFIN_REQUEST = new Name("videoFin_request");
            Name name18 = name7;
            DOWNLOAD_START = new Name("download_start");
            Name name19 = name6;
            DOWNLOAD_VIDEO_READY = new Name("download_video_ready");
            Name name20 = name5;
            DOWNLOAD_BUFFERING = new Name("download_video_buffering");
            Name name21 = name4;
            DOWNLOAD_FINISHED = new Name("download_finished");
            Name name22 = name3;
            ERROR_DURING_PLAYBACK = new Name("error_during_playback");
            Name name23 = name2;
            ERROR_FAILED_TO_PLAY = new Name("error_failed_to_play");
            Name name24 = name;
            AD_DWELL_TIME = new Name("clickthrough_dwell_time");
            $VALUES = new Name[]{name13, name14, name15, name16, name17, name18, name19, name20, name21, name22, name23, name24};
        }

        public String getName() {
            return this.mName;
        }
    }

    public static final class AppPlatform
    extends Enum<AppPlatform> {
        public static final /* enum */ AppPlatform NONE;
        public static final /* enum */ AppPlatform IOS;
        public static final /* enum */ AppPlatform ANDROID;
        public static final /* enum */ AppPlatform MOBILE_WEB;
        private static final /* synthetic */ AppPlatform[] $VALUES;
        private final int mType;

        public static AppPlatform[] values() {
            return (AppPlatform[])$VALUES.clone();
        }

        public static AppPlatform valueOf(String string) {
            return Enum.valueOf(AppPlatform.class, string);
        }

        private AppPlatform(int n2) {
            this.mType = n2;
        }

        static {
            AppPlatform appPlatform;
            AppPlatform appPlatform2;
            AppPlatform appPlatform3;
            AppPlatform appPlatform4;
            AppPlatform appPlatform5 = appPlatform4;
            NONE = new AppPlatform(0);
            AppPlatform appPlatform6 = appPlatform3;
            IOS = new AppPlatform(1);
            AppPlatform appPlatform7 = appPlatform2;
            ANDROID = new AppPlatform(2);
            AppPlatform appPlatform8 = appPlatform;
            MOBILE_WEB = new AppPlatform(3);
            $VALUES = new AppPlatform[]{appPlatform5, appPlatform6, appPlatform7, appPlatform8};
        }

        public int getType() {
            return this.mType;
        }
    }

    public static final class SdkProduct
    extends Enum<SdkProduct> {
        public static final /* enum */ SdkProduct NONE;
        public static final /* enum */ SdkProduct WEB_VIEW;
        public static final /* enum */ SdkProduct NATIVE;
        private static final /* synthetic */ SdkProduct[] $VALUES;
        private final int mType;

        public static SdkProduct[] values() {
            return (SdkProduct[])$VALUES.clone();
        }

        public static SdkProduct valueOf(String string) {
            return Enum.valueOf(SdkProduct.class, string);
        }

        private SdkProduct(int n2) {
            this.mType = n2;
        }

        static {
            SdkProduct sdkProduct;
            SdkProduct sdkProduct2;
            SdkProduct sdkProduct3;
            SdkProduct sdkProduct4 = sdkProduct3;
            NONE = new SdkProduct(0);
            SdkProduct sdkProduct5 = sdkProduct2;
            WEB_VIEW = new SdkProduct(1);
            SdkProduct sdkProduct6 = sdkProduct;
            NATIVE = new SdkProduct(2);
            $VALUES = new SdkProduct[]{sdkProduct4, sdkProduct5, sdkProduct6};
        }

        public int getType() {
            return this.mType;
        }
    }

    public static final class ScribeCategory
    extends Enum<ScribeCategory> {
        public static final /* enum */ ScribeCategory EXCHANGE_CLIENT_EVENT;
        public static final /* enum */ ScribeCategory EXCHANGE_CLIENT_ERROR;
        private static final /* synthetic */ ScribeCategory[] $VALUES;
        private final String mScribeCategory;

        public static ScribeCategory[] values() {
            return (ScribeCategory[])$VALUES.clone();
        }

        public static ScribeCategory valueOf(String string) {
            return Enum.valueOf(ScribeCategory.class, string);
        }

        private ScribeCategory(String string2) {
            this.mScribeCategory = string2;
        }

        static {
            ScribeCategory scribeCategory;
            ScribeCategory scribeCategory2;
            ScribeCategory scribeCategory3 = scribeCategory2;
            EXCHANGE_CLIENT_EVENT = new ScribeCategory("exchange_client_event");
            ScribeCategory scribeCategory4 = scribeCategory;
            EXCHANGE_CLIENT_ERROR = new ScribeCategory("exchange_client_error");
            $VALUES = new ScribeCategory[]{scribeCategory3, scribeCategory4};
        }

        public String getCategory() {
            return this.mScribeCategory;
        }
    }
}

