/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.event.ErrorEvent;
import com.tradplus.ads.common.util.LogUtil;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventSerializer {
    public JSONArray serializeAsJson(List<BaseEvent> jSONArray) {
        JSONArray jSONArray2;
        JSONArray jSONArray3 = jSONArray;
        Preconditions.checkNotNull(jSONArray3);
        jSONArray = jSONArray2;
        jSONArray2 = new JSONArray();
        for (BaseEvent baseEvent : jSONArray3) {
            try {
                jSONArray.put((Object)this.serializeAsJson(baseEvent));
            }
            catch (JSONException jSONException) {
                LogUtil.show("Failed to serialize event \"" + (Object)((Object)baseEvent.getName()) + "\" to JSON: ", (Object)jSONException);
            }
        }
        return jSONArray;
    }

    public JSONObject serializeAsJson(BaseEvent baseEvent) {
        JSONObject jSONObject;
        BaseEvent baseEvent2 = baseEvent;
        Preconditions.checkNotNull(baseEvent2);
        EventSerializer eventSerializer = jSONObject;
        eventSerializer();
        eventSerializer.put("_category_", baseEvent.getScribeCategory().getCategory());
        eventSerializer.put("ts", baseEvent.getTimestampUtcMs());
        eventSerializer.put("name", baseEvent.getName().getName());
        jSONObject.put("name_category", (Object)baseEvent.getCategory().getCategory());
        Object object = baseEvent2.getSdkProduct();
        String string = "sdk_product";
        object = object == null ? null : Integer.valueOf(((BaseEvent.SdkProduct)((Object)object)).getType());
        eventSerializer.put(string, object);
        eventSerializer.put("sdk_version", baseEvent.getSdkVersion());
        eventSerializer.put("ad_unit_id", baseEvent.getAdUnitId());
        eventSerializer.put("ad_creative_id", baseEvent.getAdCreativeId());
        eventSerializer.put("ad_type", baseEvent.getAdType());
        eventSerializer.put("ad_network_type", baseEvent.getAdNetworkType());
        eventSerializer.put("ad_width_px", baseEvent.getAdWidthPx());
        eventSerializer.put("ad_height_px", baseEvent.getAdHeightPx());
        eventSerializer.put("dsp_creative_id", baseEvent.getDspCreativeId());
        object = baseEvent.getAppPlatform();
        string = "app_platform";
        object = object == null ? null : Integer.valueOf(((BaseEvent.AppPlatform)((Object)object)).getType());
        eventSerializer.put(string, object);
        eventSerializer.put("app_name", baseEvent.getAppName());
        eventSerializer.put("app_package_name", baseEvent.getAppPackageName());
        eventSerializer.put("app_version", baseEvent.getAppVersion());
        eventSerializer.put("client_advertising_id", baseEvent.getObfuscatedClientAdvertisingId());
        eventSerializer.put("device_os_version", baseEvent.getDeviceOsVersion());
        eventSerializer.put("geo_lat", baseEvent.getGeoLat());
        eventSerializer.put("geo_lon", baseEvent.getGeoLon());
        eventSerializer.put("geo_accuracy_radius_meters", baseEvent.getGeoAccuracy());
        eventSerializer.put("perf_duration_ms", baseEvent.getPerformanceDurationMs());
        eventSerializer.put("network_iso_country_code", baseEvent.getNetworkIsoCountryCode());
        eventSerializer.put("req_id", baseEvent.getRequestId());
        eventSerializer.put("req_status_code", baseEvent.getRequestStatusCode());
        eventSerializer.put("req_uri", baseEvent.getRequestUri());
        eventSerializer.put("req_retries", baseEvent.getRequestRetries());
        eventSerializer.put("timestamp_client", baseEvent.getTimestampUtcMs());
        if (baseEvent instanceof ErrorEvent) {
            baseEvent = (ErrorEvent)baseEvent;
            eventSerializer.put("error_exception_class_name", ((ErrorEvent)baseEvent).getErrorExceptionClassName());
            eventSerializer.put("error_message", ((ErrorEvent)baseEvent).getErrorMessage());
            eventSerializer.put("error_stack_trace", ((ErrorEvent)baseEvent).getErrorStackTrace());
            eventSerializer.put("error_file_name", ((ErrorEvent)baseEvent).getErrorFileName());
            eventSerializer.put("error_class_name", ((ErrorEvent)baseEvent).getErrorClassName());
            eventSerializer.put("error_method_name", ((ErrorEvent)baseEvent).getErrorMethodName());
            eventSerializer.put("error_line_number", ((ErrorEvent)baseEvent).getErrorLineNumber());
        }
        return eventSerializer;
    }
}

