/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONObject;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.ParserConfig;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;

public class JSONArray
extends JSON
implements List<Object>,
Cloneable,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Object> list;
    protected transient Object relatedArray;
    protected transient Type componentType;

    public JSONArray() {
        ArrayList arrayList;
        List<Object> list = arrayList;
        arrayList = new ArrayList();
        v1.list = list;
    }

    public JSONArray(List<Object> list) {
        if (list != null) {
            this.list = list;
            return;
        }
        throw new IllegalArgumentException("list is null.");
    }

    public JSONArray(int n) {
        ArrayList arrayList;
        List<Object> list = arrayList;
        arrayList = new ArrayList(n);
        v1.list = list;
    }

    private void readObject(ObjectInputStream object2) {
        JSONObject.SecureObjectInputStream.ensureFields();
        if (JSONObject.SecureObjectInputStream.fields != null && !JSONObject.SecureObjectInputStream.fields_error) {
            try {
                new JSONObject.SecureObjectInputStream((ObjectInputStream)object2).defaultReadObject();
                return;
            }
            catch (NotActiveException notActiveException) {}
        }
        ((ObjectInputStream)object2).defaultReadObject();
        for (Object object2 : ((JSONArray)this).list) {
            if (object2 == null || TypeUtils.getClassFromMapping((String)(object2 = object2.getClass().getName())) != null) continue;
            ParserConfig.global.checkAutoType((String)object2, null);
        }
    }

    public Object getRelatedArray() {
        return this.relatedArray;
    }

    public void setRelatedArray(Object object) {
        this.relatedArray = object;
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public void setComponentType(Type type) {
        this.componentType = type;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.list.toArray(TArray);
    }

    @Override
    public boolean add(Object object) {
        return this.list.add(object);
    }

    public JSONArray fluentAdd(Object object) {
        JSONArray jSONArray = this;
        jSONArray.list.add(object);
        return jSONArray;
    }

    @Override
    public boolean remove(Object object) {
        return this.list.remove(object);
    }

    public JSONArray fluentRemove(Object object) {
        JSONArray jSONArray = this;
        jSONArray.list.remove(object);
        return jSONArray;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        return this.list.addAll(collection);
    }

    public JSONArray fluentAddAll(Collection<?> collection) {
        JSONArray jSONArray = this;
        jSONArray.list.addAll(collection);
        return jSONArray;
    }

    @Override
    public boolean addAll(int n, Collection<?> collection) {
        return this.list.addAll(n, collection);
    }

    public JSONArray fluentAddAll(int n, Collection<?> collection) {
        JSONArray jSONArray = this;
        jSONArray.list.addAll(n, collection);
        return jSONArray;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.list.removeAll(collection);
    }

    public JSONArray fluentRemoveAll(Collection<?> collection) {
        JSONArray jSONArray = this;
        jSONArray.list.removeAll(collection);
        return jSONArray;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.list.retainAll(collection);
    }

    public JSONArray fluentRetainAll(Collection<?> collection) {
        JSONArray jSONArray = this;
        jSONArray.list.retainAll(collection);
        return jSONArray;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public JSONArray fluentClear() {
        JSONArray jSONArray = this;
        jSONArray.list.clear();
        return jSONArray;
    }

    @Override
    public Object set(int n, Object object) {
        if (n == -1) {
            this.list.add(object);
            return null;
        }
        if (this.list.size() <= n) {
            for (int i = this.list.size(); i < n; ++i) {
                this.list.add(null);
            }
            this.list.add(object);
            return null;
        }
        return this.list.set(n, object);
    }

    public JSONArray fluentSet(int n, Object object) {
        JSONArray jSONArray = this;
        jSONArray.set(n, object);
        return jSONArray;
    }

    @Override
    public void add(int n, Object object) {
        this.list.add(n, object);
    }

    public JSONArray fluentAdd(int n, Object object) {
        JSONArray jSONArray = this;
        jSONArray.list.add(n, object);
        return jSONArray;
    }

    @Override
    public Object remove(int n) {
        return this.list.remove(n);
    }

    public JSONArray fluentRemove(int n) {
        JSONArray jSONArray = this;
        jSONArray.list.remove(n);
        return jSONArray;
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int n) {
        return this.list.listIterator(n);
    }

    @Override
    public List<Object> subList(int n, int n2) {
        return this.list.subList(n, n2);
    }

    @Override
    public Object get(int n) {
        return this.list.get(n);
    }

    public JSONObject getJSONObject(int n) {
        Object object = ((JSONArray)object).list.get(n);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object);
        }
        return (JSONObject)JSON.toJSON(object);
    }

    public JSONArray getJSONArray(int n) {
        Object object = ((JSONArray)object).list.get(n);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        return (JSONArray)JSON.toJSON(object);
    }

    public <T> T getObject(int n, Class<T> clazz) {
        return TypeUtils.castToJavaBean(this.list.get(n), clazz);
    }

    public <T> T getObject(int n, Type type) {
        Object object = ((JSONArray)object).list.get(n);
        if (type instanceof Class) {
            return TypeUtils.castToJavaBean(object, (Class)type);
        }
        return JSON.parseObject(JSON.toJSONString(object), type, new Feature[0]);
    }

    public Boolean getBoolean(int n) {
        if ((this = ((JSONArray)this).get(n)) == null) {
            return null;
        }
        return TypeUtils.castToBoolean(this);
    }

    public boolean getBooleanValue(int n) {
        if ((this = ((JSONArray)this).get(n)) == null) {
            return false;
        }
        return TypeUtils.castToBoolean(this);
    }

    public Byte getByte(int n) {
        return TypeUtils.castToByte(this.get(n));
    }

    public byte getByteValue(int n) {
        if ((this = TypeUtils.castToByte(((JSONArray)this).get(n))) == null) {
            return 0;
        }
        return (Byte)this;
    }

    public Short getShort(int n) {
        return TypeUtils.castToShort(this.get(n));
    }

    public short getShortValue(int n) {
        if ((this = TypeUtils.castToShort(((JSONArray)this).get(n))) == null) {
            return 0;
        }
        return (Short)this;
    }

    public Integer getInteger(int n) {
        return TypeUtils.castToInt(this.get(n));
    }

    public int getIntValue(int n) {
        if ((this = TypeUtils.castToInt(((JSONArray)this).get(n))) == null) {
            return 0;
        }
        return (Integer)this;
    }

    public Long getLong(int n) {
        return TypeUtils.castToLong(this.get(n));
    }

    public long getLongValue(int n) {
        if ((this = TypeUtils.castToLong(((JSONArray)this).get(n))) == null) {
            return 0L;
        }
        return (Long)this;
    }

    public Float getFloat(int n) {
        return TypeUtils.castToFloat(this.get(n));
    }

    public float getFloatValue(int n) {
        if ((this = TypeUtils.castToFloat(((JSONArray)this).get(n))) == null) {
            return 0.0f;
        }
        return ((Float)this).floatValue();
    }

    public Double getDouble(int n) {
        return TypeUtils.castToDouble(this.get(n));
    }

    public double getDoubleValue(int n) {
        if ((this = TypeUtils.castToDouble(((JSONArray)this).get(n))) == null) {
            return 0.0;
        }
        return (Double)this;
    }

    public BigDecimal getBigDecimal(int n) {
        return TypeUtils.castToBigDecimal(this.get(n));
    }

    public BigInteger getBigInteger(int n) {
        return TypeUtils.castToBigInteger(this.get(n));
    }

    public String getString(int n) {
        return TypeUtils.castToString(this.get(n));
    }

    public java.util.Date getDate(int n) {
        return TypeUtils.castToDate(this.get(n));
    }

    public Date getSqlDate(int n) {
        return TypeUtils.castToSqlDate(this.get(n));
    }

    public Timestamp getTimestamp(int n) {
        return TypeUtils.castToTimestamp(this.get(n));
    }

    public <T> List<T> toJavaList(Class<T> clazz) {
        ArrayList<T> arrayList;
        JSONArray jSONArray = parserConfig;
        ArrayList<T> arrayList2 = arrayList;
        arrayList = new ArrayList<T>(((JSONArray)((Object)parserConfig)).size());
        ParserConfig parserConfig = ParserConfig.getGlobalInstance();
        Iterator<Object> iterator = jSONArray.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(TypeUtils.cast(iterator.next(), clazz, parserConfig));
        }
        return arrayList2;
    }

    public Object clone() {
        return new JSONArray(new ArrayList<Object>(this.list));
    }

    @Override
    public boolean equals(Object object) {
        return this.list.equals(object);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }
}

