/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONArray;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.TypeReference;
import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.ParserConfig;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class JSONObject
extends JSON
implements Map<String, Object>,
Cloneable,
Serializable,
InvocationHandler {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<String, Object> map;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(Map<String, Object> map) {
        if (map != null) {
            this.map = map;
            return;
        }
        throw new IllegalArgumentException("map is null.");
    }

    public JSONObject(boolean bl) {
        this(16, bl);
    }

    public JSONObject(int n) {
        this(n, false);
    }

    public JSONObject(int n, boolean bl) {
        Map<String, Object> map;
        if (bl) {
            LinkedHashMap linkedHashMap;
            JSONObject jSONObject = map;
            map = linkedHashMap;
            linkedHashMap = new LinkedHashMap(n);
            jSONObject.map = map;
        } else {
            HashMap hashMap;
            JSONObject jSONObject = map;
            map = hashMap;
            hashMap = new HashMap(n);
            jSONObject.map = map;
        }
    }

    private void readObject(ObjectInputStream object2) {
        SecureObjectInputStream.ensureFields();
        if (SecureObjectInputStream.fields != null && !SecureObjectInputStream.fields_error) {
            try {
                new SecureObjectInputStream((ObjectInputStream)object2).defaultReadObject();
                return;
            }
            catch (NotActiveException notActiveException) {}
        }
        ((ObjectInputStream)object2).defaultReadObject();
        for (Map.Entry entry : ((JSONObject)this).map.entrySet()) {
            Object v;
            Object k = entry.getKey();
            if (k != null) {
                ParserConfig.global.checkAutoType(k.getClass());
            }
            if ((v = entry.getValue()) == null) continue;
            ParserConfig.global.checkAutoType(v.getClass());
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        boolean bl = this.map.containsKey(object);
        if (!bl && (object instanceof Number || object instanceof Character || object instanceof Boolean || object instanceof UUID)) {
            bl = this.map.containsKey(object.toString());
        }
        return bl;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Object get(Object object) {
        Object object2 = this.map.get(object);
        if (object2 == null && (object instanceof Number || object instanceof Character || object instanceof Boolean || object instanceof UUID)) {
            object2 = this.map.get(object.toString());
        }
        return object2;
    }

    public JSONObject getJSONObject(String string) {
        Object object = ((JSONObject)object).map.get(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object);
        }
        if (object instanceof String) {
            return JSON.parseObject((String)object);
        }
        return (JSONObject)JSON.toJSON(object);
    }

    public JSONArray getJSONArray(String string) {
        Object object = ((JSONObject)object).map.get(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        if (object instanceof String) {
            return (JSONArray)JSON.parse((String)object);
        }
        return (JSONArray)JSON.toJSON(object);
    }

    public <T> T getObject(String string, Class<T> clazz) {
        return TypeUtils.castToJavaBean(this.map.get(string), clazz);
    }

    public <T> T getObject(String string, Type type) {
        return TypeUtils.cast(this.map.get(string), type, ParserConfig.getGlobalInstance());
    }

    public <T> T getObject(String string, TypeReference typeReference) {
        Object object = ((JSONObject)object).map.get(string);
        if (typeReference == null) {
            return (T)object;
        }
        return TypeUtils.cast(object, typeReference.getType(), ParserConfig.getGlobalInstance());
    }

    public Boolean getBoolean(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return null;
        }
        return TypeUtils.castToBoolean(this);
    }

    public byte[] getBytes(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return null;
        }
        return TypeUtils.castToBytes(this);
    }

    public boolean getBooleanValue(String string) {
        if ((this = TypeUtils.castToBoolean(((JSONObject)this).get(string))) == null) {
            return false;
        }
        return (Boolean)this;
    }

    public Byte getByte(String string) {
        return TypeUtils.castToByte(this.get(string));
    }

    public byte getByteValue(String string) {
        if ((this = TypeUtils.castToByte(((JSONObject)this).get(string))) == null) {
            return 0;
        }
        return (Byte)this;
    }

    public Short getShort(String string) {
        return TypeUtils.castToShort(this.get(string));
    }

    public short getShortValue(String string) {
        if ((this = TypeUtils.castToShort(((JSONObject)this).get(string))) == null) {
            return 0;
        }
        return (Short)this;
    }

    public Integer getInteger(String string) {
        return TypeUtils.castToInt(this.get(string));
    }

    public int getIntValue(String string) {
        if ((this = TypeUtils.castToInt(((JSONObject)this).get(string))) == null) {
            return 0;
        }
        return (Integer)this;
    }

    public Long getLong(String string) {
        return TypeUtils.castToLong(this.get(string));
    }

    public long getLongValue(String string) {
        if ((this = TypeUtils.castToLong(((JSONObject)this).get(string))) == null) {
            return 0L;
        }
        return (Long)this;
    }

    public Float getFloat(String string) {
        return TypeUtils.castToFloat(this.get(string));
    }

    public float getFloatValue(String string) {
        if ((this = TypeUtils.castToFloat(((JSONObject)this).get(string))) == null) {
            return 0.0f;
        }
        return ((Float)this).floatValue();
    }

    public Double getDouble(String string) {
        return TypeUtils.castToDouble(this.get(string));
    }

    public double getDoubleValue(String string) {
        if ((this = TypeUtils.castToDouble(((JSONObject)this).get(string))) == null) {
            return 0.0;
        }
        return (Double)this;
    }

    public BigDecimal getBigDecimal(String string) {
        return TypeUtils.castToBigDecimal(this.get(string));
    }

    public BigInteger getBigInteger(String string) {
        return TypeUtils.castToBigInteger(this.get(string));
    }

    public String getString(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return null;
        }
        return this.toString();
    }

    public java.util.Date getDate(String string) {
        return TypeUtils.castToDate(this.get(string));
    }

    public Date getSqlDate(String string) {
        return TypeUtils.castToSqlDate(this.get(string));
    }

    public Timestamp getTimestamp(String string) {
        return TypeUtils.castToTimestamp(this.get(string));
    }

    @Override
    public Object put(String string, Object object) {
        return this.map.put(string, object);
    }

    public JSONObject fluentPut(String string, Object object) {
        JSONObject jSONObject = this;
        jSONObject.map.put(string, object);
        return jSONObject;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.map.putAll(map);
    }

    public JSONObject fluentPutAll(Map<? extends String, ?> map) {
        JSONObject jSONObject = this;
        jSONObject.map.putAll(map);
        return jSONObject;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public JSONObject fluentClear() {
        JSONObject jSONObject = this;
        jSONObject.map.clear();
        return jSONObject;
    }

    @Override
    public Object remove(Object object) {
        return this.map.remove(object);
    }

    public JSONObject fluentRemove(Object object) {
        JSONObject jSONObject = this;
        jSONObject.map.remove(object);
        return jSONObject;
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Object clone() {
        JSONObject jSONObject;
        HashMap hashMap;
        if (this.map instanceof LinkedHashMap) {
            LinkedHashMap<String, Object> linkedHashMap;
            hashMap = linkedHashMap;
            linkedHashMap = new LinkedHashMap<String, Object>(this.map);
        } else {
            HashMap<String, Object> hashMap2;
            hashMap = hashMap2;
            hashMap2 = new HashMap<String, Object>(this.map);
        }
        JSONObject jSONObject2 = jSONObject;
        jSONObject2(hashMap);
        return jSONObject2;
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object object, Method method, Object[] object2) {
        object = method.getParameterTypes();
        if (((Class<?>[])object).length == 1) {
            if (method.getName().equals("equals")) {
                return this.equals(object2[0]);
            }
            if (method.getReturnType() != Void.TYPE) throw new JSONException("illegal setter");
            object = null;
            JSONField jSONField = TypeUtils.getAnnotation(method, JSONField.class);
            if (jSONField != null && jSONField.name().length() != 0) {
                object = jSONField.name();
            }
            if (object == null) {
                object = method.getName();
                if (!((String)object).startsWith("set")) throw new JSONException("illegal setter");
                if (((String)(object = ((String)object).substring(3))).length() == 0) throw new JSONException("illegal setter");
                object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
            }
            this.map.put((String)object, object2[0]);
            return null;
        }
        if (((Object)object).length != 0) throw new UnsupportedOperationException(method.toGenericString());
        if (method.getReturnType() == Void.TYPE) throw new JSONException("illegal getter");
        object = null;
        object2 = TypeUtils.getAnnotation(method, JSONField.class);
        if (object2 != null && object2.name().length() != 0) {
            object = object2.name();
        }
        if (object != null) return TypeUtils.cast(this.map.get(object), method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        object = method.getName();
        if (((String)object).startsWith("get")) {
            if (((String)(object = ((String)object).substring(3))).length() == 0) throw new JSONException("illegal getter");
            object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
            return TypeUtils.cast(this.map.get(object), method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        } else if (((String)object).startsWith("is")) {
            if (((String)(object = ((String)object).substring(2))).length() == 0) throw new JSONException("illegal getter");
            object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
            return TypeUtils.cast(this.map.get(object), method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        } else {
            if (((String)object).startsWith("hashCode")) {
                return this.hashCode();
            }
            if (!((String)object).startsWith("toString")) throw new JSONException("illegal getter");
            return this.toString();
        }
    }

    public Map<String, Object> getInnerMap() {
        return this.map;
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) {
        if (clazz != Map.class && clazz != JSONObject.class && clazz != JSON.class) {
            if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
                return (T)this;
            }
            return TypeUtils.castToJavaBean(this, clazz, ParserConfig.getGlobalInstance());
        }
        return (T)this;
    }

    public <T> T toJavaObject(Class<T> clazz, ParserConfig parserConfig, int n) {
        if (clazz == Map.class) {
            return (T)this;
        }
        if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
            return (T)this;
        }
        return TypeUtils.castToJavaBean(this, clazz, parserConfig);
    }

    static class SecureObjectInputStream
    extends ObjectInputStream {
        static Field[] fields;
        static volatile boolean fields_error;

        static void ensureFields() {
            if (fields == null && !fields_error) {
                Field[] fieldArray = ObjectInputStream.class.getDeclaredFields();
                int n = 4;
                String[] stringArray = new String[4];
                String[] stringArray2 = stringArray;
                stringArray[0] = "bin";
                stringArray[1] = "passHandle";
                stringArray[2] = "handles";
                stringArray[3] = "curContext";
                Field[] fieldArray2 = new Field[4];
                for (int i = 0; i < n; ++i) {
                    TypeUtils.getField(ObjectInputStream.class, stringArray2[i], fieldArray).setAccessible(true);
                    continue;
                }
                try {
                    fields = fieldArray2;
                }
                catch (Throwable throwable) {
                    fields_error = true;
                    throwable.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SecureObjectInputStream(ObjectInputStream objectInputStream) {
            super(objectInputStream);
            int n = 0;
            while (true) {
                Field field;
                Field[] fieldArray;
                int n2;
                try {
                    n2 = n;
                    fieldArray = fields;
                }
                catch (IllegalAccessException illegalAccessException) {
                    fields_error = true;
                    return;
                }
                {
                    if (n2 >= fields.length) return;
                    field = fieldArray[n];
                }
                {
                    field.set(this, field.get(objectInputStream));
                    ++n;
                    continue;
                }
                break;
            }
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) {
            String string = objectStreamClass.getName();
            if (string.length() > 2) {
                int n = string.lastIndexOf(91);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                if (string.length() > 2 && string.charAt(0) == 'L') {
                    String string2 = string;
                    if (string2.charAt(string2.length() - 1) == ';') {
                        String string3 = string;
                        string = string3.substring(1, string3.length() - 1);
                    }
                }
                if (TypeUtils.getClassFromMapping(string) == null) {
                    ParserConfig.global.checkAutoType(string, null, Feature.SupportAutoType.mask);
                }
            }
            return super.resolveClass(objectStreamClass);
        }

        @Override
        protected Class<?> resolveProxyClass(String[] stringArray) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                if (TypeUtils.getClassFromMapping(string) != null) continue;
                ParserConfig.global.checkAutoType(string, null);
            }
            return super.resolveProxyClass(stringArray);
        }

        @Override
        protected void readStreamHeader() {
        }
    }
}

