/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSONException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class JSONValidator
implements Cloneable,
Closeable {
    protected boolean eof;
    protected int pos = -1;
    protected char ch;
    protected Type type;
    protected int count = 0;
    protected boolean supportMultiValue = true;

    public static JSONValidator fromUtf8(byte[] byArray) {
        return new UTF8Validator(byArray);
    }

    public static JSONValidator fromUtf8(InputStream inputStream) {
        return new UTF8InputStreamValidator(inputStream);
    }

    public static JSONValidator from(String string) {
        return new UTF16Validator(string);
    }

    public static JSONValidator from(Reader reader) {
        return new ReaderValidator(reader);
    }

    /*
     * Unable to fully structure code
     */
    private boolean any() {
        block39: {
            block47: {
                block49: {
                    block48: {
                        block46: {
                            block45: {
                                block40: {
                                    block41: {
                                        block42: {
                                            block43: {
                                                block44: {
                                                    var1_1 = this.ch;
                                                    if (var1_1 == '\"') break block39;
                                                    if (var1_1 == '+' || var1_1 == '-') ** GOTO lbl131
                                                    if (var1_1 == '[') break block40;
                                                    if (var1_1 == 'f') break block41;
                                                    if (var1_1 == 'n') break block42;
                                                    if (var1_1 == 't') break block43;
                                                    if (var1_1 == '{') break block44;
                                                    switch (var1_1) {
                                                        default: {
                                                            return false;
                                                        }
                                                        case '0': 
                                                        case '1': 
                                                        case '2': 
                                                        case '3': 
                                                        case '4': 
                                                        case '5': 
                                                        case '6': 
                                                        case '7': 
                                                        case '8': 
                                                        case '9': {
                                                            if (var1_1 == '-') break block45;
                                                        }
                                                    }
                                                }
                                                do {
                                                    this.next();
                                                } while (JSONValidator.isWhiteSpace(this.ch));
                                                if (this.ch == '}') {
                                                    this.next();
                                                    this.type = Type.Object;
                                                    return true;
                                                }
                                                while (this.ch == '\"') {
                                                    v0 = this;
                                                    v0.fieldName();
                                                    v0.skipWhiteSpace();
                                                    if (v0.ch == ':') {
                                                        v1 = this;
                                                        v1.next();
                                                        v1.skipWhiteSpace();
                                                        if (!v1.any()) {
                                                            return false;
                                                        }
                                                        v2 = this;
                                                        v2.skipWhiteSpace();
                                                        var1_1 = v2.ch;
                                                        if (var1_1 == ',') {
                                                            v3 = this;
                                                            v3.next();
                                                            v3.skipWhiteSpace();
                                                            continue;
                                                        }
                                                        if (var1_1 != '}') continue;
                                                        this.next();
                                                        this.type = Type.Object;
                                                        return true;
                                                    }
                                                    return false;
                                                }
                                                return false;
                                            }
                                            v4 = this;
                                            v4.next();
                                            if (v4.ch != 'r') {
                                                return false;
                                            }
                                            v5 = this;
                                            v5.next();
                                            if (v5.ch != 'u') {
                                                return false;
                                            }
                                            v6 = this;
                                            v6.next();
                                            if (v6.ch != 'e') {
                                                return false;
                                            }
                                            v7 = this;
                                            v7.next();
                                            if (!JSONValidator.isWhiteSpace(v7.ch) && (var1_1 = this.ch) != ',' && var1_1 != ']' && var1_1 != '}' && var1_1 != '\u0000') {
                                                return false;
                                            }
                                            this.type = Type.Value;
                                            return true;
                                        }
                                        v8 = this;
                                        v8.next();
                                        if (v8.ch != 'u') {
                                            return false;
                                        }
                                        v9 = this;
                                        v9.next();
                                        if (v9.ch != 'l') {
                                            return false;
                                        }
                                        v10 = this;
                                        v10.next();
                                        if (v10.ch != 'l') {
                                            return false;
                                        }
                                        v11 = this;
                                        v11.next();
                                        if (!JSONValidator.isWhiteSpace(v11.ch) && (var1_1 = this.ch) != ',' && var1_1 != ']' && var1_1 != '}' && var1_1 != '\u0000') {
                                            return false;
                                        }
                                        this.type = Type.Value;
                                        return true;
                                    }
                                    v12 = this;
                                    v12.next();
                                    if (v12.ch != 'a') {
                                        return false;
                                    }
                                    v13 = this;
                                    v13.next();
                                    if (v13.ch != 'l') {
                                        return false;
                                    }
                                    v14 = this;
                                    v14.next();
                                    if (v14.ch != 's') {
                                        return false;
                                    }
                                    v15 = this;
                                    v15.next();
                                    if (v15.ch != 'e') {
                                        return false;
                                    }
                                    v16 = this;
                                    v16.next();
                                    if (!JSONValidator.isWhiteSpace(v16.ch) && (var1_1 = this.ch) != ',' && var1_1 != ']' && var1_1 != '}' && var1_1 != '\u0000') {
                                        return false;
                                    }
                                    this.type = Type.Value;
                                    return true;
                                }
                                v17 = this;
                                v17.next();
                                v17.skipWhiteSpace();
                                if (v17.ch == ']') {
                                    this.next();
                                    this.type = Type.Array;
                                    return true;
                                }
                                while (true) {
                                    if (!this.any()) {
                                        return false;
                                    }
                                    v18 = this;
                                    v18.skipWhiteSpace();
                                    var1_1 = v18.ch;
                                    if (var1_1 != ',') break;
                                    v19 = this;
                                    v19.next();
                                    v19.skipWhiteSpace();
                                }
                                if (var1_1 == ']') {
                                    this.next();
                                    this.type = Type.Array;
                                    return true;
                                }
                                return false;
lbl131:
                                // 1 sources

                                if (var1_1 == '-') break block45;
                                if (var1_1 != '+') break block46;
                            }
                            v20 = this;
                            v20.next();
                            v20.skipWhiteSpace();
                            var1_1 = v20.ch;
                            if (var1_1 < '0' || var1_1 > '9') break block47;
                        }
                        do {
                            v21 = this;
                            v21.next();
                        } while ((var1_1 = v21.ch) >= '0' && var1_1 <= '9');
                        if (var1_1 == '.') {
                            v22 = this;
                            v22.next();
                            var1_1 = v22.ch;
                            if (var1_1 >= '0' && var1_1 <= '9') {
                                while ((var1_1 = this.ch) >= '0' && var1_1 <= '9') {
                                    this.next();
                                }
                            } else {
                                return false;
                            }
                        }
                        if ((var1_1 = this.ch) != 'e' && var1_1 != 'E') break block48;
                        v23 = this;
                        v23.next();
                        var1_1 = v23.ch;
                        if (var1_1 == '-' || var1_1 == '+') {
                            this.next();
                        }
                        if ((var1_1 = this.ch) < '0' || var1_1 > '9') break block49;
                        do {
                            this.next();
                            var1_1 = this.ch;
                        } while (var1_1 >= '0' && var1_1 <= '9');
                    }
                    this.type = Type.Value;
                    return true;
                }
                return false;
            }
            return false;
        }
        block9: while (true) {
            this.next();
            while (true) {
                if (this.eof) {
                    return false;
                }
                var1_1 = this.ch;
                if (var1_1 != '\\') break;
                v24 = this;
                v24.next();
                if (v24.ch != 'u') continue block9;
                v25 = this;
                v25.next();
                v25.next();
                v25.next();
                v25.next();
                v25.next();
            }
            if (var1_1 == '\"') break;
        }
        this.next();
        this.type = Type.Value;
        return true;
    }

    static final boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f' || c == '\b';
    }

    public boolean isSupportMultiValue() {
        return this.supportMultiValue;
    }

    public void setSupportMultiValue(boolean bl) {
        this.supportMultiValue = bl;
    }

    public Type getType() {
        if (this.type == null) {
            this.validate();
        }
        return this.type;
    }

    abstract void next();

    public boolean validate() {
        block3: {
            JSONValidator jSONValidator;
            do {
                if (!this.any()) {
                    return false;
                }
                JSONValidator jSONValidator2 = this;
                ++jSONValidator2.count;
                if (jSONValidator2.eof) {
                    return true;
                }
                if (!this.supportMultiValue) break block3;
                jSONValidator = this;
                jSONValidator.skipWhiteSpace();
            } while (!jSONValidator.eof);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
    }

    protected void fieldName() {
        this.next();
        while (true) {
            char c;
            if ((c = this.ch) == '\\') {
                JSONValidator jSONValidator = this;
                jSONValidator.next();
                if (jSONValidator.ch == 'u') {
                    JSONValidator jSONValidator2 = this;
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    continue;
                }
            } else if (c == '\"') {
                this.next();
                return;
            }
            this.next();
        }
    }

    protected boolean string() {
        this.next();
        while (!this.eof) {
            char c = this.ch;
            if (c == '\\') {
                JSONValidator jSONValidator = this;
                jSONValidator.next();
                if (jSONValidator.ch == 'u') {
                    JSONValidator jSONValidator2 = this;
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    continue;
                }
            } else if (c == '\"') {
                this.next();
                return true;
            }
            this.next();
        }
        return false;
    }

    void skipWhiteSpace() {
        while (JSONValidator.isWhiteSpace(this.ch)) {
            this.next();
        }
    }

    static class ReaderValidator
    extends JSONValidator {
        private static final ThreadLocal<char[]> bufLocal = new ThreadLocal();
        final Reader r;
        private char[] buf;
        private int end = -1;
        private int readCount = 0;

        ReaderValidator(Reader object) {
            this.r = object;
            object = bufLocal;
            this.buf = ((ThreadLocal)object).get();
            if (this.buf != null) {
                ((ThreadLocal)object).set(null);
            } else {
                this.buf = new char[8192];
            }
            ReaderValidator readerValidator = this;
            readerValidator.next();
            readerValidator.skipWhiteSpace();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        void next() {
            int n;
            block6: {
                char[] cArray;
                Reader reader;
                n = this.pos;
                if (n < this.end) {
                    int n2;
                    this.pos = n2 = n + 1;
                    this.ch = this.buf[n2];
                    return;
                }
                if (this.eof) return;
                try {
                    reader = this.r;
                    cArray = this.buf;
                    n = 0;
                }
                catch (IOException iOException) {
                    throw new JSONException("read error");
                }
                {
                    n = reader.read(this.buf, n, cArray.length);
                }
                {
                    ++this.readCount;
                    if (n <= 0) break block6;
                }
                this.ch = this.buf[0];
                this.pos = 0;
                this.end = n - 1;
                return;
            }
            if (n == -1) {
                ReaderValidator readerValidator = this;
                readerValidator.pos = 0;
                readerValidator.end = 0;
                readerValidator.buf = null;
                readerValidator.ch = '\u0000';
                readerValidator.eof = true;
                return;
            }
            ReaderValidator readerValidator = this;
            readerValidator.pos = 0;
            readerValidator.end = 0;
            readerValidator.buf = null;
            readerValidator.ch = '\u0000';
            readerValidator.eof = true;
            throw new JSONException("read error");
        }

        @Override
        public void close() {
            bufLocal.set(this.buf);
            this.r.close();
        }
    }

    static class UTF16Validator
    extends JSONValidator {
        private final String str;

        public UTF16Validator(String string) {
            UTF16Validator uTF16Validator = this;
            uTF16Validator.str = string;
            uTF16Validator.next();
            uTF16Validator.skipWhiteSpace();
        }

        @Override
        void next() {
            int n;
            this.pos = n = this.pos + 1;
            if (n >= this.str.length()) {
                UTF16Validator uTF16Validator = this;
                uTF16Validator.ch = '\u0000';
                uTF16Validator.eof = true;
            } else {
                this.ch = this.str.charAt(this.pos);
            }
        }

        @Override
        protected final void fieldName() {
            char c;
            int n;
            for (n = this.pos + 1; n < this.str.length() && (c = this.str.charAt(n)) != '\\'; ++n) {
                if (c != '\"') continue;
                int n2 = n + 1;
                this.ch = this.str.charAt(n2);
                this.pos = n2;
                return;
            }
            block1: while (true) {
                this.next();
                while (true) {
                    char c2 = this.ch;
                    n = c2;
                    if (c2 != '\\') break;
                    UTF16Validator uTF16Validator = this;
                    uTF16Validator.next();
                    if (uTF16Validator.ch != 'u') continue block1;
                    UTF16Validator uTF16Validator2 = this;
                    uTF16Validator2.next();
                    uTF16Validator2.next();
                    uTF16Validator2.next();
                    uTF16Validator2.next();
                    uTF16Validator2.next();
                }
                if (n == 34) break;
            }
            this.next();
        }

        @Override
        final void skipWhiteSpace() {
            if (this.ch > '\r') {
                return;
            }
            while (JSONValidator.isWhiteSpace(this.ch)) {
                this.next();
            }
        }
    }

    static class UTF8InputStreamValidator
    extends JSONValidator {
        private static final ThreadLocal<byte[]> bufLocal = new ThreadLocal();
        private final InputStream is;
        private byte[] buf;
        private int end = -1;
        private int readCount = 0;

        public UTF8InputStreamValidator(InputStream object) {
            this.is = object;
            object = bufLocal;
            this.buf = ((ThreadLocal)object).get();
            if (this.buf != null) {
                ((ThreadLocal)object).set(null);
            } else {
                this.buf = new byte[8192];
            }
            UTF8InputStreamValidator uTF8InputStreamValidator = this;
            uTF8InputStreamValidator.next();
            uTF8InputStreamValidator.skipWhiteSpace();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        void next() {
            int n;
            block6: {
                byte[] byArray;
                InputStream inputStream;
                n = this.pos;
                if (n < this.end) {
                    int n2;
                    this.pos = n2 = n + 1;
                    this.ch = (char)this.buf[n2];
                    return;
                }
                if (this.eof) return;
                try {
                    inputStream = this.is;
                    byArray = this.buf;
                    n = 0;
                }
                catch (IOException iOException) {
                    throw new JSONException("read error");
                }
                {
                    n = inputStream.read(this.buf, n, byArray.length);
                }
                {
                    ++this.readCount;
                    if (n <= 0) break block6;
                }
                this.ch = (char)this.buf[0];
                this.pos = 0;
                this.end = n - 1;
                return;
            }
            if (n == -1) {
                UTF8InputStreamValidator uTF8InputStreamValidator = this;
                uTF8InputStreamValidator.pos = 0;
                uTF8InputStreamValidator.end = 0;
                uTF8InputStreamValidator.buf = null;
                uTF8InputStreamValidator.ch = '\u0000';
                uTF8InputStreamValidator.eof = true;
                return;
            }
            UTF8InputStreamValidator uTF8InputStreamValidator = this;
            uTF8InputStreamValidator.pos = 0;
            uTF8InputStreamValidator.end = 0;
            uTF8InputStreamValidator.buf = null;
            uTF8InputStreamValidator.ch = '\u0000';
            uTF8InputStreamValidator.eof = true;
            throw new JSONException("read error");
        }

        @Override
        public void close() {
            bufLocal.set(this.buf);
            this.is.close();
        }
    }

    static class UTF8Validator
    extends JSONValidator {
        private final byte[] bytes;

        public UTF8Validator(byte[] byArray) {
            UTF8Validator uTF8Validator = this;
            uTF8Validator.bytes = byArray;
            uTF8Validator.next();
            uTF8Validator.skipWhiteSpace();
        }

        @Override
        void next() {
            int n = this.pos + 1;
            UTF8Validator uTF8Validator = this;
            uTF8Validator.pos = n;
            byte[] byArray = uTF8Validator.bytes;
            if (n >= uTF8Validator.bytes.length) {
                UTF8Validator uTF8Validator2 = this;
                uTF8Validator2.ch = '\u0000';
                uTF8Validator2.eof = true;
            } else {
                this.ch = (char)byArray[n];
            }
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Object;
        public static final /* enum */ Type Array;
        public static final /* enum */ Type Value;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        static {
            Type type;
            Type type2;
            Type type3;
            Type type4 = type3;
            Object = new Type();
            Type type5 = type2;
            Array = new Type();
            Type type6 = type;
            Value = new Type();
            $VALUES = new Type[]{type4, type5, type6};
        }
    }
}

