/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.asm;

import com.tradplus.ads.common.serialization.asm.ByteVector;
import com.tradplus.ads.common.serialization.asm.ClassWriter;
import com.tradplus.ads.common.serialization.asm.Item;
import com.tradplus.ads.common.serialization.asm.Label;
import com.tradplus.ads.common.serialization.asm.MethodVisitor;
import com.tradplus.ads.common.serialization.asm.Type;

public class MethodWriter
implements MethodVisitor {
    MethodWriter next;
    final ClassWriter cw;
    private int access;
    private final int name;
    private final int desc;
    int exceptionCount;
    int[] exceptions;
    private ByteVector code = new ByteVector();
    private int maxStack;
    private int maxLocals;

    public MethodWriter(ClassWriter classWriter, int n, String string, String string2, String string3, String[] stringArray) {
        if (classWriter.firstMethod == null) {
            classWriter.firstMethod = this;
        } else {
            classWriter.lastMethod.next = this;
        }
        classWriter.lastMethod = this;
        this.cw = classWriter;
        this.access = n;
        this.name = classWriter.newUTF8(string);
        this.desc = classWriter.newUTF8(string2);
        if (stringArray != null && stringArray.length > 0) {
            MethodWriter methodWriter = this;
            methodWriter.exceptionCount = n = stringArray.length;
            methodWriter.exceptions = new int[n];
            for (n = 0; n < this.exceptionCount; ++n) {
                this.exceptions[n] = classWriter.newClassItem((String)stringArray[n]).index;
            }
        }
    }

    @Override
    public void visitInsn(int n) {
        this.code.putByte(n);
    }

    @Override
    public void visitIntInsn(int n, int n2) {
        this.code.put11(n, n2);
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        if (n2 < 4 && n != 169) {
            n = n < 54 ? (n - 21 << 2) + 26 + n2 : (n - 54 << 2) + 59 + n2;
            this.code.putByte(n);
        } else if (n2 >= 256) {
            this.code.putByte(196).put12(n, n2);
        } else {
            this.code.put11(n, n2);
        }
    }

    @Override
    public void visitTypeInsn(int n, String string) {
        MethodWriter methodWriter = item;
        Item item = methodWriter.cw.newClassItem(string);
        methodWriter.code.put12(n, item.index);
    }

    @Override
    public void visitFieldInsn(int n, String string, String string2, String string3) {
        MethodWriter methodWriter = item;
        Item item = methodWriter.cw.newFieldItem(string, string2, string3);
        methodWriter.code.put12(n, item.index);
    }

    @Override
    public void visitMethodInsn(int n, String object, String string, String string2) {
        boolean bl = n == 185;
        object = this.cw.newMethodItem((String)object, string, string2, bl);
        int n2 = ((Item)object).intVal;
        if (bl) {
            if (n2 == 0) {
                ((Item)object).intVal = n2 = Type.getArgumentsAndReturnSizes(string2);
            }
            this.code.put12(185, ((Item)object).index).put11(n2 >> 2, 0);
        } else {
            this.code.put12(n, ((Item)object).index);
        }
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        if ((label.status & 2) != 0 && label.position - this.code.length < Short.MIN_VALUE) {
            throw new UnsupportedOperationException();
        }
        MethodWriter methodWriter = this;
        methodWriter.code.putByte(n);
        ByteVector byteVector = methodWriter.code;
        int n2 = byteVector.length - 1;
        boolean bl = n == 200;
        label.put(this, byteVector, n2, bl);
    }

    @Override
    public void visitLabel(Label label) {
        ByteVector byteVector = this.code;
        int n = byteVector.length;
        byte[] byArray = byteVector.data;
        label.resolve(this, n, byArray);
    }

    @Override
    public void visitLdcInsn(Object object) {
        Item item = this.cw.newConstItem(object);
        int n = item.index;
        int n2 = item.type;
        if (n2 != 5 && n2 != 6) {
            if (n >= 256) {
                this.code.put12(19, n);
            } else {
                this.code.put11(18, n);
            }
        } else {
            this.code.put12(20, n);
        }
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        this.code.putByte(132).put11(n, n2);
    }

    @Override
    public void visitMaxs(int n, int n2) {
        MethodWriter methodWriter = this;
        methodWriter.maxStack = n;
        methodWriter.maxLocals = n2;
    }

    @Override
    public void visitEnd() {
    }

    final int getSize() {
        int n = 8;
        if (this.code.length > 0) {
            MethodWriter methodWriter = this;
            methodWriter.cw.newUTF8("Code");
            n = methodWriter.code.length + 18 + 0 + n;
        }
        if (this.exceptionCount > 0) {
            MethodWriter methodWriter = this;
            methodWriter.cw.newUTF8("Exceptions");
            n += methodWriter.exceptionCount * 2 + 8;
        }
        return n;
    }

    final void put(ByteVector byteVector) {
        byteVector.putShort(this.access & 0xFFF9FFFF).putShort(this.name).putShort(this.desc);
        int n = 0;
        if (this.code.length > 0) {
            n = 1;
        }
        if (this.exceptionCount > 0) {
            ++n;
        }
        byteVector.putShort(n);
        n = this.code.length;
        if (n > 0) {
            ByteVector byteVector2 = byteVector;
            n = n + 12 + 0;
            byteVector.putShort(this.cw.newUTF8("Code")).putInt(n);
            byteVector.putShort(this.maxStack).putShort(this.maxLocals);
            ByteVector byteVector3 = this.code;
            byte[] byArray = byteVector3.data;
            int n2 = byteVector3.length;
            byteVector2.putInt(this.code.length).putByteArray(byArray, 0, n2);
            byteVector2.putShort(0);
            byteVector2.putShort(0);
        }
        if (this.exceptionCount > 0) {
            byteVector.putShort(this.cw.newUTF8("Exceptions")).putInt(this.exceptionCount * 2 + 2);
            byteVector.putShort(this.exceptionCount);
            for (int i = 0; i < this.exceptionCount; ++i) {
                byteVector.putShort(this.exceptions[i]);
            }
        }
    }
}

