/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.asm;

import com.tradplus.ads.common.serialization.annotation.JSONType;
import com.tradplus.ads.common.serialization.asm.MethodCollector;
import com.tradplus.ads.common.serialization.asm.Type;
import com.tradplus.ads.common.serialization.util.ASMUtils;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class TypeCollector {
    private static String JSONType = ASMUtils.desc(JSONType.class);
    private static final Map<String, String> primitives = new HashMap<String, String>(){
        {
            1 v0 = this;
            v0.put("int", "I");
            v0.put("boolean", "Z");
            v0.put("byte", "B");
            v0.put("char", "C");
            v0.put("short", "S");
            v0.put("float", "F");
            v0.put("long", "J");
            v0.put("double", "D");
        }
    };
    private final String methodName;
    private final Class<?>[] parameterTypes;
    protected MethodCollector collector;
    protected boolean jsonType;

    public TypeCollector(String string, Class<?>[] classArray) {
        this.methodName = string;
        this.parameterTypes = classArray;
        this.collector = null;
    }

    private boolean correctTypeName(Type object, String string) {
        StringBuilder stringBuilder;
        Object object2 = ((Type)object).getClassName();
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        while (((String)object2).endsWith("[]")) {
            Object object3 = object2;
            ((StringBuilder)object).append('[');
            object2 = ((String)object3).substring(0, ((String)object3).length() - 2);
        }
        if (((StringBuilder)object).length() != 0) {
            Map<String, String> map = primitives;
            object2 = map.containsKey(object2) ? ((StringBuilder)object).append(map.get(object2)).toString() : ((StringBuilder)object).append('L').append((String)object2).append(';').toString();
        }
        return ((String)object2).equals(string);
    }

    protected MethodCollector visitMethod(int n, String typeArray, String string) {
        if (this.collector != null) {
            return null;
        }
        if (!typeArray.equals(this.methodName)) {
            return null;
        }
        typeArray = Type.getArgumentTypes(string);
        int n2 = 0;
        int n3 = typeArray.length;
        for (int i = 0; i < n3; ++i) {
            String string2 = typeArray[i].getClassName();
            if (!string2.equals("long") && !string2.equals("double")) continue;
            ++n2;
        }
        if (typeArray.length != this.parameterTypes.length) {
            return null;
        }
        for (n3 = 0; n3 < typeArray.length; ++n3) {
            if (this.correctTypeName(typeArray[n3], this.parameterTypes[n3].getName())) continue;
            return null;
        }
        this.collector = new MethodCollector(Modifier.isStatic(n) ^ 1, typeArray.length + n2);
        return this.collector;
    }

    public void visitAnnotation(String string) {
        if (JSONType.equals(string)) {
            this.jsonType = true;
        }
    }

    public String[] getParameterNamesForMethod() {
        MethodCollector methodCollector = ((TypeCollector)((Object)methodCollector)).collector;
        if (methodCollector != null && methodCollector.debugInfoPresent) {
            return methodCollector.getResult().split(",");
        }
        return new String[0];
    }

    public boolean matched() {
        return this.collector != null;
    }

    public boolean hasJsonType() {
        return this.jsonType;
    }
}

