/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.JSONToken;
import com.tradplus.ads.common.serialization.parser.SymbolTable;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public abstract class JSONLexerBase
implements JSONLexer,
Closeable {
    private static final ThreadLocal<char[]> SBUF_LOCAL = new ThreadLocal();
    protected static final char[] typeFieldName = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();
    protected static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    protected static final int INT_MULTMIN_RADIX_TEN = -214748364;
    protected static final int[] digits = new int[103];
    protected int token;
    protected int pos;
    protected int features;
    protected char ch;
    protected int bp;
    protected int eofPos;
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected boolean hasSpecial;
    protected Calendar calendar = null;
    protected TimeZone timeZone = JSON.defaultTimeZone;
    protected Locale locale = JSON.defaultLocale;
    public int matchStat = 0;
    protected String stringDefaultValue = null;
    protected int nanos = 0;

    public JSONLexerBase(int n) {
        this.features = n;
        if ((n & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
        if ((this.sbuf = SBUF_LOCAL.get()) == null) {
            this.sbuf = new char[512];
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String readString(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (true) {
            block30: {
                int n4;
                block29: {
                    int n5;
                    block28: {
                        if (n3 >= n) {
                            return new String(cArray2, 0, n2);
                        }
                        n5 = cArray[n3];
                        if (n5 == 92) break block28;
                        int n6 = n2 + 1;
                        cArray2[n2] = n5;
                        n4 = n6;
                        break block29;
                    }
                    n5 = cArray[++n3];
                    switch (n5) {
                        default: {
                            switch (n5) {
                                default: {
                                    switch (n5) {
                                        default: {
                                            throw new JSONException("unclosed.str.lit");
                                        }
                                        case 118: {
                                            n5 = n2 + 1;
                                            cArray2[n2] = 11;
                                            break;
                                        }
                                        case 117: {
                                            int n7 = n2++;
                                            char[] cArray3 = new char[4];
                                            char[] cArray4 = cArray3;
                                            cArray4[0] = cArray[++n3];
                                            cArray4[1] = cArray[++n3];
                                            cArray4[2] = cArray[++n3];
                                            cArray3[3] = cArray[++n3];
                                            cArray2[n7] = (char)Integer.parseInt(new String(cArray3), 16);
                                            break block30;
                                        }
                                        case 116: {
                                            n5 = n2 + 1;
                                            cArray2[n2] = 9;
                                            break;
                                        }
                                    }
                                    break;
                                }
                                case 55: {
                                    n5 = n2 + 1;
                                    cArray2[n2] = 7;
                                    break;
                                }
                                case 54: {
                                    n5 = n2 + 1;
                                    cArray2[n2] = 6;
                                    break;
                                }
                                case 53: {
                                    n5 = n2 + 1;
                                    cArray2[n2] = 5;
                                    break;
                                }
                                case 52: {
                                    n5 = n2 + 1;
                                    cArray2[n2] = 4;
                                    break;
                                }
                                case 51: {
                                    n5 = n2 + 1;
                                    cArray2[n2] = 3;
                                    break;
                                }
                                case 50: {
                                    n5 = n2 + 1;
                                    cArray2[n2] = 2;
                                    break;
                                }
                                case 49: {
                                    n5 = n2 + 1;
                                    cArray2[n2] = '\u0001';
                                    break;
                                }
                                case 48: {
                                    n5 = n2 + 1;
                                    cArray2[n2] = '\u0000';
                                    break;
                                }
                                case 47: {
                                    n5 = n2 + 1;
                                    cArray2[n2] = 47;
                                    break;
                                }
                            }
                            break;
                        }
                        case 120: {
                            int n8 = n2++;
                            int[] nArray = digits;
                            n3 = n3 + 1;
                            cArray2[n8] = (char)(digits[cArray[n3]] * 16 + nArray[cArray[++n3]]);
                            break block30;
                        }
                        case 114: {
                            n5 = n2 + 1;
                            cArray2[n2] = 13;
                            break;
                        }
                        case 110: {
                            n5 = n2 + 1;
                            cArray2[n2] = 10;
                            break;
                        }
                        case 98: {
                            n5 = n2 + 1;
                            cArray2[n2] = 8;
                            break;
                        }
                        case 92: {
                            n5 = n2 + 1;
                            cArray2[n2] = 92;
                            break;
                        }
                        case 70: 
                        case 102: {
                            n5 = n2 + 1;
                            cArray2[n2] = 12;
                            break;
                        }
                        case 39: {
                            n5 = n2 + 1;
                            cArray2[n2] = 39;
                            break;
                        }
                        case 34: {
                            n5 = n2 + 1;
                            cArray2[n2] = 34;
                        }
                    }
                    n4 = n5;
                }
                n2 = n4;
            }
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void scanStringSingleQuote() {
        this.np = this.bp;
        this.hasSpecial = false;
        block26: while (true) {
            block36: {
                if ((var1_1 = this.next()) == '\'') {
                    this.token = 4;
                    this.next();
                    return;
                }
                if (var1_1 == '\u001a') {
                    if (!this.isEOF()) {
                        v0 = this;
                        v1 = 26;
lbl13:
                        // 20 sources

                        while (true) {
                            v0.putChar((char)v1);
                            continue block26;
                            break;
                        }
                    }
                    throw new JSONException("unclosed single-quote string");
                }
                if (var1_1 != '\\') break block36;
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    var1_1 = this.sp;
                    var2_5 = this.sbuf;
                    if (var1_1 > this.sbuf.length) {
                        var1_2 = new char[var1_1 * 2];
                        var2_6 = var2_5.length;
                        System.arraycopy(var2_5, 0, var1_2, 0, var2_6);
                        this.sbuf = var1_2;
                    }
                    v2 = this;
                    var1_1 = v2.np + 1;
                    var2_4 = v2.sp;
                    var3_7 /* !! */  = v2.sbuf;
                    v2.copyTo(var1_1, var2_4, var3_7 /* !! */ );
                }
                var1_1 = this.next();
                switch (var1_1) {
                    default: {
                        switch (var1_1) {
                            default: {
                                switch (var1_1) {
                                    default: {
                                        this.ch = var1_1;
                                        throw new JSONException("unclosed single-quote string");
                                    }
                                    case 'v': {
                                        v0 = this;
                                        v1 = 11;
                                        ** GOTO lbl13
                                    }
                                    case 'u': {
                                        v3 = new char[4];
                                        var1_3 = v3;
                                        var1_3[0] = this.next();
                                        var1_3[1] = this.next();
                                        var1_3[2] = this.next();
                                        v3[3] = this.next();
                                        this.putChar((char)Integer.parseInt(new String(v3), 16));
                                        continue block26;
                                    }
                                    case 't': 
                                }
                                v0 = this;
                                v1 = 9;
                                ** GOTO lbl13
                            }
                            case '7': {
                                v0 = this;
                                v1 = 7;
                                ** GOTO lbl13
                            }
                            case '6': {
                                v0 = this;
                                v1 = 6;
                                ** GOTO lbl13
                            }
                            case '5': {
                                v0 = this;
                                v1 = 5;
                                ** GOTO lbl13
                            }
                            case '4': {
                                v0 = this;
                                v1 = 4;
                                ** GOTO lbl13
                            }
                            case '3': {
                                v0 = this;
                                v1 = 3;
                                ** GOTO lbl13
                            }
                            case '2': {
                                v0 = this;
                                v1 = 2;
                                ** GOTO lbl13
                            }
                            case '1': {
                                v0 = this;
                                v1 = 1;
                                ** GOTO lbl13
                            }
                            case '0': {
                                v0 = this;
                                v1 = 0;
                                ** GOTO lbl13
                            }
                            case '/': 
                        }
                        v0 = this;
                        v1 = 47;
                        ** GOTO lbl13
                    }
                    case 'x': {
                        v4 = this.next();
                        var1_1 = v4;
                        var2_4 = this.next();
                        var3_8 = v4 >= '0' && var1_1 <= '9' || var1_1 >= 'a' && var1_1 <= 'f' || var1_1 >= 'A' && var1_1 <= 'F';
                        var4_9 = var2_4 >= '0' && var2_4 <= '9' || var2_4 >= 'a' && var2_4 <= 'f' || var2_4 >= 'A' && var2_4 <= 'F';
                        if (var3_8 && var4_9) {
                            var3_7 /* !! */  = (char[])JSONLexerBase.digits;
                            this.putChar((char)(JSONLexerBase.digits[var1_1] * 16 + var3_7 /* !! */ [var2_4]));
                            continue block26;
                        }
                        throw new JSONException("invalid escape character \\x" + var1_1 + var2_4);
                    }
                    case 'r': {
                        v0 = this;
                        v1 = 13;
                        ** GOTO lbl13
                    }
                    case 'n': {
                        v0 = this;
                        v1 = 10;
                        ** GOTO lbl13
                    }
                    case 'b': {
                        v0 = this;
                        v1 = 8;
                        ** GOTO lbl13
                    }
                    case '\\': {
                        v0 = this;
                        v1 = 92;
                        ** GOTO lbl13
                    }
                    case 'F': 
                    case 'f': {
                        v0 = this;
                        v1 = 12;
                        ** GOTO lbl13
                    }
                    case '\'': {
                        v0 = this;
                        v1 = 39;
                        ** GOTO lbl13
                    }
                    case '\"': 
                }
                v0 = this;
                v1 = 34;
                ** GOTO lbl13
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            var2_4 = this.sp;
            var3_7 /* !! */  = this.sbuf;
            if (var2_4 == this.sbuf.length) {
                v0 = this;
                v1 = var1_1;
                ** continue;
            }
            this.sp = var2_4 + 1;
            var3_7 /* !! */ [var2_4] = var1_1;
        }
    }

    public static boolean isWhitespace(char c) {
        return c <= ' ' && (c == ' ' || c == '\n' || c == '\r' || c == '\t' || c == '\f' || c == '\b');
    }

    static {
        int n = 48;
        while (n <= 57) {
            int n2 = n++;
            JSONLexerBase.digits[n2] = n2 - 48;
        }
        n = 97;
        while (n <= 102) {
            int n3 = n++;
            JSONLexerBase.digits[n3] = n3 - 97 + 10;
        }
        n = 65;
        while (n <= 70) {
            int n4 = n++;
            JSONLexerBase.digits[n4] = n4 - 65 + 10;
        }
    }

    protected void lexError(String string, Object ... objectArray) {
        this.token = 1;
    }

    public final int matchStat() {
        return this.matchStat;
    }

    public void setToken(int n) {
        this.token = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void nextToken() {
        objectArray2.sp = 0;
        while (true) {
            block26: {
                objectArray2.pos = objectArray2.bp;
                char c = objectArray2.ch;
                if (c == '/') {
                    objectArray2.skipComment();
                    continue;
                }
                if (c == '\"') {
                    objectArray2.scanString();
                    return;
                }
                if (c == ',') {
                    objectArray2.next();
                    objectArray2.token = 16;
                    return;
                }
                if (c >= '0' && c <= '9') {
                    objectArray2.scanNumber();
                    return;
                }
                if (c == '-') {
                    objectArray2.scanNumber();
                    return;
                }
                switch (c) {
                    default: {
                        int n;
                        if (!objectArray2.isEOF()) break;
                        if (objectArray2.token == 20) throw new JSONException("EOF error");
                        objectArray2.token = 20;
                        objectArray2.pos = n = objectArray2.bp;
                        objectArray2.eofPos = n;
                        return;
                    }
                    case '}': {
                        objectArray2.next();
                        objectArray2.token = 13;
                        return;
                    }
                    case '{': {
                        objectArray2.next();
                        objectArray2.token = 12;
                        return;
                    }
                    case 'x': {
                        objectArray2.scanHex();
                        return;
                    }
                    case 't': {
                        objectArray2.scanTrue();
                        return;
                    }
                    case 'n': {
                        objectArray2.scanNullOrNew();
                        return;
                    }
                    case 'f': {
                        objectArray2.scanFalse();
                        return;
                    }
                    case ']': {
                        objectArray2.next();
                        objectArray2.token = 15;
                        return;
                    }
                    case '[': {
                        objectArray2.next();
                        objectArray2.token = 14;
                        return;
                    }
                    case 'N': 
                    case 'S': 
                    case 'T': 
                    case 'u': {
                        objectArray2.scanIdent();
                        return;
                    }
                    case ';': {
                        objectArray2.next();
                        objectArray2.token = 24;
                        return;
                    }
                    case ':': {
                        objectArray2.next();
                        objectArray2.token = 17;
                        return;
                    }
                    case '.': {
                        objectArray2.next();
                        objectArray2.token = 25;
                        return;
                    }
                    case '+': {
                        objectArray2.next();
                        objectArray2.scanNumber();
                        return;
                    }
                    case ')': {
                        objectArray2.next();
                        objectArray2.token = 11;
                        return;
                    }
                    case '(': {
                        objectArray2.next();
                        objectArray2.token = 10;
                        return;
                    }
                    case '\'': {
                        if (!objectArray2.isEnabled(Feature.AllowSingleQuotes)) throw new JSONException("Feature.AllowSingleQuotes is false");
                        objectArray2.scanStringSingleQuote();
                        return;
                    }
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break block26;
                    }
                }
                c = objectArray2.ch;
                if (c > '\u001f' && c != '\u007f') {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = String.valueOf((int)c);
                    objectArray2.lexError("illegal.char", objectArray2);
                    objectArray2.next();
                    return;
                }
            }
            objectArray2.next();
        }
    }

    @Override
    public final void nextToken(int n) {
        this.sp = 0;
        while (true) {
            char c;
            block30: {
                block25: {
                    block26: {
                        block27: {
                            block28: {
                                block29: {
                                    if (n == 2) break block25;
                                    if (n == 4) break block26;
                                    if (n == 12) break block27;
                                    if (n == 18) break block28;
                                    if (n == 20) break block29;
                                    switch (n) {
                                        default: {
                                            break block30;
                                        }
                                        case 16: {
                                            c = this.ch;
                                            if (c == ',') {
                                                this.token = 16;
                                                this.next();
                                                return;
                                            }
                                            if (c == '}') {
                                                this.token = 13;
                                                this.next();
                                                return;
                                            }
                                            if (c == ']') {
                                                this.token = 15;
                                                this.next();
                                                return;
                                            }
                                            if (c == '\u001a') {
                                                this.token = 20;
                                                return;
                                            }
                                            if (c == 'n') {
                                                this.scanNullOrNew(false);
                                                return;
                                            }
                                            break block30;
                                        }
                                        case 15: {
                                            if (this.ch != ']') break;
                                            this.token = 15;
                                            this.next();
                                            return;
                                        }
                                        case 14: {
                                            c = this.ch;
                                            if (c == '[') {
                                                this.token = 14;
                                                this.next();
                                                return;
                                            }
                                            if (c == '{') {
                                                this.token = 12;
                                                this.next();
                                                return;
                                            }
                                            break block30;
                                        }
                                    }
                                }
                                if (this.ch == '\u001a') {
                                    this.token = 20;
                                    return;
                                }
                                break block30;
                            }
                            this.nextIdent();
                            return;
                        }
                        c = this.ch;
                        if (c == '{') {
                            this.token = 12;
                            this.next();
                            return;
                        }
                        if (c == '[') {
                            this.token = 14;
                            this.next();
                            return;
                        }
                        break block30;
                    }
                    c = this.ch;
                    if (c == '\"') {
                        JSONLexerBase jSONLexerBase = this;
                        jSONLexerBase.pos = jSONLexerBase.bp;
                        jSONLexerBase.scanString();
                        return;
                    }
                    if (c >= '0' && c <= '9') {
                        JSONLexerBase jSONLexerBase = this;
                        jSONLexerBase.pos = jSONLexerBase.bp;
                        jSONLexerBase.scanNumber();
                        return;
                    }
                    if (c == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (c == '{') {
                        this.token = 12;
                        this.next();
                        return;
                    }
                    break block30;
                }
                c = this.ch;
                if (c >= '0' && c <= '9') {
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.pos = jSONLexerBase.bp;
                    jSONLexerBase.scanNumber();
                    return;
                }
                if (c == '\"') {
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.pos = jSONLexerBase.bp;
                    jSONLexerBase.scanString();
                    return;
                }
                if (c == '[') {
                    this.token = 14;
                    this.next();
                    return;
                }
                if (c == '{') {
                    this.token = 12;
                    this.next();
                    return;
                }
            }
            c = this.ch;
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '\f' && c != '\b') {
                this.nextToken();
                return;
            }
            this.next();
        }
    }

    public final void nextIdent() {
        while (JSONLexerBase.isWhitespace(this.ch)) {
            this.next();
        }
        char c = this.ch;
        if (c != '_' && c != '$' && !Character.isLetter(c)) {
            this.nextToken();
        } else {
            this.scanIdent();
        }
    }

    @Override
    public final void nextTokenWithColon() {
        this.nextTokenWithChar(':');
    }

    public final void nextTokenWithChar(char c) {
        this.sp = 0;
        while (true) {
            char c2;
            if ((c2 = this.ch) == c) {
                JSONLexerBase jSONLexerBase = this;
                jSONLexerBase.next();
                jSONLexerBase.nextToken();
                return;
            }
            if (c2 != ' ' && c2 != '\n' && c2 != '\r' && c2 != '\t' && c2 != '\f' && c2 != '\b') {
                throw new JSONException("not match " + c + " - " + this.ch + ", info : " + this.info());
            }
            this.next();
        }
    }

    @Override
    public final int token() {
        return this.token;
    }

    @Override
    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    @Override
    public final int pos() {
        return this.pos;
    }

    public final String stringDefaultValue() {
        return this.stringDefaultValue;
    }

    @Override
    public final Number integerValue() {
        long l;
        long l2 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        JSONLexerBase jSONLexerBase = this;
        int n = jSONLexerBase.np;
        int n2 = n + this.sp;
        int n3 = 32;
        char c = jSONLexerBase.charAt(n2 - 1);
        if (c != 'B') {
            if (c != 'L') {
                if (c == 'S') {
                    --n2;
                    n3 = 83;
                }
            } else {
                --n2;
                n3 = 76;
            }
        } else {
            --n2;
            n3 = 66;
        }
        JSONLexerBase jSONLexerBase2 = this;
        if (jSONLexerBase2.charAt(jSONLexerBase2.np) == '-') {
            bl = true;
            l = Long.MIN_VALUE;
            ++n;
        } else {
            l = -9223372036854775807L;
        }
        long l3 = -922337203685477580L;
        if (n < n2) {
            l2 = -(this.charAt(n++) - 48);
        }
        while (n < n2) {
            int n4 = this.charAt(n++) - 48;
            if (l2 < l3) {
                return new BigInteger(this.numberString(), 10);
            }
            long l4 = n4;
            if ((l2 *= 10L) < l + l4) {
                return new BigInteger(this.numberString(), 10);
            }
            l2 -= l4;
        }
        if (bl) {
            if (n > this.np + 1) {
                if (l2 >= Integer.MIN_VALUE && n3 != 76) {
                    if (n3 == 83) {
                        return (short)l2;
                    }
                    if (n3 == 66) {
                        return (byte)l2;
                    }
                    return (int)l2;
                }
                return l2;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((l2 = -l2) <= Integer.MAX_VALUE && n3 != 76) {
            if (n3 == 83) {
                return (short)l2;
            }
            if (n3 == 66) {
                return (byte)l2;
            }
            return (int)l2;
        }
        return l2;
    }

    @Override
    public final void nextTokenWithColon(int n) {
        this.nextTokenWithChar(':');
    }

    @Override
    public float floatValue() {
        char c;
        float f = Float.parseFloat((String)(this = ((JSONLexerBase)this).numberString()));
        if ((f == 0.0f || f == Float.POSITIVE_INFINITY) && (c = ((String)this).charAt(0)) > '0' && c <= '9') {
            throw new JSONException("float overflow : " + (String)this);
        }
        return f;
    }

    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    @Override
    public void jsonCfg(Feature feature, boolean bl) {
        this.features = Feature.jsonCfg(this.features, feature, bl);
        if ((this.features & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
    }

    @Override
    public final boolean isEnabled(Feature feature) {
        return this.isEnabled(feature.mask);
    }

    @Override
    public final boolean isEnabled(int n) {
        return (this.features & n) != 0;
    }

    public final boolean isEnabled(int n, int n2) {
        return (this.features & n2) != 0 || (n & n2) != 0;
    }

    @Override
    public abstract String numberString();

    public abstract boolean isEOF();

    @Override
    public final char getCurrent() {
        return this.ch;
    }

    public abstract char charAt(int var1);

    @Override
    public abstract char next();

    /*
     * Enabled aggressive block sorting
     */
    protected void skipComment() {
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.next();
        char c = jSONLexerBase.ch;
        if (c != '/') {
            if (c != '*') {
                throw new JSONException("invalid comment");
            }
            block0: while (true) {
                JSONLexerBase jSONLexerBase2;
                this.next();
                do {
                    if ((c = this.ch) == '\u001a') {
                        return;
                    }
                    if (c != '*') continue block0;
                    jSONLexerBase2 = this;
                    jSONLexerBase2.next();
                } while (jSONLexerBase2.ch != '/');
                break;
            }
            this.next();
            return;
        }
        do {
            JSONLexerBase jSONLexerBase3 = this;
            jSONLexerBase3.next();
            c = jSONLexerBase3.ch;
            if (c != '\n') continue;
            this.next();
            return;
        } while (c != '\u001a');
    }

    @Override
    public final String scanSymbol(SymbolTable symbolTable) {
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.skipWhitespace();
        char c = jSONLexerBase.ch;
        if (c == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (c == '\'') {
            if (this.isEnabled(Feature.AllowSingleQuotes)) {
                return this.scanSymbol(symbolTable, '\'');
            }
            throw new JSONException("syntax error");
        }
        if (c == '}') {
            this.next();
            this.token = 13;
            return null;
        }
        if (c == ',') {
            this.next();
            this.token = 16;
            return null;
        }
        if (c == '\u001a') {
            this.token = 20;
            return null;
        }
        if (this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            return this.scanSymbolUnQuoted(symbolTable);
        }
        throw new JSONException("syntax error");
    }

    protected abstract void arrayCopy(int var1, char[] var2, int var3, int var4);

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final String scanSymbol(SymbolTable var1_1, char var2_2) {
        var3_3 = '\u0000';
        this.np = this.bp;
        this.sp = 0;
        var4_4 = false;
        block26: while (true) {
            if ((var5_5 = this.next()) == var2_2) {
                this.token = 4;
                if (!var4_4) {
                    v0 = this.np;
                    var2_2 = (char)v0;
                    var2_2 = v0 == -1 ? '\u0000' : (char)(var2_2 + 1);
                    v1 = this;
                    v2 = v1.addSymbol(var2_2, v1.sp, var3_3, (SymbolTable)var1_1);
                } else {
                    v3 = var1_1;
                    v4 = this;
                    var1_1 = v4.sbuf;
                    var2_2 = (char)v4.sp;
                    v2 = v3.addSymbol((char[])var1_1, 0, (int)var2_2, (int)var3_3);
                }
                this.sp = 0;
                this.next();
                return v2;
            }
            if (var5_5 == '\u001a') break;
            if (var5_5 == '\\') {
                if (!var4_4) {
                    var4_4 = true;
                    var5_5 = this.sp;
                    var6_8 /* !! */  = this.sbuf;
                    if (var5_5 >= this.sbuf.length) {
                        var7_12 = var6_8 /* !! */ .length * 2;
                        if (var5_5 <= var7_12) {
                            var5_5 = var7_12;
                        }
                        var5_6 = new char[var5_5];
                        var6_9 = var6_8 /* !! */ .length;
                        System.arraycopy(var6_8 /* !! */ , 0, var5_6, 0, var6_9);
                        this.sbuf = var5_6;
                    }
                    v5 = this;
                    var5_5 = v5.np + 1;
                    var6_8 /* !! */  = v5.sbuf;
                    var7_12 = v5.sp;
                    v5.arrayCopy(var5_5, var6_8 /* !! */ , 0, var7_12);
                }
                var5_5 = this.next();
                block0 : switch (var5_5) {
                    default: {
                        switch (var5_5) {
                            default: {
                                switch (var5_5) {
                                    default: {
                                        this.ch = var5_5;
                                        throw new JSONException("unclosed.str.lit");
                                    }
                                    case 'v': {
                                        v6 = this;
                                        var3_3 = var3_3 * 31 + 11;
                                        v7 = '\u000b';
                                        break block0;
                                    }
                                    case 'u': {
                                        v8 = var3_3;
                                        v9 = this;
                                        var3_3 = v9.next();
                                        var5_5 = v9.next();
                                        var6_10 = v9.next();
                                        var7_12 = v9.next();
                                        var3_3 = Integer.parseInt(new String(new char[]{var3_3, var5_5, var6_10, var7_12}), 16);
                                        var5_5 = v8 * 31 + var3_3;
                                        this.putChar(var3_3);
                                        var3_3 = var5_5;
                                        continue block26;
                                    }
                                    case 't': 
                                }
                                v6 = this;
                                var3_3 = var3_3 * 31 + 9;
                                v7 = '\t';
                                break block0;
                            }
                            case '7': {
                                v6 = this;
                                var3_3 = var3_3 * 31 + var5_5;
                                v7 = '\u0007';
                                break block0;
                            }
                            case '6': {
                                v6 = this;
                                var3_3 = var3_3 * 31 + var5_5;
                                v7 = '\u0006';
                                break block0;
                            }
                            case '5': {
                                v6 = this;
                                var3_3 = var3_3 * 31 + var5_5;
                                v7 = '\u0005';
                                break block0;
                            }
                            case '4': {
                                v6 = this;
                                var3_3 = var3_3 * 31 + var5_5;
                                v7 = '\u0004';
                                break block0;
                            }
                            case '3': {
                                v6 = this;
                                var3_3 = var3_3 * 31 + var5_5;
                                v7 = '\u0003';
                                break block0;
                            }
                            case '2': {
                                v6 = this;
                                var3_3 = var3_3 * 31 + var5_5;
                                v7 = '\u0002';
                                break block0;
                            }
                            case '1': {
                                v6 = this;
                                var3_3 = var3_3 * 31 + var5_5;
                                v7 = '\u0001';
                                break block0;
                            }
                            case '0': {
                                v6 = this;
                                var3_3 = var3_3 * 31 + var5_5;
                                v7 = '\u0000';
                                break block0;
                            }
                            case '/': 
                        }
                        v6 = this;
                        var3_3 = var3_3 * 31 + 47;
                        v7 = '/';
                        break;
                    }
                    case 'x': {
                        v10 = var3_3;
                        v11 = this;
                        var3_3 = v11.next();
                        v11.ch = v11.ch;
                        var5_5 = v11.next();
                        v11.ch = v11.ch;
                        var6_8 /* !! */  = (char[])JSONLexerBase.digits;
                        var3_3 = (char)(JSONLexerBase.digits[var3_3] * 16 + var6_8 /* !! */ [var5_5]);
                        var5_5 = v10 * 31 + var3_3;
                        this.putChar(var3_3);
                        var3_3 = var5_5;
                        continue block26;
                    }
                    case 'r': {
                        v6 = this;
                        var3_3 = var3_3 * 31 + 13;
                        v7 = '\r';
                        break;
                    }
                    case 'n': {
                        v6 = this;
                        var3_3 = var3_3 * 31 + 10;
                        v7 = '\n';
                        break;
                    }
                    case 'b': {
                        v6 = this;
                        var3_3 = var3_3 * 31 + 8;
                        v7 = '\b';
                        break;
                    }
                    case '\\': {
                        v6 = this;
                        var3_3 = var3_3 * 31 + 92;
                        v7 = '\\';
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        v6 = this;
                        var3_3 = var3_3 * 31 + 12;
                        v7 = '\f';
                        break;
                    }
                    case '\'': {
                        v6 = this;
                        var3_3 = var3_3 * 31 + 39;
                        v7 = '\'';
                        break;
                    }
                    case '\"': {
                        v6 = this;
                        var3_3 = var3_3 * 31 + 34;
                        v7 = '\"';
                    }
                }
lbl166:
                // 19 sources

                while (true) {
                    v6.putChar(v7);
                    continue block26;
                    break;
                }
            }
            var3_3 = var3_3 * 31 + var5_5;
            if (!var4_4) {
                ++this.sp;
                continue;
            }
            var6_11 = this.sp;
            var7_13 = this.sbuf;
            if (var6_11 == this.sbuf.length) {
                v6 = this;
                v7 = var5_5;
                ** continue;
            }
            this.sp = var6_11 + 1;
            var7_13[var6_11] = var5_5;
        }
        throw new JSONException("unclosed.str");
    }

    @Override
    public final void resetStringPosition() {
        this.sp = 0;
    }

    @Override
    public String info() {
        return "";
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        boolean[] blArray;
        int n;
        if (this.token == 1 && this.pos == 0 && this.bp == 1) {
            this.bp = 0;
        }
        boolean bl = (n = this.ch) >= (blArray = IOUtils.firstIdentifierFlags).length || blArray[n];
        if (bl) {
            blArray = IOUtils.identifierFlags;
            this.np = this.bp;
            this.sp = 1;
            while (true) {
                char c;
                if ((c = this.next()) < blArray.length && !blArray[c]) {
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.ch = jSONLexerBase.charAt(jSONLexerBase.bp);
                    jSONLexerBase.token = 18;
                    if (jSONLexerBase.sp == 4 && n == 3392903) {
                        JSONLexerBase jSONLexerBase2 = this;
                        if (jSONLexerBase2.charAt(jSONLexerBase2.np) == 'n') {
                            JSONLexerBase jSONLexerBase3 = this;
                            if (jSONLexerBase3.charAt(jSONLexerBase3.np + 1) == 'u') {
                                JSONLexerBase jSONLexerBase4 = this;
                                if (jSONLexerBase4.charAt(jSONLexerBase4.np + 2) == 'l') {
                                    JSONLexerBase jSONLexerBase5 = this;
                                    if (jSONLexerBase5.charAt(jSONLexerBase5.np + 3) == 'l') {
                                        return null;
                                    }
                                }
                            }
                        }
                    }
                    if (symbolTable == null) {
                        JSONLexerBase jSONLexerBase6 = this;
                        int n2 = jSONLexerBase6.np;
                        return jSONLexerBase6.subString(n2, jSONLexerBase6.sp);
                    }
                    JSONLexerBase jSONLexerBase7 = this;
                    int n3 = jSONLexerBase7.np;
                    return jSONLexerBase7.addSymbol(n3, jSONLexerBase7.sp, n, symbolTable);
                }
                n = n * 31 + c;
                ++this.sp;
            }
        }
        throw new JSONException("illegal identifier : " + this.ch + this.info());
    }

    protected abstract void copyTo(int var1, int var2, char[] var3);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void scanString() {
        this.np = this.bp;
        this.hasSpecial = false;
        block26: while (true) {
            char c;
            char c2;
            block40: {
                int n;
                JSONLexerBase jSONLexerBase;
                block38: {
                    block39: {
                        block37: {
                            if ((c2 = this.next()) == '\"') {
                                this.token = 4;
                                this.ch = this.next();
                                return;
                            }
                            if (c2 != '\u001a') break block37;
                            if (this.isEOF()) {
                                throw new JSONException("unclosed string : " + c2);
                            }
                            jSONLexerBase = this;
                            n = 26;
                            break block38;
                        }
                        if (c2 != '\\') break block39;
                        if (!this.hasSpecial) {
                            this.hasSpecial = true;
                            int n2 = this.sp;
                            char[] cArray = this.sbuf;
                            if (n2 >= this.sbuf.length) {
                                int n3;
                                int n4 = cArray.length * 2;
                                if (n2 <= n4) {
                                    n3 = n4;
                                }
                                char[] cArray2 = new char[n3];
                                int n5 = cArray.length;
                                System.arraycopy(cArray, 0, cArray2, 0, n5);
                                this.sbuf = cArray2;
                            }
                            JSONLexerBase jSONLexerBase2 = this;
                            int n6 = jSONLexerBase2.np + 1;
                            int n7 = jSONLexerBase2.sp;
                            char[] cArray3 = jSONLexerBase2.sbuf;
                            jSONLexerBase2.copyTo(n6, n7, cArray3);
                        }
                        c2 = this.next();
                        block0 : switch (c2) {
                            default: {
                                char c3;
                                switch (c2) {
                                    default: {
                                        switch (c2) {
                                            default: {
                                                this.ch = c2;
                                                throw new JSONException("unclosed string : " + c2);
                                            }
                                            case 'v': {
                                                jSONLexerBase = this;
                                                n = 11;
                                                break block0;
                                            }
                                            case 'u': {
                                                JSONLexerBase jSONLexerBase3 = this;
                                                c2 = jSONLexerBase3.next();
                                                c = jSONLexerBase3.next();
                                                char c4 = jSONLexerBase3.next();
                                                c3 = jSONLexerBase3.next();
                                                jSONLexerBase3.putChar((char)Integer.parseInt(new String(new char[]{c2, c, c4, c3}), 16));
                                                continue block26;
                                            }
                                            case 't': 
                                        }
                                        jSONLexerBase = this;
                                        n = 9;
                                        break block0;
                                    }
                                    case '7': {
                                        jSONLexerBase = this;
                                        n = 7;
                                        break block0;
                                    }
                                    case '6': {
                                        jSONLexerBase = this;
                                        n = 6;
                                        break block0;
                                    }
                                    case '5': {
                                        jSONLexerBase = this;
                                        n = 5;
                                        break block0;
                                    }
                                    case '4': {
                                        jSONLexerBase = this;
                                        n = 4;
                                        break block0;
                                    }
                                    case '3': {
                                        jSONLexerBase = this;
                                        n = 3;
                                        break block0;
                                    }
                                    case '2': {
                                        jSONLexerBase = this;
                                        n = 2;
                                        break block0;
                                    }
                                    case '1': {
                                        jSONLexerBase = this;
                                        n = 1;
                                        break block0;
                                    }
                                    case '0': {
                                        jSONLexerBase = this;
                                        n = 0;
                                        break block0;
                                    }
                                    case '/': 
                                }
                                jSONLexerBase = this;
                                n = 47;
                                break;
                            }
                            case 'x': {
                                c2 = this.next();
                                c = this.next();
                                boolean bl = c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
                                char c3 = c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' ? (char)'\u0001' : '\u0000';
                                if (bl && c3 != '\u0000') {
                                    int[] nArray = digits;
                                    this.putChar((char)(digits[c2] * 16 + nArray[c]));
                                    continue block26;
                                }
                                throw new JSONException("invalid escape character \\x" + c2 + c);
                            }
                            case 'r': {
                                jSONLexerBase = this;
                                n = 13;
                                break;
                            }
                            case 'n': {
                                jSONLexerBase = this;
                                n = 10;
                                break;
                            }
                            case 'b': {
                                jSONLexerBase = this;
                                n = 8;
                                break;
                            }
                            case '\\': {
                                jSONLexerBase = this;
                                n = 92;
                                break;
                            }
                            case 'F': 
                            case 'f': {
                                jSONLexerBase = this;
                                n = 12;
                                break;
                            }
                            case '\'': {
                                jSONLexerBase = this;
                                n = 39;
                                break;
                            }
                            case '\"': {
                                jSONLexerBase = this;
                                n = 34;
                                break;
                            }
                        }
                        break block38;
                    }
                    if (!this.hasSpecial) {
                        ++this.sp;
                        continue;
                    }
                    c = this.sp;
                    char[] cArray = this.sbuf;
                    if (c != this.sbuf.length) break block40;
                    jSONLexerBase = this;
                    n = c2;
                }
                jSONLexerBase.putChar((char)n);
                continue;
            }
            this.sp = c + 1;
            cArray[c] = c2;
        }
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public final int intValue() {
        int n;
        if (this.np == -1) {
            this.np = 0;
        }
        JSONLexerBase jSONLexerBase = this;
        int n2 = 0;
        boolean bl = false;
        int n3 = jSONLexerBase.np;
        int n4 = n3 + this.sp;
        if (jSONLexerBase.charAt(n3) == '-') {
            bl = true;
            n = Integer.MIN_VALUE;
            ++n3;
        } else {
            n = -2147483647;
        }
        long l = -214748364L;
        if (n3 < n4) {
            n2 = -(this.charAt(n3++) - 48);
        }
        while (n3 < n4) {
            int n5 = n3 + 1;
            char c = this.charAt(n3);
            n3 = c;
            if (c != 'L' && n3 != 83 && n3 != 66) {
                n3 -= 48;
                if ((long)n2 >= l) {
                    if ((n2 *= 10) >= n + n3) {
                        n2 -= n3;
                        n3 = n5;
                        continue;
                    }
                    throw new NumberFormatException(this.numberString());
                }
                throw new NumberFormatException(this.numberString());
            }
            n3 = n5;
            break;
        }
        if (bl) {
            if (n3 > this.np + 1) {
                return n2;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -n2;
    }

    @Override
    public abstract byte[] bytesValue();

    @Override
    public void close() {
        char[] cArray = this.sbuf;
        if (this.sbuf.length <= 8192) {
            SBUF_LOCAL.set(cArray);
        }
        this.sbuf = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isRef() {
        if (this.sp != 4) {
            return false;
        }
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.np + 1) != '$') return false;
        JSONLexerBase jSONLexerBase2 = this;
        if (jSONLexerBase2.charAt(jSONLexerBase2.np + 2) != 'r') return false;
        JSONLexerBase jSONLexerBase3 = this;
        if (jSONLexerBase3.charAt(jSONLexerBase3.np + 3) != 'e') return false;
        JSONLexerBase jSONLexerBase4 = this;
        if (jSONLexerBase4.charAt(jSONLexerBase4.np + 4) != 'f') return false;
        return true;
    }

    @Override
    public String scanTypeName(SymbolTable symbolTable) {
        return null;
    }

    public final int scanType(String string) {
        this.matchStat = 0;
        char[] cArray = typeFieldName;
        if (!this.charArrayCompare(typeFieldName)) {
            return -2;
        }
        int n = this.bp + cArray.length;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == this.charAt(n + i)) continue;
            return -1;
        }
        int n3 = n + n2;
        if (this.charAt(n3) != '\"') {
            return -1;
        }
        char c = this.charAt(++n3);
        n = c;
        this.ch = (char)n;
        if (c == ',') {
            int n4 = n3 + 1;
            this.ch = this.charAt(n4);
            this.bp = n4;
            this.token = 16;
            return 3;
        }
        if (n == 125) {
            char c2 = this.charAt(++n3);
            n = c2;
            this.ch = (char)n;
            if (c2 == ',') {
                this.token = 16;
                this.ch = this.charAt(++n3);
            } else if (n == 93) {
                this.token = 15;
                this.ch = this.charAt(++n3);
            } else if (n == 125) {
                this.token = 13;
                this.ch = this.charAt(++n3);
            } else {
                if (n != 26) {
                    return -1;
                }
                this.token = 20;
            }
            this.matchStat = 4;
        }
        this.bp = n3;
        return this.matchStat;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean matchField(char[] cArray) {
        int n;
        while (!this.charArrayCompare(cArray)) {
            if (!JSONLexerBase.isWhitespace(this.ch)) return false;
            this.next();
        }
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.bp = n = jSONLexerBase.bp + cArray.length;
        char c = jSONLexerBase.charAt(n);
        n = c;
        this.ch = (char)n;
        if (c == '{') {
            this.next();
            this.token = 12;
            return true;
        }
        if (n == 91) {
            this.next();
            this.token = 14;
            return true;
        }
        if (n == 83) {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.bp + 1) == 'e') {
                JSONLexerBase jSONLexerBase3 = this;
                if (jSONLexerBase3.charAt(jSONLexerBase3.bp + 2) == 't') {
                    JSONLexerBase jSONLexerBase4 = this;
                    if (jSONLexerBase4.charAt(jSONLexerBase4.bp + 3) == '[') {
                        int n2;
                        JSONLexerBase jSONLexerBase5 = this;
                        jSONLexerBase5.bp = n2 = jSONLexerBase5.bp + 3;
                        jSONLexerBase5.ch = jSONLexerBase5.charAt(n2);
                        jSONLexerBase5.token = 21;
                        return true;
                    }
                }
            }
        }
        this.nextToken();
        return true;
    }

    public int matchField(long l) {
        throw new UnsupportedOperationException();
    }

    public boolean seekArrayToItem(int n) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long l, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long[] lArray) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToFieldDeepScan(long l) {
        throw new UnsupportedOperationException();
    }

    public void skipObject() {
        throw new UnsupportedOperationException();
    }

    public void skipObject(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void skipArray() {
        throw new UnsupportedOperationException();
    }

    public abstract int indexOf(char var1, int var2);

    public abstract String addSymbol(int var1, int var2, int var3, SymbolTable var4);

    public String scanFieldString(char[] cArray) {
        block10: {
            block11: {
                block16: {
                    String string;
                    block13: {
                        int n;
                        int n2;
                        block15: {
                            block14: {
                                block12: {
                                    int n3;
                                    this.matchStat = 0;
                                    if (!this.charArrayCompare(cArray)) {
                                        this.matchStat = -2;
                                        return this.stringDefaultValue();
                                    }
                                    JSONLexerBase jSONLexerBase = this;
                                    n2 = cArray.length;
                                    if (jSONLexerBase.charAt(jSONLexerBase.bp + n2++) != '\"') {
                                        this.matchStat = -1;
                                        return this.stringDefaultValue();
                                    }
                                    JSONLexerBase jSONLexerBase2 = this;
                                    int n4 = jSONLexerBase2.indexOf('\"', jSONLexerBase2.bp + cArray.length + 1);
                                    if (n4 == -1) break block10;
                                    int n5 = this.bp + cArray.length + 1;
                                    string = this.subString(n5, n4 - n5);
                                    if (string.indexOf(92) != -1) {
                                        while (true) {
                                            int n6 = 0;
                                            for (n3 = n4 - 1; n3 >= 0 && this.charAt(n3) == '\\'; --n3) {
                                                ++n6;
                                            }
                                            if (n6 % 2 == 0) {
                                                JSONLexerBase jSONLexerBase3 = this;
                                                int n7 = jSONLexerBase3.bp;
                                                n6 = n7;
                                                n6 = n4 - (n6 + cArray.length + 1);
                                                string = JSONLexerBase.readString(jSONLexerBase3.sub_chars(n7 + cArray.length + 1, n6), n6);
                                                break;
                                            }
                                            n4 = this.indexOf('\"', n4 + 1);
                                        }
                                    }
                                    JSONLexerBase jSONLexerBase4 = this;
                                    n3 = jSONLexerBase4.bp;
                                    int n8 = n2 + (n4 - (n3 + cArray.length + 1) + 1);
                                    n = n8 + 1;
                                    char c = jSONLexerBase4.charAt(n3 + n8);
                                    n2 = c;
                                    if (c == ',') {
                                        int n9;
                                        JSONLexerBase jSONLexerBase5 = this;
                                        jSONLexerBase5.bp = n9 = jSONLexerBase5.bp + n;
                                        jSONLexerBase5.ch = jSONLexerBase5.charAt(n9);
                                        jSONLexerBase5.matchStat = 3;
                                        return string;
                                    }
                                    if (n2 != 125) break block11;
                                    JSONLexerBase jSONLexerBase6 = this;
                                    char c2 = jSONLexerBase6.charAt(jSONLexerBase6.bp + n++);
                                    n2 = c2;
                                    if (c2 != ',') break block12;
                                    JSONLexerBase jSONLexerBase7 = this;
                                    jSONLexerBase7.token = 16;
                                    jSONLexerBase7.bp = n = jSONLexerBase7.bp + n;
                                    jSONLexerBase7.ch = jSONLexerBase7.charAt(n);
                                    break block13;
                                }
                                if (n2 != 93) break block14;
                                JSONLexerBase jSONLexerBase = this;
                                jSONLexerBase.token = 15;
                                jSONLexerBase.bp = n = jSONLexerBase.bp + n;
                                jSONLexerBase.ch = jSONLexerBase.charAt(n);
                                break block13;
                            }
                            if (n2 != 125) break block15;
                            JSONLexerBase jSONLexerBase = this;
                            jSONLexerBase.token = 13;
                            jSONLexerBase.bp = n = jSONLexerBase.bp + n;
                            jSONLexerBase.ch = jSONLexerBase.charAt(n);
                            break block13;
                        }
                        if (n2 != 26) break block16;
                        this.token = 20;
                        this.bp += n - 1;
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    return string;
                }
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        throw new JSONException("unclosed str");
    }

    @Override
    public String scanString(char c) {
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.matchStat = 0;
        int n = 1;
        char c2 = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
        if (c2 == 'n') {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.bp + n) == 'u') {
                JSONLexerBase jSONLexerBase3 = this;
                if (jSONLexerBase3.charAt(jSONLexerBase3.bp + n + 1) == 'l') {
                    JSONLexerBase jSONLexerBase4 = this;
                    if (jSONLexerBase4.charAt(jSONLexerBase4.bp + n + 2) == 'l') {
                        JSONLexerBase jSONLexerBase5 = this;
                        n = 5;
                        if (jSONLexerBase5.charAt(jSONLexerBase5.bp + 4) == c) {
                            int n2;
                            JSONLexerBase jSONLexerBase6 = this;
                            jSONLexerBase6.bp = n2 = jSONLexerBase6.bp + n;
                            jSONLexerBase6.ch = jSONLexerBase6.charAt(n2);
                            jSONLexerBase6.matchStat = 3;
                            return null;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        while (true) {
            if (c2 == '\"') {
                JSONLexerBase jSONLexerBase7 = this;
                c2 = jSONLexerBase7.bp + n;
                int n3 = jSONLexerBase7.indexOf('\"', c2);
                if (n3 != -1) {
                    int n4 = this.bp + n;
                    String string = this.subString(n4, n3 - c2);
                    if (string.indexOf(92) != -1) {
                        while (true) {
                            int n5 = 0;
                            for (int i = n3 - 1; i >= 0 && this.charAt(i) == '\\'; --i) {
                                ++n5;
                            }
                            if (n5 % 2 == 0) {
                                JSONLexerBase jSONLexerBase8 = this;
                                n5 = n3 - c2;
                                string = JSONLexerBase.readString(jSONLexerBase8.sub_chars(jSONLexerBase8.bp + 1, n5), n5);
                                break;
                            }
                            n3 = this.indexOf('\"', n3 + 1);
                        }
                    }
                    JSONLexerBase jSONLexerBase9 = this;
                    n += n3 - c2 + 1;
                    c2 = jSONLexerBase9.charAt(jSONLexerBase9.bp + n++);
                    while (true) {
                        if (c2 == c) {
                            int n6;
                            JSONLexerBase jSONLexerBase10 = this;
                            jSONLexerBase10.bp = n6 = jSONLexerBase10.bp + n;
                            jSONLexerBase10.ch = jSONLexerBase10.charAt(n6);
                            jSONLexerBase10.matchStat = 3;
                            jSONLexerBase10.token = 16;
                            return string;
                        }
                        if (!JSONLexerBase.isWhitespace(c2)) break;
                        JSONLexerBase jSONLexerBase11 = this;
                        c2 = jSONLexerBase11.charAt(jSONLexerBase11.bp + n++);
                    }
                    if (c2 == ']') {
                        int n7;
                        JSONLexerBase jSONLexerBase12 = this;
                        jSONLexerBase12.bp = n7 = jSONLexerBase12.bp + n;
                        jSONLexerBase12.ch = jSONLexerBase12.charAt(n7);
                        jSONLexerBase12.matchStat = -1;
                    }
                    return string;
                }
                throw new JSONException("unclosed str");
            }
            if (!JSONLexerBase.isWhitespace(c2)) break;
            JSONLexerBase jSONLexerBase13 = this;
            c2 = jSONLexerBase13.charAt(jSONLexerBase13.bp + n++);
        }
        this.matchStat = -1;
        return this.stringDefaultValue();
    }

    public long scanFieldSymbol(char[] cArray) {
        char c;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0L;
        }
        JSONLexerBase jSONLexerBase = this;
        int n = cArray.length;
        if (jSONLexerBase.charAt(jSONLexerBase.bp + n++) != '\"') {
            this.matchStat = -1;
            return 0L;
        }
        long l = -3750763034362895579L;
        do {
            block7: {
                block8: {
                    block13: {
                        block10: {
                            block12: {
                                block11: {
                                    block9: {
                                        JSONLexerBase jSONLexerBase2 = this;
                                        if ((c = jSONLexerBase2.charAt(jSONLexerBase2.bp + n++)) != '\"') break block7;
                                        JSONLexerBase jSONLexerBase3 = this;
                                        if ((c = jSONLexerBase3.charAt(jSONLexerBase3.bp + n++)) == ',') {
                                            int n2;
                                            JSONLexerBase jSONLexerBase4 = this;
                                            jSONLexerBase4.bp = n2 = jSONLexerBase4.bp + n;
                                            jSONLexerBase4.ch = jSONLexerBase4.charAt(n2);
                                            jSONLexerBase4.matchStat = 3;
                                            return l;
                                        }
                                        if (c != '}') break block8;
                                        JSONLexerBase jSONLexerBase5 = this;
                                        if ((c = jSONLexerBase5.charAt(jSONLexerBase5.bp + n++)) != ',') break block9;
                                        JSONLexerBase jSONLexerBase6 = this;
                                        jSONLexerBase6.token = 16;
                                        jSONLexerBase6.bp = n = jSONLexerBase6.bp + n;
                                        jSONLexerBase6.ch = jSONLexerBase6.charAt(n);
                                        break block10;
                                    }
                                    if (c != ']') break block11;
                                    JSONLexerBase jSONLexerBase7 = this;
                                    jSONLexerBase7.token = 15;
                                    jSONLexerBase7.bp = n = jSONLexerBase7.bp + n;
                                    jSONLexerBase7.ch = jSONLexerBase7.charAt(n);
                                    break block10;
                                }
                                if (c != '}') break block12;
                                JSONLexerBase jSONLexerBase8 = this;
                                jSONLexerBase8.token = 13;
                                jSONLexerBase8.bp = n = jSONLexerBase8.bp + n;
                                jSONLexerBase8.ch = jSONLexerBase8.charAt(n);
                                break block10;
                            }
                            if (c != '\u001a') break block13;
                            this.token = 20;
                            this.bp += n - 1;
                            this.ch = (char)26;
                        }
                        this.matchStat = 4;
                        return l;
                    }
                    this.matchStat = -1;
                    return 0L;
                }
                this.matchStat = -1;
                return 0L;
            }
            l = (l ^ (long)c) * 1099511628211L;
        } while (c != '\\');
        this.matchStat = -1;
        return 0L;
    }

    public long scanEnumSymbol(char[] cArray) {
        int n;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0L;
        }
        JSONLexerBase jSONLexerBase = this;
        int n2 = cArray.length;
        if (jSONLexerBase.charAt(jSONLexerBase.bp + n2++) != '\"') {
            this.matchStat = -1;
            return 0L;
        }
        long l = -3750763034362895579L;
        do {
            block7: {
                block8: {
                    block13: {
                        block10: {
                            block12: {
                                block11: {
                                    block9: {
                                        JSONLexerBase jSONLexerBase2 = this;
                                        if ((n = jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++)) != 34) break block7;
                                        JSONLexerBase jSONLexerBase3 = this;
                                        char c = jSONLexerBase3.charAt(jSONLexerBase3.bp + n2++);
                                        n = c;
                                        if (c == ',') {
                                            int n3;
                                            JSONLexerBase jSONLexerBase4 = this;
                                            jSONLexerBase4.bp = n3 = jSONLexerBase4.bp + n2;
                                            jSONLexerBase4.ch = jSONLexerBase4.charAt(n3);
                                            jSONLexerBase4.matchStat = 3;
                                            return l;
                                        }
                                        if (n != 125) break block8;
                                        JSONLexerBase jSONLexerBase5 = this;
                                        char c2 = jSONLexerBase5.charAt(jSONLexerBase5.bp + n2++);
                                        n = c2;
                                        if (c2 != ',') break block9;
                                        JSONLexerBase jSONLexerBase6 = this;
                                        jSONLexerBase6.token = 16;
                                        jSONLexerBase6.bp = n2 = jSONLexerBase6.bp + n2;
                                        jSONLexerBase6.ch = jSONLexerBase6.charAt(n2);
                                        break block10;
                                    }
                                    if (n != 93) break block11;
                                    JSONLexerBase jSONLexerBase7 = this;
                                    jSONLexerBase7.token = 15;
                                    jSONLexerBase7.bp = n2 = jSONLexerBase7.bp + n2;
                                    jSONLexerBase7.ch = jSONLexerBase7.charAt(n2);
                                    break block10;
                                }
                                if (n != 125) break block12;
                                JSONLexerBase jSONLexerBase8 = this;
                                jSONLexerBase8.token = 13;
                                jSONLexerBase8.bp = n2 = jSONLexerBase8.bp + n2;
                                jSONLexerBase8.ch = jSONLexerBase8.charAt(n2);
                                break block10;
                            }
                            if (n != 26) break block13;
                            this.token = 20;
                            this.bp += n2 - 1;
                            this.ch = (char)26;
                        }
                        this.matchStat = 4;
                        return l;
                    }
                    this.matchStat = -1;
                    return 0L;
                }
                this.matchStat = -1;
                return 0L;
            }
            int n4 = n >= 65 && n <= 90 ? n + 32 : n;
            l = (l ^ (long)n4) * 1099511628211L;
        } while (n != 92);
        this.matchStat = -1;
        return 0L;
    }

    @Override
    public Enum<?> scanEnum(Class<?> clazz, SymbolTable symbolTable, char c) {
        if ((this = ((JSONLexerBase)this).scanSymbolWithSeperator(symbolTable, c)) == null) {
            return null;
        }
        return Enum.valueOf(clazz, (String)this);
    }

    @Override
    public String scanSymbolWithSeperator(SymbolTable object, char c) {
        int n;
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.matchStat = 0;
        int n2 = 1;
        char c2 = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
        if (c2 == 'n') {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.bp + n2) == 'u') {
                JSONLexerBase jSONLexerBase3 = this;
                if (jSONLexerBase3.charAt(jSONLexerBase3.bp + n2 + 1) == 'l') {
                    JSONLexerBase jSONLexerBase4 = this;
                    if (jSONLexerBase4.charAt(jSONLexerBase4.bp + n2 + 2) == 'l') {
                        JSONLexerBase jSONLexerBase5 = this;
                        int n3 = 5;
                        if (jSONLexerBase5.charAt(jSONLexerBase5.bp + 4) == c) {
                            int n4;
                            JSONLexerBase jSONLexerBase6 = this;
                            jSONLexerBase6.bp = n4 = jSONLexerBase6.bp + n3;
                            jSONLexerBase6.ch = jSONLexerBase6.charAt(n4);
                            jSONLexerBase6.matchStat = 3;
                            return null;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        if (c2 != '\"') {
            this.matchStat = -1;
            return null;
        }
        c2 = '\u0000';
        do {
            JSONLexerBase jSONLexerBase7 = this;
            if ((n = jSONLexerBase7.charAt(jSONLexerBase7.bp + n2++)) == 34) {
                JSONLexerBase jSONLexerBase8 = this;
                int n5 = jSONLexerBase8.bp;
                n = n5 + 0 + 1;
                object = jSONLexerBase8.addSymbol(n, n5 + n2 - n - 1, c2, (SymbolTable)object);
                c2 = jSONLexerBase8.charAt(jSONLexerBase8.bp + n2++);
                while (true) {
                    if (c2 == c) {
                        int n6;
                        JSONLexerBase jSONLexerBase9 = this;
                        jSONLexerBase9.bp = n6 = jSONLexerBase9.bp + n2;
                        jSONLexerBase9.ch = jSONLexerBase9.charAt(n6);
                        jSONLexerBase9.matchStat = 3;
                        return object;
                    }
                    if (!JSONLexerBase.isWhitespace(c2)) break;
                    JSONLexerBase jSONLexerBase10 = this;
                    c2 = jSONLexerBase10.charAt(jSONLexerBase10.bp + n2++);
                }
                this.matchStat = -1;
                return object;
            }
            c2 = c2 * 31 + n;
        } while (n != 92);
        this.matchStat = -1;
        return null;
    }

    public Collection<String> newCollectionByType(Class<?> clazz) {
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<String>();
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<String>();
        }
        if (clazz.isAssignableFrom(LinkedList.class)) {
            return new LinkedList<String>();
        }
        try {
            return (Collection)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JSONException(exception.getMessage(), exception);
        }
    }

    public Collection<String> scanFieldStringArray(char[] object, Class<?> clazz) {
        block17: {
            block18: {
                block23: {
                    block20: {
                        int n;
                        int n2;
                        block22: {
                            block21: {
                                block19: {
                                    block16: {
                                        block15: {
                                            this.matchStat = 0;
                                            if (!this.charArrayCompare((char[])object)) {
                                                this.matchStat = -2;
                                                return null;
                                            }
                                            JSONLexerBase jSONLexerBase = this;
                                            char[] cArray = object;
                                            object = this.newCollectionByType(clazz);
                                            n2 = cArray.length;
                                            if (jSONLexerBase.charAt(jSONLexerBase.bp + n2++) != '[') {
                                                this.matchStat = -1;
                                                return null;
                                            }
                                            do {
                                                JSONLexerBase jSONLexerBase2 = this;
                                                if ((n = jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++)) == 34) {
                                                    JSONLexerBase jSONLexerBase3 = this;
                                                    n = jSONLexerBase3.indexOf('\"', jSONLexerBase3.bp + n2);
                                                    if (n != -1) {
                                                        int n3 = this.bp + n2;
                                                        String string = this.subString(n3, n - n3);
                                                        if (string.indexOf(92) != -1) {
                                                            while (true) {
                                                                int n4 = 0;
                                                                for (int i = n - 1; i >= 0 && this.charAt(i) == '\\'; --i) {
                                                                    ++n4;
                                                                }
                                                                if (n4 % 2 == 0) {
                                                                    JSONLexerBase jSONLexerBase4 = this;
                                                                    int n5 = jSONLexerBase4.bp;
                                                                    n4 = n5;
                                                                    n4 = n - (n4 + n2);
                                                                    string = JSONLexerBase.readString(jSONLexerBase4.sub_chars(n5 + n2, n4), n4);
                                                                    break;
                                                                }
                                                                n = this.indexOf('\"', n + 1);
                                                            }
                                                        }
                                                        JSONLexerBase jSONLexerBase5 = this;
                                                        n3 = jSONLexerBase5.bp;
                                                        int n6 = n2 + (n - (n3 + n2) + 1);
                                                        n2 = n6 + 1;
                                                        n = jSONLexerBase5.charAt(n3 + n6);
                                                        object.add(string);
                                                        continue;
                                                    }
                                                    throw new JSONException("unclosed str");
                                                }
                                                if (n != 110) break block15;
                                                JSONLexerBase jSONLexerBase6 = this;
                                                if (jSONLexerBase6.charAt(jSONLexerBase6.bp + n2) != 'u') break block15;
                                                JSONLexerBase jSONLexerBase7 = this;
                                                if (jSONLexerBase7.charAt(jSONLexerBase7.bp + n2 + 1) != 'l') break block15;
                                                JSONLexerBase jSONLexerBase8 = this;
                                                if (jSONLexerBase8.charAt(jSONLexerBase8.bp + n2 + 2) != 'l') break block15;
                                                JSONLexerBase jSONLexerBase9 = this;
                                                n2 += 3;
                                                n = jSONLexerBase9.charAt(jSONLexerBase9.bp + n2++);
                                                object.add(null);
                                            } while (n == 44);
                                            if (n != 93) {
                                                this.matchStat = -1;
                                                return null;
                                            }
                                            break block16;
                                        }
                                        if (n != 93 || object.size() != 0) break block17;
                                    }
                                    JSONLexerBase jSONLexerBase = this;
                                    n = jSONLexerBase.charAt(jSONLexerBase.bp + n2++);
                                    if (n == 44) {
                                        int n7;
                                        JSONLexerBase jSONLexerBase10 = this;
                                        jSONLexerBase10.bp = n7 = jSONLexerBase10.bp + n2;
                                        jSONLexerBase10.ch = jSONLexerBase10.charAt(n7);
                                        jSONLexerBase10.matchStat = 3;
                                        return object;
                                    }
                                    if (n != 125) break block18;
                                    JSONLexerBase jSONLexerBase11 = this;
                                    char c = jSONLexerBase11.charAt(jSONLexerBase11.bp + n2++);
                                    n = c;
                                    if (c != ',') break block19;
                                    JSONLexerBase jSONLexerBase12 = this;
                                    jSONLexerBase12.token = 16;
                                    jSONLexerBase12.bp = n2 = jSONLexerBase12.bp + n2;
                                    jSONLexerBase12.ch = jSONLexerBase12.charAt(n2);
                                    break block20;
                                }
                                if (n != 93) break block21;
                                JSONLexerBase jSONLexerBase = this;
                                jSONLexerBase.token = 15;
                                jSONLexerBase.bp = n2 = jSONLexerBase.bp + n2;
                                jSONLexerBase.ch = jSONLexerBase.charAt(n2);
                                break block20;
                            }
                            if (n != 125) break block22;
                            JSONLexerBase jSONLexerBase = this;
                            jSONLexerBase.token = 13;
                            jSONLexerBase.bp = n2 = jSONLexerBase.bp + n2;
                            jSONLexerBase.ch = jSONLexerBase.charAt(n2);
                            break block20;
                        }
                        if (n != 26) break block23;
                        this.bp += n2 - 1;
                        this.token = 20;
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    return object;
                }
                this.matchStat = -1;
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        throw new JSONException("illega str");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void scanStringArray(Collection<String> var1_3, char var2_5) {
        block18: {
            block19: {
                v0 = this;
                v0.matchStat = 0;
                var3_6 = 1;
                var4_7 = v0.charAt(v0.bp + 0);
                if (var4_7 == 110) {
                    v1 = this;
                    if (v1.charAt(v1.bp + var3_6) == 'u') {
                        v2 = this;
                        if (v2.charAt(v2.bp + var3_6 + 1) == 'l') {
                            v3 = this;
                            if (v3.charAt(v3.bp + var3_6 + 2) == 'l') {
                                v4 = this;
                                if (v4.charAt(v4.bp + var3_6 + 3) == var2_5) {
                                    v5 = this;
                                    v5.bp = var0_1 = v5.bp + 5;
                                    v5.ch = v5.charAt(var0_1);
                                    v5.matchStat = 5;
                                    return;
                                }
                            }
                        }
                    }
                }
                if (var4_7 != 91) {
                    this.matchStat = -1;
                    return;
                }
                v6 = this;
                v7 = var3_6;
                var3_6 = 2;
                var4_7 = v6.charAt(v6.bp + v7);
                while (true) {
                    if (var4_7 != 110) ** GOTO lbl-1000
                    v8 = this;
                    if (v8.charAt(v8.bp + var3_6) != 'u') ** GOTO lbl-1000
                    v9 = this;
                    if (v9.charAt(v9.bp + var3_6 + 1) != 'l') ** GOTO lbl-1000
                    v10 = this;
                    if (v10.charAt(v10.bp + var3_6 + 2) == 'l') {
                        v11 = this;
                        var3_6 += 3;
                        var4_7 = v11.charAt(v11.bp + var3_6++);
                        var1_3.add(null);
                    } else lbl-1000:
                    // 4 sources

                    {
                        if (var4_7 == 93 && var1_3.size() == 0) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                continue;
                                break;
                            }
                        }
                        if (var4_7 != 34) {
                            this.matchStat = -1;
                            return;
                        }
                        v12 = this;
                        var4_7 = v12.bp + var3_6;
                        var5_8 = v12.indexOf('\"', var4_7);
                        if (var5_8 == -1) break block18;
                        var6_10 = this.bp + var3_6;
                        var6_9 = this.subString(var6_10, var5_8 - var4_7);
                        if (var6_9.indexOf(92) != -1) {
                            while (true) {
                                var6_11 = 0;
                                for (var7_12 = var5_8 - 1; var7_12 >= 0 && this.charAt(var7_12) == '\\'; --var7_12) {
                                    ++var6_11;
                                }
                                if (var6_11 % 2 == 0) {
                                    v13 = this;
                                    var4_7 = var5_8 - var4_7;
                                    var6_9 = JSONLexerBase.readString(v13.sub_chars(v13.bp + var3_6, var4_7), var4_7);
                                    break;
                                }
                                var5_8 = this.indexOf('\"', var5_8 + 1);
                            }
                        }
                        v14 = this;
                        var4_7 = v14.bp;
                        v15 = var3_6 + (var5_8 - (var4_7 + var3_6) + 1);
                        var3_6 = v15 + 1;
                        var4_7 = v14.charAt(var4_7 + v15);
                        var1_3.add(var6_9);
                    }
                    if (var4_7 != 44) break;
                    v16 = this;
                    var4_7 = v16.charAt(v16.bp + var3_6++);
                }
                if (var4_7 == 93) {
                    ** continue;
                }
                break block19;
                v17 = this;
                v18 = var3_6;
                var1_4 = v18 + 1;
                if (v17.charAt(v17.bp + v18) == var2_5) {
                    v19 = this;
                    v19.bp = var0_2 = v19.bp + var1_4;
                    v19.ch = v19.charAt(var0_2);
                    v19.matchStat = 3;
                    return;
                }
                this.matchStat = -1;
                return;
            }
            this.matchStat = -1;
            return;
        }
        throw new JSONException("unclosed str");
    }

    public int scanFieldInt(char[] cArray) {
        block10: {
            block11: {
                block12: {
                    block17: {
                        int n;
                        boolean bl;
                        block14: {
                            int n2;
                            int n3;
                            block16: {
                                block15: {
                                    block13: {
                                        char c;
                                        this.matchStat = 0;
                                        if (!this.charArrayCompare(cArray)) {
                                            this.matchStat = -2;
                                            return 0;
                                        }
                                        JSONLexerBase jSONLexerBase = this;
                                        n3 = cArray.length;
                                        if (bl = (n = jSONLexerBase.charAt(jSONLexerBase.bp + n3++)) == 45) {
                                            JSONLexerBase jSONLexerBase2 = this;
                                            n = jSONLexerBase2.charAt(jSONLexerBase2.bp + n3++);
                                        }
                                        if (n < 48 || n > 57) break block10;
                                        n -= 48;
                                        while (true) {
                                            JSONLexerBase jSONLexerBase3 = this;
                                            if ((c = jSONLexerBase3.charAt(jSONLexerBase3.bp + n3++)) < '0' || c > '9') break;
                                            n = n * 10 + (c - 48);
                                        }
                                        if (c == '.') {
                                            this.matchStat = -1;
                                            return 0;
                                        }
                                        if ((n < 0 || n3 > cArray.length + 14) && (n != Integer.MIN_VALUE || n3 != 17 || !bl)) break block11;
                                        if (c == ',') {
                                            int n4;
                                            JSONLexerBase jSONLexerBase4 = this;
                                            jSONLexerBase4.bp = n4 = jSONLexerBase4.bp + n3;
                                            jSONLexerBase4.ch = jSONLexerBase4.charAt(n4);
                                            jSONLexerBase4.matchStat = 3;
                                            jSONLexerBase4.token = 16;
                                            if (bl) {
                                                n = -n;
                                            }
                                            return n;
                                        }
                                        if (c != '}') break block12;
                                        JSONLexerBase jSONLexerBase5 = this;
                                        int n5 = n3;
                                        n2 = n5 + 1;
                                        char c2 = jSONLexerBase5.charAt(jSONLexerBase5.bp + n5);
                                        n3 = c2;
                                        if (c2 != ',') break block13;
                                        JSONLexerBase jSONLexerBase6 = this;
                                        jSONLexerBase6.token = 16;
                                        jSONLexerBase6.bp = n2 = jSONLexerBase6.bp + n2;
                                        jSONLexerBase6.ch = jSONLexerBase6.charAt(n2);
                                        break block14;
                                    }
                                    if (n3 != 93) break block15;
                                    JSONLexerBase jSONLexerBase = this;
                                    jSONLexerBase.token = 15;
                                    jSONLexerBase.bp = n2 = jSONLexerBase.bp + n2;
                                    jSONLexerBase.ch = jSONLexerBase.charAt(n2);
                                    break block14;
                                }
                                if (n3 != 125) break block16;
                                JSONLexerBase jSONLexerBase = this;
                                jSONLexerBase.token = 13;
                                jSONLexerBase.bp = n2 = jSONLexerBase.bp + n2;
                                jSONLexerBase.ch = jSONLexerBase.charAt(n2);
                                break block14;
                            }
                            if (n3 != 26) break block17;
                            this.token = 20;
                            this.bp += n2 - 1;
                            this.ch = (char)26;
                        }
                        this.matchStat = 4;
                        if (bl) {
                            n = -n;
                        }
                        return n;
                    }
                    this.matchStat = -1;
                    return 0;
                }
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = -1;
            return 0;
        }
        this.matchStat = -1;
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public final int[] scanFieldIntArray(char[] var1_1) {
        block12: {
            this.matchStat = 0;
            if (!this.charArrayCompare(var1_1)) {
                this.matchStat = -2;
                return null;
            }
            v0 = this;
            var1_2 = var1_1.length;
            if (v0.charAt(v0.bp + var1_2++) != '[') {
                this.matchStat = -2;
                return null;
            }
            v1 = this;
            var2_3 = v1.charAt(v1.bp + var1_2++);
            var3_4 = new int[16];
            var4_5 = 0;
            if (var2_3 != 93) break block12;
            v2 = this;
            var2_3 = v2.charAt(v2.bp + var1_2++);
            ** GOTO lbl49
        }
        while (true) {
            block14: {
                block15: {
                    block16: {
                        block21: {
                            block18: {
                                block20: {
                                    block19: {
                                        block17: {
                                            block13: {
                                                var5_6 = 0;
                                                if (var2_3 == 45) {
                                                    v3 = this;
                                                    var2_3 = v3.charAt(v3.bp + var1_2++);
                                                    var5_6 = 1;
                                                }
                                                if (var2_3 < 48 || var2_3 > 57) break;
                                                var2_3 -= 48;
                                                while (true) {
                                                    v4 = this;
                                                    if ((var6_7 = v4.charAt(v4.bp + var1_2++)) < '0' || var6_7 > '9') break;
                                                    var2_3 = var2_3 * 10 + (var6_7 - 48);
                                                }
                                                if (var4_5 >= var3_4.length) {
                                                    var3_4 = new int[var3_4.length * 3 / 2];
                                                    System.arraycopy(var3_4, 0, var3_4, 0, var4_5);
                                                }
                                                v5 = var5_6;
                                                var5_6 = var4_5 + 1;
                                                if (v5 != 0) {
                                                    var2_3 = -var2_3;
                                                }
                                                var3_4[var4_5] = var2_3;
                                                if (var6_7 != ',') break block13;
                                                v6 = this;
                                                var2_3 = v6.charAt(v6.bp + var1_2++);
                                                break block14;
                                            }
                                            if (var6_7 != ']') break block15;
                                            v7 = this;
                                            var2_3 = v7.charAt(v7.bp + var1_2++);
                                            var4_5 = var5_6;
lbl49:
                                            // 2 sources

                                            if (var4_5 != var3_4.length) {
                                                v8 = var3_4;
                                                var3_4 = new int[var4_5];
                                                System.arraycopy(v8, 0, var3_4, 0, var4_5);
                                            }
                                            if (var2_3 == 44) {
                                                v9 = this;
                                                v9.bp += var1_2 - 1;
                                                v9.next();
                                                v9.matchStat = 3;
                                                v9.token = 16;
                                                return var3_4;
                                            }
                                            if (var2_3 != 125) break block16;
                                            v10 = this;
                                            v11 = v10.charAt(v10.bp + var1_2++);
                                            var2_3 = v11;
                                            if (v11 != ',') break block17;
                                            v12 = this;
                                            v12.token = 16;
                                            v12.bp += var1_2 - 1;
                                            v12.next();
                                            break block18;
                                        }
                                        if (var2_3 != 93) break block19;
                                        v13 = this;
                                        v13.token = 15;
                                        v13.bp += var1_2 - 1;
                                        v13.next();
                                        break block18;
                                    }
                                    if (var2_3 != 125) break block20;
                                    v14 = this;
                                    v14.token = 13;
                                    v14.bp += var1_2 - 1;
                                    v14.next();
                                    break block18;
                                }
                                if (var2_3 != 26) break block21;
                                this.bp += var1_2 - 1;
                                this.token = 20;
                                this.ch = (char)26;
                            }
                            this.matchStat = 4;
                            return var3_4;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    this.matchStat = -1;
                    return null;
                }
                var2_3 = var6_7;
            }
            var4_5 = var5_6;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean scanBoolean(char var1_2) {
        block9: {
            block7: {
                block8: {
                    v0 = this;
                    v0.matchStat = 0;
                    var2_3 = 1;
                    var3_4 = v0.charAt(v0.bp + 0);
                    var4_5 = false;
                    if (var3_4 != 't') break block7;
                    v1 = this;
                    if (v1.charAt(v1.bp + var2_3) != 'r') break block8;
                    v2 = this;
                    if (v2.charAt(v2.bp + var2_3 + 1) != 'u') break block8;
                    v3 = this;
                    if (v3.charAt(v3.bp + var2_3 + 2) != 'e') break block8;
                    v4 = this;
                    var2_3 = 5;
                    var3_4 = v4.charAt(v4.bp + 4);
                    var4_5 = true;
                    break block9;
                }
                this.matchStat = -1;
                return false;
            }
            if (var3_4 != 'f') ** GOTO lbl38
            v5 = this;
            if (v5.charAt(v5.bp + var2_3) != 'a') ** GOTO lbl-1000
            v6 = this;
            if (v6.charAt(v6.bp + var2_3 + 1) != 'l') ** GOTO lbl-1000
            v7 = this;
            if (v7.charAt(v7.bp + var2_3 + 2) != 's') ** GOTO lbl-1000
            v8 = this;
            if (v8.charAt(v8.bp + var2_3 + 3) == 'e') {
                v9 = this;
                var2_3 = 6;
                var3_4 = v9.charAt(v9.bp + 5);
                var4_5 = false;
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return false;
lbl38:
                // 1 sources

                if (var3_4 == '1') {
                    v10 = this;
                    v11 = var2_3;
                    var2_3 = 2;
                    var3_4 = v10.charAt(v10.bp + v11);
                    var4_5 = true;
                } else if (var3_4 == '0') {
                    v12 = this;
                    v13 = var2_3;
                    var2_3 = 2;
                    var3_4 = v12.charAt(v12.bp + v13);
                    var4_5 = false;
                }
            }
        }
        while (true) {
            if (var3_4 == var1_2) {
                v14 = this;
                v14.bp = var0_1 = v14.bp + var2_3;
                v14.ch = v14.charAt(var0_1);
                v14.matchStat = 3;
                return var4_5;
            }
            if (!JSONLexerBase.isWhitespace(var3_4)) break;
            v15 = this;
            var3_4 = v15.charAt(v15.bp + var2_3++);
        }
        this.matchStat = -1;
        return var4_5;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int scanInt(char var1_4) {
        block12: {
            v0 = this;
            v0.matchStat = 0;
            var2_5 = 1;
            var3_6 = v0.charAt(v0.bp + 0);
            var4_7 = var3_6 == '\"' ? '\u0001' : '\u0000';
            if (var4_7 != '\u0000') {
                v1 = this;
                v2 = var2_5;
                var2_5 = 2;
                var3_6 = v1.charAt(v1.bp + v2);
            }
            if (var5_8 = var3_6 == '-') {
                v3 = this;
                var3_6 = v3.charAt(v3.bp + var2_5++);
            }
            if (var3_6 >= '0' && var3_6 <= '9') {
                var3_6 -= 48;
                while (true) {
                    v4 = this;
                    if ((var4_7 = v4.charAt(v4.bp + var2_5++)) < '0' || var4_7 > '9') break;
                    var3_6 = var3_6 * 10 + (var4_7 - 48);
                }
                if (var4_7 == '.') {
                    this.matchStat = -1;
                    return 0;
                }
                if (var3_6 < '\u0000') {
                    this.matchStat = -1;
                    return 0;
                }
                while (true) {
                    if (var4_7 == var1_4) {
                        v5 = this;
                        v5.bp = var0_1 = v5.bp + var2_5;
                        v5.ch = v5.charAt(var0_1);
                        v5.matchStat = 3;
                        v5.token = 16;
                        if (var5_8) {
                            var3_6 = -var3_6;
                        }
                        return var3_6;
                    }
                    if (!JSONLexerBase.isWhitespace(var4_7)) break;
                    v6 = this;
                    var4_7 = v6.charAt(v6.bp + var2_5++);
                }
                this.matchStat = -1;
                if (var5_8) {
                    var3_6 = -var3_6;
                }
                return var3_6;
            }
            if (var3_6 != 'n') break block12;
            v7 = this;
            if (v7.charAt(v7.bp + var2_5) != 'u') break block12;
            v8 = this;
            if (v8.charAt(v8.bp + var2_5 + 1) != 'l') break block12;
            v9 = this;
            if (v9.charAt(v9.bp + var2_5 + 2) != 'l') break block12;
            v10 = this;
            v10.matchStat = 5;
            var1_4 = '\u0000';
            var2_5 += 3;
            var3_6 = v10.charAt(v10.bp + var2_5++);
            if (var4_7 == '\u0000' || var3_6 != '\"') ** GOTO lbl61
            do {
                v11 = this;
                var3_6 = v11.charAt(v11.bp + var2_5++);
lbl61:
                // 2 sources

                if (var3_6 == ',') {
                    v12 = this;
                    v12.bp = var0_2 = v12.bp + var2_5;
                    v12.ch = v12.charAt(var0_2);
                    v12.matchStat = 5;
                    v12.token = 16;
                    return var1_4;
                }
                if (var3_6 != ']') continue;
                v13 = this;
                v13.bp = var0_3 = v13.bp + var2_5;
                v13.ch = v13.charAt(var0_3);
                v13.matchStat = 5;
                v13.token = 15;
                return var1_4;
            } while (JSONLexerBase.isWhitespace(var3_6));
            this.matchStat = -1;
            return 0;
        }
        this.matchStat = -1;
        return 0;
    }

    public boolean scanFieldBoolean(char[] cArray) {
        block14: {
            block15: {
                block20: {
                    boolean bl;
                    block17: {
                        char c;
                        int n;
                        block19: {
                            block18: {
                                block16: {
                                    block13: {
                                        block12: {
                                            this.matchStat = 0;
                                            if (!this.charArrayCompare(cArray)) {
                                                this.matchStat = -2;
                                                return false;
                                            }
                                            JSONLexerBase jSONLexerBase = this;
                                            n = cArray.length;
                                            if (!(bl = jSONLexerBase.charAt(jSONLexerBase.bp + n++))) break block12;
                                            JSONLexerBase jSONLexerBase2 = this;
                                            if (jSONLexerBase2.charAt(jSONLexerBase2.bp + n++) != 'r') {
                                                this.matchStat = -1;
                                                return false;
                                            }
                                            JSONLexerBase jSONLexerBase3 = this;
                                            if (jSONLexerBase3.charAt(jSONLexerBase3.bp + n++) != 'u') {
                                                this.matchStat = -1;
                                                return false;
                                            }
                                            JSONLexerBase jSONLexerBase4 = this;
                                            if (jSONLexerBase4.charAt(jSONLexerBase4.bp + n++) != 'e') {
                                                this.matchStat = -1;
                                                return false;
                                            }
                                            bl = true;
                                            break block13;
                                        }
                                        if (!bl) break block14;
                                        JSONLexerBase jSONLexerBase = this;
                                        if (jSONLexerBase.charAt(jSONLexerBase.bp + n++) != 'a') {
                                            this.matchStat = -1;
                                            return false;
                                        }
                                        JSONLexerBase jSONLexerBase5 = this;
                                        if (jSONLexerBase5.charAt(jSONLexerBase5.bp + n++) != 'l') {
                                            this.matchStat = -1;
                                            return false;
                                        }
                                        JSONLexerBase jSONLexerBase6 = this;
                                        if (jSONLexerBase6.charAt(jSONLexerBase6.bp + n++) != 's') {
                                            this.matchStat = -1;
                                            return false;
                                        }
                                        JSONLexerBase jSONLexerBase7 = this;
                                        if (jSONLexerBase7.charAt(jSONLexerBase7.bp + n++) != 'e') {
                                            this.matchStat = -1;
                                            return false;
                                        }
                                        bl = false;
                                    }
                                    JSONLexerBase jSONLexerBase = this;
                                    c = jSONLexerBase.charAt(jSONLexerBase.bp + n++);
                                    if (c == ',') {
                                        int n2;
                                        JSONLexerBase jSONLexerBase8 = this;
                                        jSONLexerBase8.bp = n2 = jSONLexerBase8.bp + n;
                                        jSONLexerBase8.ch = jSONLexerBase8.charAt(n2);
                                        jSONLexerBase8.matchStat = 3;
                                        jSONLexerBase8.token = 16;
                                        return bl;
                                    }
                                    if (c != '}') break block15;
                                    JSONLexerBase jSONLexerBase9 = this;
                                    if ((c = jSONLexerBase9.charAt(jSONLexerBase9.bp + n++)) != ',') break block16;
                                    JSONLexerBase jSONLexerBase10 = this;
                                    jSONLexerBase10.token = 16;
                                    jSONLexerBase10.bp = n = jSONLexerBase10.bp + n;
                                    jSONLexerBase10.ch = jSONLexerBase10.charAt(n);
                                    break block17;
                                }
                                if (c != ']') break block18;
                                JSONLexerBase jSONLexerBase = this;
                                jSONLexerBase.token = 15;
                                jSONLexerBase.bp = n = jSONLexerBase.bp + n;
                                jSONLexerBase.ch = jSONLexerBase.charAt(n);
                                break block17;
                            }
                            if (c != '}') break block19;
                            JSONLexerBase jSONLexerBase = this;
                            jSONLexerBase.token = 13;
                            jSONLexerBase.bp = n = jSONLexerBase.bp + n;
                            jSONLexerBase.ch = jSONLexerBase.charAt(n);
                            break block17;
                        }
                        if (c != '\u001a') break block20;
                        this.token = 20;
                        this.bp += n - 1;
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    return bl;
                }
                this.matchStat = -1;
                return false;
            }
            this.matchStat = -1;
            return false;
        }
        this.matchStat = -1;
        return false;
    }

    public long scanFieldLong(char[] cArray) {
        block11: {
            block12: {
                block17: {
                    long l;
                    boolean bl;
                    block14: {
                        int n;
                        int n2;
                        block16: {
                            block15: {
                                block13: {
                                    this.matchStat = 0;
                                    if (!this.charArrayCompare(cArray)) {
                                        this.matchStat = -2;
                                        return 0L;
                                    }
                                    JSONLexerBase jSONLexerBase = this;
                                    n2 = cArray.length;
                                    char c = jSONLexerBase.charAt(jSONLexerBase.bp + n2++);
                                    bl = false;
                                    if (c == '-') {
                                        JSONLexerBase jSONLexerBase2 = this;
                                        c = jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++);
                                        bl = true;
                                    }
                                    if (c < '0' || c > '9') break block11;
                                    l = c - 48;
                                    while (true) {
                                        JSONLexerBase jSONLexerBase3 = this;
                                        if ((c = jSONLexerBase3.charAt(jSONLexerBase3.bp + n2++)) < '0' || c > '9') break;
                                        l = l * 10L + (long)(c - 48);
                                    }
                                    if (c == '.') {
                                        this.matchStat = -1;
                                        return 0L;
                                    }
                                    if (!(n2 - cArray.length < 21 && (l >= 0L || l == Long.MIN_VALUE && bl))) {
                                        this.matchStat = -1;
                                        return 0L;
                                    }
                                    if (c == ',') {
                                        int n3;
                                        JSONLexerBase jSONLexerBase4 = this;
                                        jSONLexerBase4.bp = n3 = jSONLexerBase4.bp + n2;
                                        jSONLexerBase4.ch = jSONLexerBase4.charAt(n3);
                                        jSONLexerBase4.matchStat = 3;
                                        jSONLexerBase4.token = 16;
                                        if (bl) {
                                            l = -l;
                                        }
                                        return l;
                                    }
                                    if (c != '}') break block12;
                                    JSONLexerBase jSONLexerBase5 = this;
                                    int n4 = n2;
                                    n = n4 + 1;
                                    char c2 = jSONLexerBase5.charAt(jSONLexerBase5.bp + n4);
                                    n2 = c2;
                                    if (c2 != ',') break block13;
                                    JSONLexerBase jSONLexerBase6 = this;
                                    jSONLexerBase6.token = 16;
                                    jSONLexerBase6.bp = n = jSONLexerBase6.bp + n;
                                    jSONLexerBase6.ch = jSONLexerBase6.charAt(n);
                                    break block14;
                                }
                                if (n2 != 93) break block15;
                                JSONLexerBase jSONLexerBase = this;
                                jSONLexerBase.token = 15;
                                jSONLexerBase.bp = n = jSONLexerBase.bp + n;
                                jSONLexerBase.ch = jSONLexerBase.charAt(n);
                                break block14;
                            }
                            if (n2 != 125) break block16;
                            JSONLexerBase jSONLexerBase = this;
                            jSONLexerBase.token = 13;
                            jSONLexerBase.bp = n = jSONLexerBase.bp + n;
                            jSONLexerBase.ch = jSONLexerBase.charAt(n);
                            break block14;
                        }
                        if (n2 != 26) break block17;
                        this.token = 20;
                        this.bp += n - 1;
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    if (bl) {
                        l = -l;
                    }
                    return l;
                }
                this.matchStat = -1;
                return 0L;
            }
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = -1;
        return 0L;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long scanLong(char var1_6) {
        block11: {
            block9: {
                block10: {
                    v0 = this;
                    v0.matchStat = 0;
                    var2_7 = '\u0001';
                    var3_8 = v0.charAt(v0.bp + 0);
                    var4_10 = var3_8 == '\"';
                    if (var4_10) {
                        v1 = this;
                        v2 = var2_7;
                        var2_7 = '\u0002';
                        var3_8 = v1.charAt(v1.bp + v2);
                    }
                    if (var5_11 = var3_8 == '-') {
                        v3 = this;
                        var3_8 = v3.charAt(v3.bp + var2_7++);
                    }
                    if (var3_8 < '0' || var3_8 > '9') break block9;
                    var6_12 = var3_8 - 48;
                    while (true) {
                        v4 = this;
                        if ((var3_8 = v4.charAt(v4.bp + var2_7++)) < '0' || var3_8 > '9') break;
                        var6_12 = var6_12 * 10L + (long)(var3_8 - 48);
                    }
                    if (var3_8 == '.') {
                        this.matchStat = -1;
                        return 0L;
                    }
                    v5 = var6_12 >= 0L || var6_12 == -9223372036854775808L && var5_11;
                    if (!v5) break block10;
                    if (!var4_10) ** GOTO lbl33
                    if (var3_8 != '\"') {
                        this.matchStat = -1;
                        return 0L;
                    }
                    do {
                        v6 = this;
                        var3_8 = v6.charAt(v6.bp + var2_7++);
lbl33:
                        // 2 sources

                        if (var3_8 != var1_6) continue;
                        v7 = this;
                        v7.bp = var0_1 = v7.bp + var2_7;
                        v7.ch = v7.charAt(var0_1);
                        v7.matchStat = 3;
                        v7.token = 16;
                        if (var5_11) {
                            var6_12 = -var6_12;
                        }
                        return var6_12;
                    } while (JSONLexerBase.isWhitespace(var3_8));
                    this.matchStat = -1;
                    return var6_12;
                }
                var0_2 = this.bp;
                var0_3 = this.subString(var0_2, var2_7 - 1);
                throw new NumberFormatException(var0_3);
            }
            if (var3_8 != 'n') break block11;
            v8 = this;
            if (v8.charAt(v8.bp + var2_7) != 'u') break block11;
            v9 = this;
            if (v9.charAt(v9.bp + var2_7 + 1) != 'l') break block11;
            v10 = this;
            if (v10.charAt(v10.bp + var2_7 + 2) != 'l') break block11;
            v11 = this;
            v11.matchStat = 5;
            var3_9 = 0L;
            v12 = var1_6 = (char)(var2_7 + 3);
            var1_6 = (char)(v12 + '\u0001');
            var2_7 = v11.charAt(v11.bp + v12);
            if (!var4_10 || var2_7 != 34) ** GOTO lbl69
            do {
                v13 = this;
                v14 = var1_6;
                var1_6 = (char)(v14 + '\u0001');
                var2_7 = v13.charAt(v13.bp + v14);
lbl69:
                // 2 sources

                if (var2_7 == ',') {
                    v15 = this;
                    v15.bp = var0_4 = v15.bp + var1_6;
                    v15.ch = v15.charAt(var0_4);
                    v15.matchStat = 5;
                    v15.token = 16;
                    return var3_9;
                }
                if (var2_7 != 93) continue;
                v16 = this;
                v16.bp = var0_5 = v16.bp + var1_6;
                v16.ch = v16.charAt(var0_5);
                v16.matchStat = 5;
                v16.token = 15;
                return var3_9;
            } while (JSONLexerBase.isWhitespace(var2_7));
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = -1;
        return 0L;
    }

    /*
     * Unable to fully structure code
     */
    public final float scanFieldFloat(char[] var1_4) {
        block31: {
            block23: {
                block25: {
                    block30: {
                        block27: {
                            block29: {
                                block28: {
                                    block26: {
                                        block24: {
                                            this.matchStat = 0;
                                            if (!this.charArrayCompare(var1_4)) {
                                                this.matchStat = -2;
                                                return 0.0f;
                                            }
                                            v0 = this;
                                            var2_8 = var1_4.length;
                                            if ((var4_10 = (var3_9 = v0.charAt(v0.bp + var2_8++)) == '\"' ? 1 : 0) != 0) {
                                                v1 = this;
                                                var3_9 = v1.charAt(v1.bp + var2_8++);
                                            }
                                            if (var5_11 = var3_9 == '-') {
                                                v2 = this;
                                                var3_9 = v2.charAt(v2.bp + var2_8++);
                                            }
                                            if (var3_9 < '0' || var3_9 > '9') break block23;
                                            var6_12 = var3_9 - 48;
                                            while (true) {
                                                v3 = this;
                                                if ((var3_9 = v3.charAt(v3.bp + var2_8++)) < '0' || var3_9 > '9') break;
                                                var6_12 = var6_12 * 10L + (long)(var3_9 - 48);
                                            }
                                            var8_13 = 1L;
                                            if (var3_9 == '.') {
                                                v4 = this;
                                                if ((var3_9 = v4.charAt(v4.bp + var2_8++)) >= '0' && var3_9 <= '9') {
                                                    var6_12 = var6_12 * 10L + (long)(var3_9 - 48);
                                                    var8_13 = 10L;
                                                    while (true) {
                                                        v5 = this;
                                                        if ((var3_9 = v5.charAt(v5.bp + var2_8++)) >= '0' && var3_9 <= '9') {
                                                            var6_12 = var6_12 * 10L + (long)(var3_9 - 48);
                                                            var8_13 *= 10L;
                                                            continue;
                                                        }
                                                        break;
                                                    }
                                                } else {
                                                    this.matchStat = -1;
                                                    return 0.0f;
                                                }
                                            }
                                            var10_14 = var3_9 == 'e' || var3_9 == 'E';
                                            if (!var10_14) break block24;
                                            v6 = this;
                                            if ((var3_9 = v6.charAt(v6.bp + var2_8++)) != '+' && var3_9 != '-') ** GOTO lbl42
                                            do {
                                                v7 = this;
                                                var3_9 = v7.charAt(v7.bp + var2_8++);
lbl42:
                                                // 2 sources

                                            } while (var3_9 >= '0' && var3_9 <= '9');
                                        }
                                        if (var4_10 != 0) {
                                            if (var3_9 != '\"') {
                                                this.matchStat = -1;
                                                return 0.0f;
                                            }
                                            v8 = this;
                                            var3_9 = v8.charAt(v8.bp + var2_8++);
                                            v9 = v8.bp;
                                            var1_5 = v9 + var1_4.length + 1;
                                            var4_10 = v9 + var2_8 - var1_5 - 2;
                                        } else {
                                            v10 = this.bp;
                                            var1_5 = v10 + var1_4.length;
                                            var4_10 = v10 + var2_8 - var1_5 - 1;
                                        }
                                        if (!var10_14 && var4_10 < 17) {
                                            var1_6 = (float)((double)var6_12 / (double)var8_13);
                                            if (var5_11) {
                                                var1_6 = -var1_6;
                                            }
                                        } else {
                                            var1_6 = Float.parseFloat(this.subString(var1_5, var4_10));
                                        }
                                        if (var3_9 == ',') {
                                            v11 = this;
                                            v11.bp = var0_1 = v11.bp + var2_8;
                                            v11.ch = v11.charAt(var0_1);
                                            v11.matchStat = 3;
                                            v11.token = 16;
                                            return var1_6;
                                        }
                                        if (var3_9 != '}') break block25;
                                        v12 = this;
                                        if ((var3_9 = v12.charAt(v12.bp + var2_8++)) != ',') break block26;
                                        v13 = this;
                                        v13.token = 16;
                                        v13.bp = var2_8 = v13.bp + var2_8;
                                        v13.ch = v13.charAt(var2_8);
                                        break block27;
                                    }
                                    if (var3_9 != ']') break block28;
                                    v14 = this;
                                    v14.token = 15;
                                    v14.bp = var2_8 = v14.bp + var2_8;
                                    v14.ch = v14.charAt(var2_8);
                                    break block27;
                                }
                                if (var3_9 != '}') break block29;
                                v15 = this;
                                v15.token = 13;
                                v15.bp = var2_8 = v15.bp + var2_8;
                                v15.ch = v15.charAt(var2_8);
                                break block27;
                            }
                            if (var3_9 != '\u001a') break block30;
                            this.bp += var2_8 - 1;
                            this.token = 20;
                            this.ch = (char)26;
                        }
                        this.matchStat = 4;
                        return var1_6;
                    }
                    this.matchStat = -1;
                    return 0.0f;
                }
                this.matchStat = -1;
                return 0.0f;
            }
            if (var3_9 != 'n') break block31;
            v16 = this;
            if (v16.charAt(v16.bp + var2_8) != 'u') break block31;
            v17 = this;
            if (v17.charAt(v17.bp + var2_8 + 1) != 'l') break block31;
            v18 = this;
            if (v18.charAt(v18.bp + var2_8 + 2) != 'l') break block31;
            v19 = this;
            v19.matchStat = 5;
            var1_7 = 0.0f;
            var2_8 += 3;
            var3_9 = v19.charAt(v19.bp + var2_8++);
            if (var4_10 == 0 || var3_9 != '\"') ** GOTO lbl123
            do {
                v20 = this;
                var3_9 = v20.charAt(v20.bp + var2_8++);
lbl123:
                // 2 sources

                if (var3_9 == ',') {
                    v21 = this;
                    v21.bp = var0_2 = v21.bp + var2_8;
                    v21.ch = v21.charAt(var0_2);
                    v21.matchStat = 5;
                    v21.token = 16;
                    return var1_7;
                }
                if (var3_9 != '}') continue;
                v22 = this;
                v22.bp = var0_3 = v22.bp + var2_8;
                v22.ch = v22.charAt(var0_3);
                v22.matchStat = 5;
                v22.token = 13;
                return var1_7;
            } while (JSONLexerBase.isWhitespace(var3_9));
            this.matchStat = -1;
            return 0.0f;
        }
        this.matchStat = -1;
        return 0.0f;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final float scanFloat(char var1_4) {
        block20: {
            block18: {
                block19: {
                    v0 = this;
                    v0.matchStat = 0;
                    var2_6 = 1;
                    var3_7 = v0.charAt(v0.bp + 0);
                    var4_8 = var3_7 == '\"' ? 1 : 0;
                    if (var4_8 != 0) {
                        v1 = this;
                        v2 = var2_6;
                        var2_6 = 2;
                        var3_7 = v1.charAt(v1.bp + v2);
                    }
                    if (var5_10 = var3_7 == '-') {
                        v3 = this;
                        var3_7 = v3.charAt(v3.bp + var2_6++);
                    }
                    if (var3_7 < '0' || var3_7 > '9') break block18;
                    var6_11 = var3_7 - 48;
                    while (true) {
                        v4 = this;
                        if ((var3_7 = v4.charAt(v4.bp + var2_6++)) < '0' || var3_7 > '9') break;
                        var6_11 = var6_11 * 10L + (long)(var3_7 - 48);
                    }
                    var8_12 = 1L;
                    if (var3_7 == '.') {
                        v5 = this;
                        if ((var3_7 = v5.charAt(v5.bp + var2_6++)) >= '0' && var3_7 <= '9') {
                            var6_11 = var6_11 * 10L + (long)(var3_7 - 48);
                            var8_12 = 10L;
                            while (true) {
                                v6 = this;
                                if ((var3_7 = v6.charAt(v6.bp + var2_6++)) >= '0' && var3_7 <= '9') {
                                    var6_11 = var6_11 * 10L + (long)(var3_7 - 48);
                                    var8_12 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    var10_13 = var3_7 == 'e' || var3_7 == 'E';
                    if (!var10_13) break block19;
                    v7 = this;
                    if ((var3_7 = v7.charAt(v7.bp + var2_6++)) != '+' && var3_7 != '-') ** GOTO lbl43
                    do {
                        v8 = this;
                        var3_7 = v8.charAt(v8.bp + var2_6++);
lbl43:
                        // 2 sources

                    } while (var3_7 >= '0' && var3_7 <= '9');
                }
                if (var4_8 != 0) {
                    if (var3_7 != '\"') {
                        this.matchStat = -1;
                        return 0.0f;
                    }
                    v9 = this;
                    var3_7 = v9.charAt(v9.bp + var2_6++);
                    v10 = v9.bp;
                    var4_8 = v10 + 1;
                    var11_14 = v10 + var2_6 - var4_8 - 2;
                } else {
                    var4_8 = this.bp;
                    var11_14 = var4_8 + var2_6 - var4_8 - 1;
                }
                if (!var10_13 && var11_14 < 17) {
                    var4_9 = (float)((double)var6_11 / (double)var8_12);
                    if (var5_10) {
                        var4_9 = -var4_9;
                    }
                } else {
                    var4_9 = Float.parseFloat(this.subString(var4_8, var11_14));
                }
                if (var3_7 == var1_4) {
                    v11 = this;
                    v11.bp = var0_1 = v11.bp + var2_6;
                    v11.ch = v11.charAt(var0_1);
                    v11.matchStat = 3;
                    v11.token = 16;
                    return var4_9;
                }
                this.matchStat = -1;
                return var4_9;
            }
            if (var3_7 != 'n') break block20;
            v12 = this;
            if (v12.charAt(v12.bp + var2_6) != 'u') break block20;
            v13 = this;
            if (v13.charAt(v13.bp + var2_6 + 1) != 'l') break block20;
            v14 = this;
            if (v14.charAt(v14.bp + var2_6 + 2) != 'l') break block20;
            v15 = this;
            v15.matchStat = 5;
            var1_5 = 0.0f;
            var2_6 += 3;
            var3_7 = v15.charAt(v15.bp + var2_6++);
            if (var4_8 == 0 || var3_7 != '\"') ** GOTO lbl89
            do {
                v16 = this;
                var3_7 = v16.charAt(v16.bp + var2_6++);
lbl89:
                // 2 sources

                if (var3_7 == ',') {
                    v17 = this;
                    v17.bp = var0_2 = v17.bp + var2_6;
                    v17.ch = v17.charAt(var0_2);
                    v17.matchStat = 5;
                    v17.token = 16;
                    return var1_5;
                }
                if (var3_7 != ']') continue;
                v18 = this;
                v18.bp = var0_3 = v18.bp + var2_6;
                v18.ch = v18.charAt(var0_3);
                v18.matchStat = 5;
                v18.token = 15;
                return var1_5;
            } while (JSONLexerBase.isWhitespace(var3_7));
            this.matchStat = -1;
            return 0.0f;
        }
        this.matchStat = -1;
        return 0.0f;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double scanDouble(char var1_4) {
        block20: {
            block18: {
                block19: {
                    v0 = this;
                    v0.matchStat = 0;
                    var2_5 = 1;
                    var3_6 = v0.charAt(v0.bp + 0);
                    var4_8 = var3_6 == '\"' ? 1 : 0;
                    if (var4_8 != 0) {
                        v1 = this;
                        v2 = var2_5;
                        var2_5 = 2;
                        var3_6 = v1.charAt(v1.bp + v2);
                    }
                    if (var5_10 = var3_6 == '-') {
                        v3 = this;
                        var3_6 = v3.charAt(v3.bp + var2_5++);
                    }
                    if (var3_6 < '0' || var3_6 > '9') break block18;
                    var6_11 = var3_6 - 48;
                    while (true) {
                        v4 = this;
                        if ((var3_6 = v4.charAt(v4.bp + var2_5++)) < '0' || var3_6 > '9') break;
                        var6_11 = var6_11 * 10L + (long)(var3_6 - 48);
                    }
                    var8_12 = 1L;
                    if (var3_6 == '.') {
                        v5 = this;
                        if ((var3_6 = v5.charAt(v5.bp + var2_5++)) >= '0' && var3_6 <= '9') {
                            var6_11 = var6_11 * 10L + (long)(var3_6 - 48);
                            var8_12 = 10L;
                            while (true) {
                                v6 = this;
                                if ((var3_6 = v6.charAt(v6.bp + var2_5++)) >= '0' && var3_6 <= '9') {
                                    var6_11 = var6_11 * 10L + (long)(var3_6 - 48);
                                    var8_12 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    var10_13 = var3_6 == 'e' || var3_6 == 'E';
                    if (!var10_13) break block19;
                    v7 = this;
                    if ((var3_6 = v7.charAt(v7.bp + var2_5++)) != '+' && var3_6 != '-') ** GOTO lbl43
                    do {
                        v8 = this;
                        var3_6 = v8.charAt(v8.bp + var2_5++);
lbl43:
                        // 2 sources

                    } while (var3_6 >= '0' && var3_6 <= '9');
                }
                if (var4_8 != 0) {
                    if (var3_6 != '\"') {
                        this.matchStat = -1;
                        return 0.0;
                    }
                    v9 = this;
                    var3_6 = v9.charAt(v9.bp + var2_5++);
                    v10 = v9.bp;
                    var4_8 = v10 + 1;
                    var11_14 = v10 + var2_5 - var4_8 - 2;
                } else {
                    var4_8 = this.bp;
                    var11_14 = var4_8 + var2_5 - var4_8 - 1;
                }
                if (!var10_13 && var11_14 < 17) {
                    var4_9 = (double)var6_11 / (double)var8_12;
                    if (var5_10) {
                        var4_9 = -var4_9;
                    }
                } else {
                    var4_9 = Double.parseDouble(this.subString(var4_8, var11_14));
                }
                if (var3_6 == var1_4) {
                    v11 = this;
                    v11.bp = var0_1 = v11.bp + var2_5;
                    v11.ch = v11.charAt(var0_1);
                    v11.matchStat = 3;
                    v11.token = 16;
                    return var4_9;
                }
                this.matchStat = -1;
                return var4_9;
            }
            if (var3_6 != 'n') break block20;
            v12 = this;
            if (v12.charAt(v12.bp + var2_5) != 'u') break block20;
            v13 = this;
            if (v13.charAt(v13.bp + var2_5 + 1) != 'l') break block20;
            v14 = this;
            if (v14.charAt(v14.bp + var2_5 + 2) != 'l') break block20;
            v15 = this;
            v15.matchStat = 5;
            var3_7 = 0.0;
            v16 = var1_4 = (char)(var2_5 + 3);
            var1_4 = (char)(v16 + '\u0001');
            var2_5 = v15.charAt(v15.bp + v16);
            if (var4_8 == 0 || var2_5 != 34) ** GOTO lbl92
            do {
                v17 = this;
                v18 = var1_4;
                var1_4 = (char)(v18 + '\u0001');
                var2_5 = v17.charAt(v17.bp + v18);
lbl92:
                // 2 sources

                if (var2_5 == 44) {
                    v19 = this;
                    v19.bp = var0_2 = v19.bp + var1_4;
                    v19.ch = v19.charAt(var0_2);
                    v19.matchStat = 5;
                    v19.token = 16;
                    return var3_7;
                }
                if (var2_5 != 93) continue;
                v20 = this;
                v20.bp = var0_3 = v20.bp + var1_4;
                v20.ch = v20.charAt(var0_3);
                v20.matchStat = 5;
                v20.token = 15;
                return var3_7;
            } while (JSONLexerBase.isWhitespace((char)var2_5));
            this.matchStat = -1;
            return 0.0;
        }
        this.matchStat = -1;
        return 0.0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public BigDecimal scanDecimal(char var1_4) {
        block28: {
            block19: {
                block21: {
                    block22: {
                        block27: {
                            block24: {
                                block26: {
                                    block25: {
                                        block23: {
                                            block20: {
                                                v0 = this;
                                                v0.matchStat = 0;
                                                var1_4 = '\u0001';
                                                var2_5 = v0.charAt(v0.bp + 0);
                                                var3_7 = var2_5 == '\"' ? '\u0001' : '\u0000';
                                                if (var3_7 != '\u0000') {
                                                    v1 = this;
                                                    v2 = var1_4;
                                                    var1_4 = (char)2;
                                                    var2_5 = v1.charAt(v1.bp + v2);
                                                }
                                                if (var2_5 == '-') {
                                                    v3 = this;
                                                    v4 = var1_4;
                                                    var1_4 = (char)(v4 + '\u0001');
                                                    var2_5 = v3.charAt(v3.bp + v4);
                                                }
                                                if (var2_5 < '0' || var2_5 > '9') break block19;
                                                do {
                                                    v5 = this;
                                                    v6 = var1_4;
                                                    var1_4 = (char)(v6 + '\u0001');
                                                } while ((var2_5 = v5.charAt(v5.bp + v6)) >= '0' && var2_5 <= '9');
                                                if (var2_5 == '.') {
                                                    v7 = this;
                                                    v8 = var1_4;
                                                    var1_4 = (char)(v8 + '\u0001');
                                                    var2_5 = v7.charAt(v7.bp + v8);
                                                    if (var2_5 >= '0' && var2_5 <= '9') {
                                                        while (true) {
                                                            v9 = this;
                                                            v10 = var1_4;
                                                            var1_4 = (char)(v10 + '\u0001');
                                                            var2_5 = v9.charAt(v9.bp + v10);
                                                            if (var2_5 >= '0' && var2_5 <= '9') {
                                                                continue;
                                                            }
                                                            break;
                                                        }
                                                    } else {
                                                        this.matchStat = -1;
                                                        return null;
                                                    }
                                                }
                                                v11 = var2_5 == 'e' || var2_5 == 'E';
                                                if (!v11) break block20;
                                                v12 = this;
                                                v13 = var1_4;
                                                var1_4 = (char)(v13 + '\u0001');
                                                var2_5 = v12.charAt(v12.bp + v13);
                                                if (var2_5 != '+' && var2_5 != '-') ** GOTO lbl50
                                                do {
                                                    v14 = this;
                                                    v15 = var1_4;
                                                    var1_4 = (char)(v15 + '\u0001');
                                                    var2_5 = v14.charAt(v14.bp + v15);
lbl50:
                                                    // 2 sources

                                                } while (var2_5 >= '0' && var2_5 <= '9');
                                            }
                                            if (var3_7 != '\u0000') {
                                                if (var2_5 != '\"') {
                                                    this.matchStat = -1;
                                                    return null;
                                                }
                                                v16 = this;
                                                v17 = var1_4;
                                                var1_4 = (char)(v17 + '\u0001');
                                                var2_5 = v16.charAt(v16.bp + v17);
                                                v18 = v16.bp;
                                                var3_7 = v18 + 1;
                                                var4_9 = v18 + var1_4 - var3_7 - 2;
                                            } else {
                                                var3_7 = this.bp;
                                                var4_9 = var3_7 + var1_4 - var3_7 - 1;
                                            }
                                            if (var4_9 > 65535) break block21;
                                            var3_8 = this.sub_chars(var3_7, var4_9);
                                            var4_10 = v19;
                                            var5_11 = var3_8.length;
                                            var6_12 = MathContext.UNLIMITED;
                                            v19 = new BigDecimal(var3_8, 0, var5_11, var6_12);
                                            if (var2_5 == ',') {
                                                v20 = this;
                                                v20.bp = var0_1 = v20.bp + var1_4;
                                                v20.ch = v20.charAt(var0_1);
                                                v20.matchStat = 3;
                                                v20.token = 16;
                                                return var4_10;
                                            }
                                            if (var2_5 != ']') break block22;
                                            v21 = this;
                                            v22 = var1_4;
                                            var1_4 = (char)(v22 + '\u0001');
                                            var2_5 = v21.charAt(v21.bp + v22);
                                            if (var2_5 != ',') break block23;
                                            v23 = this;
                                            v23.token = 16;
                                            v24 = v23.bp + var1_4;
                                            var1_4 = (char)v24;
                                            v23.bp = v24;
                                            v23.ch = v23.charAt(var1_4);
                                            break block24;
                                        }
                                        if (var2_5 != ']') break block25;
                                        v25 = this;
                                        v25.token = 15;
                                        v26 = v25.bp + var1_4;
                                        var1_4 = (char)v26;
                                        v25.bp = v26;
                                        v25.ch = v25.charAt(var1_4);
                                        break block24;
                                    }
                                    if (var2_5 != '}') break block26;
                                    v27 = this;
                                    v27.token = 13;
                                    v28 = v27.bp + var1_4;
                                    var1_4 = (char)v28;
                                    v27.bp = v28;
                                    v27.ch = v27.charAt(var1_4);
                                    break block24;
                                }
                                if (var2_5 != '\u001a') break block27;
                                this.token = 20;
                                this.bp += var1_4 - '\u0001';
                                this.ch = (char)26;
                            }
                            this.matchStat = 4;
                            return var4_10;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    this.matchStat = -1;
                    return null;
                }
                throw new JSONException("decimal overflow");
            }
            if (var2_5 != 'n') break block28;
            v29 = this;
            if (v29.charAt(v29.bp + var1_4) != 'u') break block28;
            v30 = this;
            if (v30.charAt(v30.bp + var1_4 + 1) != 'l') break block28;
            v31 = this;
            if (v31.charAt(v31.bp + var1_4 + 2) != 'l') break block28;
            v32 = var3_7;
            v33 = this;
            v33.matchStat = 5;
            var2_6 = null;
            v34 = var1_4 = (char)(var1_4 + 3);
            var1_4 = (char)(v34 + '\u0001');
            var3_7 = v33.charAt(v33.bp + v34);
            if (v32 == '\u0000' || var3_7 != '\"') ** GOTO lbl147
            do {
                v35 = this;
                v36 = var1_4;
                var1_4 = (char)(v36 + '\u0001');
                var3_7 = v35.charAt(v35.bp + v36);
lbl147:
                // 2 sources

                if (var3_7 == ',') {
                    v37 = this;
                    v37.bp = var0_2 = v37.bp + var1_4;
                    v37.ch = v37.charAt(var0_2);
                    v37.matchStat = 5;
                    v37.token = 16;
                    return var2_6;
                }
                if (var3_7 != '}') continue;
                v38 = this;
                v38.bp = var0_3 = v38.bp + var1_4;
                v38.ch = v38.charAt(var0_3);
                v38.matchStat = 5;
                v38.token = 13;
                return var2_6;
            } while (JSONLexerBase.isWhitespace(var3_7));
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final float[] scanFieldFloatArray(char[] var1_1) {
        this.matchStat = 0;
        if (!this.charArrayCompare(var1_1)) {
            this.matchStat = -2;
            return null;
        }
        v0 = this;
        var1_2 = var1_1.length;
        if (v0.charAt(v0.bp + var1_2++) != '[') {
            this.matchStat = -2;
            return null;
        }
        v1 = this;
        var2_3 = v1.charAt(v1.bp + var1_2++);
        var3_6 = new float[16];
        var4_7 = 0;
        while (true) {
            block23: {
                block24: {
                    block25: {
                        block30: {
                            block27: {
                                block29: {
                                    block28: {
                                        block26: {
                                            block22: {
                                                block21: {
                                                    var5_8 = this.bp;
                                                    var6_9 = var5_8 + var1_2 - 1;
                                                    var7_10 = var2_3 == 45;
                                                    if (var7_10) {
                                                        var2_3 = this.charAt(var5_8 + var1_2++);
                                                    }
                                                    if (var2_3 < 48 || var2_3 > 57) break;
                                                    var2_3 -= 48;
                                                    while (true) {
                                                        v2 = this;
                                                        v3 = v2.charAt(v2.bp + var1_2++);
                                                        var5_8 = v3;
                                                        if (v3 < '0' || var5_8 > 57) break;
                                                        var2_3 = var2_3 * 10 + (var5_8 - 48);
                                                    }
                                                    var8_11 = 1;
                                                    if (var5_8 == 46) {
                                                        v4 = this;
                                                        v5 = v4.charAt(v4.bp + var1_2++);
                                                        var5_8 = v5;
                                                        var8_11 = 10;
                                                        if (v5 >= '0' && var5_8 <= 57) {
                                                            var2_3 = var2_3 * 10 + (var5_8 - 48);
                                                            while (true) {
                                                                v6 = this;
                                                                v7 = v6.charAt(v6.bp + var1_2++);
                                                                var5_8 = v7;
                                                                if (v7 >= '0' && var5_8 <= 57) {
                                                                    var2_3 = var2_3 * 10 + (var5_8 - 48);
                                                                    var8_11 = var5_8 = var8_11 * 10;
                                                                    continue;
                                                                }
                                                                break;
                                                            }
                                                        } else {
                                                            this.matchStat = -1;
                                                            return null;
                                                        }
                                                    }
                                                    var9_12 = var5_8 != 101 && var5_8 != 69 ? 0 : 1;
                                                    if (var9_12 == 0) break block21;
                                                    v8 = this;
                                                    v9 = v8.charAt(v8.bp + var1_2++);
                                                    var5_8 = v9;
                                                    if (v9 != '+' && var5_8 != 45) ** GOTO lbl57
                                                    do {
                                                        v10 = this;
                                                        var5_8 = v10.charAt(v10.bp + var1_2++);
lbl57:
                                                        // 2 sources

                                                    } while (var5_8 >= 48 && var5_8 <= 57);
                                                }
                                                v11 = var9_12;
                                                var9_12 = this.bp + var1_2 - var6_9 - 1;
                                                if (v11 == 0 && var9_12 < 10) {
                                                    var2_4 = (float)var2_3 / (float)var8_11;
                                                    if (var7_10) {
                                                        var2_4 = -var2_4;
                                                    }
                                                } else {
                                                    var2_4 = Float.parseFloat(this.subString(var6_9, var9_12));
                                                }
                                                if (var4_7 >= var3_6.length) {
                                                    var3_6 = new float[var3_6.length * 3 / 2];
                                                    System.arraycopy(var3_6, 0, var3_6, 0, var4_7);
                                                }
                                                var6_9 = var4_7 + 1;
                                                var3_6[var4_7] = var2_4;
                                                if (var5_8 != 44) break block22;
                                                v12 = this;
                                                var2_3 = v12.charAt(v12.bp + var1_2++);
                                                break block23;
                                            }
                                            if (var5_8 != 93) break block24;
                                            v13 = this;
                                            var2_5 = v13.charAt(v13.bp + var1_2++);
                                            if (var6_9 != var3_6.length) {
                                                v14 = var3_6;
                                                var3_6 = new float[var6_9];
                                                System.arraycopy(v14, 0, var3_6, 0, var6_9);
                                            }
                                            if (var2_5 == ',') {
                                                v15 = this;
                                                v15.bp += var1_2 - 1;
                                                v15.next();
                                                v15.matchStat = 3;
                                                v15.token = 16;
                                                return var3_6;
                                            }
                                            if (var2_5 != '}') break block25;
                                            v16 = this;
                                            if ((var2_5 = v16.charAt(v16.bp + var1_2++)) != ',') break block26;
                                            v17 = this;
                                            v17.token = 16;
                                            v17.bp += var1_2 - 1;
                                            v17.next();
                                            break block27;
                                        }
                                        if (var2_5 != ']') break block28;
                                        v18 = this;
                                        v18.token = 15;
                                        v18.bp += var1_2 - 1;
                                        v18.next();
                                        break block27;
                                    }
                                    if (var2_5 != '}') break block29;
                                    v19 = this;
                                    v19.token = 13;
                                    v19.bp += var1_2 - 1;
                                    v19.next();
                                    break block27;
                                }
                                if (var2_5 != '\u001a') break block30;
                                this.bp += var1_2 - 1;
                                this.token = 20;
                                this.ch = (char)26;
                            }
                            this.matchStat = 4;
                            return var3_6;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    this.matchStat = -1;
                    return null;
                }
                var2_3 = var5_8;
            }
            var4_7 = var6_9;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final float[][] scanFieldFloatArray2(char[] var1_1) {
        block31: {
            block36: {
                block33: {
                    block35: {
                        block34: {
                            block32: {
                                this.matchStat = 0;
                                if (!this.charArrayCompare(var1_1)) {
                                    this.matchStat = -2;
                                    return null;
                                }
                                v0 = this;
                                var1_2 = var1_1.length;
                                if (v0.charAt(v0.bp + var1_2++) != '[') {
                                    this.matchStat = -2;
                                    return null;
                                }
                                v1 = this;
                                var2_3 = v1.charAt(v1.bp + var1_2++);
                                var3_5 = new float[16][];
                                var4_6 = 0;
                                block0: while (var2_3 == 91) {
                                    v2 = this;
                                    var2_3 = v2.charAt(v2.bp + var1_2++);
                                    var5_7 = new float[16];
                                    var6_8 = 0;
                                    while (true) {
                                        block30: {
                                            var7_9 = this.bp;
                                            var8_10 = var7_9 + var1_2 - 1;
                                            var9_11 = var2_3 == 45;
                                            if (var9_11) {
                                                var2_3 = this.charAt(var7_9 + var1_2++);
                                            }
                                            if (var2_3 < 48 || var2_3 > 57) break;
                                            var2_3 -= 48;
                                            while (true) {
                                                v3 = this;
                                                v4 = v3.charAt(v3.bp + var1_2++);
                                                var7_9 = v4;
                                                if (v4 < '0' || var7_9 > 57) break;
                                                var2_3 = var2_3 * 10 + (var7_9 - 48);
                                            }
                                            var10_12 = 1;
                                            if (var7_9 == 46) {
                                                v5 = this;
                                                v6 = v5.charAt(v5.bp + var1_2++);
                                                var7_9 = v6;
                                                if (v6 >= '0' && var7_9 <= 57) {
                                                    var2_3 = var2_3 * 10 + (var7_9 - 48);
                                                    var10_12 = var7_9 = 10;
                                                    while (true) {
                                                        v7 = this;
                                                        v8 = v7.charAt(v7.bp + var1_2++);
                                                        var7_9 = v8;
                                                        if (v8 >= '0' && var7_9 <= 57) {
                                                            var2_3 = var2_3 * 10 + (var7_9 - 48);
                                                            var10_12 = var7_9 = var10_12 * 10;
                                                            continue;
                                                        }
                                                        break;
                                                    }
                                                } else {
                                                    this.matchStat = -1;
                                                    return null;
                                                }
                                            }
                                            var11_13 = var7_9 != 101 && var7_9 != 69 ? 0 : 1;
                                            if (var11_13 == 0) break block30;
                                            v9 = this;
                                            v10 = v9.charAt(v9.bp + var1_2++);
                                            var7_9 = v10;
                                            if (v10 != '+' && var7_9 != 45) ** GOTO lbl62
                                            do {
                                                v11 = this;
                                                var7_9 = v11.charAt(v11.bp + var1_2++);
lbl62:
                                                // 2 sources

                                            } while (var7_9 >= 48 && var7_9 <= 57);
                                        }
                                        v12 = var11_13;
                                        var11_13 = this.bp + var1_2 - var8_10 - 1;
                                        if (v12 == 0 && var11_13 < 10) {
                                            var2_4 = (float)var2_3 / (float)var10_12;
                                            if (var9_11) {
                                                var2_4 = -var2_4;
                                            }
                                        } else {
                                            var2_4 = Float.parseFloat(this.subString(var8_10, var11_13));
                                        }
                                        if (var6_8 >= var5_7.length) {
                                            var5_7 = new float[var5_7.length * 3 / 2];
                                            System.arraycopy(var5_7, 0, var5_7, 0, var6_8);
                                        }
                                        var8_10 = var6_8 + 1;
                                        var5_7[var6_8] = var2_4;
                                        if (var7_9 == 44) {
                                            v13 = this;
                                            var2_3 = v13.charAt(v13.bp + var1_2++);
                                        } else {
                                            if (var7_9 == 93) {
                                                v14 = this;
                                                var2_3 = v14.charAt(v14.bp + var1_2++);
                                                if (var8_10 != var5_7.length) {
                                                    v15 = var5_7;
                                                    var5_7 = new float[var8_10];
                                                    System.arraycopy(v15, 0, var5_7, 0, var8_10);
                                                }
                                                if (var4_6 >= var3_5.length) {
                                                    var3_5 = new float[var3_5.length * 3 / 2][];
                                                    System.arraycopy(var5_7, 0, var3_5, 0, var8_10);
                                                }
                                                var6_8 = var4_6 + 1;
                                                var3_5[var4_6] = var5_7;
                                                if (var2_3 == 44) {
                                                    v16 = this;
                                                    var2_3 = v16.charAt(v16.bp + var1_2++);
                                                } else if (var2_3 == 93) {
                                                    v17 = this;
                                                    var2_3 = v17.charAt(v17.bp + var1_2++);
                                                    var4_6 = var6_8;
                                                    break block0;
                                                }
                                                var4_6 = var6_8;
                                                continue block0;
                                            }
                                            var2_3 = var7_9;
                                        }
                                        var6_8 = var8_10;
                                    }
                                    this.matchStat = -1;
                                    return null;
                                }
                                if (var4_6 != var3_5.length) {
                                    v18 = var3_5;
                                    var3_5 = new float[var4_6][];
                                    System.arraycopy(v18, 0, var3_5, 0, var4_6);
                                }
                                if (var2_3 == 44) {
                                    v19 = this;
                                    v19.bp += var1_2 - 1;
                                    v19.next();
                                    v19.matchStat = 3;
                                    v19.token = 16;
                                    return var3_5;
                                }
                                if (var2_3 != 125) break block31;
                                v20 = this;
                                if ((var2_3 = v20.charAt(v20.bp + var1_2++)) != 44) break block32;
                                v21 = this;
                                v21.token = 16;
                                v21.bp += var1_2 - 1;
                                v21.next();
                                break block33;
                            }
                            if (var2_3 != 93) break block34;
                            v22 = this;
                            v22.token = 15;
                            v22.bp += var1_2 - 1;
                            v22.next();
                            break block33;
                        }
                        if (var2_3 != 125) break block35;
                        v23 = this;
                        v23.token = 13;
                        v23.bp += var1_2 - 1;
                        v23.next();
                        break block33;
                    }
                    if (var2_3 != 26) break block36;
                    this.bp += var1_2 - 1;
                    this.token = 20;
                    this.ch = (char)26;
                }
                this.matchStat = 4;
                return var3_5;
            }
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final double scanFieldDouble(char[] var1_4) {
        block31: {
            block23: {
                block25: {
                    block30: {
                        block27: {
                            block29: {
                                block28: {
                                    block26: {
                                        block24: {
                                            this.matchStat = 0;
                                            if (!this.charArrayCompare(var1_4)) {
                                                this.matchStat = -2;
                                                return 0.0;
                                            }
                                            v0 = this;
                                            var2_7 = var1_4.length;
                                            if ((var4_10 = (var3_8 = v0.charAt(v0.bp + var2_7++)) == '\"' ? 1 : 0) != 0) {
                                                v1 = this;
                                                var3_8 = v1.charAt(v1.bp + var2_7++);
                                            }
                                            if (var5_12 = var3_8 == '-') {
                                                v2 = this;
                                                var3_8 = v2.charAt(v2.bp + var2_7++);
                                            }
                                            if (var3_8 < '0' || var3_8 > '9') break block23;
                                            var6_13 = var3_8 - 48;
                                            while (true) {
                                                v3 = this;
                                                if ((var3_8 = v3.charAt(v3.bp + var2_7++)) < '0' || var3_8 > '9') break;
                                                var6_13 = var6_13 * 10L + (long)(var3_8 - 48);
                                            }
                                            var8_14 = 1L;
                                            if (var3_8 == '.') {
                                                v4 = this;
                                                if ((var3_8 = v4.charAt(v4.bp + var2_7++)) >= '0' && var3_8 <= '9') {
                                                    var6_13 = var6_13 * 10L + (long)(var3_8 - 48);
                                                    var8_14 = 10L;
                                                    while (true) {
                                                        v5 = this;
                                                        if ((var3_8 = v5.charAt(v5.bp + var2_7++)) >= '0' && var3_8 <= '9') {
                                                            var6_13 = var6_13 * 10L + (long)(var3_8 - 48);
                                                            var8_14 *= 10L;
                                                            continue;
                                                        }
                                                        break;
                                                    }
                                                } else {
                                                    this.matchStat = -1;
                                                    return 0.0;
                                                }
                                            }
                                            var10_15 = var3_8 == 'e' || var3_8 == 'E';
                                            if (!var10_15) break block24;
                                            v6 = this;
                                            if ((var3_8 = v6.charAt(v6.bp + var2_7++)) != '+' && var3_8 != '-') ** GOTO lbl42
                                            do {
                                                v7 = this;
                                                var3_8 = v7.charAt(v7.bp + var2_7++);
lbl42:
                                                // 2 sources

                                            } while (var3_8 >= '0' && var3_8 <= '9');
                                        }
                                        if (var4_10 != 0) {
                                            if (var3_8 != '\"') {
                                                this.matchStat = -1;
                                                return 0.0;
                                            }
                                            v8 = this;
                                            var3_8 = v8.charAt(v8.bp + var2_7++);
                                            v9 = v8.bp;
                                            var1_5 = v9 + var1_4.length + 1;
                                            var4_10 = v9 + var2_7 - var1_5 - 2;
                                        } else {
                                            v10 = this.bp;
                                            var1_5 = v10 + var1_4.length;
                                            var4_10 = v10 + var2_7 - var1_5 - 1;
                                        }
                                        if (!var10_15 && var4_10 < 17) {
                                            var4_11 = (double)var6_13 / (double)var8_14;
                                            if (var5_12) {
                                                var4_11 = -var4_11;
                                            }
                                        } else {
                                            var4_11 = Double.parseDouble(this.subString(var1_5, var4_10));
                                        }
                                        if (var3_8 == ',') {
                                            v11 = this;
                                            v11.bp = var0_1 = v11.bp + var2_7;
                                            v11.ch = v11.charAt(var0_1);
                                            v11.matchStat = 3;
                                            v11.token = 16;
                                            return var4_11;
                                        }
                                        if (var3_8 != '}') break block25;
                                        v12 = this;
                                        v13 = var2_7;
                                        var1_5 = v13 + 1;
                                        v14 = v12.charAt(v12.bp + v13);
                                        var2_7 = v14;
                                        if (v14 != ',') break block26;
                                        v15 = this;
                                        v15.token = 16;
                                        v15.bp = var1_5 = v15.bp + var1_5;
                                        v15.ch = v15.charAt(var1_5);
                                        break block27;
                                    }
                                    if (var2_7 != 93) break block28;
                                    v16 = this;
                                    v16.token = 15;
                                    v16.bp = var1_5 = v16.bp + var1_5;
                                    v16.ch = v16.charAt(var1_5);
                                    break block27;
                                }
                                if (var2_7 != 125) break block29;
                                v17 = this;
                                v17.token = 13;
                                v17.bp = var1_5 = v17.bp + var1_5;
                                v17.ch = v17.charAt(var1_5);
                                break block27;
                            }
                            if (var2_7 != 26) break block30;
                            this.token = 20;
                            this.bp += var1_5 - 1;
                            this.ch = (char)26;
                        }
                        this.matchStat = 4;
                        return var4_11;
                    }
                    this.matchStat = -1;
                    return 0.0;
                }
                this.matchStat = -1;
                return 0.0;
            }
            if (var3_8 != 'n') break block31;
            v18 = this;
            if (v18.charAt(v18.bp + var2_7) != 'u') break block31;
            v19 = this;
            if (v19.charAt(v19.bp + var2_7 + 1) != 'l') break block31;
            v20 = this;
            if (v20.charAt(v20.bp + var2_7 + 2) != 'l') break block31;
            v21 = this;
            v21.matchStat = 5;
            var3_9 = 0.0;
            var1_6 = var2_7 + 3;
            var2_7 = v21.charAt(v21.bp + var1_6++);
            if (var4_10 == 0 || var2_7 != 34) ** GOTO lbl127
            do {
                v22 = this;
                var2_7 = v22.charAt(v22.bp + var1_6++);
lbl127:
                // 2 sources

                if (var2_7 == 44) {
                    v23 = this;
                    v23.bp = var0_2 = v23.bp + var1_6;
                    v23.ch = v23.charAt(var0_2);
                    v23.matchStat = 5;
                    v23.token = 16;
                    return var3_9;
                }
                if (var2_7 != 125) continue;
                v24 = this;
                v24.bp = var0_3 = v24.bp + var1_6;
                v24.ch = v24.charAt(var0_3);
                v24.matchStat = 5;
                v24.token = 13;
                return var3_9;
            } while (JSONLexerBase.isWhitespace((char)var2_7));
            this.matchStat = -1;
            return 0.0;
        }
        this.matchStat = -1;
        return 0.0;
    }

    /*
     * Unable to fully structure code
     */
    public BigDecimal scanFieldDecimal(char[] var1_4) {
        block29: {
            block20: {
                block22: {
                    block23: {
                        block28: {
                            block25: {
                                block27: {
                                    block26: {
                                        block24: {
                                            block21: {
                                                this.matchStat = 0;
                                                if (!this.charArrayCompare(var1_4)) {
                                                    this.matchStat = -2;
                                                    return null;
                                                }
                                                v0 = this;
                                                var2_8 = var1_4.length;
                                                if ((var4_10 = (var3_9 = v0.charAt(v0.bp + var2_8++)) == '\"' ? 1 : 0) != 0) {
                                                    v1 = this;
                                                    var3_9 = v1.charAt(v1.bp + var2_8++);
                                                }
                                                if (var3_9 == '-') {
                                                    v2 = this;
                                                    var3_9 = v2.charAt(v2.bp + var2_8++);
                                                }
                                                if (var3_9 < '0' || var3_9 > '9') break block20;
                                                do {
                                                    v3 = this;
                                                } while ((var3_9 = v3.charAt(v3.bp + var2_8++)) >= '0' && var3_9 <= '9');
                                                if (var3_9 == '.') {
                                                    v4 = this;
                                                    if ((var3_9 = v4.charAt(v4.bp + var2_8++)) >= '0' && var3_9 <= '9') {
                                                        while (true) {
                                                            v5 = this;
                                                            if ((var3_9 = v5.charAt(v5.bp + var2_8++)) >= '0' && var3_9 <= '9') {
                                                                continue;
                                                            }
                                                            break;
                                                        }
                                                    } else {
                                                        this.matchStat = -1;
                                                        return null;
                                                    }
                                                }
                                                v6 = var3_9 == 'e' || var3_9 == 'E';
                                                if (!v6) break block21;
                                                v7 = this;
                                                if ((var3_9 = v7.charAt(v7.bp + var2_8++)) != '+' && var3_9 != '-') ** GOTO lbl34
                                                do {
                                                    v8 = this;
                                                    var3_9 = v8.charAt(v8.bp + var2_8++);
lbl34:
                                                    // 2 sources

                                                } while (var3_9 >= '0' && var3_9 <= '9');
                                            }
                                            if (var4_10 != 0) {
                                                if (var3_9 != '\"') {
                                                    this.matchStat = -1;
                                                    return null;
                                                }
                                                v9 = this;
                                                var3_9 = v9.charAt(v9.bp + var2_8++);
                                                v10 = v9.bp;
                                                var1_5 = v10 + var1_4.length + 1;
                                                var4_10 = v10 + var2_8 - var1_5 - 2;
                                            } else {
                                                v11 = this.bp;
                                                var1_5 = v11 + var1_4.length;
                                                var4_10 = v11 + var2_8 - var1_5 - 1;
                                            }
                                            if (var4_10 > 65535) break block22;
                                            var1_6 = this.sub_chars(var1_5, var4_10);
                                            var4_11 = v12;
                                            var5_12 = var1_6.length;
                                            var6_13 = MathContext.UNLIMITED;
                                            v12 = new BigDecimal(var1_6, 0, var5_12, var6_13);
                                            if (var3_9 == ',') {
                                                v13 = this;
                                                v13.bp = var0_1 = v13.bp + var2_8;
                                                v13.ch = v13.charAt(var0_1);
                                                v13.matchStat = 3;
                                                v13.token = 16;
                                                return var4_11;
                                            }
                                            if (var3_9 != '}') break block23;
                                            v14 = this;
                                            v15 = var2_8;
                                            var1_7 = v15 + 1;
                                            v16 = v14.charAt(v14.bp + v15);
                                            var2_8 = v16;
                                            if (v16 != ',') break block24;
                                            v17 = this;
                                            v17.token = 16;
                                            v17.bp = var1_7 = v17.bp + var1_7;
                                            v17.ch = v17.charAt(var1_7);
                                            break block25;
                                        }
                                        if (var2_8 != 93) break block26;
                                        v18 = this;
                                        v18.token = 15;
                                        v18.bp = var1_7 = v18.bp + var1_7;
                                        v18.ch = v18.charAt(var1_7);
                                        break block25;
                                    }
                                    if (var2_8 != 125) break block27;
                                    v19 = this;
                                    v19.token = 13;
                                    v19.bp = var1_7 = v19.bp + var1_7;
                                    v19.ch = v19.charAt(var1_7);
                                    break block25;
                                }
                                if (var2_8 != 26) break block28;
                                this.token = 20;
                                this.bp += var1_7 - 1;
                                this.ch = (char)26;
                            }
                            this.matchStat = 4;
                            return var4_11;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    this.matchStat = -1;
                    return null;
                }
                throw new JSONException("scan decimal overflow");
            }
            if (var3_9 != 'n') break block29;
            v20 = this;
            if (v20.charAt(v20.bp + var2_8) != 'u') break block29;
            v21 = this;
            if (v21.charAt(v21.bp + var2_8 + 1) != 'l') break block29;
            v22 = this;
            if (v22.charAt(v22.bp + var2_8 + 2) != 'l') break block29;
            v23 = this;
            v23.matchStat = 5;
            var1_4 = null;
            var2_8 += 3;
            var3_9 = v23.charAt(v23.bp + var2_8++);
            if (var4_10 == 0 || var3_9 != '\"') ** GOTO lbl121
            do {
                v24 = this;
                var3_9 = v24.charAt(v24.bp + var2_8++);
lbl121:
                // 2 sources

                if (var3_9 == ',') {
                    v25 = this;
                    v25.bp = var0_2 = v25.bp + var2_8;
                    v25.ch = v25.charAt(var0_2);
                    v25.matchStat = 5;
                    v25.token = 16;
                    return var1_4;
                }
                if (var3_9 != '}') continue;
                v26 = this;
                v26.bp = var0_3 = v26.bp + var2_8;
                v26.ch = v26.charAt(var0_3);
                v26.matchStat = 5;
                v26.token = 13;
                return var1_4;
            } while (JSONLexerBase.isWhitespace(var3_9));
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger scanFieldBigInteger(char[] var1_4) {
        block25: {
            block15: {
                block18: {
                    block19: {
                        block24: {
                            block21: {
                                block23: {
                                    block22: {
                                        block20: {
                                            block17: {
                                                block16: {
                                                    this.matchStat = 0;
                                                    if (!this.charArrayCompare(var1_4)) {
                                                        this.matchStat = -2;
                                                        return null;
                                                    }
                                                    v0 = this;
                                                    var2_7 = var1_4.length;
                                                    if ((var4_11 = (var3_8 = v0.charAt(v0.bp + var2_7++)) == '\"' ? 1 : 0) != 0) {
                                                        v1 = this;
                                                        var3_8 = v1.charAt(v1.bp + var2_7++);
                                                    }
                                                    if (var5_12 = var3_8 == '-') {
                                                        v2 = this;
                                                        var3_8 = v2.charAt(v2.bp + var2_7++);
                                                    }
                                                    if (var3_8 < '0' || var3_8 > '9') break block15;
                                                    var6_13 = var3_8 - 48;
                                                    var3_8 = '\u0000';
                                                    while (true) {
                                                        v3 = this;
                                                        if ((var8_14 = v3.charAt(v3.bp + var2_7++)) < '0' || var8_14 > '9') break;
                                                        var9_15 = var6_13 * 10L + (long)(var8_14 - 48);
                                                        if (var9_15 < var6_13) {
                                                            var3_8 = '\u0001';
                                                            break;
                                                        }
                                                        var6_13 = var9_15;
                                                    }
                                                    if (var4_11 != 0) {
                                                        if (var8_14 != '\"') {
                                                            this.matchStat = -1;
                                                            return null;
                                                        }
                                                        v4 = this;
                                                        var8_14 = v4.charAt(v4.bp + var2_7++);
                                                        v5 = v4.bp;
                                                        var1_5 = v5 + var1_4.length + 1;
                                                        var4_11 = v5 + var2_7 - var1_5 - 2;
                                                    } else {
                                                        v6 = this.bp;
                                                        var1_5 = v6 + var1_4.length;
                                                        var4_11 = v6 + var2_7 - var1_5 - 1;
                                                    }
                                                    if (var3_8 != '\u0000' || var4_11 >= 20 && (!var5_12 || var4_11 >= 21)) break block16;
                                                    if (var5_12) {
                                                        var6_13 = -var6_13;
                                                    }
                                                    var1_6 = BigInteger.valueOf(var6_13);
                                                    break block17;
                                                }
                                                if (var4_11 > 65535) break block18;
                                                var1_6 = this.subString(var1_5, var4_11);
                                                var3_9 = v7;
                                                v7 = new BigInteger((String)var1_6, 10);
                                                var1_6 = var3_9;
                                            }
                                            if (var8_14 == ',') {
                                                v8 = this;
                                                v8.bp = var0_1 = v8.bp + var2_7;
                                                v8.ch = v8.charAt(var0_1);
                                                v8.matchStat = 3;
                                                v8.token = 16;
                                                return var1_6;
                                            }
                                            if (var8_14 != '}') break block19;
                                            v9 = this;
                                            if ((var3_10 = v9.charAt(v9.bp + var2_7++)) != ',') break block20;
                                            v10 = this;
                                            v10.token = 16;
                                            v10.bp = var2_7 = v10.bp + var2_7;
                                            v10.ch = v10.charAt(var2_7);
                                            break block21;
                                        }
                                        if (var3_10 != ']') break block22;
                                        v11 = this;
                                        v11.token = 15;
                                        v11.bp = var2_7 = v11.bp + var2_7;
                                        v11.ch = v11.charAt(var2_7);
                                        break block21;
                                    }
                                    if (var3_10 != '}') break block23;
                                    v12 = this;
                                    v12.token = 13;
                                    v12.bp = var2_7 = v12.bp + var2_7;
                                    v12.ch = v12.charAt(var2_7);
                                    break block21;
                                }
                                if (var3_10 != '\u001a') break block24;
                                this.token = 20;
                                this.bp += var2_7 - 1;
                                this.ch = (char)26;
                            }
                            this.matchStat = 4;
                            return var1_6;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    this.matchStat = -1;
                    return null;
                }
                throw new JSONException("scanInteger overflow");
            }
            if (var3_8 != 'n') break block25;
            v13 = this;
            if (v13.charAt(v13.bp + var2_7) != 'u') break block25;
            v14 = this;
            if (v14.charAt(v14.bp + var2_7 + 1) != 'l') break block25;
            v15 = this;
            if (v15.charAt(v15.bp + var2_7 + 2) != 'l') break block25;
            v16 = this;
            v16.matchStat = 5;
            var1_4 = null;
            var2_7 += 3;
            var3_8 = v16.charAt(v16.bp + var2_7++);
            if (var4_11 == 0 || var3_8 != '\"') ** GOTO lbl112
            do {
                v17 = this;
                var3_8 = v17.charAt(v17.bp + var2_7++);
lbl112:
                // 2 sources

                if (var3_8 == ',') {
                    v18 = this;
                    v18.bp = var0_2 = v18.bp + var2_7;
                    v18.ch = v18.charAt(var0_2);
                    v18.matchStat = 5;
                    v18.token = 16;
                    return var1_4;
                }
                if (var3_8 != '}') continue;
                v19 = this;
                v19.bp = var0_3 = v19.bp + var2_7;
                v19.ch = v19.charAt(var0_3);
                v19.matchStat = 5;
                v19.token = 13;
                return var1_4;
            } while (JSONLexerBase.isWhitespace(var3_8));
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    public Date scanFieldDate(char[] cArray) {
        block23: {
            block28: {
                Object object;
                block25: {
                    int n;
                    int n2;
                    block27: {
                        block26: {
                            block24: {
                                Date date;
                                int n3;
                                this.matchStat = 0;
                                if (!this.charArrayCompare(cArray)) {
                                    this.matchStat = -2;
                                    return null;
                                }
                                JSONLexerBase jSONLexerBase = this;
                                n2 = cArray.length;
                                if ((n3 = jSONLexerBase.charAt(jSONLexerBase.bp + n2++)) == 34) {
                                    JSONLexerBase jSONLexerBase2 = this;
                                    n3 = jSONLexerBase2.indexOf('\"', jSONLexerBase2.bp + cArray.length + 1);
                                    if (n3 != -1) {
                                        block22: {
                                            JSONScanner jSONScanner;
                                            int n4;
                                            int n5 = this.bp + cArray.length + 1;
                                            String string = this.subString(n5, n3 - n5);
                                            if (string.indexOf(92) != -1) {
                                                while (true) {
                                                    int n6 = 0;
                                                    for (n4 = n3 - 1; n4 >= 0 && this.charAt(n4) == '\\'; --n4) {
                                                        ++n6;
                                                    }
                                                    if (n6 % 2 == 0) {
                                                        JSONLexerBase jSONLexerBase3 = this;
                                                        int n7 = jSONLexerBase3.bp;
                                                        n6 = n7;
                                                        n6 = n3 - (n6 + cArray.length + 1);
                                                        string = JSONLexerBase.readString(jSONLexerBase3.sub_chars(n7 + cArray.length + 1, n6), n6);
                                                        break;
                                                    }
                                                    n3 = this.indexOf('\"', n3 + 1);
                                                }
                                            }
                                            JSONLexerBase jSONLexerBase4 = this;
                                            n4 = jSONLexerBase4.bp;
                                            int n8 = n2 + (n3 - (n4 + cArray.length + 1) + 1);
                                            n = n8 + 1;
                                            n2 = jSONLexerBase4.charAt(n4 + n8);
                                            object = jSONScanner;
                                            try {
                                                if (!new JSONScanner(string).scanISO8601DateIfMatch(false)) break block22;
                                            }
                                            catch (Throwable throwable) {
                                                ((JSONLexerBase)object).close();
                                                throw throwable;
                                            }
                                            Object object2 = object;
                                            object = ((JSONLexerBase)object2).getCalendar().getTime();
                                            ((JSONLexerBase)object2).close();
                                        }
                                        this.matchStat = -1;
                                        ((JSONLexerBase)object).close();
                                        return null;
                                    }
                                    throw new JSONException("unclosed str");
                                }
                                if (n3 != 45 && (n3 < 48 || n3 > 57)) {
                                    this.matchStat = -1;
                                    return null;
                                }
                                long l = 0L;
                                boolean bl = false;
                                if (n3 == 45) {
                                    JSONLexerBase jSONLexerBase5 = this;
                                    n3 = jSONLexerBase5.charAt(jSONLexerBase5.bp + n2++);
                                    bl = true;
                                }
                                if (n3 >= 48 && n3 <= 57) {
                                    long l2;
                                    l = l2 = (long)(n3 - 48);
                                    while (true) {
                                        JSONLexerBase jSONLexerBase6 = this;
                                        char c = jSONLexerBase6.charAt(jSONLexerBase6.bp + n2++);
                                        n3 = c;
                                        if (c < '0' || n3 > 57) break;
                                        l = l2 = l * 10L + (long)(n3 - 48);
                                    }
                                }
                                if (l < 0L) {
                                    this.matchStat = -1;
                                    return null;
                                }
                                if (bl) {
                                    l = -l;
                                }
                                Date date2 = date;
                                date = new Date(l);
                                object = date2;
                                n = n2;
                                n2 = n3;
                                if (n2 == 44) {
                                    int n9;
                                    JSONLexerBase jSONLexerBase7 = this;
                                    jSONLexerBase7.bp = n9 = jSONLexerBase7.bp + n;
                                    jSONLexerBase7.ch = jSONLexerBase7.charAt(n9);
                                    jSONLexerBase7.matchStat = 3;
                                    return object;
                                }
                                if (n2 != 125) break block23;
                                JSONLexerBase jSONLexerBase8 = this;
                                char c = jSONLexerBase8.charAt(jSONLexerBase8.bp + n++);
                                n2 = c;
                                if (c != ',') break block24;
                                JSONLexerBase jSONLexerBase9 = this;
                                jSONLexerBase9.token = 16;
                                jSONLexerBase9.bp = n = jSONLexerBase9.bp + n;
                                jSONLexerBase9.ch = jSONLexerBase9.charAt(n);
                                break block25;
                            }
                            if (n2 != 93) break block26;
                            JSONLexerBase jSONLexerBase = this;
                            jSONLexerBase.token = 15;
                            jSONLexerBase.bp = n = jSONLexerBase.bp + n;
                            jSONLexerBase.ch = jSONLexerBase.charAt(n);
                            break block25;
                        }
                        if (n2 != 125) break block27;
                        JSONLexerBase jSONLexerBase = this;
                        jSONLexerBase.token = 13;
                        jSONLexerBase.bp = n = jSONLexerBase.bp + n;
                        jSONLexerBase.ch = jSONLexerBase.charAt(n);
                        break block25;
                    }
                    if (n2 != 26) break block28;
                    this.token = 20;
                    this.bp += n - 1;
                    this.ch = (char)26;
                }
                this.matchStat = 4;
                return object;
            }
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Date scanDate(char var1_2) {
        block23: {
            block28: {
                block25: {
                    block27: {
                        block26: {
                            block24: {
                                v0 = this;
                                v0.matchStat = 0;
                                var1_2 = '\u0001';
                                var2_3 = v0.charAt(v0.bp + 0);
                                if (var2_3 == 34) {
                                    v1 = this;
                                    var2_3 = v1.indexOf('\"', v1.bp + 1);
                                    if (var2_3 != -1) {
                                        block22: {
                                            var3_5 = this.bp + 1;
                                            var3_6 = this.subString(var3_5, var2_3 - var3_5);
                                            if (var3_6.indexOf(92) != -1) {
                                                while (true) {
                                                    var3_7 = 0;
                                                    for (var4_9 = var2_3 - 1; var4_9 >= 0 && this.charAt(var4_9) == '\\'; --var4_9) {
                                                        ++var3_7;
                                                    }
                                                    if (var3_7 % 2 == 0) {
                                                        v2 = this;
                                                        v3 = v2.bp;
                                                        var3_7 = var2_3 - (v3 + 1);
                                                        var3_6 = JSONLexerBase.readString(v2.sub_chars(v3 + 1, var3_7), var3_7);
                                                        break;
                                                    }
                                                    var2_3 = this.indexOf('\"', var2_3 + 1);
                                                }
                                            }
                                            v4 = this;
                                            var4_9 = v4.bp;
                                            v5 = var1_2 + (var2_3 - (var4_9 + 1) + 1);
                                            var1_2 = (char)(v5 + 1);
                                            var2_3 = v4.charAt(var4_9 + v5);
                                            var4_10 = v6;
                                            try {
                                                if (!new JSONScanner((String)var3_6).scanISO8601DateIfMatch(false)) break block22;
                                            }
                                            catch (Throwable v7) {
                                                var4_10.close();
                                                throw v7;
                                            }
                                            v8 = var4_10;
                                            var3_6 = v8.getCalendar().getTime();
                                            v8.close();
                                        }
                                        this.matchStat = -1;
                                        var4_10.close();
                                        return null;
                                    }
                                    throw new JSONException("unclosed str");
                                }
                                if (var2_3 == 45 || var2_3 >= 48 && var2_3 <= 57) ** GOTO lbl63
                                if (var2_3 != 110) ** GOTO lbl-1000
                                v9 = this;
                                if (v9.charAt(v9.bp + var1_2) != 'u') ** GOTO lbl-1000
                                v10 = this;
                                if (v10.charAt(v10.bp + var1_2 + 1) != 'l') ** GOTO lbl-1000
                                v11 = this;
                                if (v11.charAt(v11.bp + var1_2 + 2) == 'l') {
                                    v12 = this;
                                    v12.matchStat = 5;
                                    var3_6 = null;
                                    var1_2 = (char)5;
                                    var2_3 = v12.charAt(v12.bp + 4);
                                } else lbl-1000:
                                // 4 sources

                                {
                                    this.matchStat = -1;
                                    return null;
lbl63:
                                    // 1 sources

                                    var3_8 = 0L;
                                    var5_11 = false;
                                    if (var2_3 == 45) {
                                        v13 = this;
                                        v14 = var1_2;
                                        var1_2 = (char)2;
                                        var2_3 = v13.charAt(v13.bp + v14);
                                        var5_11 = true;
                                    }
                                    if (var2_3 >= 48 && var2_3 <= 57) {
                                        var3_8 = var2_4 = (long)(var2_3 - 48);
                                        while (true) {
                                            v15 = this;
                                            v16 = var1_2;
                                            var1_2 = (char)(v16 + '\u0001');
                                            v17 = v15.charAt(v15.bp + v16);
                                            var2_3 = v17;
                                            if (v17 < '0' || var2_3 > 57) break;
                                            var3_8 = var2_4 = var3_8 * 10L + (long)(var2_3 - 48);
                                        }
                                    }
                                    if (var3_8 < 0L) {
                                        this.matchStat = -1;
                                        return null;
                                    }
                                    if (var5_11) {
                                        var3_8 = -var3_8;
                                    }
                                    var5_12 = v18;
                                    v18 = new Date(var3_8);
                                    var3_6 = var5_12;
                                }
                                if (var2_3 == 44) {
                                    v19 = this;
                                    v19.bp = var0_1 = v19.bp + var1_2;
                                    v19.ch = v19.charAt(var0_1);
                                    v19.matchStat = 3;
                                    v19.token = 16;
                                    return var3_6;
                                }
                                if (var2_3 != 93) break block23;
                                v20 = this;
                                v21 = var1_2;
                                var1_2 = (char)(v21 + '\u0001');
                                v22 = v20.charAt(v20.bp + v21);
                                var2_3 = v22;
                                if (v22 != ',') break block24;
                                v23 = this;
                                v23.token = 16;
                                v24 = v23.bp + var1_2;
                                var1_2 = (char)v24;
                                v23.bp = v24;
                                v23.ch = v23.charAt(var1_2);
                                break block25;
                            }
                            if (var2_3 != 93) break block26;
                            v25 = this;
                            v25.token = 15;
                            v26 = v25.bp + var1_2;
                            var1_2 = (char)v26;
                            v25.bp = v26;
                            v25.ch = v25.charAt(var1_2);
                            break block25;
                        }
                        if (var2_3 != 125) break block27;
                        v27 = this;
                        v27.token = 13;
                        v28 = v27.bp + var1_2;
                        var1_2 = (char)v28;
                        v27.bp = v28;
                        v27.ch = v27.charAt(var1_2);
                        break block25;
                    }
                    if (var2_3 != 26) break block28;
                    this.token = 20;
                    this.bp += var1_2 - '\u0001';
                    this.ch = (char)26;
                }
                this.matchStat = 4;
                return var3_6;
            }
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    public UUID scanFieldUUID(char[] cArray) {
        block66: {
            block67: {
                block72: {
                    UUID uUID;
                    block69: {
                        int n;
                        int n2;
                        block71: {
                            block70: {
                                block68: {
                                    block56: {
                                        int n3;
                                        block33: {
                                            block34: {
                                                block57: {
                                                    UUID uUID2;
                                                    int n4;
                                                    int n5;
                                                    int n6;
                                                    int n7;
                                                    block35: {
                                                        UUID uUID3;
                                                        int n8;
                                                        int n9;
                                                        this.matchStat = 0;
                                                        if (!this.charArrayCompare(cArray)) {
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        JSONLexerBase jSONLexerBase = this;
                                                        n2 = cArray.length;
                                                        if ((n3 = jSONLexerBase.charAt(jSONLexerBase.bp + n2++)) != 34) break block33;
                                                        JSONLexerBase jSONLexerBase2 = this;
                                                        n3 = jSONLexerBase2.indexOf('\"', jSONLexerBase2.bp + cArray.length + 1);
                                                        if (n3 == -1) break block34;
                                                        n7 = this.bp + cArray.length + 1;
                                                        n6 = n3 - n7;
                                                        if (n6 != 36) break block35;
                                                        long l = 0L;
                                                        long l2 = 0L;
                                                        for (n9 = 0; n9 < 8; ++n9) {
                                                            block39: {
                                                                block37: {
                                                                    block38: {
                                                                        block36: {
                                                                            n8 = this.charAt(n7 + n9);
                                                                            if (n8 < 48 || n8 > 57) break block36;
                                                                            n8 -= 48;
                                                                            break block37;
                                                                        }
                                                                        if (n8 < 97 || n8 > 102) break block38;
                                                                        n8 = n8 - 97 + 10;
                                                                        break block37;
                                                                    }
                                                                    if (n8 < 65 || n8 > 70) break block39;
                                                                    n8 = n8 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n8;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n9 = 9; n9 < 13; ++n9) {
                                                            block43: {
                                                                block41: {
                                                                    block42: {
                                                                        block40: {
                                                                            n8 = this.charAt(n7 + n9);
                                                                            if (n8 < 48 || n8 > 57) break block40;
                                                                            n8 -= 48;
                                                                            break block41;
                                                                        }
                                                                        if (n8 < 97 || n8 > 102) break block42;
                                                                        n8 = n8 - 97 + 10;
                                                                        break block41;
                                                                    }
                                                                    if (n8 < 65 || n8 > 70) break block43;
                                                                    n8 = n8 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n8;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n9 = 14; n9 < 18; ++n9) {
                                                            block47: {
                                                                block45: {
                                                                    block46: {
                                                                        block44: {
                                                                            char c = this.charAt(n7 + n9);
                                                                            n8 = c;
                                                                            if (c < '0' || n8 > 57) break block44;
                                                                            n8 -= 48;
                                                                            break block45;
                                                                        }
                                                                        if (n8 < 97 || n8 > 102) break block46;
                                                                        n8 = n8 - 97 + 10;
                                                                        break block45;
                                                                    }
                                                                    if (n8 < 65 || n8 > 70) break block47;
                                                                    n8 = n8 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n8;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n9 = 19; n9 < 23; ++n9) {
                                                            block51: {
                                                                block49: {
                                                                    block50: {
                                                                        block48: {
                                                                            char c = this.charAt(n7 + n9);
                                                                            n8 = c;
                                                                            if (c < '0' || n8 > 57) break block48;
                                                                            n8 -= 48;
                                                                            break block49;
                                                                        }
                                                                        if (n8 < 97 || n8 > 102) break block50;
                                                                        n8 = n8 - 97 + 10;
                                                                        break block49;
                                                                    }
                                                                    if (n8 < 65 || n8 > 70) break block51;
                                                                    n8 = n8 - 65 + 10;
                                                                }
                                                                l2 = l2 << 4 | (long)n8;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n9 = 24; n9 < 36; ++n9) {
                                                            block55: {
                                                                block53: {
                                                                    block54: {
                                                                        block52: {
                                                                            char c = this.charAt(n7 + n9);
                                                                            n8 = c;
                                                                            if (c < '0' || n8 > 57) break block52;
                                                                            n8 -= 48;
                                                                            break block53;
                                                                        }
                                                                        if (n8 < 97 || n8 > 102) break block54;
                                                                        n8 = n8 - 97 + 10;
                                                                        break block53;
                                                                    }
                                                                    if (n8 < 65 || n8 > 70) break block55;
                                                                    n8 = n8 - 65 + 10;
                                                                }
                                                                l2 = l2 << 4 | (long)n8;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        JSONLexerBase jSONLexerBase3 = this;
                                                        uUID = uUID3;
                                                        uUID3 = new UUID(l, l2);
                                                        int n10 = jSONLexerBase3.bp;
                                                        int n11 = n2 + (n3 - (n10 + cArray.length + 1) + 1);
                                                        n = n11 + 1;
                                                        n2 = jSONLexerBase3.charAt(n10 + n11);
                                                        break block56;
                                                    }
                                                    if (n6 != 32) break block57;
                                                    long l = 0L;
                                                    long l3 = 0L;
                                                    for (n5 = 0; n5 < 16; ++n5) {
                                                        block61: {
                                                            block59: {
                                                                block60: {
                                                                    block58: {
                                                                        n4 = this.charAt(n7 + n5);
                                                                        if (n4 < 48 || n4 > 57) break block58;
                                                                        n4 -= 48;
                                                                        break block59;
                                                                    }
                                                                    if (n4 < 97 || n4 > 102) break block60;
                                                                    n4 = n4 - 97 + 10;
                                                                    break block59;
                                                                }
                                                                if (n4 < 65 || n4 > 70) break block61;
                                                                n4 = n4 - 65 + 10;
                                                            }
                                                            l = l << 4 | (long)n4;
                                                            continue;
                                                        }
                                                        this.matchStat = -2;
                                                        return null;
                                                    }
                                                    for (n5 = 16; n5 < 32; ++n5) {
                                                        block65: {
                                                            block63: {
                                                                block64: {
                                                                    block62: {
                                                                        n4 = this.charAt(n7 + n5);
                                                                        if (n4 < 48 || n4 > 57) break block62;
                                                                        n4 -= 48;
                                                                        break block63;
                                                                    }
                                                                    if (n4 < 97 || n4 > 102) break block64;
                                                                    n4 = n4 - 97 + 10;
                                                                    break block63;
                                                                }
                                                                if (n4 < 65 || n4 > 70) break block65;
                                                                n4 = n4 - 65 + 10;
                                                            }
                                                            l3 = l3 << 4 | (long)n4;
                                                            continue;
                                                        }
                                                        this.matchStat = -2;
                                                        return null;
                                                    }
                                                    JSONLexerBase jSONLexerBase = this;
                                                    uUID = uUID2;
                                                    uUID2 = new UUID(l, l3);
                                                    int n12 = jSONLexerBase.bp;
                                                    int n13 = n2 + (n3 - (n12 + cArray.length + 1) + 1);
                                                    n = n13 + 1;
                                                    n2 = jSONLexerBase.charAt(n12 + n13);
                                                    break block56;
                                                }
                                                this.matchStat = -1;
                                                return null;
                                            }
                                            throw new JSONException("unclosed str");
                                        }
                                        if (n3 != 110) break block66;
                                        JSONLexerBase jSONLexerBase = this;
                                        int n14 = n2;
                                        n = n14 + 1;
                                        if (jSONLexerBase.charAt(jSONLexerBase.bp + n14) != 'u') break block66;
                                        JSONLexerBase jSONLexerBase4 = this;
                                        if (jSONLexerBase4.charAt(jSONLexerBase4.bp + n++) != 'l') break block66;
                                        JSONLexerBase jSONLexerBase5 = this;
                                        if (jSONLexerBase5.charAt(jSONLexerBase5.bp + n++) != 'l') break block66;
                                        JSONLexerBase jSONLexerBase6 = this;
                                        uUID = null;
                                        n2 = jSONLexerBase6.charAt(jSONLexerBase6.bp + n++);
                                    }
                                    if (n2 == 44) {
                                        int n15;
                                        JSONLexerBase jSONLexerBase = this;
                                        jSONLexerBase.bp = n15 = jSONLexerBase.bp + n;
                                        jSONLexerBase.ch = jSONLexerBase.charAt(n15);
                                        jSONLexerBase.matchStat = 3;
                                        return uUID;
                                    }
                                    if (n2 != 125) break block67;
                                    JSONLexerBase jSONLexerBase = this;
                                    char c = jSONLexerBase.charAt(jSONLexerBase.bp + n++);
                                    n2 = c;
                                    if (c != ',') break block68;
                                    JSONLexerBase jSONLexerBase7 = this;
                                    jSONLexerBase7.token = 16;
                                    jSONLexerBase7.bp = n = jSONLexerBase7.bp + n;
                                    jSONLexerBase7.ch = jSONLexerBase7.charAt(n);
                                    break block69;
                                }
                                if (n2 != 93) break block70;
                                JSONLexerBase jSONLexerBase = this;
                                jSONLexerBase.token = 15;
                                jSONLexerBase.bp = n = jSONLexerBase.bp + n;
                                jSONLexerBase.ch = jSONLexerBase.charAt(n);
                                break block69;
                            }
                            if (n2 != 125) break block71;
                            JSONLexerBase jSONLexerBase = this;
                            jSONLexerBase.token = 13;
                            jSONLexerBase.bp = n = jSONLexerBase.bp + n;
                            jSONLexerBase.ch = jSONLexerBase.charAt(n);
                            break block69;
                        }
                        if (n2 != 26) break block72;
                        this.token = 20;
                        this.bp += n - 1;
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    return uUID;
                }
                this.matchStat = -1;
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    public UUID scanUUID(char c) {
        block65: {
            block66: {
                block71: {
                    UUID uUID;
                    block68: {
                        int n;
                        block70: {
                            block69: {
                                block67: {
                                    block55: {
                                        block32: {
                                            block33: {
                                                block56: {
                                                    UUID uUID2;
                                                    int n2;
                                                    int n3;
                                                    int n4;
                                                    int n5;
                                                    block34: {
                                                        UUID uUID3;
                                                        int n6;
                                                        int n7;
                                                        JSONLexerBase jSONLexerBase = this;
                                                        jSONLexerBase.matchStat = 0;
                                                        c = '\u0001';
                                                        n = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
                                                        if (n != 34) break block32;
                                                        JSONLexerBase jSONLexerBase2 = this;
                                                        n = jSONLexerBase2.indexOf('\"', jSONLexerBase2.bp + 1);
                                                        if (n == -1) break block33;
                                                        n5 = this.bp + 1;
                                                        n4 = n - n5;
                                                        if (n4 != 36) break block34;
                                                        long l = 0L;
                                                        long l2 = 0L;
                                                        for (n7 = 0; n7 < 8; ++n7) {
                                                            block38: {
                                                                block36: {
                                                                    block37: {
                                                                        block35: {
                                                                            n6 = this.charAt(n5 + n7);
                                                                            if (n6 < 48 || n6 > 57) break block35;
                                                                            n6 -= 48;
                                                                            break block36;
                                                                        }
                                                                        if (n6 < 97 || n6 > 102) break block37;
                                                                        n6 = n6 - 97 + 10;
                                                                        break block36;
                                                                    }
                                                                    if (n6 < 65 || n6 > 70) break block38;
                                                                    n6 = n6 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n6;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n7 = 9; n7 < 13; ++n7) {
                                                            block42: {
                                                                block40: {
                                                                    block41: {
                                                                        block39: {
                                                                            n6 = this.charAt(n5 + n7);
                                                                            if (n6 < 48 || n6 > 57) break block39;
                                                                            n6 -= 48;
                                                                            break block40;
                                                                        }
                                                                        if (n6 < 97 || n6 > 102) break block41;
                                                                        n6 = n6 - 97 + 10;
                                                                        break block40;
                                                                    }
                                                                    if (n6 < 65 || n6 > 70) break block42;
                                                                    n6 = n6 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n6;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n7 = 14; n7 < 18; ++n7) {
                                                            block46: {
                                                                block44: {
                                                                    block45: {
                                                                        block43: {
                                                                            char c2 = this.charAt(n5 + n7);
                                                                            n6 = c2;
                                                                            if (c2 < '0' || n6 > 57) break block43;
                                                                            n6 -= 48;
                                                                            break block44;
                                                                        }
                                                                        if (n6 < 97 || n6 > 102) break block45;
                                                                        n6 = n6 - 97 + 10;
                                                                        break block44;
                                                                    }
                                                                    if (n6 < 65 || n6 > 70) break block46;
                                                                    n6 = n6 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n6;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n7 = 19; n7 < 23; ++n7) {
                                                            block50: {
                                                                block48: {
                                                                    block49: {
                                                                        block47: {
                                                                            char c3 = this.charAt(n5 + n7);
                                                                            n6 = c3;
                                                                            if (c3 < '0' || n6 > 57) break block47;
                                                                            n6 -= 48;
                                                                            break block48;
                                                                        }
                                                                        if (n6 < 97 || n6 > 102) break block49;
                                                                        n6 = n6 - 97 + 10;
                                                                        break block48;
                                                                    }
                                                                    if (n6 < 65 || n6 > 70) break block50;
                                                                    n6 = n6 - 65 + 10;
                                                                }
                                                                l2 = l2 << 4 | (long)n6;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n7 = 24; n7 < 36; ++n7) {
                                                            block54: {
                                                                block52: {
                                                                    block53: {
                                                                        block51: {
                                                                            char c4 = this.charAt(n5 + n7);
                                                                            n6 = c4;
                                                                            if (c4 < '0' || n6 > 57) break block51;
                                                                            n6 -= 48;
                                                                            break block52;
                                                                        }
                                                                        if (n6 < 97 || n6 > 102) break block53;
                                                                        n6 = n6 - 97 + 10;
                                                                        break block52;
                                                                    }
                                                                    if (n6 < 65 || n6 > 70) break block54;
                                                                    n6 = n6 - 65 + 10;
                                                                }
                                                                l2 = l2 << 4 | (long)n6;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        JSONLexerBase jSONLexerBase3 = this;
                                                        uUID = uUID3;
                                                        uUID3 = new UUID(l, l2);
                                                        int n8 = jSONLexerBase3.bp;
                                                        int n9 = c + (n - (n8 + 1) + 1);
                                                        c = (char)(n9 + 1);
                                                        n = jSONLexerBase3.charAt(n8 + n9);
                                                        break block55;
                                                    }
                                                    if (n4 != 32) break block56;
                                                    long l = 0L;
                                                    long l3 = 0L;
                                                    for (n3 = 0; n3 < 16; ++n3) {
                                                        block60: {
                                                            block58: {
                                                                block59: {
                                                                    block57: {
                                                                        n2 = this.charAt(n5 + n3);
                                                                        if (n2 < 48 || n2 > 57) break block57;
                                                                        n2 -= 48;
                                                                        break block58;
                                                                    }
                                                                    if (n2 < 97 || n2 > 102) break block59;
                                                                    n2 = n2 - 97 + 10;
                                                                    break block58;
                                                                }
                                                                if (n2 < 65 || n2 > 70) break block60;
                                                                n2 = n2 - 65 + 10;
                                                            }
                                                            l = l << 4 | (long)n2;
                                                            continue;
                                                        }
                                                        this.matchStat = -2;
                                                        return null;
                                                    }
                                                    for (n3 = 16; n3 < 32; ++n3) {
                                                        block64: {
                                                            block62: {
                                                                block63: {
                                                                    block61: {
                                                                        n2 = this.charAt(n5 + n3);
                                                                        if (n2 < 48 || n2 > 57) break block61;
                                                                        n2 -= 48;
                                                                        break block62;
                                                                    }
                                                                    if (n2 < 97 || n2 > 102) break block63;
                                                                    n2 = n2 - 97 + 10;
                                                                    break block62;
                                                                }
                                                                if (n2 < 65 || n2 > 70) break block64;
                                                                n2 = n2 - 65 + 10;
                                                            }
                                                            l3 = l3 << 4 | (long)n2;
                                                            continue;
                                                        }
                                                        this.matchStat = -2;
                                                        return null;
                                                    }
                                                    JSONLexerBase jSONLexerBase = this;
                                                    uUID = uUID2;
                                                    uUID2 = new UUID(l, l3);
                                                    int n10 = jSONLexerBase.bp;
                                                    int n11 = c + (n - (n10 + 1) + 1);
                                                    c = (char)(n11 + 1);
                                                    n = jSONLexerBase.charAt(n10 + n11);
                                                    break block55;
                                                }
                                                this.matchStat = -1;
                                                return null;
                                            }
                                            throw new JSONException("unclosed str");
                                        }
                                        if (n != 110) break block65;
                                        JSONLexerBase jSONLexerBase = this;
                                        char c5 = c;
                                        c = (char)2;
                                        if (jSONLexerBase.charAt(jSONLexerBase.bp + c5) != 'u') break block65;
                                        JSONLexerBase jSONLexerBase4 = this;
                                        char c6 = c;
                                        c = (char)3;
                                        if (jSONLexerBase4.charAt(jSONLexerBase4.bp + c6) != 'l') break block65;
                                        JSONLexerBase jSONLexerBase5 = this;
                                        char c7 = c;
                                        c = (char)4;
                                        if (jSONLexerBase5.charAt(jSONLexerBase5.bp + c7) != 'l') break block65;
                                        JSONLexerBase jSONLexerBase6 = this;
                                        uUID = null;
                                        char c8 = c;
                                        c = (char)5;
                                        n = jSONLexerBase6.charAt(jSONLexerBase6.bp + c8);
                                    }
                                    if (n == 44) {
                                        int n12;
                                        JSONLexerBase jSONLexerBase = this;
                                        jSONLexerBase.bp = n12 = jSONLexerBase.bp + c;
                                        jSONLexerBase.ch = jSONLexerBase.charAt(n12);
                                        jSONLexerBase.matchStat = 3;
                                        return uUID;
                                    }
                                    if (n != 93) break block66;
                                    JSONLexerBase jSONLexerBase = this;
                                    char c9 = c;
                                    c = (char)(c9 + '\u0001');
                                    char c10 = jSONLexerBase.charAt(jSONLexerBase.bp + c9);
                                    n = c10;
                                    if (c10 != ',') break block67;
                                    JSONLexerBase jSONLexerBase7 = this;
                                    jSONLexerBase7.token = 16;
                                    int n13 = jSONLexerBase7.bp + c;
                                    c = (char)n13;
                                    jSONLexerBase7.bp = n13;
                                    jSONLexerBase7.ch = jSONLexerBase7.charAt(c);
                                    break block68;
                                }
                                if (n != 93) break block69;
                                JSONLexerBase jSONLexerBase = this;
                                jSONLexerBase.token = 15;
                                int n14 = jSONLexerBase.bp + c;
                                c = (char)n14;
                                jSONLexerBase.bp = n14;
                                jSONLexerBase.ch = jSONLexerBase.charAt(c);
                                break block68;
                            }
                            if (n != 125) break block70;
                            JSONLexerBase jSONLexerBase = this;
                            jSONLexerBase.token = 13;
                            int n15 = jSONLexerBase.bp + c;
                            c = (char)n15;
                            jSONLexerBase.bp = n15;
                            jSONLexerBase.ch = jSONLexerBase.charAt(c);
                            break block68;
                        }
                        if (n != 26) break block71;
                        this.token = 20;
                        this.bp += c - '\u0001';
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    return uUID;
                }
                this.matchStat = -1;
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    public final void scanTrue() {
        if (this.ch == 't') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            if (jSONLexerBase.ch == 'r') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 'u') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    if (jSONLexerBase3.ch == 'e') {
                        JSONLexerBase jSONLexerBase4 = this;
                        jSONLexerBase4.next();
                        char c = jSONLexerBase4.ch;
                        if (c != ' ' && c != ',' && c != '}' && c != ']' && c != '\n' && c != '\r' && c != '\t' && c != '\u001a' && c != '\f' && c != '\b' && c != ':' && c != '/') {
                            throw new JSONException("scan true error");
                        }
                        this.token = 6;
                        return;
                    }
                    throw new JSONException("error parse true");
                }
                throw new JSONException("error parse true");
            }
            throw new JSONException("error parse true");
        }
        throw new JSONException("error parse true");
    }

    public final void scanNullOrNew() {
        this.scanNullOrNew(true);
    }

    public final void scanNullOrNew(boolean c) {
        if (this.ch == 'n') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            char c2 = jSONLexerBase.ch;
            if (c2 == 'u') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 'l') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    if (jSONLexerBase3.ch == 'l') {
                        JSONLexerBase jSONLexerBase4 = this;
                        jSONLexerBase4.next();
                        c2 = jSONLexerBase4.ch;
                        if (c2 != ' ' && c2 != ',' && c2 != '}' && c2 != ']' && c2 != '\n' && c2 != '\r' && c2 != '\t' && c2 != '\u001a' && (c2 != ':' || c == '\u0000') && c2 != '\f' && c2 != '\b') {
                            throw new JSONException("scan null error");
                        }
                        this.token = 8;
                        return;
                    }
                    throw new JSONException("error parse null");
                }
                throw new JSONException("error parse null");
            }
            if (c2 == 'e') {
                JSONLexerBase jSONLexerBase5 = this;
                jSONLexerBase5.next();
                if (jSONLexerBase5.ch == 'w') {
                    JSONLexerBase jSONLexerBase6 = this;
                    jSONLexerBase6.next();
                    c = jSONLexerBase6.ch;
                    if (c != ' ' && c != ',' && c != '}' && c != ']' && c != '\n' && c != '\r' && c != '\t' && c != '\u001a' && c != '\f' && c != '\b') {
                        throw new JSONException("scan new error");
                    }
                    this.token = 9;
                    return;
                }
                throw new JSONException("error parse new");
            }
            throw new JSONException("error parse new");
        }
        throw new JSONException("error parse null or new");
    }

    public final void scanFalse() {
        if (this.ch == 'f') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            if (jSONLexerBase.ch == 'a') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 'l') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    if (jSONLexerBase3.ch == 's') {
                        JSONLexerBase jSONLexerBase4 = this;
                        jSONLexerBase4.next();
                        if (jSONLexerBase4.ch == 'e') {
                            JSONLexerBase jSONLexerBase5 = this;
                            jSONLexerBase5.next();
                            char c = jSONLexerBase5.ch;
                            if (c != ' ' && c != ',' && c != '}' && c != ']' && c != '\n' && c != '\r' && c != '\t' && c != '\u001a' && c != '\f' && c != '\b' && c != ':' && c != '/') {
                                throw new JSONException("scan false error");
                            }
                            this.token = 7;
                            return;
                        }
                        throw new JSONException("error parse false");
                    }
                    throw new JSONException("error parse false");
                }
                throw new JSONException("error parse false");
            }
            throw new JSONException("error parse false");
        }
        throw new JSONException("error parse false");
    }

    public final void scanIdent() {
        JSONLexerBase jSONLexerBase;
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            jSONLexerBase = this;
            ++jSONLexerBase.sp;
            jSONLexerBase.next();
        } while (Character.isLetterOrDigit(jSONLexerBase.ch));
        String string = this.stringVal();
        this.token = "null".equalsIgnoreCase(string) ? 8 : ("new".equals(string) ? 9 : ("true".equals(string) ? 6 : ("false".equals(string) ? 7 : ("undefined".equals(string) ? 23 : ("Set".equals(string) ? 21 : ("TreeSet".equals(string) ? 22 : 18))))));
    }

    @Override
    public abstract String stringVal();

    public abstract String subString(int var1, int var2);

    protected abstract char[] sub_chars(int var1, int var2);

    protected abstract boolean charArrayCompare(char[] var1);

    @Override
    public boolean isBlankInput() {
        int n = 0;
        while (true) {
            char c;
            if ((c = this.charAt(n)) == '\u001a') {
                this.token = 20;
                return true;
            }
            if (!JSONLexerBase.isWhitespace(c)) {
                return false;
            }
            ++n;
        }
    }

    @Override
    public final void skipWhitespace() {
        char c;
        while ((c = this.ch) <= '/') {
            if (c != ' ' && c != '\r' && c != '\n' && c != '\t' && c != '\f' && c != '\b') {
                if (c != '/') break;
                this.skipComment();
                continue;
            }
            this.next();
        }
    }

    protected final void putChar(char c) {
        char[] cArray = this.sbuf;
        if (this.sp == this.sbuf.length) {
            cArray = new char[cArray.length * 2];
            int n = cArray.length;
            System.arraycopy(cArray, 0, cArray, 0, n);
            this.sbuf = cArray;
        }
        int n = this.sp;
        this.sp = n + 1;
        this.sbuf[n] = c;
    }

    public final void scanHex() {
        if (this.ch == 'x') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            if (jSONLexerBase.ch == '\'') {
                char c;
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.np = jSONLexerBase2.bp;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == '\'') {
                    this.next();
                    this.token = 26;
                    return;
                }
                while ((c = this.next()) >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
                    ++this.sp;
                }
                if (c == '\'') {
                    JSONLexerBase jSONLexerBase3 = this;
                    ++jSONLexerBase3.sp;
                    jSONLexerBase3.next();
                    jSONLexerBase3.token = 26;
                    return;
                }
                throw new JSONException("illegal state. " + c);
            }
            throw new JSONException("illegal state. " + this.ch);
        }
        throw new JSONException("illegal state. " + this.ch);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    public final void scanNumber() {
        int n;
        char c;
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.np = jSONLexerBase.bp;
        boolean bl = true;
        do {
            if (bl && !(bl = false) && jSONLexerBase.ch != '-') continue;
            JSONLexerBase jSONLexerBase2 = this;
            ++jSONLexerBase2.sp;
            jSONLexerBase2.next();
        } while ((c = this.ch) >= '0' && c <= '9');
        char c2 = c;
        c = '\u0000';
        if (c2 == '.') {
            JSONLexerBase jSONLexerBase3 = this;
            ++jSONLexerBase3.sp;
            jSONLexerBase3.next();
            c = '\u0001';
            while (true) {
                char c3 = this.ch;
                n = c3;
                if (c3 < '0' || n > 57) break;
                JSONLexerBase jSONLexerBase4 = this;
                ++jSONLexerBase4.sp;
                jSONLexerBase4.next();
            }
        }
        if ((n = this.sp) > 65535) throw new JSONException("scanNumber overflow");
        char c4 = this.ch;
        if (c4 == 'L' || c4 == 'S' || c4 == 'B') {
            this.sp = n + 1;
            this.next();
        } else if (c4 == 'F' || c4 == 'D') {
            this.sp = n + 1;
            this.next();
            c = '\u0001';
        } else if (c4 == 'e' || c4 == 'E') {
            JSONLexerBase jSONLexerBase5 = this;
            jSONLexerBase5.sp = n + 1;
            jSONLexerBase5.next();
            c = jSONLexerBase5.ch;
            boolean bl2 = true;
            do {
                if (bl2 && !(bl2 = false) && c != '+' && c != '-') continue;
                JSONLexerBase jSONLexerBase6 = this;
                ++jSONLexerBase6.sp;
                jSONLexerBase6.next();
            } while ((c = this.ch) >= '0' && c <= '9');
            if (c == 'D' || c == 'F') {
                JSONLexerBase jSONLexerBase7 = this;
                ++jSONLexerBase7.sp;
                jSONLexerBase7.next();
            }
            c = '\u0001';
        }
        if (c != '\u0000') {
            this.token = 3;
            return;
        }
        this.token = 2;
    }

    @Override
    public final long longValue() {
        long l;
        long l2 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        JSONLexerBase jSONLexerBase = this;
        int n = jSONLexerBase.np;
        int n2 = n + this.sp;
        if (jSONLexerBase.charAt(n) == '-') {
            bl = true;
            l = Long.MIN_VALUE;
            ++n;
        } else {
            l = -9223372036854775807L;
        }
        long l3 = -922337203685477580L;
        if (n < n2) {
            l2 = -(this.charAt(n++) - 48);
        }
        while (n < n2) {
            int n3 = n + 1;
            char c = this.charAt(n);
            n = c;
            if (c != 'L' && n != 83 && n != 66) {
                n -= 48;
                if (l2 >= l3) {
                    long l4 = n;
                    if ((l2 *= 10L) >= l + l4) {
                        l2 -= l4;
                        n = n3;
                        continue;
                    }
                    throw new NumberFormatException(this.numberString());
                }
                throw new NumberFormatException(this.numberString());
            }
            n = n3;
            break;
        }
        if (bl) {
            if (n > this.np + 1) {
                return l2;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Number decimalValue(boolean bl) {
        JSONLexerBase jSONLexerBase = this;
        char c = jSONLexerBase.charAt(jSONLexerBase.np + this.sp - 1);
        if (c == 'F') {
            try {
                return Float.valueOf(Float.parseFloat(this.numberString()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JSONException(numberFormatException.getMessage() + ", " + this.info());
            }
        }
        if (c == 'D') {
            return Double.parseDouble(this.numberString());
        }
        if (!bl) return this.doubleValue();
        return this.decimalValue();
    }

    @Override
    public abstract BigDecimal decimalValue();

    public String[] scanFieldStringArray(char[] cArray, int n, SymbolTable symbolTable) {
        throw new UnsupportedOperationException();
    }

    public boolean matchField2(char[] cArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(int n) {
        this.features = n;
    }
}

