/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser.deserializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class OptionalCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static OptionalCodec instance = new OptionalCodec();

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Object object2;
        if (type == OptionalInt.class) {
            object2 = TypeUtils.castToInt(defaultJSONParser.parseObject(Integer.class));
            if (object2 == null) {
                return (T)OptionalInt.empty();
            }
            return (T)OptionalInt.of((Integer)object2);
        }
        if (type == OptionalLong.class) {
            object2 = TypeUtils.castToLong(defaultJSONParser.parseObject(Long.class));
            if (object2 == null) {
                return (T)OptionalLong.empty();
            }
            return (T)OptionalLong.of((Long)object2);
        }
        if (type == OptionalDouble.class) {
            object2 = TypeUtils.castToDouble(defaultJSONParser.parseObject(Double.class));
            if (object2 == null) {
                return (T)OptionalDouble.empty();
            }
            return (T)OptionalDouble.of((Double)object2);
        }
        object2 = defaultJSONParser.parseObject(TypeUtils.unwrapOptional(type));
        if (object2 == null) {
            return (T)Optional.empty();
        }
        return (T)Optional.of(object2);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) {
        Object object3;
        if (object == null) {
            jSONSerializer.writeNull();
            return;
        }
        if (object instanceof Optional) {
            object3 = (Optional)object;
            object3 = ((Optional)object3).isPresent() ? ((Optional)object3).get() : null;
            jSONSerializer.write(object3);
            return;
        }
        if (object instanceof OptionalDouble) {
            object3 = (OptionalDouble)object;
            if (((OptionalDouble)object3).isPresent()) {
                jSONSerializer.write(((OptionalDouble)object3).getAsDouble());
            } else {
                jSONSerializer.writeNull();
            }
            return;
        }
        if (object instanceof OptionalInt) {
            object3 = (OptionalInt)object;
            if (((OptionalInt)object3).isPresent()) {
                int n2 = ((OptionalInt)object3).getAsInt();
                jSONSerializer.out.writeInt(n2);
            } else {
                jSONSerializer.writeNull();
            }
            return;
        }
        if (object instanceof OptionalLong) {
            object3 = (OptionalLong)object;
            if (((OptionalLong)object3).isPresent()) {
                long l = ((OptionalLong)object3).getAsLong();
                jSONSerializer.out.writeLong(l);
            } else {
                jSONSerializer.writeNull();
            }
            return;
        }
        throw new JSONException("not support optional : " + object.getClass());
    }
}

