/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class BigDecimalCodec
implements ObjectSerializer,
ObjectDeserializer {
    static final BigDecimal LOW = BigDecimal.valueOf(-9007199254740991L);
    static final BigDecimal HIGH = BigDecimal.valueOf(0x1FFFFFFFFFFFFFL);
    public static final BigDecimalCodec instance = new BigDecimalCodec();

    public static <T> T deserialze(DefaultJSONParser object) {
        JSONLexer jSONLexer = ((DefaultJSONParser)object).lexer;
        if (jSONLexer.token() == 2) {
            BigDecimal bigDecimal = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            return (T)bigDecimal;
        }
        if (jSONLexer.token() == 3) {
            BigDecimal bigDecimal = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            return (T)bigDecimal;
        }
        return (T)((object = ((DefaultJSONParser)object).parse()) == null ? null : TypeUtils.castToBigDecimal(object));
    }

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type, int n) {
        SerializeWriter serializeWriter = ((JSONSerializer)object).out;
        if (object2 == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullNumberAsZero);
        } else {
            object = (BigDecimal)object2;
            int n2 = ((BigDecimal)object).scale();
            object3 = SerializerFeature.isEnabled(n, serializeWriter.features, SerializerFeature.WriteBigDecimalAsPlain) && n2 >= -100 && n2 < 100 ? ((BigDecimal)object).toPlainString() : ((BigDecimal)object).toString();
            if (n2 == 0 && ((String)object3).length() >= 16 && SerializerFeature.isEnabled(n, serializeWriter.features, SerializerFeature.BrowserCompatible) && (((BigDecimal)object).compareTo(LOW) < 0 || ((BigDecimal)object).compareTo(HIGH) > 0)) {
                serializeWriter.writeString((String)object3);
                return;
            }
            SerializeWriter serializeWriter2 = serializeWriter;
            serializeWriter2.write((String)object3);
            if (serializeWriter2.isEnabled(SerializerFeature.WriteClassName) && type != BigDecimal.class && ((BigDecimal)object).scale() == 0) {
                serializeWriter.write(46);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        try {
            return BigDecimalCodec.deserialze(defaultJSONParser);
        }
        catch (Exception exception) {
            throw new JSONException("parseDecimal error, field : " + object, exception);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

