/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.deserializer.ContextObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.BeanContext;
import com.tradplus.ads.common.serialization.serializer.ContextObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.DateCodec;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class CalendarCodec
extends ContextObjectDeserializer
implements ObjectSerializer,
ContextObjectSerializer {
    public static final CalendarCodec instance = new CalendarCodec();
    private DatatypeFactory dateFactory;

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, BeanContext object2) {
        SimpleDateFormat simpleDateFormat;
        Object object3 = jSONSerializer.out;
        object2 = ((BeanContext)object2).getFormat();
        object = (Calendar)object;
        if (((String)object2).equals("unixtime")) {
            ((SerializeWriter)object3).writeInt((int)(((Calendar)object).getTimeInMillis() / 1000L));
            return;
        }
        Object object4 = object3;
        object3 = simpleDateFormat;
        ((SimpleDateFormat)object3)((String)object2);
        ((DateFormat)object3).setTimeZone(jSONSerializer.timeZone);
        ((SerializeWriter)object4).writeString(simpleDateFormat.format(((Calendar)object).getTime()));
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull();
            return;
        }
        object = object instanceof XMLGregorianCalendar ? ((XMLGregorianCalendar)object).toGregorianCalendar() : (Calendar)object;
        if (serializeWriter.isEnabled(SerializerFeature.UseISO8601DateFormat)) {
            char[] cArray;
            char c = serializeWriter.isEnabled(SerializerFeature.UseSingleQuotes) ? (char)'\'' : '\"';
            Object object3 = object;
            serializeWriter.append(c);
            int n2 = ((Calendar)object3).get(1);
            int n3 = ((Calendar)object3).get(2) + 1;
            n = ((Calendar)object3).get(5);
            int n4 = ((Calendar)object3).get(11);
            int n5 = ((Calendar)object3).get(12);
            int n6 = ((Calendar)object3).get(13);
            int n7 = ((Calendar)object3).get(14);
            if (n7 != 0) {
                cArray = "0000-00-00T00:00:00.000".toCharArray();
                IOUtils.getChars(n7, 23, cArray);
                IOUtils.getChars(n6, 19, cArray);
                IOUtils.getChars(n5, 16, cArray);
                IOUtils.getChars(n4, 13, cArray);
                IOUtils.getChars(n, 10, cArray);
                IOUtils.getChars(n3, 7, cArray);
                IOUtils.getChars(n2, 4, cArray);
            } else if (n6 == 0 && n5 == 0 && n4 == 0) {
                cArray = "0000-00-00".toCharArray();
                IOUtils.getChars(n, 10, cArray);
                IOUtils.getChars(n3, 7, cArray);
                IOUtils.getChars(n2, 4, cArray);
            } else {
                cArray = "0000-00-00T00:00:00".toCharArray();
                IOUtils.getChars(n6, 19, cArray);
                IOUtils.getChars(n5, 16, cArray);
                IOUtils.getChars(n4, 13, cArray);
                IOUtils.getChars(n, 10, cArray);
                IOUtils.getChars(n3, 7, cArray);
                IOUtils.getChars(n2, 4, cArray);
            }
            serializeWriter.write(cArray);
            float f = (float)((Calendar)object).getTimeZone().getOffset(((Calendar)object).getTimeInMillis()) / 3600000.0f;
            int n8 = (int)f;
            if ((double)n8 == 0.0) {
                serializeWriter.write(90);
            } else {
                if (n8 > 9) {
                    SerializeWriter serializeWriter2 = serializeWriter;
                    serializeWriter2.write(43);
                    serializeWriter2.writeInt(n8);
                } else if (n8 > 0) {
                    Object object4 = serializeWriter;
                    ((SerializeWriter)object4).write(43);
                    ((SerializeWriter)object4).write(48);
                    ((SerializeWriter)object4).writeInt(n8);
                } else if (n8 < -9) {
                    SerializeWriter serializeWriter3 = serializeWriter;
                    serializeWriter3.write(45);
                    serializeWriter3.writeInt(n8);
                } else if (n8 < 0) {
                    Object object5 = serializeWriter;
                    ((SerializeWriter)object5).write(45);
                    ((SerializeWriter)object5).write(48);
                    serializeWriter.writeInt(-n8);
                }
                serializeWriter.write(58);
                int n9 = (int)((f - (float)n8) * 60.0f);
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n9;
                serializeWriter.append(String.format("%02d", objectArray2));
            }
            serializeWriter.append(c);
        } else {
            jSONSerializer.write(((Calendar)object).getTime());
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        return this.deserialze(defaultJSONParser, type, object, null, 0);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser object, Type type, Object object2, String string, int n) {
        if ((object2 = DateCodec.instance.deserialze((DefaultJSONParser)object, type, object2, string, n)) instanceof Calendar) {
            return (T)object2;
        }
        if ((object2 = (Date)object2) == null) {
            return null;
        }
        object = ((DefaultJSONParser)object).lexer;
        object = Calendar.getInstance(object.getTimeZone(), object.getLocale());
        ((Calendar)object).setTime((Date)object2);
        if (type == XMLGregorianCalendar.class) {
            return (T)this.createXMLGregorianCalendar((GregorianCalendar)object);
        }
        return (T)object;
    }

    public XMLGregorianCalendar createXMLGregorianCalendar(Calendar calendar) {
        if (this.dateFactory == null) {
            try {
                this.dateFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalStateException("Could not obtain an instance of DatatypeFactory.", datatypeConfigurationException);
            }
        }
        return this.dateFactory.newXMLGregorianCalendar((GregorianCalendar)calendar);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

