/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.deserializer.AbstractDateDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.IOUtils;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class DateCodec
extends AbstractDateDeserializer
implements ObjectSerializer {
    public static final DateCodec instance = new DateCodec();

    @Override
    public void write(JSONSerializer object, Object object2, Object serializable, Type type, int n) {
        long l;
        SerializeWriter serializeWriter = ((JSONSerializer)object).out;
        if (object2 == null) {
            serializeWriter.writeNull();
            return;
        }
        serializable = object2.getClass();
        if (serializable == Date.class && ((l = ((Date)object2).getTime()) + (long)((JSONSerializer)object).timeZone.getOffset(l)) % 86400000L == 0L && !SerializerFeature.isEnabled(serializeWriter.features, n, SerializerFeature.WriteClassName)) {
            serializeWriter.writeString(object2.toString());
            return;
        }
        if (serializable == Time.class) {
            l = ((Time)object2).getTime();
            if ("unixtime".equals(((JSONSerializer)object).getDateFormatPattern())) {
                serializeWriter.writeLong(l / 1000L);
                return;
            }
            if ("millis".equals(((JSONSerializer)object).getDateFormatPattern())) {
                serializeWriter.writeLong(l);
                return;
            }
            if (l < 86400000L) {
                serializeWriter.writeString(object2.toString());
                return;
            }
        }
        n = 0;
        if (serializable == Timestamp.class) {
            n = ((Timestamp)object2).getNanos();
        }
        java.util.Date date = object2 instanceof java.util.Date ? (java.util.Date)object2 : TypeUtils.castToDate(object2);
        if ("unixtime".equals(((JSONSerializer)object).getDateFormatPattern())) {
            serializeWriter.writeLong(date.getTime() / 1000L);
            return;
        }
        if ("millis".equals(((JSONSerializer)object).getDateFormatPattern())) {
            serializeWriter.writeLong(date.getTime());
            return;
        }
        if (serializeWriter.isEnabled(SerializerFeature.WriteDateUseDateFormat)) {
            object2 = ((JSONSerializer)object).getDateFormat();
            if (object2 == null) {
                SimpleDateFormat simpleDateFormat;
                object2 = ((JSONSerializer)object).getFastJsonConfigDateFormatPattern();
                if (object2 == null) {
                    object2 = JSON.DEFFAULT_DATE_FORMAT;
                }
                serializable = simpleDateFormat;
                ((SimpleDateFormat)serializable)((String)object2, ((JSONSerializer)object).locale);
                simpleDateFormat.setTimeZone(((JSONSerializer)object).timeZone);
                object2 = serializable;
            }
            serializeWriter.writeString(((DateFormat)object2).format(date));
            return;
        }
        if (serializeWriter.isEnabled(SerializerFeature.WriteClassName) && serializable != type) {
            if (serializable == java.util.Date.class) {
                SerializeWriter serializeWriter2 = serializeWriter;
                serializeWriter.write("new Date(");
                serializeWriter2.writeLong(((java.util.Date)object2).getTime());
                serializeWriter2.write(41);
            } else {
                Object object3 = serializeWriter;
                SerializeWriter serializeWriter3 = serializeWriter;
                serializeWriter3.write(123);
                serializeWriter3.writeFieldName(JSON.DEFAULT_TYPE_KEY);
                ((JSONSerializer)object).write(((Class)serializable).getName());
                long l2 = ((java.util.Date)object2).getTime();
                ((SerializeWriter)object3).writeFieldValue(',', "val", l2);
                ((SerializeWriter)object3).write(125);
            }
            return;
        }
        long l3 = date.getTime();
        if (serializeWriter.isEnabled(SerializerFeature.UseISO8601DateFormat)) {
            char[] cArray;
            int n2 = serializeWriter.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
            serializeWriter.write(n2);
            object = Calendar.getInstance(((JSONSerializer)object).timeZone, ((JSONSerializer)object).locale);
            ((Calendar)object).setTimeInMillis(l3);
            int n3 = ((Calendar)object).get(1);
            int n4 = ((Calendar)object).get(2) + 1;
            int n5 = ((Calendar)object).get(5);
            int n6 = ((Calendar)object).get(11);
            int n7 = ((Calendar)object).get(12);
            int n8 = ((Calendar)object).get(13);
            int n9 = ((Calendar)object).get(14);
            if (n > 0) {
                cArray = "0000-00-00 00:00:00.000000000".toCharArray();
                IOUtils.getChars(n, 29, cArray);
                IOUtils.getChars(n8, 19, cArray);
                IOUtils.getChars(n7, 16, cArray);
                IOUtils.getChars(n6, 13, cArray);
                IOUtils.getChars(n5, 10, cArray);
                IOUtils.getChars(n4, 7, cArray);
                IOUtils.getChars(n3, 4, cArray);
            } else if (n9 != 0) {
                cArray = "0000-00-00T00:00:00.000".toCharArray();
                IOUtils.getChars(n9, 23, cArray);
                IOUtils.getChars(n8, 19, cArray);
                IOUtils.getChars(n7, 16, cArray);
                IOUtils.getChars(n6, 13, cArray);
                IOUtils.getChars(n5, 10, cArray);
                IOUtils.getChars(n4, 7, cArray);
                IOUtils.getChars(n3, 4, cArray);
            } else if (n8 == 0 && n7 == 0 && n6 == 0) {
                cArray = "0000-00-00".toCharArray();
                IOUtils.getChars(n5, 10, cArray);
                IOUtils.getChars(n4, 7, cArray);
                IOUtils.getChars(n3, 4, cArray);
            } else {
                cArray = "0000-00-00T00:00:00".toCharArray();
                IOUtils.getChars(n8, 19, cArray);
                IOUtils.getChars(n7, 16, cArray);
                IOUtils.getChars(n6, 13, cArray);
                IOUtils.getChars(n5, 10, cArray);
                IOUtils.getChars(n4, 7, cArray);
                IOUtils.getChars(n3, 4, cArray);
            }
            if (n > 0) {
                int n10;
                for (n10 = 0; n10 < 9 && cArray[cArray.length - n10 - 1] == '0'; ++n10) {
                }
                serializeWriter.write(cArray, 0, cArray.length - n10);
                serializeWriter.write(n2);
                return;
            }
            serializeWriter.write(cArray);
            float f = (float)((Calendar)object).getTimeZone().getOffset(((Calendar)object).getTimeInMillis()) / 3600000.0f;
            int n11 = (int)f;
            if ((double)n11 == 0.0) {
                serializeWriter.write(90);
            } else {
                if (n11 > 9) {
                    Object object4 = serializeWriter;
                    ((SerializeWriter)object4).write(43);
                    ((SerializeWriter)object4).writeInt(n11);
                } else if (n11 > 0) {
                    Object object5 = serializeWriter;
                    ((SerializeWriter)object5).write(43);
                    ((SerializeWriter)object5).write(48);
                    ((SerializeWriter)object5).writeInt(n11);
                } else if (n11 < -9) {
                    serializeWriter.write(45);
                    serializeWriter.writeInt(-n11);
                } else if (n11 < 0) {
                    SerializeWriter serializeWriter4 = serializeWriter;
                    serializeWriter4.write(45);
                    serializeWriter4.write(48);
                    serializeWriter.writeInt(-n11);
                }
                serializeWriter.write(58);
                int n12 = (int)(Math.abs(f - (float)n11) * 60.0f);
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n12;
                serializeWriter.append(String.format("%02d", objectArray2));
            }
            serializeWriter.write(n2);
        } else {
            serializeWriter.writeLong(l3);
        }
    }

    @Override
    public <T> T cast(DefaultJSONParser defaultJSONParser, Type type, Object object, Object object2) {
        block25: {
            block26: {
                Object object3;
                block21: {
                    java.util.Date date;
                    block22: {
                        JSONScanner jSONScanner;
                        if (object2 == null) {
                            return null;
                        }
                        if (object2 instanceof java.util.Date) {
                            return (T)object2;
                        }
                        if (object2 instanceof BigDecimal) {
                            return (T)new java.util.Date(TypeUtils.longValue((BigDecimal)object2));
                        }
                        if (object2 instanceof Number) {
                            return (T)new java.util.Date(((Number)object2).longValue());
                        }
                        if (!(object2 instanceof String)) break block25;
                        object3 = (String)object2;
                        if (((String)object3).length() == 0) {
                            return null;
                        }
                        if (((String)object3).length() == 23 && ((String)object3).endsWith(" 000")) {
                            object3 = ((String)object3).substring(0, 19);
                        }
                        object = jSONScanner;
                        if (!new JSONScanner((String)object3).scanISO8601DateIfMatch(false)) break block21;
                        Type type2 = type;
                        object3 = ((JSONLexerBase)object).getCalendar();
                        if (type2 != Calendar.class) break block22;
                        ((JSONLexerBase)object).close();
                        return (T)object3;
                    }
                    try {
                        date = ((Calendar)object3).getTime();
                        ((JSONLexerBase)object).close();
                    }
                    catch (Throwable throwable) {
                        ((JSONLexerBase)object).close();
                        throw throwable;
                    }
                    return (T)date;
                }
                ((JSONLexerBase)object).close();
                object = defaultJSONParser.getDateFomartPattern();
                boolean bl = ((String)object3).length() == ((String)object).length() || ((String)object3).length() == 22 && ((String)object).equals("yyyyMMddHHmmssSSSZ") || ((String)object3).indexOf(84) != -1 && ((String)object).contains("'T'") && ((String)object3).length() + 2 == ((String)object).length();
                if (bl) {
                    try {
                        return (T)defaultJSONParser.getDateFormat().parse((String)object3);
                    }
                    catch (ParseException parseException) {}
                }
                if (((String)object3).startsWith("/Date(") && ((String)object3).endsWith(")/")) {
                    Object object4 = object3;
                    object3 = ((String)object4).substring(6, ((String)object4).length() - 2);
                }
                if ("0000-00-00".equals(object3) || "0000-00-00T00:00:00".equalsIgnoreCase((String)object3) || "0001-01-01T00:00:00+08:00".equalsIgnoreCase((String)object3)) break block26;
                int n = ((String)object3).lastIndexOf(124);
                if (n > 20 && !"GMT".equals(((TimeZone)(object = TimeZone.getTimeZone(((String)object3).substring(n + 1)))).getID())) {
                    block23: {
                        block24: {
                            JSONScanner jSONScanner;
                            String string = ((String)object3).substring(0, n);
                            object2 = jSONScanner;
                            try {
                                if (!new JSONScanner(string).scanISO8601DateIfMatch(false)) break block23;
                            }
                            catch (Throwable throwable) {
                                ((JSONLexerBase)object2).close();
                                throw throwable;
                            }
                            Type type3 = type;
                            object3 = ((JSONLexerBase)object2).getCalendar();
                            ((Calendar)object3).setTimeZone((TimeZone)object);
                            if (type3 != Calendar.class) break block24;
                            ((JSONLexerBase)object2).close();
                            return (T)object3;
                        }
                        java.util.Date date = ((Calendar)object3).getTime();
                        ((JSONLexerBase)object2).close();
                        return (T)date;
                    }
                    ((JSONLexerBase)object2).close();
                }
                long l = Long.parseLong((String)object3);
                return (T)new java.util.Date(l);
            }
            return null;
        }
        throw new JSONException("parse error");
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

