/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.IOUtils;
import com.tradplus.ads.common.serialization.util.RyuDouble;
import com.tradplus.ads.common.serialization.util.RyuFloat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.List;

public final class SerializeWriter
extends Writer {
    private static final ThreadLocal<char[]> bufLocal;
    private static final ThreadLocal<byte[]> bytesBufLocal;
    private static final char[] VALUE_TRUE;
    private static final char[] VALUE_FALSE;
    private static int BUFFER_THRESHOLD;
    static final int nonDirectFeatures;
    protected char[] buf;
    protected int count;
    protected int features;
    private final Writer writer;
    protected boolean useSingleQuotes;
    protected boolean quoteFieldNames;
    protected boolean sortField;
    protected boolean disableCircularReferenceDetect;
    protected boolean beanToArray;
    protected boolean writeNonStringValueAsString;
    protected boolean notWriteDefaultValue;
    protected boolean writeEnumUsingName;
    protected boolean writeEnumUsingToString;
    protected boolean writeDirect;
    protected char keySeperator;
    protected int maxBufSize;
    protected boolean browserSecure;
    protected long sepcialBits;

    public SerializeWriter() {
        this((Writer)null);
    }

    public SerializeWriter(Writer writer) {
        SerializerFeature[] serializerFeatureArray = serializerFeatureArray2;
        SerializerFeature[] serializerFeatureArray2 = SerializerFeature.EMPTY;
        super(writer, JSON.DEFAULT_GENERATE_FEATURE, serializerFeatureArray2);
    }

    public SerializeWriter(SerializerFeature ... serializerFeatureArray) {
        this((Writer)null, serializerFeatureArray);
    }

    public SerializeWriter(Writer writer, SerializerFeature ... serializerFeatureArray) {
        this(writer, 0, serializerFeatureArray);
    }

    public SerializeWriter(Writer object, int n, SerializerFeature ... serializerFeatureArray) {
        this.maxBufSize = -1;
        this.writer = object;
        object = bufLocal;
        this.buf = ((ThreadLocal)object).get();
        if (this.buf != null) {
            ((ThreadLocal)object).set(null);
        } else {
            this.buf = new char[2048];
        }
        int n2 = serializerFeatureArray.length;
        for (int i = 0; i < n2; ++i) {
            n |= serializerFeatureArray[i].getMask();
        }
        this.features = n;
        this.computeFeatures();
    }

    public SerializeWriter(int n) {
        this(null, n);
    }

    public SerializeWriter(Writer writer, int n) {
        this.maxBufSize = -1;
        this.writer = writer;
        if (n > 0) {
            this.buf = new char[n];
            this.computeFeatures();
            return;
        }
        throw new IllegalArgumentException("Negative initial size: " + n);
    }

    private int encodeToUTF8(OutputStream outputStream) {
        int n = (int)((double)this.count * 3.0);
        ThreadLocal<byte[]> threadLocal = bytesBufLocal;
        byte[] byArray = threadLocal.get();
        if (byArray == null) {
            byArray = new byte[8192];
            threadLocal.set(byArray);
        }
        byte[] byArray2 = byArray.length < n ? new byte[n] : byArray;
        int n2 = IOUtils.edu(this.buf, 0, this.count, byArray2);
        outputStream.write(byArray2, 0, n2);
        if (byArray2 != byArray && byArray2.length <= BUFFER_THRESHOLD) {
            threadLocal.set(byArray2);
        }
        return n2;
    }

    private byte[] encodeToUTF8Bytes() {
        int n = (int)((double)this.count * 3.0);
        ThreadLocal<byte[]> threadLocal = bytesBufLocal;
        byte[] byArray = threadLocal.get();
        if (byArray == null) {
            byArray = new byte[8192];
            threadLocal.set(byArray);
        }
        byte[] byArray2 = byArray.length < n ? new byte[n] : byArray;
        byte[] byArray3 = byArray;
        int n2 = IOUtils.edu(this.buf, 0, this.count, byArray2);
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        if (byArray2 != byArray3 && byArray2.length <= BUFFER_THRESHOLD) {
            threadLocal.set(byArray2);
        }
        return byArray;
    }

    private void writeEnumFieldValue(char c, String string, String string2) {
        if (this.useSingleQuotes) {
            this.writeFieldValue(c, string, string2);
        } else {
            this.writeFieldValueStringWithDoubleQuote(c, string, string2);
        }
    }

    private void writeKeyWithSingleQuoteIfHasSpecial(String string) {
        byte[] byArray = IOUtils.specicalFlags_singleQuotes;
        int n = string.length();
        int n2 = this.count + n + 1;
        if (n2 > this.buf.length) {
            if (this.writer != null) {
                char c;
                int n3;
                if (n == 0) {
                    SerializeWriter serializeWriter = this;
                    serializeWriter.write(39);
                    serializeWriter.write(39);
                    serializeWriter.write(58);
                    return;
                }
                n2 = 0;
                for (n3 = 0; n3 < n; ++n3) {
                    c = string.charAt(n3);
                    if (c >= byArray.length || byArray[c] == 0) continue;
                    n2 = 1;
                    break;
                }
                if (n2 != 0) {
                    this.write(39);
                }
                for (n3 = 0; n3 < n; ++n3) {
                    c = string.charAt(n3);
                    if (c < byArray.length && byArray[c] != 0) {
                        SerializeWriter serializeWriter = this;
                        serializeWriter.write(92);
                        serializeWriter.write(IOUtils.replaceChars[c]);
                        continue;
                    }
                    this.write(c);
                }
                if (n2 != 0) {
                    this.write(39);
                }
                this.write(58);
                return;
            }
            this.expandCapacity(n2);
        }
        if (n == 0) {
            int n4 = this.count;
            if (n4 + 3 > this.buf.length) {
                this.expandCapacity(n4 + 3);
            }
            char[] cArray = this.buf;
            int n5 = this.count;
            this.count = n = n5 + 1;
            cArray[n5] = 39;
            this.count = n5 = n + 1;
            cArray[n] = 39;
            this.count = n5 + 1;
            this.buf[n5] = 58;
            return;
        }
        SerializeWriter serializeWriter = this;
        int n6 = serializeWriter.count;
        int n7 = n6 + n;
        char[] cArray = serializeWriter.buf;
        string.getChars(0, n, cArray, n6);
        this.count = n2;
        n = 0;
        for (int i = n6; i < n7; ++i) {
            int n8;
            char[] cArray2 = this.buf;
            char c = this.buf[i];
            if (c >= byArray.length || byArray[c] == 0) continue;
            if (n == 0) {
                n = n2 + 3;
                if (n > cArray2.length) {
                    this.expandCapacity(n);
                }
                SerializeWriter serializeWriter2 = this;
                serializeWriter2.count = n;
                int n9 = i;
                n2 = n9 + 1;
                int n10 = i + 3;
                n8 = n7 - n9 - 1;
                System.arraycopy(serializeWriter2.buf, n2, serializeWriter2.buf, n10, n8);
                System.arraycopy(serializeWriter2.buf, 0, serializeWriter2.buf, 1, i);
                char[] cArray3 = serializeWriter2.buf;
                cArray3[n6] = 39;
                cArray3[n2] = 92;
                i = n2 + 1;
                cArray3[i] = IOUtils.replaceChars[c];
                n2 = n7 + 2;
                serializeWriter2.buf[this.count - 2] = 39;
                n7 = 1;
                int n11 = n;
                n = n7;
                n7 = n2;
                n2 = n11;
                continue;
            }
            if (++n2 > cArray2.length) {
                this.expandCapacity(n2);
            }
            SerializeWriter serializeWriter3 = this;
            serializeWriter3.count = n2;
            int n12 = i;
            int n13 = n12 + 1;
            n8 = i + 2;
            int n14 = n7 - n12;
            System.arraycopy(serializeWriter3.buf, n13, serializeWriter3.buf, n8, n14);
            serializeWriter3.buf[i] = 92;
            serializeWriter3.buf[n13] = IOUtils.replaceChars[c];
            ++n7;
            i = n13;
        }
        this.buf[n2 - 1] = 58;
    }

    static {
        block5: {
            bufLocal = new ThreadLocal();
            bytesBufLocal = new ThreadLocal();
            VALUE_TRUE = ":true".toCharArray();
            VALUE_FALSE = ":false".toCharArray();
            BUFFER_THRESHOLD = 131072;
            String string = IOUtils.getStringProperty("fastjson.serializer_buffer_threshold");
            if (string == null) break block5;
            if (string.length() <= 0) break block5;
            int n = Integer.parseInt(string);
            if (n < 64 || n > 65536) break block5;
            try {
                BUFFER_THRESHOLD = n * 1024;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        nonDirectFeatures = SerializerFeature.UseSingleQuotes.mask | 0 | SerializerFeature.BrowserCompatible.mask | SerializerFeature.PrettyFormat.mask | SerializerFeature.WriteEnumUsingToString.mask | SerializerFeature.WriteNonStringValueAsString.mask | SerializerFeature.WriteSlashAsSpecial.mask | SerializerFeature.IgnoreErrorGetter.mask | SerializerFeature.WriteClassName.mask | SerializerFeature.NotWriteDefaultValue.mask;
    }

    public int getMaxBufSize() {
        return this.maxBufSize;
    }

    public void setMaxBufSize(int n) {
        if (n >= this.buf.length) {
            this.maxBufSize = n;
            return;
        }
        throw new JSONException("must > " + this.buf.length);
    }

    public int getBufferLength() {
        return this.buf.length;
    }

    public void jsonCfg(SerializerFeature serializerFeature, boolean bl) {
        if (bl) {
            int n;
            this.features = n = this.features | serializerFeature.getMask();
            SerializerFeature serializerFeature2 = SerializerFeature.WriteEnumUsingToString;
            if (serializerFeature == serializerFeature2) {
                this.features = n & ~SerializerFeature.WriteEnumUsingName.getMask();
            } else if (serializerFeature == SerializerFeature.WriteEnumUsingName) {
                this.features = n & ~serializerFeature2.getMask();
            }
        } else {
            this.features &= ~serializerFeature.getMask();
        }
        this.computeFeatures();
    }

    protected void computeFeatures() {
        int n = this.features;
        int n2 = (n & SerializerFeature.QuoteFieldNames.mask) != 0 ? 1 : 0;
        this.quoteFieldNames = n2;
        boolean bl = (n & SerializerFeature.UseSingleQuotes.mask) != 0;
        this.useSingleQuotes = bl;
        boolean bl2 = (n & SerializerFeature.SortField.mask) != 0;
        this.sortField = bl2;
        bl2 = (n & SerializerFeature.DisableCircularReferenceDetect.mask) != 0;
        this.disableCircularReferenceDetect = bl2;
        bl2 = (n & SerializerFeature.BeanToArray.mask) != 0;
        this.beanToArray = bl2;
        boolean bl3 = (n & SerializerFeature.WriteNonStringValueAsString.mask) != 0;
        this.writeNonStringValueAsString = bl3;
        bl3 = (n & SerializerFeature.NotWriteDefaultValue.mask) != 0;
        this.notWriteDefaultValue = bl3;
        bl3 = (n & SerializerFeature.WriteEnumUsingName.mask) != 0;
        this.writeEnumUsingName = bl3;
        boolean bl4 = (n & SerializerFeature.WriteEnumUsingToString.mask) != 0;
        this.writeEnumUsingToString = bl4;
        n2 = n2 != 0 && (n & nonDirectFeatures) == 0 && (bl2 || bl3) ? 1 : 0;
        this.writeDirect = n2;
        n2 = bl ? 39 : 34;
        this.keySeperator = (char)n2;
        n2 = (n & SerializerFeature.BrowserSecure.mask) != 0 ? 1 : 0;
        this.browserSecure = n2;
        long l = n2 != 0 ? 5764610843043954687L : ((n & SerializerFeature.WriteSlashAsSpecial.mask) != 0 ? 140758963191807L : 0x4FFFFFFFFL);
        this.sepcialBits = l;
    }

    public boolean isSortField() {
        return this.sortField;
    }

    public boolean isNotWriteDefaultValue() {
        return this.notWriteDefaultValue;
    }

    public boolean isEnabled(SerializerFeature serializerFeature) {
        return (this.features & serializerFeature.mask) != 0;
    }

    public boolean isEnabled(int n) {
        return (this.features & n) != 0;
    }

    @Override
    public void write(int n) {
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n2);
            } else {
                this.flush();
                n2 = 1;
            }
        }
        int n3 = this.count;
        this.buf[n3] = (char)n;
        this.count = n2;
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        int n3;
        if (n >= 0 && n <= cArray.length && n2 >= 0 && (n3 = n + n2) <= cArray.length && n3 >= 0) {
            if (n2 == 0) {
                return;
            }
            n3 = ((SerializeWriter)object).count + n2;
            if (n3 > ((SerializeWriter)object).buf.length) {
                if (((SerializeWriter)object).writer == null) {
                    ((SerializeWriter)object).expandCapacity(n3);
                } else {
                    while (true) {
                        SerializeWriter serializeWriter = object;
                        char[] cArray2 = ((SerializeWriter)object).buf;
                        n3 = ((SerializeWriter)object).count;
                        int n4 = ((SerializeWriter)object).buf.length - n3;
                        System.arraycopy(cArray, n, cArray2, n3, n4);
                        serializeWriter.count = serializeWriter.buf.length;
                        serializeWriter.flush();
                        n3 = n2 - n4;
                        n += n4;
                        if (n3 <= ((SerializeWriter)object).buf.length) {
                            n2 = n3;
                            break;
                        }
                        n2 = n3;
                    }
                }
            }
            SerializeWriter serializeWriter = object;
            SerializeWriter serializeWriter2 = object;
            Object object = serializeWriter2.buf;
            int n5 = serializeWriter2.count;
            System.arraycopy(cArray, n, object, n5, n2);
            serializeWriter.count = n3;
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    public void expandCapacity(int n) {
        ThreadLocal<char[]> threadLocal;
        char[] cArray;
        int n2 = this.maxBufSize;
        if (n2 != -1 && n >= n2) {
            throw new JSONException("serialize exceeded MAX_OUTPUT_LENGTH=" + this.maxBufSize + ", minimumCapacity=" + n);
        }
        char[] cArray2 = this.buf;
        int n3 = this.buf.length + (cArray2.length >> 1) + 1;
        if (n3 >= n) {
            n = n3;
        }
        char[] cArray3 = new char[n];
        int n4 = this.count;
        System.arraycopy(cArray2, 0, cArray3, 0, n4);
        if (this.buf.length < BUFFER_THRESHOLD && ((cArray = (threadLocal = bufLocal).get()) == null || cArray.length < this.buf.length)) {
            threadLocal.set(this.buf);
        }
        this.buf = cArray3;
    }

    @Override
    public SerializeWriter append(CharSequence charSequence) {
        charSequence = charSequence == null ? "null" : charSequence.toString();
        SerializeWriter serializeWriter = this;
        int n = ((String)charSequence).length();
        serializeWriter.write((String)charSequence, 0, n);
        return serializeWriter;
    }

    @Override
    public SerializeWriter append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        SerializeWriter serializeWriter = this;
        String string = charSequence.subSequence(n, n2).toString();
        serializeWriter.write(string, 0, string.length());
        return serializeWriter;
    }

    @Override
    public SerializeWriter append(char c) {
        SerializeWriter serializeWriter = this;
        serializeWriter.write(c);
        return serializeWriter;
    }

    @Override
    public void write(String object, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n3);
            } else {
                while (true) {
                    int n4 = n2;
                    SerializeWriter serializeWriter = this;
                    int n5 = n;
                    char[] cArray = this.buf;
                    n2 = this.count;
                    n3 = this.buf.length - n2;
                    int n6 = n5 + n3;
                    ((String)object).getChars(n5, n6, cArray, n2);
                    serializeWriter.count = serializeWriter.buf.length;
                    serializeWriter.flush();
                    n3 = n4 - n3;
                    if (n3 <= this.buf.length) {
                        n2 = n3;
                        n = n6;
                        break;
                    }
                    n2 = n3;
                    n = n6;
                }
            }
        }
        String string = object;
        SerializeWriter serializeWriter = this;
        int n7 = n + n2;
        object = serializeWriter.buf;
        n2 = serializeWriter.count;
        string.getChars(n, n7, (char[])object, n2);
        this.count = n3;
    }

    public void writeTo(Writer writer) {
        if (((SerializeWriter)object).writer == null) {
            SerializeWriter serializeWriter = object;
            Object object = serializeWriter.buf;
            int n = serializeWriter.count;
            writer.write((char[])object, 0, n);
            return;
        }
        throw new UnsupportedOperationException("writer not null");
    }

    public void writeTo(OutputStream outputStream, String string) {
        this.writeTo(outputStream, Charset.forName(string));
    }

    public void writeTo(OutputStream outputStream, Charset charset) {
        this.writeToEx(outputStream, charset);
    }

    public int writeToEx(OutputStream outputStream, Charset charset) {
        if (((SerializeWriter)object).writer == null) {
            if (charset == IOUtils.UTF8) {
                return ((SerializeWriter)object).encodeToUTF8(outputStream);
            }
            SerializeWriter serializeWriter = object;
            Object object = serializeWriter.buf;
            int n = serializeWriter.count;
            byte[] byArray = new String((char[])object, 0, n).getBytes(charset);
            object = byArray;
            outputStream.write(byArray);
            return ((Object)object).length;
        }
        throw new UnsupportedOperationException("writer not null");
    }

    public char[] toCharArray() {
        if (this.writer == null) {
            int n = this.count;
            char[] cArray = new char[n];
            System.arraycopy(this.buf, 0, cArray, 0, n);
            return cArray;
        }
        throw new UnsupportedOperationException("writer not null");
    }

    public char[] toCharArrayForSpringWebSocket() {
        if (this.writer == null) {
            int n = this.count;
            char[] cArray = new char[n - 2];
            int n2 = n - 2;
            System.arraycopy(this.buf, 1, cArray, 0, n2);
            return cArray;
        }
        throw new UnsupportedOperationException("writer not null");
    }

    public byte[] toBytes(String object) {
        object = object != null && !"UTF-8".equals(object) ? Charset.forName((String)object) : IOUtils.UTF8;
        return this.toBytes((Charset)object);
    }

    public byte[] toBytes(Charset charset) {
        if (((SerializeWriter)object).writer == null) {
            if (charset == IOUtils.UTF8) {
                return ((SerializeWriter)object).encodeToUTF8Bytes();
            }
            SerializeWriter serializeWriter = object;
            Object object = serializeWriter.buf;
            int n = serializeWriter.count;
            return new String((char[])object, 0, n).getBytes(charset);
        }
        throw new UnsupportedOperationException("writer not null");
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        SerializeWriter serializeWriter = object;
        Object object = serializeWriter.buf;
        int n = serializeWriter.count;
        return new String((char[])object, 0, n);
    }

    @Override
    public void close() {
        if (this.writer != null && this.count > 0) {
            this.flush();
        }
        char[] cArray = this.buf;
        if (this.buf.length <= BUFFER_THRESHOLD) {
            bufLocal.set(cArray);
        }
        this.buf = null;
    }

    @Override
    public void write(String string) {
        if (string == null) {
            this.writeNull();
            return;
        }
        int n = string.length();
        this.write(string, 0, n);
    }

    public void writeInt(int n) {
        if (n == Integer.MIN_VALUE) {
            ((SerializeWriter)object).write("-2147483648");
            return;
        }
        int n2 = n < 0 ? IOUtils.stringSize(-n) + 1 : IOUtils.stringSize(n);
        int n3 = ((SerializeWriter)object).count + n2;
        if (n3 > ((SerializeWriter)object).buf.length) {
            if (((SerializeWriter)object).writer == null) {
                ((SerializeWriter)object).expandCapacity(n3);
            } else {
                SerializeWriter serializeWriter = object;
                Object object = new char[n2];
                IOUtils.getChars(n, n2, (char[])object);
                serializeWriter.write((char[])object, 0, n2);
                return;
            }
        }
        IOUtils.getChars(n, n3, ((SerializeWriter)object).buf);
        ((SerializeWriter)object).count = n3;
    }

    public void writeByteArray(byte[] object) {
        if (this.isEnabled(SerializerFeature.WriteClassName.mask)) {
            this.writeHex((byte[])object);
            return;
        }
        int n = ((byte[])object).length;
        boolean bl = this.useSingleQuotes;
        int n2 = bl ? 39 : 34;
        if (n == 0) {
            object = bl ? (Object)"''" : (Object)"\"\"";
            this.write((String)object);
            return;
        }
        int n3 = n;
        char[] cArray = IOUtils.CA;
        int n4 = n3 / 3 * 3;
        int n5 = n3 - 1;
        int n6 = n5 / 3 + 1 << 2;
        int n7 = this.count;
        if ((n6 = n7 + n6 + 2) > this.buf.length) {
            if (this.writer != null) {
                this.write(n2);
                n6 = 0;
                while (n6 < n4) {
                    n7 = (object[n6++] & 0xFF) << 16 | (object[n6++] & 0xFF) << 8 | object[n6++] & 0xFF;
                    this.write(cArray[n7 >>> 18 & 0x3F]);
                    this.write(cArray[n7 >>> 12 & 0x3F]);
                    this.write(cArray[n7 >>> 6 & 0x3F]);
                    this.write(cArray[n7 & 0x3F]);
                }
                if ((n -= n4) > 0) {
                    n4 = (object[n4] & 0xFF) << 10;
                    int n8 = n == 2 ? (object[n5] & 0xFF) << 2 : 0;
                    n8 = n4 | n8;
                    this.write(cArray[n8 >> 12]);
                    this.write(cArray[n8 >>> 6 & 0x3F]);
                    n8 = n == 2 ? cArray[n8 & 0x3F] : 61;
                    SerializeWriter serializeWriter = this;
                    serializeWriter.write(n8);
                    serializeWriter.write(61);
                }
                this.write(n2);
                return;
            }
            this.expandCapacity(n6);
        }
        this.count = n6;
        this.buf[n7++] = n2;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = (object[n9++] & 0xFF) << 16 | (object[n9++] & 0xFF) << 8 | object[n9++] & 0xFF;
            char[] cArray2 = this.buf;
            int n11 = n10;
            int n12 = n10;
            int n13 = n10;
            cArray2[n7++] = cArray[n10 >>> 18 & 0x3F];
            n10 = n7 + 1;
            cArray2[n7] = cArray[n13 >>> 12 & 0x3F];
            n7 = n10 + 1;
            cArray2[n10] = cArray[n12 >>> 6 & 0x3F];
            n10 = n7 + 1;
            this.buf[n7] = cArray[n11 & 0x3F];
            n7 = n10;
        }
        if ((n -= n4) > 0) {
            n4 = (object[n4] & 0xFF) << 10;
            int n14 = n == 2 ? (object[n5] & 0xFF) << 2 : 0;
            n14 = n4 | n14;
            char[] cArray3 = this.buf;
            n4 = n6 - 5;
            cArray3[n4] = cArray[n14 >> 12];
            n4 = n6 - 4;
            this.buf[n4] = cArray[n14 >>> 6 & 0x3F];
            n4 = n6 - 3;
            n14 = n == 2 ? cArray[n14 & 0x3F] : 61;
            cArray3[n4] = n14;
            cArray3[n6 - 2] = 61;
        }
        this.buf[n6 - 1] = n2;
    }

    public void writeHex(byte[] byArray) {
        int n;
        int n2 = this.count + byArray.length * 2 + 3;
        if (n2 > this.buf.length) {
            this.expandCapacity(n2);
        }
        char[] cArray = this.buf;
        int n3 = this.count;
        this.count = n = n3 + 1;
        cArray[n3] = 120;
        this.count = n + 1;
        this.buf[n] = 39;
        for (int i = 0; i < byArray.length; ++i) {
            int n4;
            n3 = byArray[i] & 0xFF;
            n = n3 >> 4;
            SerializeWriter serializeWriter = this;
            n3 &= 0xF;
            char[] cArray2 = serializeWriter.buf;
            int n5 = serializeWriter.count;
            serializeWriter.count = n4 = n5 + 1;
            int n6 = n < 10 ? 48 : 55;
            cArray2[n5] = (char)(n + n6);
            this.count = n4 + 1;
            n = n3 < 10 ? 48 : 55;
            cArray2[n4] = (char)(n3 + n);
        }
        int n7 = this.count;
        this.count = n7 + 1;
        this.buf[n7] = 39;
    }

    public void writeFloat(float f, boolean bl) {
        float f2 = f;
        if (f2 == f2 && f != Float.POSITIVE_INFINITY && f != Float.NEGATIVE_INFINITY) {
            int n = this.count + 15;
            if (n > this.buf.length) {
                if (this.writer == null) {
                    this.expandCapacity(n);
                } else {
                    String string = RyuFloat.toString(f);
                    int n2 = string.length();
                    this.write(string, 0, n2);
                    if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                        this.write(70);
                    }
                    return;
                }
            }
            SerializeWriter serializeWriter = this;
            char[] cArray = serializeWriter.buf;
            int n2 = RyuFloat.toString(f, cArray, serializeWriter.count);
            this.count += n2;
            if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                this.write(70);
            }
        } else {
            this.writeNull();
        }
    }

    public void writeDouble(double d, boolean bl) {
        if (!Double.isNaN(d) && !Double.isInfinite(d)) {
            int n = this.count + 24;
            if (n > this.buf.length) {
                if (this.writer == null) {
                    this.expandCapacity(n);
                } else {
                    String string = RyuDouble.toString(d);
                    int n2 = string.length();
                    this.write(string, 0, n2);
                    if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                        this.write(68);
                    }
                    return;
                }
            }
            SerializeWriter serializeWriter = this;
            char[] cArray = serializeWriter.buf;
            int n3 = RyuDouble.toString(d, cArray, serializeWriter.count);
            this.count += n3;
            if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                this.write(68);
            }
            return;
        }
        this.writeNull();
    }

    public void writeEnum(Enum<?> enum_) {
        if (enum_ == null) {
            this.writeNull();
            return;
        }
        String string = null;
        if (this.writeEnumUsingName && !this.writeEnumUsingToString) {
            string = enum_.name();
        } else if (this.writeEnumUsingToString) {
            string = enum_.toString();
        }
        if (string != null) {
            int n = this.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
            SerializeWriter serializeWriter = this;
            serializeWriter.write(n);
            serializeWriter.write(string);
            serializeWriter.write(n);
        } else {
            this.writeInt(enum_.ordinal());
        }
    }

    public void writeLongAndChar(long l, char c) {
        SerializeWriter serializeWriter = this;
        serializeWriter.writeLong(l);
        serializeWriter.write(c);
    }

    public void writeLong(long l) {
        boolean bl = this.isEnabled(SerializerFeature.BrowserCompatible) && !this.isEnabled(SerializerFeature.WriteClassName) && (l > 0x1FFFFFFFFFFFFFL || l < -9007199254740991L);
        if (l == Long.MIN_VALUE) {
            if (bl) {
                this.write("\"-9223372036854775808\"");
            } else {
                this.write("-9223372036854775808");
            }
            return;
        }
        int n = l < 0L ? IOUtils.stringSize(-l) + 1 : IOUtils.stringSize(l);
        int n2 = this.count + n;
        if (bl) {
            n2 += 2;
        }
        if (n2 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n2);
            } else {
                char[] cArray = new char[n];
                IOUtils.getChars(l, n, cArray);
                if (bl) {
                    SerializeWriter serializeWriter = this;
                    serializeWriter.write(34);
                    serializeWriter.write(cArray, 0, n);
                    serializeWriter.write(34);
                } else {
                    this.write(cArray, 0, n);
                }
                return;
            }
        }
        if (bl) {
            char[] cArray = this.buf;
            this.buf[this.count] = 34;
            int n3 = n2 - 1;
            IOUtils.getChars(l, n3, cArray);
            this.buf[n3] = 34;
        } else {
            IOUtils.getChars(l, n2, this.buf);
        }
        this.count = n2;
    }

    public void writeNull() {
        this.write("null");
    }

    public void writeNull(SerializerFeature serializerFeature) {
        this.writeNull(0, serializerFeature.mask);
    }

    public void writeNull(int n, int n2) {
        if ((n & n2) == 0 && (this.features & n2) == 0) {
            this.writeNull();
            return;
        }
        int n3 = SerializerFeature.WriteMapNullValue.mask;
        if ((n & n3) != 0 && (n & ~n3 & SerializerFeature.WRITE_MAP_NULL_FEATURES) == 0) {
            this.writeNull();
            return;
        }
        if (n2 == SerializerFeature.WriteNullListAsEmpty.mask) {
            this.write("[]");
        } else if (n2 == SerializerFeature.WriteNullStringAsEmpty.mask) {
            this.writeString("");
        } else if (n2 == SerializerFeature.WriteNullBooleanAsFalse.mask) {
            this.write("false");
        } else if (n2 == SerializerFeature.WriteNullNumberAsZero.mask) {
            this.write(48);
        } else {
            this.writeNull();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void writeStringWithDoubleQuote(String var1_1, char var2_9) {
        block56: {
            block57: {
                if (var1_1 == null) {
                    this.writeNull();
                    if (var2_9 != '\u0000') {
                        this.write(var2_9);
                    }
                    return;
                }
                var3_10 = var1_1.length();
                var4_21 = this.count + var3_10 + 2;
                if (var2_9 != '\u0000') {
                    ++var4_21;
                }
                if (var4_21 <= this.buf.length) break block56;
                if (this.writer == null) break block57;
                this.write(34);
                for (var3_10 = 0; var3_10 < var1_1.length(); ++var3_10) {
                    var4_21 = var1_1.charAt(var3_10);
                    if (this.isEnabled(SerializerFeature.BrowserSecure) && (var4_21 == 40 || var4_21 == 41 || var4_21 == 60 || var4_21 == 62)) {
                        v0 = this;
                        v0.write(92);
                        v0.write(117);
                        var5_23 /* !! */  = (byte[])IOUtils.DIGITS;
                        this.write(var5_23 /* !! */ [var4_21 >>> 12 & 15]);
                        this.write(var5_23 /* !! */ [var4_21 >>> 8 & 15]);
                        this.write(var5_23 /* !! */ [var4_21 >>> 4 & 15]);
                        v0.write(IOUtils.DIGITS[var4_21 & 15]);
                        continue;
                    }
                    if (!this.isEnabled(SerializerFeature.BrowserCompatible)) ** GOTO lbl52
                    if (var4_21 != 8 && var4_21 != 12 && var4_21 != 10 && var4_21 != 13 && var4_21 != 9 && var4_21 != 34 && var4_21 != 47 && var4_21 != 92) {
                        if (var4_21 < 32) {
                            v1 = this;
                            v1.write(92);
                            v1.write(117);
                            v1.write(48);
                            v1.write(48);
                            var5_23 /* !! */  = (byte[])IOUtils.ASCII_CHARS;
                            this.write(var5_23 /* !! */ [var4_21 *= 2]);
                            v1.write(IOUtils.ASCII_CHARS[var4_21 + 1]);
                            continue;
                        }
                        if (var4_21 >= 127) {
                            v2 = this;
                            v2.write(92);
                            v2.write(117);
                            var5_23 /* !! */  = (byte[])IOUtils.DIGITS;
                            this.write(var5_23 /* !! */ [var4_21 >>> 12 & 15]);
                            this.write(var5_23 /* !! */ [var4_21 >>> 8 & 15]);
                            this.write(var5_23 /* !! */ [var4_21 >>> 4 & 15]);
                            v2.write(IOUtils.DIGITS[var4_21 & 15]);
                            continue;
                        }
                    } else {
                        v3 = this;
                        v3.write(92);
                        v3.write(IOUtils.replaceChars[var4_21]);
                        continue;
lbl52:
                        // 1 sources

                        var5_23 /* !! */  = IOUtils.specicalFlags_doubleQuotes;
                        if (var4_21 < IOUtils.specicalFlags_doubleQuotes.length && var5_23 /* !! */ [var4_21] != 0 || var4_21 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                            this.write(92);
                            if (var5_23 /* !! */ [var4_21] == 4) {
                                v4 = this;
                                v4.write(117);
                                var5_23 /* !! */  = (byte[])IOUtils.DIGITS;
                                this.write(var5_23 /* !! */ [var4_21 >>> 12 & 15]);
                                this.write(var5_23 /* !! */ [var4_21 >>> 8 & 15]);
                                this.write(var5_23 /* !! */ [var4_21 >>> 4 & 15]);
                                v4.write(IOUtils.DIGITS[var4_21 & 15]);
                                continue;
                            }
                            this.write(IOUtils.replaceChars[var4_21]);
                            continue;
                        }
                    }
                    this.write(var4_21);
                }
                this.write(34);
                if (var2_9 != '\u0000') {
                    this.write(var2_9);
                }
                return;
            }
            this.expandCapacity(var4_21);
        }
        v5 = this;
        var5_24 = v5.count;
        var6_30 = var5_24 + 1;
        var7_31 = var6_30 + var3_10;
        var8_32 = v5.buf;
        v5.buf[var5_24] = 34;
        var1_1.getChars(0, var3_10, var8_32, var6_30);
        this.count = var4_21;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            var1_2 = -1;
            block1: for (var3_10 = var6_30; var3_10 < var7_31; ++var3_10) {
                var5_24 = this.buf[var3_10];
                if (var5_24 != 34 && var5_24 != 47 && var5_24 != 92 && var5_24 != 8 && var5_24 != 12 && var5_24 != 10 && var5_24 != 13 && var5_24 != 9) {
                    if (var5_24 < 32) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            v6 = var1_2 = var4_21 + 5;
                            var1_2 = var3_10;
                            var4_21 = v6;
                            continue block1;
                            break;
                        }
                    }
                    if (var5_24 < 127) continue;
                    ** continue;
                }
                v7 = var1_2 = var4_21 + 1;
                var1_2 = var3_10;
                var4_21 = v7;
            }
            if (var4_21 > this.buf.length) {
                this.expandCapacity(var4_21);
            }
            this.count = var4_21;
            while (var1_2 >= var6_30) {
                var3_11 = this.buf;
                var4_21 = this.buf[var1_2];
                if (var4_21 != 8 && var4_21 != 12 && var4_21 != 10 && var4_21 != 13 && var4_21 != 9) {
                    if (var4_21 != 34 && var4_21 != 47 && var4_21 != 92) {
                        if (var4_21 < 32) {
                            v8 = var1_2;
                            var5_24 = v8 + 1;
                            var8_33 = var1_2 + 6;
                            var9_43 = var7_31 - v8 - 1;
                            System.arraycopy(var3_11, var5_24, var3_11, var8_33, var9_43);
                            v9 = this.buf;
                            var3_11 = v9;
                            var3_11[var1_2] = 92;
                            var3_11[var5_24] = 117;
                            var3_11[var1_2 + 2] = 48;
                            v9[var1_2 + 3] = 48;
                            var5_24 = var1_2 + 4;
                            var8_34 = IOUtils.ASCII_CHARS;
                            var3_11[var5_24] = var8_34[var4_21 *= 2];
                            var3_12 = var1_2 + 5;
                            this.buf[var3_12] = IOUtils.ASCII_CHARS[var4_21 + 1];
                            var7_31 = var3_12 = var7_31 + 5;
                        } else if (var4_21 >= 127) {
                            v10 = var1_2;
                            var5_24 = v10 + 1;
                            var8_35 = var1_2 + 6;
                            var9_43 = var7_31 - v10 - 1;
                            System.arraycopy(var3_11, var5_24, var3_11, var8_35, var9_43);
                            v11 = this.buf;
                            var3_11 = v11;
                            var3_11[var1_2] = 92;
                            v11[var5_24] = 117;
                            var5_24 = var1_2 + 2;
                            var8_36 = IOUtils.DIGITS;
                            var3_11[var5_24] = var8_36[var4_21 >>> 12 & 15];
                            var3_13 = var1_2 + 3;
                            var3_11[var3_13] = var8_36[var4_21 >>> 8 & 15];
                            var3_13 = var1_2 + 4;
                            var3_11[var3_13] = var8_36[var4_21 >>> 4 & 15];
                            var3_13 = var1_2 + 5;
                            this.buf[var3_13] = IOUtils.DIGITS[var4_21 & 15];
                            var7_31 = var3_13 = var7_31 + 5;
                        }
                    } else {
                        v12 = var1_2;
                        var5_24 = v12 + 1;
                        var8_37 = var1_2 + 2;
                        var9_43 = var7_31 - v12 - 1;
                        System.arraycopy(var3_11, var5_24, var3_11, var8_37, var9_43);
                        this.buf[var1_2] = 92;
                        this.buf[var5_24] = var4_21;
                        var7_31 = var3_14 = var7_31 + 1;
                    }
                } else {
                    v13 = var1_2;
                    var5_24 = v13 + 1;
                    var8_38 = var1_2 + 2;
                    var9_43 = var7_31 - v13 - 1;
                    System.arraycopy(var3_11, var5_24, var3_11, var8_38, var9_43);
                    this.buf[var1_2] = 92;
                    this.buf[var5_24] = IOUtils.replaceChars[var4_21];
                    var7_31 = var3_15 = var7_31 + 1;
                }
                --var1_2;
            }
            if (var2_9 != '\u0000') {
                var1_3 = this.buf;
                v14 = this.count;
                var1_3[v14 - 2] = 34;
                this.buf[v14 - 1] = var2_9;
            } else {
                this.buf[this.count - 1] = 34;
            }
            return;
        }
        var3_10 = 0;
        var5_24 = -1;
        var8_39 = -1;
        var9_44 = 0;
        for (var10_45 = var6_30; var10_45 < var7_31; ++var10_45) {
            block59: {
                block58: {
                    var11_46 = this.buf[var10_45];
                    if (var11_46 >= 93) {
                        if (var11_46 < 127 || var11_46 != 8232 && var11_46 != 8233 && var11_46 >= 160) continue;
                        if (var8_39 == -1) {
                            var8_39 = var10_45;
                        }
                        ++var3_10;
                        var4_21 += 4;
                        var5_24 = var10_45;
                        var9_44 = var11_46;
                        continue;
                    }
                    if (!(var11_46 < 64 && (this.sepcialBits & 1L << var11_46) != 0L || var11_46 == 92)) continue;
                    ++var3_10;
                    if (var11_46 == 40 || var11_46 == 41 || var11_46 == 60 || var11_46 == 62) break block58;
                    var5_25 = IOUtils.specicalFlags_doubleQuotes;
                    if (var11_46 >= IOUtils.specicalFlags_doubleQuotes.length || var5_25[var11_46] != 4) break block59;
                }
                var4_21 += 4;
            }
            if (var8_39 == -1) {
                var5_24 = var10_45;
                var8_39 = var10_45;
                var9_44 = var11_46;
                continue;
            }
            var5_24 = var10_45;
            var9_44 = var11_46;
        }
        if (var3_10 > 0) {
            if ((var4_21 += var3_10) > this.buf.length) {
                this.expandCapacity(var4_21);
            }
            this.count = var4_21;
            if (var3_10 == 1) {
                if (var9_44 == 8232) {
                    v15 = this;
                    v16 = var5_24;
                    var1_4 = v16 + 1;
                    var3_10 = var5_24 + 6;
                    var4_21 = var7_31 - v16 - 1;
                    System.arraycopy(v15.buf, var1_4, v15.buf, var3_10, var4_21);
                    v17 = v15.buf;
                    var3_16 = v17;
                    var3_16[var5_24] = 92;
                    v17[var1_4] = 117;
                    v17[++var1_4] = 50;
                    v17[++var1_4] = 48;
                    v18 = var1_4 + 1;
                    var3_16[v18] = 50;
                    v15.buf[v18 + 1] = 56;
                } else if (var9_44 == 8233) {
                    v19 = this;
                    v20 = var5_24;
                    var1_5 = v20 + 1;
                    var3_10 = var5_24 + 6;
                    var4_21 = var7_31 - v20 - 1;
                    System.arraycopy(v19.buf, var1_5, v19.buf, var3_10, var4_21);
                    v21 = v19.buf;
                    var3_17 = v21;
                    var3_17[var5_24] = 92;
                    v21[var1_5] = 117;
                    v21[++var1_5] = 50;
                    v21[++var1_5] = 48;
                    v22 = var1_5 + 1;
                    var3_17[v22] = 50;
                    v19.buf[v22 + 1] = 57;
                } else if (var9_44 != 40 && var9_44 != 41 && var9_44 != 60 && var9_44 != 62) {
                    var1_1 = IOUtils.specicalFlags_doubleQuotes;
                    if (var9_44 < IOUtils.specicalFlags_doubleQuotes.length && var1_1[var9_44] == 4) {
                        v23 = this;
                        v24 = var5_24;
                        var1_6 = v24 + 1;
                        var3_10 = var5_24 + 6;
                        var4_21 = var7_31 - v24 - 1;
                        System.arraycopy(v23.buf, var1_6, v23.buf, var3_10, var4_21);
                        v25 = v23.buf;
                        var3_18 = v25;
                        var3_18[var5_24] = 92;
                        v25[var1_6++] = 117;
                        var4_21 = var1_6 + 1;
                        var5_27 = IOUtils.DIGITS;
                        var3_18[var1_6] = var5_27[var9_44 >>> 12 & 15];
                        var1_6 = var4_21 + 1;
                        var3_18[var4_21] = var5_27[var9_44 >>> 8 & 15];
                        var3_19 = var1_6 + 1;
                        var3_18[var1_6] = var5_27[var9_44 >>> 4 & 15];
                        v23.buf[var3_19] = IOUtils.DIGITS[var9_44 & 15];
                    } else {
                        v26 = this;
                        v27 = var5_24;
                        var1_7 = v27 + 1;
                        var3_10 = var5_24 + 2;
                        var4_21 = var7_31 - v27 - 1;
                        System.arraycopy(v26.buf, var1_7, v26.buf, var3_10, var4_21);
                        v26.buf[var5_24] = 92;
                        v26.buf[var1_7] = IOUtils.replaceChars[var9_44];
                    }
                } else {
                    v28 = this;
                    v29 = var5_24;
                    var1_8 = v29 + 1;
                    var3_10 = var5_24 + 6;
                    var4_21 = var7_31 - v29 - 1;
                    System.arraycopy(v28.buf, var1_8, v28.buf, var3_10, var4_21);
                    v30 = v28.buf;
                    var3_20 = v30;
                    var3_20[var5_24] = 92;
                    v30[var1_8] = 117;
                    var4_22 = IOUtils.DIGITS;
                    var3_20[++var1_8] = var4_22[var9_44 >>> 12 & 15];
                    var3_20[++var1_8] = var4_22[var9_44 >>> 8 & 15];
                    var3_20[++var1_8] = var4_22[var9_44 >>> 4 & 15];
                    v28.buf[++var1_8] = IOUtils.DIGITS[var9_44 & 15];
                }
            } else if (var3_10 > 1) {
                for (var3_10 = var8_39 - var6_30; var3_10 < var1_1.length(); ++var3_10) {
                    var4_21 = var1_1.charAt(var3_10);
                    if (this.browserSecure && (var4_21 == 40 || var4_21 == 41 || var4_21 == 60 || var4_21 == 62)) {
                        v31 = this.buf;
                        v32 = this.buf;
                        var5_28 = v31;
                        v33 = var8_39;
                        var6_30 = v33 + 1;
                        v32[v33] = 92;
                        v31[var6_30++] = 117;
                        var7_31 = var6_30 + 1;
                        var8_40 = IOUtils.DIGITS;
                        v34 = var4_21;
                        v35 = var4_21;
                        v36 = var4_21;
                        var5_28[var6_30] = var8_40[var4_21 >>> 12 & 15];
                        var4_21 = var7_31 + 1;
                        var5_28[var7_31] = var8_40[v36 >>> 8 & 15];
                        var5_24 = var4_21 + 1;
                        var5_28[var4_21] = var8_40[v35 >>> 4 & 15];
                        var4_21 = var5_24 + 1;
                        v32[var5_24] = IOUtils.DIGITS[v34 & 15];
                        var8_39 = var4_21;
                        continue;
                    }
                    var5_29 /* !! */  = IOUtils.specicalFlags_doubleQuotes;
                    if (var4_21 < IOUtils.specicalFlags_doubleQuotes.length && var5_29 /* !! */ [var4_21] != 0 || var4_21 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        v37 = var5_29 /* !! */ ;
                        var5_29 /* !! */  = (byte[])this.buf;
                        v38 = var8_39;
                        var6_30 = v38 + 1;
                        this.buf[v38] = 92;
                        if (v37[var4_21] == 4) {
                            var5_29 /* !! */ [var6_30++] = 117;
                            var7_31 = var6_30 + 1;
                            var8_41 = IOUtils.DIGITS;
                            v39 = var4_21;
                            v40 = var4_21;
                            v41 = var4_21;
                            var5_29 /* !! */ [var6_30] = var8_41[var4_21 >>> 12 & 15];
                            var4_21 = var7_31 + 1;
                            var5_29 /* !! */ [var7_31] = var8_41[v41 >>> 8 & 15];
                            var5_24 = var4_21 + 1;
                            var5_29 /* !! */ [var4_21] = var8_41[v40 >>> 4 & 15];
                            var4_21 = var5_24 + 1;
                            var5_29 /* !! */ [var5_24] = IOUtils.DIGITS[v39 & 15];
                            var8_39 = var4_21;
                            continue;
                        }
                        v42 = var6_30;
                        var5_24 = v42 + 1;
                        var5_29 /* !! */ [v42] = IOUtils.replaceChars[var4_21];
                        var8_39 = var5_24;
                        continue;
                    }
                    if (var4_21 != 8232 && var4_21 != 8233) {
                        v43 = var8_39;
                        var5_24 = v43 + 1;
                        this.buf[v43] = var4_21;
                        var8_39 = var5_24;
                        continue;
                    }
                    v44 = this.buf;
                    v45 = this.buf;
                    var5_29 /* !! */  = (byte[])v44;
                    v46 = var8_39;
                    var6_30 = v46 + 1;
                    v45[v46] = 92;
                    v44[var6_30++] = 117;
                    var7_31 = var6_30 + 1;
                    var8_42 = IOUtils.DIGITS;
                    v47 = var4_21;
                    v48 = var4_21;
                    v49 = var4_21;
                    var5_29 /* !! */ [var6_30] = var8_42[var4_21 >>> 12 & 15];
                    var4_21 = var7_31 + 1;
                    var5_29 /* !! */ [var7_31] = var8_42[v49 >>> 8 & 15];
                    var5_24 = var4_21 + 1;
                    var5_29 /* !! */ [var4_21] = var8_42[v48 >>> 4 & 15];
                    var4_21 = var5_24 + 1;
                    v45[var5_24] = IOUtils.DIGITS[v47 & 15];
                    var8_39 = var4_21;
                }
            }
        }
        if (var2_9 != '\u0000') {
            var1_1 = this.buf;
            v50 = this.count;
            var1_1[v50 - 2] = 34;
            this.buf[v50 - 1] = var2_9;
        } else {
            this.buf[this.count - 1] = 34;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void writeStringWithDoubleQuote(char[] var1_1, char var2_9) {
        block56: {
            block57: {
                if (var1_1 /* !! */  == null) {
                    this.writeNull();
                    if (var2_9 != '\u0000') {
                        this.write(var2_9);
                    }
                    return;
                }
                var3_10 = var1_1 /* !! */ .length;
                var4_16 = this.count + var3_10 + 2;
                if (var2_9 != '\u0000') {
                    ++var4_16;
                }
                if (var4_16 <= this.buf.length) break block56;
                if (this.writer == null) break block57;
                this.write(34);
                for (var3_10 = 0; var3_10 < var1_1 /* !! */ .length; ++var3_10) {
                    var4_16 = var1_1 /* !! */ [var3_10];
                    if (this.isEnabled(SerializerFeature.BrowserSecure) && (var4_16 == 40 || var4_16 == 41 || var4_16 == 60 || var4_16 == 62)) {
                        v0 = this;
                        v0.write(92);
                        v0.write(117);
                        var5_21 /* !! */  = (byte[])IOUtils.DIGITS;
                        this.write(var5_21 /* !! */ [var4_16 >>> 12 & 15]);
                        this.write(var5_21 /* !! */ [var4_16 >>> 8 & 15]);
                        this.write(var5_21 /* !! */ [var4_16 >>> 4 & 15]);
                        v0.write(IOUtils.DIGITS[var4_16 & 15]);
                        continue;
                    }
                    if (!this.isEnabled(SerializerFeature.BrowserCompatible)) ** GOTO lbl52
                    if (var4_16 != 8 && var4_16 != 12 && var4_16 != 10 && var4_16 != 13 && var4_16 != 9 && var4_16 != 34 && var4_16 != 47 && var4_16 != 92) {
                        if (var4_16 < 32) {
                            v1 = this;
                            v1.write(92);
                            v1.write(117);
                            v1.write(48);
                            v1.write(48);
                            var5_21 /* !! */  = (byte[])IOUtils.ASCII_CHARS;
                            this.write(var5_21 /* !! */ [var4_16 *= 2]);
                            v1.write(IOUtils.ASCII_CHARS[var4_16 + 1]);
                            continue;
                        }
                        if (var4_16 >= 127) {
                            v2 = this;
                            v2.write(92);
                            v2.write(117);
                            var5_21 /* !! */  = (byte[])IOUtils.DIGITS;
                            this.write(var5_21 /* !! */ [var4_16 >>> 12 & 15]);
                            this.write(var5_21 /* !! */ [var4_16 >>> 8 & 15]);
                            this.write(var5_21 /* !! */ [var4_16 >>> 4 & 15]);
                            v2.write(IOUtils.DIGITS[var4_16 & 15]);
                            continue;
                        }
                    } else {
                        v3 = this;
                        v3.write(92);
                        v3.write(IOUtils.replaceChars[var4_16]);
                        continue;
lbl52:
                        // 1 sources

                        var5_21 /* !! */  = IOUtils.specicalFlags_doubleQuotes;
                        if (var4_16 < IOUtils.specicalFlags_doubleQuotes.length && var5_21 /* !! */ [var4_16] != 0 || var4_16 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                            this.write(92);
                            if (var5_21 /* !! */ [var4_16] == 4) {
                                v4 = this;
                                v4.write(117);
                                var5_21 /* !! */  = (byte[])IOUtils.DIGITS;
                                this.write(var5_21 /* !! */ [var4_16 >>> 12 & 15]);
                                this.write(var5_21 /* !! */ [var4_16 >>> 8 & 15]);
                                this.write(var5_21 /* !! */ [var4_16 >>> 4 & 15]);
                                v4.write(IOUtils.DIGITS[var4_16 & 15]);
                                continue;
                            }
                            this.write(IOUtils.replaceChars[var4_16]);
                            continue;
                        }
                    }
                    this.write(var4_16);
                }
                this.write(34);
                if (var2_9 != '\u0000') {
                    this.write(var2_9);
                }
                return;
            }
            this.expandCapacity(var4_16);
        }
        v5 = this;
        var5_22 = v5.count;
        var6_26 = var5_22 + 1;
        var3_10 = var6_26 + var3_10;
        var7_27 = v5.buf;
        v5.buf[var5_22] = 34;
        var5_22 = var1_1 /* !! */ .length;
        System.arraycopy(var1_1 /* !! */ , 0, var7_27, var6_26, var5_22);
        this.count = var4_16;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            var1_2 = -1;
            block1: for (var5_22 = var6_26; var5_22 < var3_10; ++var5_22) {
                var7_28 = this.buf[var5_22];
                if (var7_28 != '\"' && var7_28 != '/' && var7_28 != '\\' && var7_28 != '\b' && var7_28 != '\f' && var7_28 != '\n' && var7_28 != '\r' && var7_28 != '\t') {
                    if (var7_28 < ' ') lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            v6 = var1_2 = var4_16 + 5;
                            var1_2 = var5_22;
                            var4_16 = v6;
                            continue block1;
                            break;
                        }
                    }
                    if (var7_28 < '\u007f') continue;
                    ** continue;
                }
                v7 = var1_2 = var4_16 + 1;
                var1_2 = var5_22;
                var4_16 = v7;
            }
            if (var4_16 > this.buf.length) {
                this.expandCapacity(var4_16);
            }
            this.count = var4_16;
            while (var1_2 >= var6_26) {
                var4_17 = this.buf;
                var5_22 = this.buf[var1_2];
                if (var5_22 != 8 && var5_22 != 12 && var5_22 != 10 && var5_22 != 13 && var5_22 != 9) {
                    if (var5_22 != 34 && var5_22 != 47 && var5_22 != 92) {
                        if (var5_22 < 32) {
                            v8 = var1_2;
                            var7_29 = v8 + 1;
                            var8_35 = var1_2 + 6;
                            var9_45 = var3_10 - v8 - 1;
                            System.arraycopy(var4_17, var7_29, var4_17, var8_35, var9_45);
                            v9 = this.buf;
                            var4_17 = v9;
                            var4_17[var1_2] = 92;
                            var4_17[var7_29] = 117;
                            var4_17[var1_2 + 2] = 48;
                            v9[var1_2 + 3] = 48;
                            var7_29 = var1_2 + 4;
                            var8_36 = IOUtils.ASCII_CHARS;
                            var4_17[var7_29] = var8_36[var5_22 *= 2];
                            var4_18 = var1_2 + 5;
                            this.buf[var4_18] = IOUtils.ASCII_CHARS[var5_22 + 1];
                            var3_10 += 5;
                        } else if (var5_22 >= 127) {
                            v10 = var1_2;
                            var7_30 = v10 + 1;
                            var8_37 = var1_2 + 6;
                            var9_45 = var3_10 - v10 - 1;
                            System.arraycopy(var4_17, var7_30, var4_17, var8_37, var9_45);
                            v11 = this.buf;
                            var4_17 = v11;
                            var4_17[var1_2] = 92;
                            v11[var7_30] = 117;
                            var7_30 = var1_2 + 2;
                            var8_38 = IOUtils.DIGITS;
                            var4_17[var7_30] = var8_38[var5_22 >>> 12 & 15];
                            var4_19 = var1_2 + 3;
                            var4_17[var4_19] = var8_38[var5_22 >>> 8 & 15];
                            var4_19 = var1_2 + 4;
                            var4_17[var4_19] = var8_38[var5_22 >>> 4 & 15];
                            var4_19 = var1_2 + 5;
                            this.buf[var4_19] = IOUtils.DIGITS[var5_22 & 15];
                            var3_10 += 5;
                        }
                    } else {
                        v12 = var1_2;
                        var7_31 = v12 + 1;
                        var8_39 = var1_2 + 2;
                        var9_45 = var3_10 - v12 - 1;
                        System.arraycopy(var4_17, var7_31, var4_17, var8_39, var9_45);
                        this.buf[var1_2] = 92;
                        this.buf[var7_31] = var5_22;
                        ++var3_10;
                    }
                } else {
                    v13 = var1_2;
                    var7_32 = v13 + 1;
                    var8_40 = var1_2 + 2;
                    var9_45 = var3_10 - v13 - 1;
                    System.arraycopy(var4_17, var7_32, var4_17, var8_40, var9_45);
                    this.buf[var1_2] = 92;
                    this.buf[var7_32] = IOUtils.replaceChars[var5_22];
                    ++var3_10;
                }
                --var1_2;
            }
            if (var2_9 != '\u0000') {
                var1_3 = this.buf;
                v14 = this.count;
                var1_3[v14 - 2] = 34;
                this.buf[v14 - 1] = var2_9;
            } else {
                this.buf[this.count - 1] = 34;
            }
            return;
        }
        var5_22 = 0;
        var7_33 = -1;
        var8_41 = -1;
        var9_46 = 0;
        for (var10_47 = var6_26; var10_47 < var3_10; ++var10_47) {
            block59: {
                block58: {
                    var11_48 = this.buf[var10_47];
                    if (var11_48 >= 93) {
                        if (var11_48 < 127 || var11_48 != 8232 && var11_48 != 8233 && var11_48 >= 160) continue;
                        if (var8_41 == -1) {
                            var8_41 = var10_47;
                        }
                        ++var5_22;
                        var4_16 += 4;
                        var7_33 = var10_47;
                        var9_46 = var11_48;
                        continue;
                    }
                    if (!(var11_48 < 64 && (this.sepcialBits & 1L << var11_48) != 0L || var11_48 == 92)) continue;
                    ++var5_22;
                    if (var11_48 == 40 || var11_48 == 41 || var11_48 == 60 || var11_48 == 62) break block58;
                    var7_34 = IOUtils.specicalFlags_doubleQuotes;
                    if (var11_48 >= IOUtils.specicalFlags_doubleQuotes.length || var7_34[var11_48] != 4) break block59;
                }
                var4_16 += 4;
            }
            if (var8_41 == -1) {
                var7_33 = var10_47;
                var8_41 = var10_47;
                var9_46 = var11_48;
                continue;
            }
            var7_33 = var10_47;
            var9_46 = var11_48;
        }
        if (var5_22 > 0) {
            if ((var4_16 += var5_22) > this.buf.length) {
                this.expandCapacity(var4_16);
            }
            this.count = var4_16;
            if (var5_22 == 1) {
                if (var9_46 == 8232) {
                    v15 = this;
                    v16 = var3_10;
                    v17 = var7_33;
                    var1_4 = v17 + 1;
                    var3_10 = var7_33 + 6;
                    var4_16 = v16 - v17 - 1;
                    System.arraycopy(v15.buf, var1_4, v15.buf, var3_10, var4_16);
                    v18 = v15.buf;
                    var3_11 = v18;
                    var3_11[var7_33] = 92;
                    v18[var1_4] = 117;
                    v18[++var1_4] = 50;
                    v18[++var1_4] = 48;
                    v19 = var1_4 + 1;
                    var3_11[v19] = 50;
                    v15.buf[v19 + 1] = 56;
                } else if (var9_46 == 8233) {
                    v20 = this;
                    v21 = var3_10;
                    v22 = var7_33;
                    var1_5 = v22 + 1;
                    var3_10 = var7_33 + 6;
                    var4_16 = v21 - v22 - 1;
                    System.arraycopy(v20.buf, var1_5, v20.buf, var3_10, var4_16);
                    v23 = v20.buf;
                    var3_12 = v23;
                    var3_12[var7_33] = 92;
                    v23[var1_5] = 117;
                    v23[++var1_5] = 50;
                    v23[++var1_5] = 48;
                    v24 = var1_5 + 1;
                    var3_12[v24] = 50;
                    v20.buf[v24 + 1] = 57;
                } else if (var9_46 != 40 && var9_46 != 41 && var9_46 != 60 && var9_46 != 62) {
                    var1_1 /* !! */  = (char[])IOUtils.specicalFlags_doubleQuotes;
                    if (var9_46 < IOUtils.specicalFlags_doubleQuotes.length && var1_1 /* !! */ [var9_46] == '\u0004') {
                        v25 = this;
                        v26 = var3_10;
                        v27 = var7_33;
                        var1_6 = v27 + 1;
                        var3_10 = var7_33 + 6;
                        var4_16 = v26 - v27 - 1;
                        System.arraycopy(v25.buf, var1_6, v25.buf, var3_10, var4_16);
                        v28 = v25.buf;
                        var3_13 = v28;
                        var3_13[var7_33] = 92;
                        v28[var1_6++] = 117;
                        var4_16 = var1_6 + 1;
                        var5_23 = IOUtils.DIGITS;
                        var3_13[var1_6] = var5_23[var9_46 >>> 12 & 15];
                        var1_6 = var4_16 + 1;
                        var3_13[var4_16] = var5_23[var9_46 >>> 8 & 15];
                        var3_14 = var1_6 + 1;
                        var3_13[var1_6] = var5_23[var9_46 >>> 4 & 15];
                        v25.buf[var3_14] = IOUtils.DIGITS[var9_46 & 15];
                    } else {
                        v29 = this;
                        v30 = var3_10;
                        v31 = var7_33;
                        var1_7 = v31 + 1;
                        var3_10 = var7_33 + 2;
                        var4_16 = v30 - v31 - 1;
                        System.arraycopy(v29.buf, var1_7, v29.buf, var3_10, var4_16);
                        v29.buf[var7_33] = 92;
                        v29.buf[var1_7] = IOUtils.replaceChars[var9_46];
                    }
                } else {
                    v32 = this;
                    v33 = var3_10;
                    v34 = var7_33;
                    var1_8 = v34 + 1;
                    var3_10 = var7_33 + 6;
                    var4_16 = v33 - v34 - 1;
                    System.arraycopy(v32.buf, var1_8, v32.buf, var3_10, var4_16);
                    v35 = v32.buf;
                    var3_15 = v35;
                    var3_15[var7_33] = 92;
                    v35[var1_8] = 117;
                    var4_20 = IOUtils.DIGITS;
                    var3_15[++var1_8] = var4_20[var9_46 >>> 12 & 15];
                    var3_15[++var1_8] = var4_20[var9_46 >>> 8 & 15];
                    var3_15[++var1_8] = var4_20[var9_46 >>> 4 & 15];
                    v32.buf[++var1_8] = IOUtils.DIGITS[var9_46 & 15];
                }
            } else if (var5_22 > 1) {
                for (var3_10 = var8_41 - var6_26; var3_10 < var1_1 /* !! */ .length; ++var3_10) {
                    var4_16 = var1_1 /* !! */ [var3_10];
                    if (this.browserSecure && (var4_16 == 40 || var4_16 == 41 || var4_16 == 60 || var4_16 == 62)) {
                        v36 = this.buf;
                        v37 = this.buf;
                        var5_24 = v36;
                        v38 = var8_41;
                        var6_26 = v38 + 1;
                        v37[v38] = 92;
                        v36[var6_26++] = 117;
                        var7_33 = var6_26 + 1;
                        var8_42 = IOUtils.DIGITS;
                        v39 = var4_16;
                        v40 = var4_16;
                        v41 = var4_16;
                        var5_24[var6_26] = var8_42[var4_16 >>> 12 & 15];
                        var4_16 = var7_33 + 1;
                        var5_24[var7_33] = var8_42[v41 >>> 8 & 15];
                        var5_22 = var4_16 + 1;
                        var5_24[var4_16] = var8_42[v40 >>> 4 & 15];
                        var4_16 = var5_22 + 1;
                        v37[var5_22] = IOUtils.DIGITS[v39 & 15];
                        var8_41 = var4_16;
                        continue;
                    }
                    var5_25 /* !! */  = IOUtils.specicalFlags_doubleQuotes;
                    if (var4_16 < IOUtils.specicalFlags_doubleQuotes.length && var5_25 /* !! */ [var4_16] != 0 || var4_16 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        v42 = var5_25 /* !! */ ;
                        var5_25 /* !! */  = (byte[])this.buf;
                        v43 = var8_41;
                        var6_26 = v43 + 1;
                        this.buf[v43] = 92;
                        if (v42[var4_16] == 4) {
                            var5_25 /* !! */ [var6_26++] = 117;
                            var7_33 = var6_26 + 1;
                            var8_43 = IOUtils.DIGITS;
                            v44 = var4_16;
                            v45 = var4_16;
                            v46 = var4_16;
                            var5_25 /* !! */ [var6_26] = var8_43[var4_16 >>> 12 & 15];
                            var4_16 = var7_33 + 1;
                            var5_25 /* !! */ [var7_33] = var8_43[v46 >>> 8 & 15];
                            var5_22 = var4_16 + 1;
                            var5_25 /* !! */ [var4_16] = var8_43[v45 >>> 4 & 15];
                            var4_16 = var5_22 + 1;
                            var5_25 /* !! */ [var5_22] = IOUtils.DIGITS[v44 & 15];
                            var8_41 = var4_16;
                            continue;
                        }
                        v47 = var6_26;
                        var5_22 = v47 + 1;
                        var5_25 /* !! */ [v47] = IOUtils.replaceChars[var4_16];
                        var8_41 = var5_22;
                        continue;
                    }
                    if (var4_16 != 8232 && var4_16 != 8233) {
                        v48 = var8_41;
                        var5_22 = v48 + 1;
                        this.buf[v48] = var4_16;
                        var8_41 = var5_22;
                        continue;
                    }
                    v49 = this.buf;
                    v50 = this.buf;
                    var5_25 /* !! */  = (byte[])v49;
                    v51 = var8_41;
                    var6_26 = v51 + 1;
                    v50[v51] = 92;
                    v49[var6_26++] = 117;
                    var7_33 = var6_26 + 1;
                    var8_44 = IOUtils.DIGITS;
                    v52 = var4_16;
                    v53 = var4_16;
                    v54 = var4_16;
                    var5_25 /* !! */ [var6_26] = var8_44[var4_16 >>> 12 & 15];
                    var4_16 = var7_33 + 1;
                    var5_25 /* !! */ [var7_33] = var8_44[v54 >>> 8 & 15];
                    var5_22 = var4_16 + 1;
                    var5_25 /* !! */ [var4_16] = var8_44[v53 >>> 4 & 15];
                    var4_16 = var5_22 + 1;
                    v50[var5_22] = IOUtils.DIGITS[v52 & 15];
                    var8_41 = var4_16;
                }
            }
        }
        if (var2_9 != '\u0000') {
            var1_1 /* !! */  = this.buf;
            v55 = this.count;
            var1_1 /* !! */ [v55 - 2] = 34;
            this.buf[v55 - 1] = var2_9;
        } else {
            this.buf[this.count - 1] = 34;
        }
    }

    public void writeFieldNameDirect(String string) {
        int n = string.length();
        int n2 = this.count + n + 3;
        if (n2 > this.buf.length) {
            this.expandCapacity(n2);
        }
        SerializeWriter serializeWriter = this;
        SerializeWriter serializeWriter2 = this;
        int n3 = serializeWriter2.count;
        int n4 = n3 + 1;
        char[] cArray = serializeWriter2.buf;
        serializeWriter2.buf[n3] = 34;
        string.getChars(0, n, cArray, n4);
        serializeWriter.count = n2;
        serializeWriter.buf[n2 - 2] = 34;
        serializeWriter.buf[n2 - 1] = 58;
    }

    public void write(List<String> list) {
        if (list.isEmpty()) {
            this.write("[]");
            return;
        }
        int n = this.count;
        int n2 = list.size();
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4;
            Object object = list.get(i);
            int n5 = 0;
            if (object == null) {
                n5 = 1;
            } else {
                int n6 = ((String)object).length();
                for (n4 = 0; n4 < n6; ++n4) {
                    n5 = ((String)object).charAt(n4);
                    n5 = n5 >= 32 && n5 <= 126 && n5 != 34 && n5 != 92 ? 0 : 1;
                    if (n5 != 0) break;
                }
            }
            if (n5 != 0) {
                this.count = n;
                this.write(91);
                for (n = 0; n < list.size(); ++n) {
                    String string = list.get(n);
                    if (n != 0) {
                        this.write(44);
                    }
                    if (string == null) {
                        this.write("null");
                        continue;
                    }
                    this.writeStringWithDoubleQuote(string, '\u0000');
                }
                this.write(93);
                return;
            }
            n5 = n3 + ((String)object).length() + 3;
            if (i == list.size() - 1) {
                ++n5;
            }
            if (n5 > this.buf.length) {
                this.count = n3;
                this.expandCapacity(n5);
            }
            this.buf[n3++] = i == 0 ? 91 : 44;
            SerializeWriter serializeWriter = this;
            char[] cArray = serializeWriter.buf;
            n4 = n3 + 1;
            String string = object;
            cArray[n3] = 34;
            n3 = ((String)object).length();
            object = this.buf;
            string.getChars(0, n3, (char[])object, n4);
            n3 = n4 + string.length();
            serializeWriter.buf[n3++] = 34;
        }
        int n7 = n3;
        int n8 = n7 + 1;
        this.buf[n7] = 93;
        this.count = n8;
    }

    public void writeFieldValue(char c, String string, char c2) {
        SerializeWriter serializeWriter = this;
        serializeWriter.write(c);
        serializeWriter.writeFieldName(string);
        if (c2 == '\u0000') {
            this.writeString("\u0000");
        } else {
            this.writeString(Character.toString(c2));
        }
    }

    public void writeFieldValue(char c, String string, boolean bl) {
        if (!this.quoteFieldNames) {
            SerializeWriter serializeWriter = this;
            serializeWriter.write(c);
            serializeWriter.writeFieldName(string);
            serializeWriter.write(bl);
            return;
        }
        int n = bl ? 4 : 5;
        int n2 = string.length();
        n = this.count + n2 + 4 + n;
        if (n > this.buf.length) {
            if (this.writer != null) {
                SerializeWriter serializeWriter = this;
                serializeWriter.write(c);
                serializeWriter.writeString(string);
                serializeWriter.write(58);
                serializeWriter.write(bl);
                return;
            }
            this.expandCapacity(n);
        }
        SerializeWriter serializeWriter = this;
        int n3 = this.count;
        serializeWriter.count = n;
        char[] cArray = serializeWriter.buf;
        cArray[n3] = c;
        c = (char)(n3 + n2 + 1);
        n = n3 + 1;
        serializeWriter.buf[n] = this.keySeperator;
        string.getChars(0, n2, cArray, n3 += 2);
        char[] cArray2 = this.buf;
        int n4 = c + '\u0001';
        this.buf[n4] = this.keySeperator;
        if (bl) {
            n4 = c + 2;
            System.arraycopy(VALUE_TRUE, 0, cArray2, n4, 5);
        } else {
            n4 = c + 2;
            System.arraycopy(VALUE_FALSE, 0, cArray2, n4, 6);
        }
    }

    public void write(boolean bl) {
        if (bl) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void writeFieldValue(char c, String string, int n) {
        if (n != Integer.MIN_VALUE && this.quoteFieldNames) {
            int n2 = n < 0 ? IOUtils.stringSize(-n) + 1 : IOUtils.stringSize(n);
            int n3 = string.length();
            n2 = this.count + n3 + 4 + n2;
            if (n2 > this.buf.length) {
                if (this.writer != null) {
                    SerializeWriter serializeWriter = this;
                    serializeWriter.write(c);
                    serializeWriter.writeFieldName(string);
                    serializeWriter.writeInt(n);
                    return;
                }
                this.expandCapacity(n2);
            }
            SerializeWriter serializeWriter = this;
            SerializeWriter serializeWriter2 = this;
            int n4 = this.count;
            serializeWriter2.count = n2;
            char[] cArray = serializeWriter2.buf;
            cArray[n4] = c;
            c = (char)(n4 + n3 + 1);
            n2 = n4 + 1;
            serializeWriter2.buf[n2] = this.keySeperator;
            string.getChars(0, n3, cArray, n4 += 2);
            char[] cArray2 = serializeWriter.buf;
            int n5 = c + '\u0001';
            cArray2[n5] = this.keySeperator;
            serializeWriter.buf[c + 2] = 58;
            IOUtils.getChars(n, serializeWriter.count, cArray2);
            return;
        }
        SerializeWriter serializeWriter = this;
        serializeWriter.write(c);
        serializeWriter.writeFieldName(string);
        serializeWriter.writeInt(n);
    }

    public void writeFieldValue(char c, String string, long l) {
        if (l != Long.MIN_VALUE && this.quoteFieldNames && !this.isEnabled(SerializerFeature.BrowserCompatible.mask)) {
            int n = l < 0L ? IOUtils.stringSize(-l) + 1 : IOUtils.stringSize(l);
            int n2 = string.length();
            n = this.count + n2 + 4 + n;
            if (n > this.buf.length) {
                if (this.writer != null) {
                    SerializeWriter serializeWriter = this;
                    serializeWriter.write(c);
                    serializeWriter.writeFieldName(string);
                    serializeWriter.writeLong(l);
                    return;
                }
                this.expandCapacity(n);
            }
            SerializeWriter serializeWriter = this;
            SerializeWriter serializeWriter2 = this;
            int n3 = this.count;
            serializeWriter2.count = n;
            char[] cArray = serializeWriter2.buf;
            cArray[n3] = c;
            c = (char)(n3 + n2 + 1);
            int n4 = n3 + 1;
            serializeWriter2.buf[n4] = this.keySeperator;
            string.getChars(0, n2, cArray, n3 += 2);
            char[] cArray2 = serializeWriter.buf;
            int n5 = c + '\u0001';
            cArray2[n5] = this.keySeperator;
            serializeWriter.buf[c + 2] = 58;
            IOUtils.getChars(l, serializeWriter.count, cArray2);
            return;
        }
        SerializeWriter serializeWriter = this;
        serializeWriter.write(c);
        serializeWriter.writeFieldName(string);
        serializeWriter.writeLong(l);
    }

    public void writeFieldValue(char c, String string, float f) {
        SerializeWriter serializeWriter = this;
        serializeWriter.write(c);
        serializeWriter.writeFieldName(string);
        serializeWriter.writeFloat(f, false);
    }

    public void writeFieldValue(char c, String string, double d) {
        SerializeWriter serializeWriter = this;
        serializeWriter.write(c);
        serializeWriter.writeFieldName(string);
        serializeWriter.writeDouble(d, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeFieldValue(char c, String string, String string2) {
        block6: {
            block7: {
                block4: {
                    block5: {
                        if (!this.quoteFieldNames) break block4;
                        if (!this.useSingleQuotes) break block5;
                        SerializeWriter serializeWriter = this;
                        serializeWriter.write(c);
                        serializeWriter.writeFieldName(string);
                        if (string2 != null) break block6;
                        break block7;
                    }
                    if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                        SerializeWriter serializeWriter = this;
                        serializeWriter.write(c);
                        serializeWriter.writeStringWithDoubleQuote(string, ':');
                        serializeWriter.writeStringWithDoubleQuote(string2, '\u0000');
                        return;
                    }
                    this.writeFieldValueStringWithDoubleQuoteCheck(c, string, string2);
                    return;
                }
                SerializeWriter serializeWriter = this;
                serializeWriter.write(c);
                serializeWriter.writeFieldName(string);
                if (string2 != null) break block6;
            }
            this.writeNull();
            return;
        }
        this.writeString(string2);
    }

    public void writeFieldValueStringWithDoubleQuoteCheck(char c, String object, String string) {
        int n;
        int n2 = ((String)object).length();
        int n3 = this.count;
        if (string == null) {
            int n4 = n3;
            n3 = 4;
            n = n4 + (n2 + 8);
        } else {
            int n5 = n3;
            n3 = string.length();
            n = n5 + (n2 + n3 + 6);
        }
        if (n > this.buf.length) {
            if (this.writer != null) {
                SerializeWriter serializeWriter = this;
                serializeWriter.write(c);
                serializeWriter.writeStringWithDoubleQuote((String)object, ':');
                serializeWriter.writeStringWithDoubleQuote(string, '\u0000');
                return;
            }
            this.expandCapacity(n);
        }
        SerializeWriter serializeWriter = this;
        String string2 = object;
        object = this.buf;
        int n6 = this.count;
        int n7 = n6;
        object[n7] = c;
        int n8 = n7 + 2;
        c = (char)n8;
        n7 = n8 + n2;
        this.buf[n6 + 1] = 34;
        string2.getChars(0, n2, (char[])object, c);
        serializeWriter.count = n;
        char[] cArray = serializeWriter.buf;
        char[] cArray2 = cArray;
        cArray[n7] = 34;
        int n9 = n7 + 1;
        int n10 = n9 + 1;
        serializeWriter.buf[n9] = 58;
        if (string == null) {
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            int n11 = n10 + 1;
            cArray3[n10] = 110;
            int n12 = n11 + 1;
            cArray4[n11] = 117;
            n11 = n12 + 1;
            cArray3[n12] = 108;
            cArray4[n11] = 108;
            return;
        }
        n2 = n10 + 1;
        cArray2[n10] = 34;
        n10 = n2 + n3;
        string.getChars(0, n3, cArray2, n2);
        int n13 = 0;
        n3 = -1;
        n7 = -1;
        int n14 = 0;
        for (int i = n2; i < n10; ++i) {
            int n15;
            block31: {
                block30: {
                    n15 = this.buf[i];
                    if (n15 >= 93) {
                        if (n15 < 127 || n15 != 8232 && n15 != 8233 && n15 >= 160) continue;
                        if (n7 == -1) {
                            n7 = i;
                        }
                        ++n13;
                        int n16 = n3 = n + 4;
                        n3 = i;
                        n14 = n15;
                        n = n16;
                        continue;
                    }
                    if (!(n15 < 64 && (this.sepcialBits & 1L << n15) != 0L || n15 == 92)) continue;
                    ++n13;
                    if (n15 == 40 || n15 == 41 || n15 == 60 || n15 == 62) break block30;
                    byte[] byArray = IOUtils.specicalFlags_doubleQuotes;
                    if (n15 >= IOUtils.specicalFlags_doubleQuotes.length || byArray[n15] != 4) break block31;
                }
                n += 4;
            }
            if (n7 == -1) {
                n3 = i;
                n7 = i;
                n14 = n15;
                continue;
            }
            n3 = i;
            n14 = n15;
        }
        if (n13 > 0) {
            if ((n += n13) > this.buf.length) {
                this.expandCapacity(n);
            }
            this.count = n;
            if (n13 == 1) {
                if (n14 == 8232) {
                    SerializeWriter serializeWriter2 = this;
                    int n17 = n10;
                    int n18 = n3;
                    n13 = n18 + 1;
                    n10 = n3 + 6;
                    int n19 = n17 - n18 - 1;
                    System.arraycopy(serializeWriter2.buf, n13, serializeWriter2.buf, n10, n19);
                    char[] cArray5 = serializeWriter2.buf;
                    char[] cArray6 = cArray5;
                    cArray6[n3] = 92;
                    cArray5[n13] = 117;
                    cArray5[++n13] = 50;
                    cArray5[++n13] = 48;
                    int n20 = n13 + 1;
                    cArray6[n20] = 50;
                    serializeWriter2.buf[n20 + 1] = 56;
                } else if (n14 == 8233) {
                    SerializeWriter serializeWriter3 = this;
                    int n21 = n10;
                    int n22 = n3;
                    n13 = n22 + 1;
                    n10 = n3 + 6;
                    int n23 = n21 - n22 - 1;
                    System.arraycopy(serializeWriter3.buf, n13, serializeWriter3.buf, n10, n23);
                    char[] cArray7 = serializeWriter3.buf;
                    char[] cArray8 = cArray7;
                    cArray8[n3] = 92;
                    cArray7[n13] = 117;
                    cArray7[++n13] = 50;
                    cArray7[++n13] = 48;
                    int n24 = n13 + 1;
                    cArray8[n24] = 50;
                    serializeWriter3.buf[n24 + 1] = 57;
                } else if (n14 != 40 && n14 != 41 && n14 != 60 && n14 != 62) {
                    byte[] byArray = IOUtils.specicalFlags_doubleQuotes;
                    if (n14 < IOUtils.specicalFlags_doubleQuotes.length && byArray[n14] == 4) {
                        SerializeWriter serializeWriter4 = this;
                        int n25 = n10;
                        int n26 = n3;
                        int n27 = n26 + 1;
                        n10 = n3 + 6;
                        int n28 = n25 - n26 - 1;
                        System.arraycopy(serializeWriter4.buf, n27, serializeWriter4.buf, n10, n28);
                        char[] cArray9 = serializeWriter4.buf;
                        char[] cArray10 = cArray9;
                        cArray10[n3] = 92;
                        cArray9[n27++] = 117;
                        n28 = n27 + 1;
                        char[] cArray11 = IOUtils.DIGITS;
                        cArray10[n27] = cArray11[n14 >>> 12 & 0xF];
                        n27 = n28 + 1;
                        cArray10[n28] = cArray11[n14 >>> 8 & 0xF];
                        int n29 = n27 + 1;
                        cArray10[n27] = cArray11[n14 >>> 4 & 0xF];
                        serializeWriter4.buf[n29] = IOUtils.DIGITS[n14 & 0xF];
                    } else {
                        SerializeWriter serializeWriter5 = this;
                        int n30 = n10;
                        int n31 = n3;
                        int n32 = n31 + 1;
                        n10 = n3 + 2;
                        int n33 = n30 - n31 - 1;
                        System.arraycopy(serializeWriter5.buf, n32, serializeWriter5.buf, n10, n33);
                        serializeWriter5.buf[n3] = 92;
                        serializeWriter5.buf[n32] = IOUtils.replaceChars[n14];
                    }
                } else {
                    SerializeWriter serializeWriter6 = this;
                    int n34 = n10;
                    int n35 = n3;
                    n13 = n35 + 1;
                    n10 = n3 + 6;
                    int n36 = n34 - n35 - 1;
                    System.arraycopy(serializeWriter6.buf, n13, serializeWriter6.buf, n10, n36);
                    char[] cArray12 = serializeWriter6.buf;
                    char[] cArray13 = cArray12;
                    cArray13[n3] = 92;
                    cArray12[n13++] = 117;
                    n36 = n13 + 1;
                    char[] cArray14 = IOUtils.DIGITS;
                    cArray13[n13] = cArray14[n14 >>> 12 & 0xF];
                    n13 = n36 + 1;
                    cArray13[n36] = cArray14[n14 >>> 8 & 0xF];
                    int n37 = n13 + 1;
                    cArray13[n13] = cArray14[n14 >>> 4 & 0xF];
                    serializeWriter6.buf[n37] = IOUtils.DIGITS[n14 & 0xF];
                }
            } else if (n13 > 1) {
                for (n13 = n7 - n2; n13 < string.length(); ++n13) {
                    n10 = string.charAt(n13);
                    if (this.browserSecure && (n10 == 40 || n10 == 41 || n10 == 60 || n10 == 62)) {
                        char[] cArray15 = this.buf;
                        char[] cArray16 = this.buf;
                        char[] cArray17 = cArray15;
                        int n38 = n7;
                        n3 = n38 + 1;
                        cArray16[n38] = 92;
                        cArray15[n3++] = 117;
                        n = n3 + 1;
                        char[] cArray18 = IOUtils.DIGITS;
                        int n39 = n10;
                        int n40 = n10;
                        int n41 = n10;
                        cArray17[n3] = cArray18[n10 >>> 12 & 0xF];
                        n10 = n + 1;
                        cArray17[n] = cArray18[n41 >>> 8 & 0xF];
                        n2 = n10 + 1;
                        cArray17[n10] = cArray18[n40 >>> 4 & 0xF];
                        n10 = n2 + 1;
                        cArray16[n2] = IOUtils.DIGITS[n39 & 0xF];
                        n7 = n10;
                        continue;
                    }
                    Object[] objectArray = IOUtils.specicalFlags_doubleQuotes;
                    if (n10 < IOUtils.specicalFlags_doubleQuotes.length && objectArray[n10] != 0 || n10 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        byte[] byArray = objectArray;
                        objectArray = this.buf;
                        int n42 = n7;
                        n3 = n42 + 1;
                        this.buf[n42] = 92;
                        if (byArray[n10] == 4) {
                            objectArray[n3++] = 117;
                            n = n3 + 1;
                            char[] cArray19 = IOUtils.DIGITS;
                            int n43 = n10;
                            int n44 = n10;
                            int n45 = n10;
                            objectArray[n3] = cArray19[n10 >>> 12 & 0xF];
                            n10 = n + 1;
                            objectArray[n] = cArray19[n45 >>> 8 & 0xF];
                            n2 = n10 + 1;
                            objectArray[n10] = cArray19[n44 >>> 4 & 0xF];
                            n10 = n2 + 1;
                            objectArray[n2] = IOUtils.DIGITS[n43 & 0xF];
                            n7 = n10;
                            continue;
                        }
                        int n46 = n3;
                        n2 = n46 + 1;
                        objectArray[n46] = IOUtils.replaceChars[n10];
                        n7 = n2;
                        continue;
                    }
                    if (n10 != 8232 && n10 != 8233) {
                        int n47 = n7;
                        n2 = n47 + 1;
                        this.buf[n47] = n10;
                        n7 = n2;
                        continue;
                    }
                    char[] cArray20 = this.buf;
                    char[] cArray21 = this.buf;
                    objectArray = cArray20;
                    int n48 = n7;
                    n3 = n48 + 1;
                    cArray21[n48] = 92;
                    cArray20[n3++] = 117;
                    n = n3 + 1;
                    char[] cArray22 = IOUtils.DIGITS;
                    int n49 = n10;
                    int n50 = n10;
                    int n51 = n10;
                    objectArray[n3] = cArray22[n10 >>> 12 & 0xF];
                    n10 = n + 1;
                    objectArray[n] = cArray22[n51 >>> 8 & 0xF];
                    n2 = n10 + 1;
                    objectArray[n10] = cArray22[n50 >>> 4 & 0xF];
                    n10 = n2 + 1;
                    cArray21[n2] = IOUtils.DIGITS[n49 & 0xF];
                    n7 = n10;
                }
            }
        }
        this.buf[this.count - 1] = 34;
    }

    public void writeFieldValueStringWithDoubleQuote(char c, String object, String string) {
        int n;
        int n2 = ((String)object).length();
        int n3 = this.count + (n2 + (n = string.length()) + 6);
        if (n3 > this.buf.length) {
            if (this.writer != null) {
                SerializeWriter serializeWriter = this;
                serializeWriter.write(c);
                serializeWriter.writeStringWithDoubleQuote((String)object, ':');
                serializeWriter.writeStringWithDoubleQuote(string, '\u0000');
                return;
            }
            this.expandCapacity(n3);
        }
        SerializeWriter serializeWriter = this;
        String string2 = object;
        object = this.buf;
        int n4 = this.count;
        int n5 = n4;
        object[n5] = c;
        int n6 = n5 + 2;
        c = (char)n6;
        n5 = n6 + n2;
        this.buf[n4 + 1] = 34;
        string2.getChars(0, n2, (char[])object, c);
        serializeWriter.count = n3;
        char[] cArray = serializeWriter.buf;
        char[] cArray2 = serializeWriter.buf;
        char[] cArray3 = cArray;
        cArray2[n5] = 34;
        int n7 = n5 + 1;
        int n8 = n7 + 1;
        cArray[n7] = 58;
        cArray2[n8++] = 34;
        string.getChars(0, n, cArray3, n8);
        this.buf[this.count - 1] = 34;
    }

    public void writeFieldValue(char c, String string, Enum<?> enum_) {
        Object object;
        if (enum_ == null) {
            SerializeWriter serializeWriter = object;
            serializeWriter.write(c);
            serializeWriter.writeFieldName(string);
            serializeWriter.writeNull();
            return;
        }
        if (((SerializeWriter)object).writeEnumUsingName && !((SerializeWriter)object).writeEnumUsingToString) {
            SerializeWriter serializeWriter = object;
            object = enum_.name();
            serializeWriter.writeEnumFieldValue(c, string, (String)object);
        } else if (((SerializeWriter)object).writeEnumUsingToString) {
            SerializeWriter serializeWriter = object;
            object = enum_.toString();
            serializeWriter.writeEnumFieldValue(c, string, (String)object);
        } else {
            int n = enum_.ordinal();
            ((SerializeWriter)object).writeFieldValue(c, string, n);
        }
    }

    public void writeFieldValue(char c, String string, BigDecimal bigDecimal) {
        SerializeWriter serializeWriter = this;
        serializeWriter.write(c);
        serializeWriter.writeFieldName(string);
        if (bigDecimal == null) {
            this.writeNull();
        } else {
            c = (char)bigDecimal.scale();
            String string2 = this.isEnabled(SerializerFeature.WriteBigDecimalAsPlain) && c >= '\uffffff9c' && c < 'd' ? bigDecimal.toPlainString() : bigDecimal.toString();
            this.write(string2);
        }
    }

    public void writeString(String string, char c) {
        if (this.useSingleQuotes) {
            SerializeWriter serializeWriter = this;
            serializeWriter.writeStringWithSingleQuote(string);
            serializeWriter.write(c);
        } else {
            this.writeStringWithDoubleQuote(string, c);
        }
    }

    public void writeString(String string) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote(string);
        } else {
            this.writeStringWithDoubleQuote(string, '\u0000');
        }
    }

    public void writeString(char[] cArray) {
        if (((SerializeWriter)((Object)string2)).useSingleQuotes) {
            ((SerializeWriter)((Object)string2)).writeStringWithSingleQuote(cArray);
        } else {
            String string;
            SerializeWriter serializeWriter = string2;
            String string2 = string;
            string = new String(cArray);
            serializeWriter.writeStringWithDoubleQuote(string2, '\u0000');
        }
    }

    protected void writeStringWithSingleQuote(String string) {
        int n;
        if (string == null) {
            int n2 = ((SerializeWriter)object).count + 4;
            if (n2 > ((SerializeWriter)object).buf.length) {
                ((SerializeWriter)object).expandCapacity(n2);
            }
            SerializeWriter serializeWriter = object;
            Object object = serializeWriter.buf;
            int n3 = serializeWriter.count;
            "null".getChars(0, 4, (char[])object, n3);
            serializeWriter.count = n2;
            return;
        }
        int n4 = string.length();
        int n5 = ((SerializeWriter)object).count + n4 + 2;
        if (n5 > ((SerializeWriter)object).buf.length) {
            if (((SerializeWriter)object).writer != null) {
                ((SerializeWriter)object).write(39);
                for (n4 = 0; n4 < string.length(); ++n4) {
                    char c = string.charAt(n4);
                    n5 = c;
                    if (!(c <= '\r' || n5 == 92 || n5 == 39 || n5 == 47 && ((SerializeWriter)object).isEnabled(SerializerFeature.WriteSlashAsSpecial))) {
                        ((SerializeWriter)object).write(n5);
                        continue;
                    }
                    Object object = object;
                    ((SerializeWriter)object).write(92);
                    ((SerializeWriter)object).write(IOUtils.replaceChars[n5]);
                }
                ((SerializeWriter)object).write(39);
                return;
            }
            ((SerializeWriter)object).expandCapacity(n5);
        }
        Object object = object;
        int n6 = ((SerializeWriter)object).count;
        int n7 = n6 + 1;
        int n8 = n7 + n4;
        char[] cArray = ((SerializeWriter)object).buf;
        ((SerializeWriter)object).buf[n6] = 39;
        string.getChars(0, n4, cArray, n7);
        ((SerializeWriter)object).count = n5;
        n6 = 0;
        n4 = -1;
        int n9 = 0;
        for (n = n7; n < n8; ++n) {
            int n10 = ((SerializeWriter)object).buf[n];
            if (n10 > 13 && n10 != 92 && n10 != 39 && (n10 != 47 || !((SerializeWriter)object).isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            ++n6;
            n9 = n10;
            n4 = n;
        }
        if ((n5 += n6) > ((SerializeWriter)object).buf.length) {
            ((SerializeWriter)object).expandCapacity(n5);
        }
        ((SerializeWriter)object).count = n5;
        if (n6 == 1) {
            Object object2 = object;
            int n11 = n4;
            n6 = n11 + 1;
            n5 = n4 + 2;
            n7 = n8 - n11 - 1;
            System.arraycopy(((SerializeWriter)object2).buf, n6, ((SerializeWriter)object2).buf, n5, n7);
            ((SerializeWriter)object2).buf[n4] = 92;
            ((SerializeWriter)object2).buf[n6] = IOUtils.replaceChars[n9];
        } else if (n6 > 1) {
            char[] cArray2 = ((SerializeWriter)object).buf;
            n5 = n4 + 1;
            int n12 = n4;
            int n13 = n12 + 2;
            System.arraycopy(cArray2, n5, cArray2, n13, n8 - n12 - 1);
            ((SerializeWriter)object).buf[n4] = 92;
            ((SerializeWriter)object).buf[n5] = IOUtils.replaceChars[n9];
            n13 = n8 + 1;
            for (n4 = n5 - 2; n4 >= n7; --n4) {
                n5 = ((SerializeWriter)object).buf[n4];
                if (n5 > 13 && n5 != 92 && n5 != 39 && (n5 != 47 || !((SerializeWriter)object).isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                Object object3 = object;
                int n14 = n4;
                n8 = n14 + 1;
                n9 = n4 + 2;
                n = n13 - n14 - 1;
                System.arraycopy(((SerializeWriter)object3).buf, n8, ((SerializeWriter)object3).buf, n9, n);
                ((SerializeWriter)object3).buf[n4] = 92;
                ((SerializeWriter)object3).buf[n8] = IOUtils.replaceChars[n5];
                ++n13;
            }
        }
        ((SerializeWriter)object).buf[((SerializeWriter)object).count - 1] = 39;
    }

    protected void writeStringWithSingleQuote(char[] cArray) {
        int n;
        if (cArray == null) {
            int n2 = ((SerializeWriter)object).count + 4;
            if (n2 > ((SerializeWriter)object).buf.length) {
                ((SerializeWriter)object).expandCapacity(n2);
            }
            SerializeWriter serializeWriter = object;
            Object object = serializeWriter.buf;
            int n3 = serializeWriter.count;
            "null".getChars(0, 4, (char[])object, n3);
            serializeWriter.count = n2;
            return;
        }
        int n4 = cArray.length;
        int n5 = ((SerializeWriter)object).count + n4 + 2;
        if (n5 > ((SerializeWriter)object).buf.length) {
            if (((SerializeWriter)object).writer != null) {
                ((SerializeWriter)object).write(39);
                for (n4 = 0; n4 < cArray.length; ++n4) {
                    n5 = cArray[n4];
                    if (!(n5 <= 13 || n5 == 92 || n5 == 39 || n5 == 47 && ((SerializeWriter)object).isEnabled(SerializerFeature.WriteSlashAsSpecial))) {
                        ((SerializeWriter)object).write(n5);
                        continue;
                    }
                    Object object = object;
                    ((SerializeWriter)object).write(92);
                    ((SerializeWriter)object).write(IOUtils.replaceChars[n5]);
                }
                ((SerializeWriter)object).write(39);
                return;
            }
            ((SerializeWriter)object).expandCapacity(n5);
        }
        Object object = object;
        int n6 = ((SerializeWriter)object).count;
        int n7 = n6 + 1;
        n4 = n7 + n4;
        char[] cArray2 = ((SerializeWriter)object).buf;
        ((SerializeWriter)object).buf[n6] = 39;
        n6 = cArray.length;
        System.arraycopy(cArray, 0, cArray2, n7, n6);
        ((SerializeWriter)object).count = n5;
        n6 = 0;
        int n8 = -1;
        int n9 = 0;
        for (n = n7; n < n4; ++n) {
            int n10 = ((SerializeWriter)object).buf[n];
            if (n10 > 13 && n10 != 92 && n10 != 39 && (n10 != 47 || !((SerializeWriter)object).isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            ++n6;
            n9 = n10;
            n8 = n;
        }
        if ((n5 += n6) > ((SerializeWriter)object).buf.length) {
            ((SerializeWriter)object).expandCapacity(n5);
        }
        ((SerializeWriter)object).count = n5;
        if (n6 == 1) {
            Object object2 = object;
            int n11 = n4;
            int n12 = n8;
            n6 = n12 + 1;
            n4 = n8 + 2;
            n5 = n11 - n12 - 1;
            System.arraycopy(((SerializeWriter)object2).buf, n6, ((SerializeWriter)object2).buf, n4, n5);
            ((SerializeWriter)object2).buf[n8] = 92;
            ((SerializeWriter)object2).buf[n6] = IOUtils.replaceChars[n9];
        } else if (n6 > 1) {
            char[] cArray3 = ((SerializeWriter)object).buf;
            n5 = n8 + 1;
            int n13 = n8;
            int n14 = n13 + 2;
            System.arraycopy(cArray3, n5, cArray3, n14, n4 - n13 - 1);
            ((SerializeWriter)object).buf[n8] = 92;
            ((SerializeWriter)object).buf[n5] = IOUtils.replaceChars[n9];
            n14 = n4 + 1;
            for (n4 = n5 - 2; n4 >= n7; --n4) {
                n5 = ((SerializeWriter)object).buf[n4];
                if (n5 > 13 && n5 != 92 && n5 != 39 && (n5 != 47 || !((SerializeWriter)object).isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                Object object3 = object;
                int n15 = n4;
                n8 = n15 + 1;
                n9 = n4 + 2;
                n = n14 - n15 - 1;
                System.arraycopy(((SerializeWriter)object3).buf, n8, ((SerializeWriter)object3).buf, n9, n);
                ((SerializeWriter)object3).buf[n4] = 92;
                ((SerializeWriter)object3).buf[n8] = IOUtils.replaceChars[n5];
                ++n14;
            }
        }
        ((SerializeWriter)object).buf[((SerializeWriter)object).count - 1] = 39;
    }

    public void writeFieldName(String string) {
        this.writeFieldName(string, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeFieldName(String string, boolean bl) {
        if (string == null) {
            this.write("null:");
            return;
        }
        if (this.useSingleQuotes) {
            if (this.quoteFieldNames) {
                SerializeWriter serializeWriter = this;
                serializeWriter.writeStringWithSingleQuote(string);
                serializeWriter.write(58);
                return;
            }
            this.writeKeyWithSingleQuoteIfHasSpecial(string);
            return;
        }
        if (!this.quoteFieldNames) {
            bl = string.length() == 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!(c < '@' && (this.sepcialBits & 1L << c) != 0L || c == '\\')) continue;
                bl = true;
                break;
            }
            if (!bl) {
                SerializeWriter serializeWriter = this;
                serializeWriter.write(string);
                serializeWriter.write(58);
                return;
            }
        }
        this.writeStringWithDoubleQuote(string, ':');
    }

    @Override
    public void flush() {
        int n;
        SerializeWriter serializeWriter;
        Writer writer;
        SerializeWriter serializeWriter2;
        Writer writer2 = ((SerializeWriter)object).writer;
        if (writer2 == null) {
            return;
        }
        try {
            SerializeWriter serializeWriter3 = object;
            serializeWriter2 = serializeWriter3;
            SerializeWriter serializeWriter4 = serializeWriter3;
            writer = writer2;
            SerializeWriter serializeWriter5 = object;
            serializeWriter = serializeWriter5;
            Object object = serializeWriter5.buf;
            n = 0;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
        int n2 = serializeWriter.count;
        writer.write((char[])object, n, n2);
        serializeWriter2.writer.flush();
        serializeWriter4.count = 0;
    }

    public void reset() {
        this.count = 0;
    }
}

