/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

public class AntiCollisionHashMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int M_MASK = -2023358765;
    static final int SEED = -2128831035;
    static final int KEY = 16777619;
    private static final long serialVersionUID = 362498820763181265L;
    volatile transient Set<K> keySet;
    volatile transient Collection<V> values;
    transient Entry<K, V>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    final int random;
    private transient Set<Map.Entry<K, V>> entrySet;

    private int hashString(String string) {
        int n = this.random * -2128831035;
        for (int i = 0; i < string.length(); ++i) {
            n = n * 16777619 ^ string.charAt(i);
        }
        int n2 = n;
        return (n2 ^ n2 >> 1) & 0x8765FED3;
    }

    public AntiCollisionHashMap(int n, float f) {
        this.keySet = null;
        this.values = null;
        this.random = new Random().nextInt(99999);
        this.entrySet = null;
        if (n >= 0) {
            if (n > 0x40000000) {
                n = 0x40000000;
            }
            if (!(f <= 0.0f) && !Float.isNaN(f)) {
                int n2;
                for (n2 = 1; n2 < n; n2 <<= 1) {
                }
                this.loadFactor = f;
                this.threshold = (int)((float)n2 * f);
                this.table = new Entry[n2];
                this.init();
                return;
            }
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        throw new IllegalArgumentException("Illegal initial capacity: " + n);
    }

    public AntiCollisionHashMap(int n) {
        this(n, 0.75f);
    }

    public AntiCollisionHashMap() {
        AntiCollisionHashMap antiCollisionHashMap = this;
        antiCollisionHashMap.keySet = null;
        antiCollisionHashMap.values = null;
        antiCollisionHashMap.random = new Random().nextInt(99999);
        antiCollisionHashMap.entrySet = null;
        antiCollisionHashMap.loadFactor = 0.75f;
        antiCollisionHashMap.threshold = 12;
        antiCollisionHashMap.table = new Entry[16];
        antiCollisionHashMap.init();
    }

    public AntiCollisionHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        super.putAllForCreate(map);
    }

    static int hash(int n) {
        int n2 = n;
        n = n2 * n2;
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    private V getForNullKey() {
        Entry entry = ((AntiCollisionHashMap)((Object)entry)).table[0];
        while (entry != null) {
            if (entry.key == null) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private V putForNullKey(V v) {
        Entry<K, V> entry = this.table[0];
        while (entry != null) {
            if (entry.key == null) {
                entry.value = v;
                return entry.value;
            }
            entry = entry.next;
        }
        AntiCollisionHashMap antiCollisionHashMap = this;
        ++antiCollisionHashMap.modCount;
        antiCollisionHashMap.addEntry(0, null, v, 0);
        return null;
    }

    private void putForCreate(K k, V v) {
        int n = k == null ? 0 : (k instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)k)) : AntiCollisionHashMap.hash(k.hashCode()));
        int n2 = AntiCollisionHashMap.indexFor(n, this.table.length);
        Entry<K, V> entry = this.table[n2];
        while (entry != null) {
            Object k2;
            if (entry.hash == n && ((k2 = entry.key) == k || k != null && k.equals(k2))) {
                entry.value = v;
                return;
            }
            entry = entry.next;
        }
        this.createEntry(n, k, v, n2);
    }

    private void putAllForCreate(Map<? extends K, ? extends V> object) {
        for (Map.Entry entry : object.entrySet()) {
            Object k = entry.getKey();
            this.putForCreate(k, entry.getValue());
        }
    }

    private boolean containsNullValue() {
        Entry<K, V>[] entryArray = entryArray.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<K, V> entry = entryArray[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private Set<Map.Entry<K, V>> entrySet0() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            EntrySet entrySet2;
            entrySet = entrySet2;
            entrySet2 = new EntrySet();
            this.entrySet = entrySet;
        }
        return entrySet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        Iterator<Map.Entry<K, V>> iterator = ((AntiCollisionHashMap)((Object)entry)).size > 0 ? ((AntiCollisionHashMap)((Object)entry)).entrySet0().iterator() : null;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(((AntiCollisionHashMap)((Object)entry)).table.length);
        objectOutputStream.writeInt(((AntiCollisionHashMap)((Object)entry)).size);
        if (iterator != null) {
            while (iterator.hasNext()) {
                ObjectOutputStream objectOutputStream2 = objectOutputStream;
                Map.Entry<K, V> entry = iterator.next();
                objectOutputStream2.writeObject(entry.getKey());
                objectOutputStream2.writeObject(entry.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.table = new Entry[objectInputStream2.readInt()];
        this.init();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            ObjectInputStream objectInputStream3 = objectInputStream;
            Object object = objectInputStream3.readObject();
            this.putForCreate(object, objectInputStream3.readObject());
        }
    }

    void init() {
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return ((AntiCollisionHashMap)((Object)entry)).getForNullKey();
        }
        int n = object instanceof String ? AntiCollisionHashMap.hash(((AntiCollisionHashMap)((Object)entry)).hashString((String)object)) : AntiCollisionHashMap.hash(object.hashCode());
        Entry entry = ((AntiCollisionHashMap)((Object)entry)).table[AntiCollisionHashMap.indexFor(n, ((AntiCollisionHashMap)((Object)entry)).table.length)];
        while (entry != null) {
            Object k;
            if (entry.hash == n && ((k = entry.key) == object || object.equals(k))) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    final Entry<K, V> getEntry(Object object) {
        int n = object == null ? 0 : (object instanceof String ? AntiCollisionHashMap.hash(((AntiCollisionHashMap)((Object)entry)).hashString((String)object)) : AntiCollisionHashMap.hash(object.hashCode()));
        Entry entry = ((AntiCollisionHashMap)((Object)entry)).table[AntiCollisionHashMap.indexFor(n, ((AntiCollisionHashMap)((Object)entry)).table.length)];
        while (entry != null) {
            Object k;
            if (entry.hash == n && ((k = entry.key) == object || object != null && object.equals(k))) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            return this.putForNullKey(v);
        }
        int n = k instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)k)) : AntiCollisionHashMap.hash(k.hashCode());
        int n2 = AntiCollisionHashMap.indexFor(n, this.table.length);
        Entry<K, V> entry = this.table[n2];
        while (entry != null) {
            Object k2;
            if (entry.hash == n && ((k2 = entry.key) == k || k.equals(k2))) {
                entry.value = v;
                return entry.value;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n, k, v, n2);
        return null;
    }

    void resize(int n) {
        if (this.table.length == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray = new Entry[n];
        this.transfer(entryArray);
        this.table = entryArray;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    void transfer(Entry[] entryArray) {
        Entry<K, V>[] entryArray2 = entryArray2.table;
        int n = entryArray.length;
        block0: for (int i = 0; i < entryArray2.length; ++i) {
            Entry<K, V> entry = entryArray2[i];
            if (entry == null) continue;
            entryArray2[i] = null;
            while (true) {
                Entry entry2 = entry.next;
                int n2 = AntiCollisionHashMap.indexFor(entry.hash, n);
                entry.next = entryArray[n2];
                entryArray[n2] = entry;
                if (entry2 == null) continue block0;
                entry = entry2;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> object) {
        int n = object.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            int n2;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n; n2 <<= 1) {
            }
            if (n2 > this.table.length) {
                this.resize(n2);
            }
        }
        for (Map.Entry entry : object.entrySet()) {
            Object k = entry.getKey();
            this.put(k, entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        return (this = ((AntiCollisionHashMap)this).removeEntryForKey(object)) == null ? null : (V)((Entry)this).value;
    }

    final Entry<K, V> removeEntryForKey(Object object) {
        Entry<K, V> entry;
        int n = object == null ? 0 : (object instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)object)) : AntiCollisionHashMap.hash(object.hashCode()));
        int n2 = AntiCollisionHashMap.indexFor(n, this.table.length);
        Entry<K, V> entry2 = entry = this.table[n2];
        while (entry != null) {
            Object k;
            Entry<K, V> entry3 = entry;
            Entry entry4 = entry3.next;
            if (entry3.hash == n && ((k = entry.key) == object || object != null && object.equals(k))) {
                AntiCollisionHashMap antiCollisionHashMap = this;
                ++antiCollisionHashMap.modCount;
                --antiCollisionHashMap.size;
                if (entry2 == entry) {
                    this.table[n2] = entry4;
                } else {
                    entry2.next = entry4;
                }
                return entry;
            }
            entry2 = entry;
            entry = entry4;
        }
        return entry;
    }

    final Entry<K, V> removeMapping(Object object) {
        Entry<K, V> entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Object k = (object = (Map.Entry)object).getKey();
        int n = k == null ? 0 : (k instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)k)) : AntiCollisionHashMap.hash(k.hashCode()));
        int n2 = AntiCollisionHashMap.indexFor(n, this.table.length);
        Entry<K, V> entry2 = entry = this.table[n2];
        while (entry != null) {
            Entry<K, V> entry3 = entry;
            Entry entry4 = entry3.next;
            if (entry3.hash == n && entry.equals(object)) {
                AntiCollisionHashMap antiCollisionHashMap = this;
                ++antiCollisionHashMap.modCount;
                --antiCollisionHashMap.size;
                if (entry2 == entry) {
                    this.table[n2] = entry4;
                } else {
                    entry2.next = entry4;
                }
                return entry;
            }
            entry2 = entry;
            entry = entry4;
        }
        return entry;
    }

    @Override
    public void clear() {
        AntiCollisionHashMap antiCollisionHashMap = this;
        ++antiCollisionHashMap.modCount;
        Entry<K, V>[] entryArray = antiCollisionHashMap.table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return entryArray.containsNullValue();
        }
        Entry<K, V>[] entryArray = entryArray.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<K, V> entry = entryArray[i];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        AntiCollisionHashMap antiCollisionHashMap = null;
        try {
            antiCollisionHashMap = (AntiCollisionHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        AntiCollisionHashMap antiCollisionHashMap2 = antiCollisionHashMap;
        antiCollisionHashMap.table = new Entry[this.table.length];
        antiCollisionHashMap.entrySet = null;
        antiCollisionHashMap.modCount = 0;
        antiCollisionHashMap.size = 0;
        antiCollisionHashMap.init();
        antiCollisionHashMap2.putAllForCreate(this);
        return antiCollisionHashMap2;
    }

    void addEntry(int n, K k, V v, int n2) {
        Entry<K, V> entry;
        AntiCollisionHashMap antiCollisionHashMap = this;
        Entry<K, V> entry2 = antiCollisionHashMap.table[n2];
        Entry<K, V> entry3 = entry;
        entry = new Entry<K, V>(n, k, v, entry2);
        antiCollisionHashMap.table[n2] = entry3;
        n = antiCollisionHashMap.size;
        this.size = n + 1;
        if (n >= this.threshold) {
            AntiCollisionHashMap antiCollisionHashMap2 = this;
            antiCollisionHashMap2.resize(antiCollisionHashMap2.table.length * 2);
        }
    }

    void createEntry(int n, K k, V v, int n2) {
        Entry<K, V> entry;
        AntiCollisionHashMap antiCollisionHashMap = entry2;
        Entry<K, V> entry2 = antiCollisionHashMap.table[n2];
        Entry<K, V> entry3 = entry;
        entry = new Entry<K, V>(n, k, v, entry2);
        antiCollisionHashMap.table[n2] = entry3;
        ++antiCollisionHashMap.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        if (keySet == null) {
            KeySet keySet2;
            keySet = keySet2;
            keySet2 = new KeySet();
            this.keySet = keySet;
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        if (values == null) {
            Values values2;
            values = values2;
            values2 = new Values();
            this.values = values;
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet0();
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AntiCollisionHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object entry) {
            if (!(entry instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry2 = entry;
            return (entry = ((EntrySet)((Object)entry2)).AntiCollisionHashMap.this.getEntry(entry2.getKey())) != null && entry.equals(entry2);
        }

        @Override
        public boolean remove(Object object) {
            return AntiCollisionHashMap.this.removeMapping(object) != null;
        }

        @Override
        public int size() {
            return AntiCollisionHashMap.this.size;
        }

        @Override
        public void clear() {
            AntiCollisionHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return AntiCollisionHashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return AntiCollisionHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return AntiCollisionHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            AntiCollisionHashMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return AntiCollisionHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return AntiCollisionHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return AntiCollisionHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return AntiCollisionHashMap.this.removeEntryForKey(object) != null;
        }

        @Override
        public void clear() {
            AntiCollisionHashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K, V> next;
        int expectedModCount;
        int index;
        Entry<K, V> current;

        HashIterator() {
            this.expectedModCount = AntiCollisionHashMap.this.modCount;
            if (AntiCollisionHashMap.this.size > 0) {
                int n;
                AntiCollisionHashMap.this = AntiCollisionHashMap.this.table;
                while ((n = this.index) < AntiCollisionHashMap.this.length) {
                    this.index = n + 1;
                    this.next = AntiCollisionHashMap.this[n];
                    if (this.next == null) continue;
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            if (AntiCollisionHashMap.this.modCount == this.expectedModCount) {
                Entry entry = this.next;
                if (entry != null) {
                    this.next = entry.next;
                    if (this.next == null) {
                        int n;
                        Entry<K, V>[] entryArray = AntiCollisionHashMap.this.table;
                        while ((n = this.index) < entryArray.length) {
                            this.index = n + 1;
                            this.next = entryArray[n];
                            if (this.next == null) continue;
                        }
                    }
                    this.current = entry;
                    return entry;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public void remove() {
            if (hashIterator2.current != null) {
                if (hashIterator2.AntiCollisionHashMap.this.modCount == hashIterator2.expectedModCount) {
                    HashIterator hashIterator = hashIterator2;
                    HashIterator<Object> hashIterator2 = hashIterator.current.key;
                    hashIterator.current = null;
                    hashIterator.AntiCollisionHashMap.this.removeEntryForKey(hashIterator2);
                    hashIterator.expectedModCount = hashIterator.AntiCollisionHashMap.this.modCount;
                    return;
                }
                throw new ConcurrentModificationException();
            }
            throw new IllegalStateException();
        }
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        Entry<K, V> next;
        final int hash;

        Entry(int n, K k, V v, Entry<K, V> entry) {
            this.value = v;
            this.next = entry;
            this.key = k;
            this.hash = n;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V v) {
            this.value = v;
            return this.value;
        }

        @Override
        public final boolean equals(Object object) {
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            object = (Map.Entry)object;
            K k2 = this.getKey();
            return (k2 == (k = object.getKey()) || k2 != null && k2.equals(k)) && ((this = this.getValue()) == (object = object.getValue()) || this != null && ((Object)this).equals(object));
            {
            }
        }

        @Override
        public final int hashCode() {
            K k = entry.key;
            int n = k == null ? 0 : k.hashCode();
            Entry<K, V> entry = entry.value;
            int n2 = entry == null ? 0 : ((Object)entry).hashCode();
            return n ^ n2;
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

