/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import com.tradplus.ads.common.serialization.JSONException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Properties;

public class IOUtils {
    public static final String FASTJSON_PROPERTIES = "fastjson.properties";
    public static final String FASTJSON_COMPATIBLEWITHJAVABEAN = "fastjson.compatibleWithJavaBean";
    public static final String FASTJSON_COMPATIBLEWITHFIELDNAME = "fastjson.compatibleWithFieldName";
    public static final Properties DEFAULT_PROPERTIES;
    public static final Charset UTF8;
    public static final char[] DIGITS;
    public static final boolean[] firstIdentifierFlags;
    public static final boolean[] identifierFlags;
    public static final byte[] specicalFlags_doubleQuotes;
    public static final byte[] specicalFlags_singleQuotes;
    public static final boolean[] specicalFlags_doubleQuotesFlags;
    public static final boolean[] specicalFlags_singleQuotesFlags;
    public static final char[] replaceChars;
    public static final char[] ASCII_CHARS;
    static final char[] digits;
    static final char[] DigitTens;
    static final char[] DigitOnes;
    static final int[] sizeTable;
    public static final char[] CA;
    public static final int[] IA;

    public static String getStringProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {}
        if (string2 == null) {
            string2 = DEFAULT_PROPERTIES.getProperty(string);
        }
        return string2;
    }

    public static void loadPropertiesFromFile() {
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
                }
                return ClassLoader.getSystemResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
            }
        });
        if (inputStream != null) {
            try {
                DEFAULT_PROPERTIES.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int stringSize(long l) {
        long l2 = 10L;
        for (int i = 1; i < 19; ++i) {
            if (l < l2) {
                return i;
            }
            l2 *= 10L;
        }
        return 19;
    }

    public static void getChars(long l, int n, char[] cArray) {
        int n2;
        int n3 = 0;
        if (l < 0L) {
            n3 = 45;
            l = -l;
        }
        while (l > Integer.MAX_VALUE) {
            long l2 = l;
            l = l2 / 100L;
            int n4 = (int)(l2 - ((l << 6) + (l << 5) + (l << 2)));
            cArray[n += -1] = DigitOnes[n4];
            cArray[n += -1] = DigitTens[n4];
        }
        int n5 = (int)l;
        while (n5 >= 65536) {
            int n6 = n5;
            n5 = n6 / 100;
            n2 = n6 - ((n5 << 6) + (n5 << 5) + (n5 << 2));
            cArray[n += -1] = DigitOnes[n2];
            cArray[n += -1] = DigitTens[n2];
        }
        while (true) {
            n2 = n5 * 52429 >>> 19;
            cArray[n += -1] = digits[n5 -= (n2 << 3) + (n2 << 1)];
            if (n2 == 0) {
                if (n3 != 0) {
                    cArray[n + -1] = n3;
                }
                return;
            }
            n5 = n2;
        }
    }

    public static void getChars(int n, int n2, char[] cArray) {
        int n3;
        int n4 = 0;
        if (n < 0) {
            n4 = 45;
            n = -n;
        }
        while (n >= 65536) {
            int n5 = n;
            n = n5 / 100;
            n3 = n5 - ((n << 6) + (n << 5) + (n << 2));
            cArray[n2 += -1] = DigitOnes[n3];
            cArray[n2 += -1] = DigitTens[n3];
        }
        while (true) {
            n3 = n * 52429 >>> 19;
            cArray[n2 += -1] = digits[n -= (n3 << 3) + (n3 << 1)];
            if (n3 == 0) {
                if (n4 != 0) {
                    cArray[n2 + -1] = n4;
                }
                return;
            }
            n = n3;
        }
    }

    public static void getChars(byte by, int n, char[] cArray) {
        int n2 = 0;
        if (by < 0) {
            n2 = 45;
            by = -by;
        }
        while (true) {
            int n3 = by * 52429 >>> 19;
            by = (byte)(by - ((n3 << 3) + (n3 << 1)));
            cArray[n += -1] = digits[by];
            if (n3 == 0) {
                if (n2 != 0) {
                    cArray[n + -1] = n2;
                }
                return;
            }
            by = (byte)n3;
        }
    }

    public static int stringSize(int n) {
        int n2 = 0;
        while (n > sizeTable[n2]) {
            ++n2;
        }
        return n2 + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dd(CharsetDecoder object, ByteBuffer object2, CharBuffer charBuffer) {
        try {
            object2 = ((CharsetDecoder)object).decode((ByteBuffer)object2, charBuffer, true);
            if (!((CoderResult)object2).isUnderflow()) {
                ((CoderResult)object2).throwException();
            }
            if (!((CoderResult)(object = ((CharsetDecoder)object).flush(charBuffer))).isUnderflow()) {
                ((CoderResult)object).throwException();
            }
            return;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new JSONException("utf8 decode error, " + characterCodingException.getMessage(), characterCodingException);
        }
    }

    public static boolean firstIdentifier(char c) {
        boolean[] blArray = firstIdentifierFlags;
        return c < firstIdentifierFlags.length && blArray[c];
    }

    public static boolean isIdent(char c) {
        boolean[] blArray = identifierFlags;
        return c < identifierFlags.length && blArray[c];
    }

    public static byte[] ddb(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = n + n2 - 1;
        while (n < n3 && IA[cArray[n]] < 0) {
            ++n;
        }
        while (n3 > 0 && IA[cArray[n3]] < 0) {
            --n3;
        }
        int n4 = cArray[n3] == '=' ? (cArray[n3 - 1] == '=' ? 2 : 1) : 0;
        int n5 = n2;
        n2 = n3 - n + 1;
        int n6 = n5 > 76 ? (cArray[76] == '\r' ? n2 / 78 : 0) << 1 : 0;
        n2 = ((n2 - n6) * 6 >> 3) - n4;
        byte[] byArray = new byte[n2];
        int n7 = 0;
        int n8 = 0;
        int n9 = n2 / 3 * 3;
        while (n7 < n9) {
            int n10;
            int[] nArray = IA;
            int n11 = IA[cArray[n++]] << 18 | nArray[cArray[n++]] << 12 | nArray[cArray[n++]] << 6 | nArray[cArray[n++]];
            int n12 = n10 = n11;
            byArray[n7++] = (byte)(n10 >> 16);
            n10 = n7 + 1;
            byArray[n7] = (byte)(n12 >> 8);
            n7 = n10 + 1;
            byArray[n10] = (byte)n11;
            if (n6 <= 0 || ++n8 != 19) continue;
            n += 2;
            n8 = 0;
        }
        if (n7 < n2) {
            n6 = 0;
            n8 = 0;
            while (n <= n3 - n4) {
                n6 |= IA[cArray[n++]] << 18 - n8 * 6;
                ++n8;
            }
            int n13 = 16;
            while (n7 < n2) {
                byArray[n7++] = (byte)(n6 >> n13);
                n13 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] ddb(String string, int n, int n2) {
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = n + n2 - 1;
        while (n < n3 && IA[string.charAt(n)] < 0) {
            ++n;
        }
        while (n3 > 0 && IA[string.charAt(n3)] < 0) {
            --n3;
        }
        int n4 = string.charAt(n3) == '=' ? (string.charAt(n3 - 1) == '=' ? 2 : 1) : 0;
        int n5 = n2;
        n2 = n3 - n + 1;
        int n6 = n5 > 76 ? (string.charAt(76) == '\r' ? n2 / 78 : 0) << 1 : 0;
        n2 = ((n2 - n6) * 6 >> 3) - n4;
        byte[] byArray = new byte[n2];
        int n7 = 0;
        int n8 = 0;
        int n9 = n2 / 3 * 3;
        while (n7 < n9) {
            int n10;
            int[] nArray = IA;
            int n11 = IA[string.charAt(n++)] << 18 | nArray[string.charAt(n++)] << 12 | nArray[string.charAt(n++)] << 6 | nArray[string.charAt(n++)];
            int n12 = n10 = n11;
            byArray[n7++] = (byte)(n10 >> 16);
            n10 = n7 + 1;
            byArray[n7] = (byte)(n12 >> 8);
            n7 = n10 + 1;
            byArray[n10] = (byte)n11;
            if (n6 <= 0 || ++n8 != 19) continue;
            n += 2;
            n8 = 0;
        }
        if (n7 < n2) {
            n6 = 0;
            n8 = 0;
            while (n <= n3 - n4) {
                n6 |= IA[string.charAt(n++)] << 18 - n8 * 6;
                ++n8;
            }
            int n13 = 16;
            while (n7 < n2) {
                byArray[n7++] = (byte)(n6 >> n13);
                n13 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] ddb(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = n2 - 1;
        for (n = 0; n < n3 && IA[string.charAt(n) & 0xFF] < 0; ++n) {
        }
        while (n3 > 0 && IA[string.charAt(n3) & 0xFF] < 0) {
            --n3;
        }
        int n4 = string.charAt(n3) == '=' ? (string.charAt(n3 - 1) == '=' ? 2 : 1) : 0;
        int n5 = n2;
        n2 = n3 - n + 1;
        int n6 = n5 > 76 ? (string.charAt(76) == '\r' ? n2 / 78 : 0) << 1 : 0;
        n2 = ((n2 - n6) * 6 >> 3) - n4;
        byte[] byArray = new byte[n2];
        int n7 = 0;
        int n8 = 0;
        int n9 = n2 / 3 * 3;
        while (n7 < n9) {
            int n10;
            int[] nArray = IA;
            int n11 = IA[string.charAt(n++)] << 18 | nArray[string.charAt(n++)] << 12 | nArray[string.charAt(n++)] << 6 | nArray[string.charAt(n++)];
            int n12 = n10 = n11;
            byArray[n7++] = (byte)(n10 >> 16);
            n10 = n7 + 1;
            byArray[n7] = (byte)(n12 >> 8);
            n7 = n10 + 1;
            byArray[n10] = (byte)n11;
            if (n6 <= 0 || ++n8 != 19) continue;
            n += 2;
            n8 = 0;
        }
        if (n7 < n2) {
            n6 = 0;
            n8 = 0;
            while (n <= n3 - n4) {
                n6 |= IA[string.charAt(n++)] << 18 - n8 * 6;
                ++n8;
            }
            int n13 = 16;
            while (n7 < n2) {
                byArray[n7++] = (byte)(n6 >> n13);
                n13 -= 8;
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int edu(char[] cArray, int n, int n2, byte[] byArray) {
        int n3 = n2;
        n2 = n + n2;
        int n4 = 0;
        int n5 = Math.min(n3, byArray.length) + n4;
        while (n4 < n5 && cArray[n] < '\u0080') {
            byArray[n4++] = (byte)cArray[n++];
        }
        while (true) {
            block13: {
                block12: {
                    block14: {
                        if (n >= n2) {
                            return n4;
                        }
                        n5 = n + 1;
                        if ((n = cArray[n]) < 128) {
                            int n6 = n;
                            n = n4 + 1;
                            byArray[n4] = (byte)n6;
                            n4 = n;
                            n = n5;
                            continue;
                        }
                        if (n < 2048) {
                            int n7 = n;
                            int n8 = n;
                            n = n4 + 1;
                            byArray[n4] = (byte)(n8 >> 6 | 0xC0);
                            n4 = n + 1;
                            byArray[n] = (byte)(n7 & 0x3F | 0x80);
                            n = n5;
                            continue;
                        }
                        if (n < 55296 || n >= 57344) break block13;
                        int n9 = n5 - 1;
                        if (n < 55296 || n >= 56320) break block14;
                        if (n2 - n9 < 2) {
                            n = -1;
                            break block12;
                        } else if ((n9 = cArray[n9 + 1]) >= 56320 && n9 < 57344) {
                            n = (n << 10) + n9 + -56613888;
                            break block12;
                        } else {
                            n = n4 + 1;
                            byArray[n4] = 63;
                            n4 = n;
                            n = n5;
                            continue;
                        }
                    }
                    if (n >= 56320 && n < 57344) {
                        n = n4 + 1;
                        byArray[n4] = 63;
                        n4 = n;
                        n = n5;
                        continue;
                    }
                }
                if (n < 0) {
                    n = n4 + 1;
                    byArray[n4] = 63;
                } else {
                    int n10 = n;
                    int n11 = n;
                    int n12 = n;
                    int n13 = n;
                    n = n4 + 1;
                    byArray[n4] = (byte)(n13 >> 18 | 0xF0);
                    n4 = n + 1;
                    byArray[n] = (byte)(n12 >> 12 & 0x3F | 0x80);
                    n = n4 + 1;
                    byArray[n4] = (byte)(n11 >> 6 & 0x3F | 0x80);
                    n4 = n + 1;
                    byArray[n] = (byte)(n10 & 0x3F | 0x80);
                    ++n5;
                    n = n4;
                }
                n4 = n;
                n = n5;
                continue;
            }
            int n14 = n;
            int n15 = n;
            int n16 = n;
            n = n4 + 1;
            byArray[n4] = (byte)(n16 >> 12 | 0xE0);
            n4 = n + 1;
            byArray[n] = (byte)(n15 >> 6 & 0x3F | 0x80);
            n = n4 + 1;
            byArray[n4] = (byte)(n14 & 0x3F | 0x80);
            n4 = n;
            n = n5;
        }
    }

    public static int ddu(byte[] byArray, int n, int n2, char[] cArray) {
        int n3 = n2;
        n2 = n + n2;
        int n4 = 0;
        int n5 = Math.min(n3, cArray.length);
        while (n4 < n5 && byArray[n] >= 0) {
            cArray[n4++] = (char)byArray[n++];
        }
        while (n < n2) {
            int n6;
            int n7;
            n5 = n + 1;
            if ((n = byArray[n]) >= 0) {
                int n8 = n;
                n = n4 + 1;
                cArray[n4] = (char)n8;
                n4 = n;
                n = n5;
                continue;
            }
            if (n >> 5 == -2 && (n & 0x1E) != 0) {
                if (n5 < n2) {
                    if (((n7 = byArray[n5++]) & 0xC0) != 128) {
                        return -1;
                    }
                    cArray[n4++] = (char)(n << 6 ^ n7 ^ 0xF80);
                    n = n5;
                    continue;
                }
                return -1;
            }
            if (n >> 4 == -2) {
                n7 = n5 + 1;
                if (n7 < n2) {
                    n5 = byArray[n5];
                    n6 = n7 + 1;
                    n7 = byArray[n7];
                    if ((n != -32 || (n5 & 0xE0) != 128) && (n5 & 0xC0) == 128 && (n7 & 0xC0) == 128) {
                        char c = (char)(n << 12 ^ n5 << 6 ^ (n7 ^ 0xFFFE1F80));
                        n = c;
                        if (c >= '\ud800' && n < 57344) {
                            return -1;
                        }
                        n5 = n4 + 1;
                        cArray[n4] = n;
                        n4 = n5;
                        n = n6;
                        continue;
                    }
                    return -1;
                }
                return -1;
            }
            if (n >> 3 == -2) {
                if (n5 + 2 < n2) {
                    byte by = byArray[n5++];
                    int n9 = n;
                    int n10 = n5;
                    n = n10 + 1;
                    n5 = byArray[n10];
                    n7 = byArray[n++];
                    n6 = n9 << 18 ^ by << 12 ^ n5 << 6 ^ (n7 ^ 0x381F80);
                    if ((by & 0xC0) == 128 && (n5 & 0xC0) == 128 && (n7 & 0xC0) == 128 && n6 >= 65536 && n6 < 0x110000) {
                        cArray[n4++] = (char)((n6 >>> 10) + 55232);
                        n5 = n4 + 1;
                        cArray[n4] = (char)((n6 & 0x3FF) + 56320);
                        n4 = n5;
                        continue;
                    }
                    return -1;
                }
                return -1;
            }
            return -1;
        }
        return n4;
    }

    /*
     * Unable to fully structure code
     */
    public static String readAll(Reader var0) {
        var1_2 = v0;
        v0 = new StringBuilder();
        var2_3 = 2048;
        try {
            var3_4 = new char[2048];
        }
        catch (Exception var0_1) {
            throw new JSONException("read string from reader error", var0_1);
        }
        while (true) lbl-1000:
        // 2 sources

        {
            var4_5 = var0.read(var3_4, 0, var2_3);
            if (var4_5 >= 0) ** break block5
            return var1_2.toString();
            break;
        }
        {
            var1_2.append(var3_4, 0, var4_5);
            ** while (true)
        }
    }

    public static boolean isValidJsonpQueryParam(String string) {
        if (string != null && string.length() != 0) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '.' || IOUtils.isIdent(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        int n;
        Object[] objectArray;
        DEFAULT_PROPERTIES = new Properties();
        UTF8 = Charset.forName("UTF-8");
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        firstIdentifierFlags = new boolean[256];
        identifierFlags = new boolean[256];
        int n2 = 0;
        while (true) {
            objectArray = firstIdentifierFlags;
            if (n2 >= firstIdentifierFlags.length) break;
            if (n2 >= 65 && n2 <= 90) {
                objectArray[n2] = true;
            } else if (n2 >= 97 && n2 <= 122) {
                objectArray[n2] = true;
            } else if (n2 == 95 || n2 == 36) {
                objectArray[n2] = true;
            }
            n2 = (char)(n2 + 1);
        }
        n2 = 0;
        while (true) {
            objectArray = identifierFlags;
            if (n2 >= identifierFlags.length) break;
            if (n2 >= 65 && n2 <= 90) {
                objectArray[n2] = true;
            } else if (n2 >= 97 && n2 <= 122) {
                objectArray[n2] = true;
            } else if (n2 == 95) {
                objectArray[n2] = true;
            } else if (n2 >= 48 && n2 <= 57) {
                objectArray[n2] = true;
            }
            n2 = (char)(n2 + 1);
        }
        try {
            IOUtils.loadPropertiesFromFile();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        byte[] byArray = new byte[161];
        specicalFlags_doubleQuotes = byArray;
        byte[] byArray2 = new byte[161];
        objectArray = byArray2;
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray;
        specicalFlags_singleQuotes = (byte[])objectArray;
        specicalFlags_doubleQuotesFlags = new boolean[161];
        specicalFlags_singleQuotesFlags = new boolean[161];
        replaceChars = new char[93];
        byArray3[0] = 4;
        byArray4[1] = 4;
        byArray3[2] = 4;
        byArray4[3] = 4;
        byArray3[4] = 4;
        byArray4[5] = 4;
        byArray3[6] = 4;
        byArray4[7] = 4;
        byArray3[8] = 1;
        byArray4[9] = 1;
        byArray3[10] = 1;
        byArray4[11] = 4;
        byArray3[12] = 1;
        byArray4[13] = 1;
        byArray3[34] = 1;
        byArray4[92] = 1;
        byArray2[0] = 4;
        byArray2[1] = 4;
        byArray2[2] = 4;
        byArray2[3] = 4;
        byArray2[4] = 4;
        byArray2[5] = 4;
        byArray2[6] = 4;
        byArray2[7] = 4;
        byArray2[8] = 1;
        byArray2[9] = 1;
        byArray2[10] = 1;
        byArray2[11] = 4;
        byArray2[12] = 1;
        byArray2[13] = 1;
        byArray2[92] = 1;
        byArray2[39] = 1;
        for (n = 14; n <= 31; ++n) {
            IOUtils.specicalFlags_doubleQuotes[n] = 4;
            IOUtils.specicalFlags_singleQuotes[n] = 4;
        }
        for (n = 127; n < 160; ++n) {
            IOUtils.specicalFlags_doubleQuotes[n] = 4;
            IOUtils.specicalFlags_singleQuotes[n] = 4;
        }
        for (n = 0; n < 161; ++n) {
            objectArray = specicalFlags_doubleQuotesFlags;
            boolean bl = specicalFlags_doubleQuotes[n] != 0;
            objectArray[n] = bl;
            objectArray = specicalFlags_singleQuotesFlags;
            bl = specicalFlags_singleQuotes[n] != 0;
            objectArray[n] = bl;
        }
        char[] cArray = replaceChars;
        char[] cArray2 = replaceChars;
        cArray[0] = 48;
        cArray2[1] = 49;
        cArray[2] = 50;
        cArray2[3] = 51;
        cArray[4] = 52;
        cArray2[5] = 53;
        cArray[6] = 54;
        cArray2[7] = 55;
        cArray[8] = 98;
        cArray2[9] = 116;
        cArray[10] = 110;
        cArray2[11] = 118;
        cArray[12] = 102;
        cArray2[13] = 114;
        cArray[34] = 34;
        cArray2[39] = 39;
        cArray[47] = 47;
        cArray2[92] = 92;
        ASCII_CHARS = new char[]{'0', '0', '0', '1', '0', '2', '0', '3', '0', '4', '0', '5', '0', '6', '0', '7', '0', '8', '0', '9', '0', 'A', '0', 'B', '0', 'C', '0', 'D', '0', 'E', '0', 'F', '1', '0', '1', '1', '1', '2', '1', '3', '1', '4', '1', '5', '1', '6', '1', '7', '1', '8', '1', '9', '1', 'A', '1', 'B', '1', 'C', '1', 'D', '1', 'E', '1', 'F', '2', '0', '2', '1', '2', '2', '2', '3', '2', '4', '2', '5', '2', '6', '2', '7', '2', '8', '2', '9', '2', 'A', '2', 'B', '2', 'C', '2', 'D', '2', 'E', '2', 'F'};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int n3 = CA.length;
        for (n = 0; n < n3; ++n) {
            IOUtils.IA[IOUtils.CA[n]] = n;
        }
        IOUtils.IA[61] = 0;
    }
}

