/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.task;

import com.tradplus.ads.common.task.TPWorker;
import com.tradplus.ads.common.util.LogUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TPTaskManager {
    public static final int TYPE_SINGLE = 1;
    public static final int TYPE_NORMAL = 2;
    public static final int TYPE_NETWORK_REQUEST = 3;
    public static final int TYPE_TCP_LOG = 4;
    public static final int TYPE_IMAGE_TYPE = 5;
    public static final int TYPE_PRELOAD_TASK = 6;
    private static TPTaskManager sSelf;
    private final int IMAGE_POOL_SIZE;
    private ExecutorService mNormalPool = Executors.newCachedThreadPool();
    private ExecutorService mSinglePool = Executors.newSingleThreadExecutor();
    private ExecutorService mNetworkReuqestPool = Executors.newCachedThreadPool();
    private ExecutorService mTcpLogPool = null;
    private ExecutorService mImagePool = null;
    private ExecutorService mOfferPreLoadPool = null;

    protected TPTaskManager() {
        this.IMAGE_POOL_SIZE = 2;
    }

    public static TPTaskManager getInstance() {
        if (sSelf == null) {
            sSelf = new TPTaskManager();
        }
        return sSelf;
    }

    protected static void setInstance(TPTaskManager tPTaskManager) {
        sSelf = tPTaskManager;
    }

    public void run(TPWorker tPWorker, int n) {
        switch (n) {
            default: {
                break;
            }
            case 6: {
                if (this.mOfferPreLoadPool == null) {
                    this.mOfferPreLoadPool = Executors.newSingleThreadExecutor();
                }
                this.mOfferPreLoadPool.execute(tPWorker);
                break;
            }
            case 5: {
                if (this.mImagePool == null) {
                    this.mImagePool = Executors.newFixedThreadPool(2);
                }
                this.mImagePool.execute(tPWorker);
                break;
            }
            case 4: {
                if (this.mTcpLogPool == null) {
                    this.mTcpLogPool = Executors.newSingleThreadExecutor();
                }
                this.mTcpLogPool.execute(tPWorker);
                break;
            }
            case 3: {
                this.mNetworkReuqestPool.execute(tPWorker);
                break;
            }
            case 2: {
                this.mNormalPool.execute(tPWorker);
                break;
            }
            case 1: {
                this.mSinglePool.execute(tPWorker);
            }
        }
    }

    public void run(TPWorker tPWorker) {
        this.run(tPWorker, 2);
    }

    public void run_proxy(Runnable runnable) {
        this.run_proxyDelayed(runnable, 0L);
    }

    public void run_proxyDelayed(final Runnable runnable, final long l) {
        if (runnable != null) {
            TPWorker tPWorker = new TPWorker(){

                @Override
                public void work() {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    LogUtil.ownShow("t", "thread-" + this.getID());
                    runnable.run();
                }
            };
            tPWorker.setID(new Long(System.currentTimeMillis() / 1000L).intValue());
            this.run(tPWorker);
        }
    }

    public void release() {
        TPTaskManager tPTaskManager = this;
        tPTaskManager.mSinglePool.shutdown();
        tPTaskManager.mNormalPool.shutdown();
    }
}

