/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Streams {
    public static void copyContent(InputStream inputStream, OutputStream outputStream) {
        if (inputStream != null && outputStream != null) {
            int n;
            byte[] byArray = new byte[16384];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            return;
        }
        throw new IOException("Unable to copy from or to a null stream.");
    }

    public static void copyContent(InputStream inputStream, OutputStream outputStream, long l) {
        if (inputStream != null && outputStream != null) {
            int n;
            byte[] byArray = new byte[16384];
            long l2 = 0L;
            while ((n = inputStream.read(byArray)) != -1) {
                if ((l2 += (long)n) < l) {
                    outputStream.write(byArray, 0, n);
                    continue;
                }
                throw new IOException("Error copying content: attempted to copy " + l2 + " bytes, with " + l + " maximum.");
            }
            return;
        }
        throw new IOException("Unable to copy from or to a null stream.");
    }

    public static void readStream(InputStream inputStream, byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = byArray.length;
        while ((n = inputStream.read(byArray, n2, n3)) != -1) {
            n2 += n;
            if ((n3 -= n) > 0) continue;
            return;
        }
    }

    public static void closeStream(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {}
    }
}

