/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import java.util.concurrent.TimeUnit;

public class Timer {
    private long mStopTimeNanos;
    private long mStartTimeNanos;
    private State mState = State.STOPPED;

    public void start() {
        Timer timer = this;
        timer.mStartTimeNanos = System.nanoTime();
        timer.mState = State.STARTED;
    }

    public void stop() {
        if (this.mState == State.STARTED) {
            Timer timer = this;
            timer.mState = State.STOPPED;
            timer.mStopTimeNanos = System.nanoTime();
            return;
        }
        throw new IllegalStateException("EventTimer was not started.");
    }

    public long getTime() {
        long l = this.mState == State.STARTED ? System.nanoTime() : this.mStopTimeNanos;
        return TimeUnit.MILLISECONDS.convert(l - this.mStartTimeNanos, TimeUnit.NANOSECONDS);
    }

    private static final class State
    extends Enum<State> {
        public static final /* enum */ State STARTED;
        public static final /* enum */ State STOPPED;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }

        static {
            State state;
            State state2;
            State state3 = state2;
            STARTED = new State();
            State state4 = state;
            STOPPED = new State();
            $VALUES = new State[]{state3, state4};
        }
    }
}

