/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.FrequencyUtils;
import com.tradplus.ads.mobileads.f;
import com.tradplus.ads.mobileads.util.TradPlusDataConstants;
import com.tradplus.ads.mobileads.util.d;
import com.tradplus.ads.network.OnConfigListener;
import com.tradplus.ads.network.response.ConfigResponse;
import com.tradplus.ads.volley.VolleyError;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigLoadManager {
    private static ConfigLoadManager a = null;
    private ConcurrentHashMap<String, ConfigResponse> b = new ConcurrentHashMap();

    private ConfigLoadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ConfigLoadManager getInstance() {
        if (a != null) return a;
        Class<ConfigLoadManager> clazz = ConfigLoadManager.class;
        synchronized (ConfigLoadManager.class) {
            if (a != null) return a;
            a = new ConfigLoadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    public ConfigResponse getLocalConfigResponse(String string) {
        ConfigResponse configResponse = this.b.get(string);
        if (configResponse != null) {
            return configResponse;
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        configResponse = f.a().b(context, string, TradPlusDataConstants.CACHETRADPLUSTYPE);
        if (configResponse != null) {
            this.b.put(string, configResponse);
        }
        return configResponse;
    }

    public void loadConfig(final String string, final ConfigLoadListener configLoadListener) {
        final Context context = GlobalTradPlus.getInstance().getContext();
        ConfigResponse configResponse = this.b.get(string);
        if (configResponse != null) {
            configLoadListener.onSuccess(configResponse);
            this.a(context, string, configResponse);
            return;
        }
        d d2 = new d(context, string);
        d2.a(new OnConfigListener(){

            @Override
            public void onSuccess(ConfigResponse configResponse) {
                ConfigLoadManager.this.a(context, string, configResponse);
                if (configLoadListener == null) {
                    return;
                }
                if (configResponse != null) {
                    ConfigLoadManager.this.b.put(string, configResponse);
                    FrequencyUtils.getInstance().saveFrequency(context, configResponse.getFrequency(), string, TradPlusDataConstants.CACHETRADPLUSTYPE);
                    FrequencyUtils.getInstance().saveFrequencyLoadTime(context, string, TradPlusDataConstants.CACHETRADPLUSTYPE);
                    configLoadListener.onSuccess(configResponse);
                } else {
                    configLoadListener.onFailed(new VolleyError());
                }
            }

            @Override
            public void onFailed(VolleyError volleyError) {
                configLoadListener.onFailed(volleyError);
            }
        });
        d2.a(true);
    }

    public void setDefaultConfig(String string, String string2) {
        if (string2 == null || string2.length() <= 0) {
            return;
        }
        Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig getLocalConfig start---------");
        ConfigResponse configResponse = this.getLocalConfigResponse(string);
        Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig getLocalConfig end---------");
        if (configResponse != null) {
            return;
        }
        if (string2.contains("\n")) {
            string2 = string2.replaceAll("\n", "");
            string2 = string2.replaceAll("\r", "");
            string2 = string2.replaceAll(" ", "");
        }
        try {
            byte[] byArray = Base64.decode((byte[])string2.getBytes(), (int)0);
            String string3 = new String(byArray, "utf-8");
            Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig decode ========");
            ConfigResponse configResponse2 = JSON.parseObject(string3, ConfigResponse.class);
            if (configResponse2 != null) {
                Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig success ========");
                this.b.put(string, configResponse2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig error ==========");
        }
    }

    public String getCurrentConfig(String string) {
        ConfigResponse configResponse = this.getLocalConfigResponse(string);
        if (configResponse == null) {
            return "";
        }
        String string2 = "";
        try {
            String string3 = JSON.toJSONString(configResponse);
            string2 = Base64.encodeToString((byte[])string3.getBytes(), (int)0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private boolean a(Context context, final String string, ConfigResponse configResponse) {
        if (configResponse == null) {
            return true;
        }
        if (d.a(configResponse.getCreateTime(), configResponse.getExpires())) {
            d d2 = new d(context, string);
            d2.a(new OnConfigListener(){

                @Override
                public void onSuccess(ConfigResponse configResponse) {
                    if (configResponse != null) {
                        ConfigLoadManager.this.b.put(string, configResponse);
                    }
                }

                @Override
                public void onFailed(VolleyError volleyError) {
                }
            });
            d2.a();
            return true;
        }
        return false;
    }

    public static interface ConfigLoadListener {
        public void onSuccess(ConfigResponse var1);

        public void onFailed(VolleyError var1);
    }
}

