/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.os.AsyncTask;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.DiskLruCache;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Streams;
import com.tradplus.ads.common.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CacheService {
    private static DiskLruCache a;

    public static boolean initializeDiskCache(Context context) {
        if (context == null) {
            return false;
        }
        if (a == null) {
            File file = CacheService.getDiskCacheDirectory(context);
            if (file == null) {
                return false;
            }
            long l2 = DeviceUtils.diskCacheSizeBytes(file);
            try {
                a = DiskLruCache.open(file, 1, 1, l2);
            }
            catch (IOException iOException) {
                LogUtil.show("Unable to create DiskLruCache", iOException);
                return false;
            }
        }
        return true;
    }

    public static void initialize(Context context) {
        CacheService.initializeDiskCache(context);
    }

    public static String createValidDiskCacheKey(String string) {
        return Utils.sha1(string);
    }

    @Nullable
    public static File getDiskCacheDirectory(@NonNull Context context) {
        File file = context.getCacheDir();
        if (file == null) {
            return null;
        }
        String string = file.getPath();
        return new File(string + File.separator + "flute-cache");
    }

    public static boolean containsKeyDiskCache(String string) {
        if (a == null) {
            return false;
        }
        try {
            DiskLruCache.Snapshot snapshot = a.get(CacheService.createValidDiskCacheKey(string));
            return snapshot != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getFilePathDiskCache(String string) {
        if (a == null) {
            return null;
        }
        return a.getDirectory() + File.separator + CacheService.createValidDiskCacheKey(string) + "." + 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFromDiskCache(String string) {
        byte[] byArray;
        block12: {
            if (a == null) {
                return null;
            }
            byArray = null;
            try (DiskLruCache.Snapshot snapshot = null;){
                snapshot = a.get(CacheService.createValidDiskCacheKey(string));
                if (snapshot == null) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                InputStream inputStream = snapshot.getInputStream(0);
                if (inputStream == null) break block12;
                byArray = new byte[(int)snapshot.getLength(0)];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                try {
                    Streams.readStream(bufferedInputStream, byArray);
                }
                finally {
                    Streams.closeStream(bufferedInputStream);
                }
            }
        }
        return byArray;
    }

    public static void getFromDiskCacheAsync(String string, DiskLruCacheGetListener diskLruCacheGetListener) {
        new a(string, diskLruCacheGetListener).execute(new Void[0]);
    }

    public static boolean putToDiskCache(String string, byte[] byArray) {
        return CacheService.putToDiskCache(string, new ByteArrayInputStream(byArray));
    }

    public static boolean putToDiskCache(String string, InputStream inputStream) {
        if (a == null) {
            return false;
        }
        DiskLruCache.Editor editor = null;
        try {
            editor = a.edit(CacheService.createValidDiskCacheKey(string));
            if (editor == null) {
                return false;
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(editor.newOutputStream(0));
            Streams.copyContent(inputStream, bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
            a.flush();
            editor.commit();
        }
        catch (Exception exception) {
            LogUtil.show("Unable to put to DiskLruCache", exception);
            try {
                if (editor != null) {
                    editor.abort();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static void putToDiskCacheAsync(String string, byte[] byArray) {
        new b(string, byArray).execute(new Void[0]);
    }

    @Deprecated
    @VisibleForTesting
    public static void clearAndNullCaches() {
        if (a != null) {
            try {
                a.delete();
                a = null;
            }
            catch (IOException iOException) {
                a = null;
            }
        }
    }

    @Deprecated
    @VisibleForTesting
    public static DiskLruCache getDiskLruCache() {
        return a;
    }

    private static class b
    extends AsyncTask<Void, Void, Void> {
        private final String a;
        private final byte[] b;

        b(String string, byte[] byArray) {
            this.a = string;
            this.b = byArray;
        }

        protected Void a(Void ... voidArray) {
            CacheService.putToDiskCache(this.a, this.b);
            return null;
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }

    private static class a
    extends AsyncTask<Void, Void, byte[]> {
        private final DiskLruCacheGetListener a;
        private final String b;

        a(String string, DiskLruCacheGetListener diskLruCacheGetListener) {
            this.a = diskLruCacheGetListener;
            this.b = string;
        }

        protected byte[] a(Void ... voidArray) {
            return CacheService.getFromDiskCache(this.b);
        }

        protected void a(byte[] byArray) {
            if (this.isCancelled()) {
                this.onCancelled();
                return;
            }
            if (this.a != null) {
                this.a.onComplete(this.b, byArray);
            }
        }

        protected void onCancelled() {
            if (this.a != null) {
                this.a.onComplete(this.b, null);
            }
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((byte[])object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }

    public static interface DiskLruCacheGetListener {
        public void onComplete(String var1, byte[] var2);
    }
}

