/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.BaseUrlGenerator;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.DateAndTime;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.util.SegmentUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class FSAdUrlGenerator
extends BaseUrlGenerator {
    private static final String AD_UNIT_ID_KEY = "x";
    private static final String AD_CAMPAIGN_ID_KEY = "campaign_id";
    private static final String AD_ADTYPE_KEY = "adtype";
    private static final String DEVICE_CONTYPE_KEY = "device_contype";
    private static final String DEVICE_TYPE_KEY = "device_type";
    private static final String DEVICE_MAKE_KEY = "device_make";
    private static final String DEVICE_MODEL_KEY = "device_model";
    private static final String DEVICE_OS_KEY = "device_os";
    private static final String DEVICE_OSV_KEY = "device_osv";
    private static final String SCREEN_H_KEY = "screen_h";
    private static final String SCREEN_W_KEY = "screen_w";
    private static final String SCREEN_ORIENTATION_KEY = "screen_orientation";
    private static final String CREATIVE_ORIENTATION_KEY = "creative_orientation";
    private static final String SDK_VERSION_KEY = "sdkv";
    private static final String CP_SDK_VERSION_KEY = "sdk_version";
    private static final String KEYWORDS_KEY = "q";
    private static final String LAT_LONG_KEY = "ll";
    private static final String LAT_LONGITUDE_KEY = "lo";
    private static final String LAT_LATITUDE_KEY = "la";
    private static final String LAT_LONG_ACCURACY_KEY = "lla";
    private static final String LAT_LONG_FRESHNESS_KEY = "llf";
    private static final String LAT_LONG_FROM_SDK_KEY = "llsdk";
    private static final String TIMEZONE_OFFSET_KEY = "z";
    private static final String ORIENTATION_KEY = "o";
    private static final String SCREEN_SCALE_KEY = "sc";
    private static final String IS_MRAID_KEY = "mr";
    private static final String MOBILE_COUNTRY_CODE_KEY = "mcc";
    private static final String MOBILE_NETWORK_CODE_KEY = "mnc";
    private static final String COUNTRY_CODE_KEY = "iso";
    private static final String CARRIER_NAME_KEY = "cn";
    private static final String CARRIER_TYPE_KEY = "ct";
    private static final String BUNDLE_ID_KEY = "m";
    private static final String PACKAGE_KEY = "package";
    private static final String DEVICE_ID_KEY = "imei";
    private static final String MAC_ADDRESS_KEY = "mac";
    private static final String ANDROID_ID_KEY = "aid";
    private static final String ADVERTISING_ID_KEY = "aaid";
    private static final String DEVICE_AAID_KEY = "device_aaid";
    private static final String DEVICE_OIAD_KEY = "device_oaid";
    private static final String ANDROID_ID_FOR_JSTAG_KEY = "did";
    private static final String ADVERTISING_ID_FOR_JSTAG_KEY = "ddid";
    private static final String BRAND_KEY = "br";
    private static final String MODEL_KEY = "dn";
    private static final String SCREEN_WIDTH_KEY = "sw";
    private static final String SCREEN_HEIGHT_KEY = "sh";
    private static final String ADVERTISING_LIMITED_KEY = "lmt";
    private static final String LANGUAGE_CODE_KEY = "l";
    private static final String ROM_CODE_KEY = "rom";
    private static final String ROM_VERSION_KEY = "romv";
    private static final String OS_KEY = "os";
    private static final String APPID = "appid";
    private static final String TPUID = "tpguid";
    protected Context mContext;
    protected String mAdUnitId;
    protected String mKeywords;
    protected Location mLocation;
    protected String mCampaignId;
    protected String mAdType;
    protected String deviceContype;
    protected int creative_orientation;

    public FSAdUrlGenerator(Context context) {
        this.mContext = context;
    }

    public FSAdUrlGenerator withAdUnitId(String string) {
        this.mAdUnitId = string;
        return this;
    }

    public FSAdUrlGenerator withAdCampaignIdId(String string) {
        this.mCampaignId = string;
        return this;
    }

    public FSAdUrlGenerator withAdOrientation(int n2) {
        this.creative_orientation = n2;
        return this;
    }

    public FSAdUrlGenerator withAdType(String string) {
        this.mAdType = string;
        return this;
    }

    public FSAdUrlGenerator withKeywords(String string) {
        this.mKeywords = string;
        return this;
    }

    public FSAdUrlGenerator withLocation(Location location) {
        this.mLocation = location;
        return this;
    }

    protected void setDeviceConType(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(DEVICE_CONTYPE_KEY, string);
        }
    }

    protected void setAdType(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(AD_ADTYPE_KEY, string);
        }
    }

    protected void setAdCampaignId(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(AD_CAMPAIGN_ID_KEY, string);
        }
    }

    protected void setAdUnitId(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(AD_UNIT_ID_KEY, string);
        }
    }

    protected void setDeviceType(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(DEVICE_TYPE_KEY, string);
        }
    }

    protected void setDeviceMake(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(DEVICE_MAKE_KEY, string);
        }
    }

    protected void setDeviceModel(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(DEVICE_MODEL_KEY, string);
        }
    }

    protected void setDeviceOS(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(DEVICE_OS_KEY, string);
        }
    }

    protected void setDeviceOSV(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(DEVICE_OSV_KEY, string);
        }
    }

    protected void setScreenHeight(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(SCREEN_H_KEY, string);
        }
    }

    protected void setScreenWidth(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(SCREEN_W_KEY, string);
        }
    }

    protected void setScreenOrientation(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(SCREEN_ORIENTATION_KEY, string);
        }
    }

    protected void setCreativeOrientation(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(CREATIVE_ORIENTATION_KEY, string);
        }
    }

    protected void setCPSdkVersion(String string) {
        this.addParam(CP_SDK_VERSION_KEY, string);
    }

    protected void setSdkVersion(String string) {
        this.addParam(SDK_VERSION_KEY, string);
    }

    protected void setKeywords(String string) {
        this.addParam(KEYWORDS_KEY, string);
    }

    protected void setLocation(@Nullable Location location) {
        Location location2 = location;
        if (location2 != null) {
            this.addParam(LAT_LONGITUDE_KEY, location2.getLongitude());
            this.addParam(LAT_LATITUDE_KEY, location2.getLatitude());
        }
    }

    protected void setTimezone(String string) {
        this.addParam(TIMEZONE_OFFSET_KEY, string);
    }

    protected void setOrientation(int n2) {
        this.addParam(ORIENTATION_KEY, n2);
    }

    protected void setDensity(float f2) {
        this.addParam(SCREEN_SCALE_KEY, Float.valueOf(f2));
    }

    protected void setMraidFlag(boolean bl) {
        if (bl) {
            this.addParam(IS_MRAID_KEY, "1");
        }
    }

    protected void setMccCode(String string) {
        String string2 = string == null ? "" : string.substring(0, this.mncPortionLength(string));
        this.addParam(MOBILE_COUNTRY_CODE_KEY, string2);
    }

    protected void setMncCode(String string) {
        String string2 = string == null ? "" : string.substring(this.mncPortionLength(string));
        this.addParam(MOBILE_NETWORK_CODE_KEY, string2);
    }

    protected void setIsoCountryCode(String string) {
        this.addParam(COUNTRY_CODE_KEY, string);
    }

    protected void setCarrierName(String string) {
        this.addParam(CARRIER_NAME_KEY, string);
    }

    protected void setNetworkType(int n2) {
        this.addParam(CARRIER_TYPE_KEY, n2);
    }

    protected void setBundleId(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(BUNDLE_ID_KEY, string);
        }
    }

    protected void setPackageName(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(PACKAGE_KEY, string);
        }
    }

    protected void setDeviceId(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(DEVICE_ID_KEY, string);
        }
    }

    protected void setMacAddress(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(MAC_ADDRESS_KEY, string);
        }
    }

    protected void setAndroidId(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(ANDROID_ID_KEY, string);
        }
    }

    protected void setAdvertisingId(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(ADVERTISING_ID_KEY, string);
        }
    }

    protected void setAndroidIdForJstagKey(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(ANDROID_ID_FOR_JSTAG_KEY, string);
        }
    }

    protected void setAdvertisingIdForJstagKey(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(ADVERTISING_ID_FOR_JSTAG_KEY, string);
        }
    }

    protected void setDeviceGaidKey(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(DEVICE_AAID_KEY, string);
        }
    }

    protected void setDeviceOiadKey(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(DEVICE_OIAD_KEY, string);
        }
    }

    protected void setBrand(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(BRAND_KEY, string);
        }
    }

    protected void setModel(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(MODEL_KEY, string);
        }
    }

    protected void setScreenSize(int n2, int n3) {
        this.addParam(SCREEN_WIDTH_KEY, n2);
        this.addParam(SCREEN_HEIGHT_KEY, n3);
    }

    protected void setAdvertisingLimited(int n2) {
        this.addParam(ADVERTISING_LIMITED_KEY, n2);
    }

    protected void setLanguageCode(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(LANGUAGE_CODE_KEY, string);
        }
    }

    protected void setRomCode(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(ROM_CODE_KEY, string);
        }
    }

    protected void setRomVersion(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(ROM_VERSION_KEY, string);
        }
    }

    protected void setOsKey(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(OS_KEY, string);
        }
    }

    protected void setAppid(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(APPID, string);
        }
    }

    protected void setTPUid(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.addParam(TPUID, string);
        }
    }

    protected void addCPBaseParams(ClientMetadata clientMetadata) {
        this.setAdCampaignId(this.mCampaignId);
        this.setCreativeOrientation(this.creative_orientation + "");
        this.setAdType(this.mAdType);
        this.setCPSdkVersion(clientMetadata.getSdkVersion());
        this.setAndroidIdForJstagKey(clientMetadata.getAndroidId());
        this.setAdvertisingIdForJstagKey(clientMetadata.getAdvertisingId());
        this.setDeviceGaidKey(clientMetadata.getAdvertisingId());
        this.setDeviceOiadKey(clientMetadata.getOaid());
        this.setIsoCountryCode(clientMetadata.getIsoCountryCode());
        this.setPackageName(clientMetadata.getAppPackageName());
        this.setDeviceConType(clientMetadata.getDeviceCounByType() + "");
        this.setDeviceType(clientMetadata.getDeviceType());
        this.setDeviceMake(Build.BRAND);
        this.setDeviceModel(Build.MODEL);
        this.setDeviceOS("1");
        this.setDeviceOSV(Build.VERSION.RELEASE);
        this.setScreenHeight(String.valueOf(DeviceUtils.getScreenHeight(this.mContext)));
        this.setScreenWidth(String.valueOf(DeviceUtils.getScreenWidth(this.mContext)));
        this.setScreenOrientation(DeviceUtils.getScreenOrientation(this.mContext));
        this.setTPUid(clientMetadata.getTpGuid());
    }

    protected void addBaseParams(ClientMetadata clientMetadata, boolean bl) {
        this.setSdkVersion(clientMetadata.getSdkVersion());
        this.setAdUnitId(this.mAdUnitId);
        this.setDeviceId(clientMetadata.getImei());
        this.setOsKey("1");
        this.setAndroidId(clientMetadata.getAndroidId());
        if (!bl) {
            this.setAdvertisingId(clientMetadata.getAdvertisingId());
            this.setAdvertisingIdForJstagKey(clientMetadata.getAdvertisingId());
            this.setDeviceGaidKey(clientMetadata.getAdvertisingId());
            this.setDeviceOiadKey(clientMetadata.getOaid());
        }
        this.setAndroidIdForJstagKey(clientMetadata.getAndroidId());
        this.setBrand(Build.BRAND);
        this.setModel(Build.MODEL);
        this.setBundleId(clientMetadata.getAppPackageName());
        this.setNetworkType(clientMetadata.getNetworkClassByType());
        this.setCarrierName(clientMetadata.getNetworkOperatorName());
        String string = clientMetadata.getNetworkOperatorForUrl();
        this.setMccCode(string);
        this.setMncCode(string);
        this.setLocation(this.mLocation);
        this.setScreenSize(clientMetadata.getWidthPixels(), clientMetadata.getHeightPixels());
        this.setAdvertisingLimited(clientMetadata.getAdvertisingLimited());
        this.setIsoCountryCode(clientMetadata.getIsoCountryCode());
        this.setDensity(clientMetadata.getDensity());
        this.setTimezone(DateAndTime.getTimeZoneOffsetString());
        this.setLanguageCode(clientMetadata.getLanguageCode());
        this.setOrientation(clientMetadata.getOrientationInt(this.mContext));
        this.setRomCode(Build.MANUFACTURER);
        this.setRomVersion(Build.VERSION.INCREMENTAL);
        this.setAppid(TradPlus.getAppId());
        this.setTPUid(clientMetadata.getTpGuid());
    }

    protected void addCustomMapParamsToOpen() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (SegmentUtils.customMap != null) {
            hashMap.putAll(SegmentUtils.customMap);
        }
        for (int i2 = 0; i2 < SegmentUtils.fieldProtection.length; ++i2) {
            if (hashMap.get(SegmentUtils.fieldProtection[i2]) == null) continue;
            hashMap.remove(SegmentUtils.fieldProtection[i2]);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            this.addParam(string, string2);
        }
    }

    protected void addCustomMapParams() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (SegmentUtils.customMap != null) {
            hashMap.putAll(SegmentUtils.customMap);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAdUnitId) && SegmentUtils.customPlacementMap != null && SegmentUtils.customPlacementMap.get(this.mAdUnitId) != null) {
            hashMap.putAll(SegmentUtils.customPlacementMap.get(this.mAdUnitId));
        }
        for (String string : hashMap.keySet()) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SEGENMENT_TAG, string + " : " + (String)hashMap.get(string) + ", AdUnitId:" + this.mAdUnitId);
        }
        for (int i2 = 0; i2 < SegmentUtils.fieldProtection.length; ++i2) {
            if (hashMap.get(SegmentUtils.fieldProtection[i2]) == null) continue;
            hashMap.remove(SegmentUtils.fieldProtection[i2]);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            this.addParam(string, string2);
        }
    }

    protected void addDefaultMap(ClientMetadata clientMetadata) {
        this.addParam("app_ver", clientMetadata.getAppVersion());
        this.addParam("app_instime", clientMetadata.getFirstInstallTime());
        this.addParam(DEVICE_OSV_KEY, clientMetadata.getDeviceOsVersion());
        this.addParam(DEVICE_TYPE_KEY, clientMetadata.getDeviceType());
        this.addParam(DEVICE_MAKE_KEY, Build.BRAND);
        this.addParam(DEVICE_MODEL_KEY, Build.MODEL);
        this.addParam(DEVICE_CONTYPE_KEY, clientMetadata.getDeviceCounByType());
    }

    private void addParam(String string, ClientMetadata.MoPubNetworkType moPubNetworkType) {
        this.addParam(string, moPubNetworkType.toString());
    }

    private int mncPortionLength(String string) {
        return Math.min(3, string.length());
    }

    private static int calculateLocationStalenessInMilliseconds(Location location) {
        Preconditions.checkNotNull(location);
        long l2 = location.getTime();
        long l3 = System.currentTimeMillis();
        return (int)(l3 - l2);
    }
}

