/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.os.AsyncTask;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.SharedPreferencesHelper;
import com.tradplus.ads.common.factories.MethodBuilderFactory;
import com.tradplus.ads.common.util.AsyncTasks;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Reflection;
import java.lang.ref.WeakReference;

public class GpsHelper {
    public static final int GOOGLE_PLAY_SUCCESS_CODE = 0;
    public static final String ADVERTISING_ID_KEY = "advertisingId";
    public static final String IS_LIMIT_AD_TRACKING_ENABLED_KEY = "isLimitAdTrackingEnabled";
    private static String a = "com.google.android.gms.common.GooglePlayServicesUtil";
    private static String b = "com.google.android.gms.ads.identifier.AdvertisingIdClient";

    public static boolean isPlayServicesAvailable(Context context) {
        try {
            Reflection.MethodBuilder methodBuilder = MethodBuilderFactory.create(null, "isGooglePlayServicesAvailable").setStatic(Class.forName(a)).addParam(Context.class, context);
            Object object = methodBuilder.execute();
            return object != null && (Integer)object == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLimitAdTrackingEnabled(Context context) {
        boolean bl = false;
        if (GpsHelper.isPlayServicesAvailable(context)) {
            return SharedPreferencesHelper.getSharedPreferences(context).getBoolean(IS_LIMIT_AD_TRACKING_ENABLED_KEY, false);
        }
        return false;
    }

    static boolean a(Context context) {
        return ClientMetadata.getInstance(context).isAdvertisingInfoSet();
    }

    public static void fetchAdvertisingInfoAsync(Context context, GpsHelperListener gpsHelperListener) {
        boolean bl = GpsHelper.isPlayServicesAvailable(context);
        if (bl && !GpsHelper.a(context)) {
            GpsHelper.a(context, gpsHelperListener);
        } else {
            if (gpsHelperListener != null) {
                gpsHelperListener.onFetchAdInfoCompleted();
            }
            if (bl) {
                GpsHelper.a(context, null);
            }
        }
    }

    @Nullable
    public static AdvertisingInfo fetchAdvertisingInfoSync(Context context) {
        Object object;
        if (context == null) {
            return null;
        }
        Object object2 = null;
        try {
            object = MethodBuilderFactory.create(null, "getAdvertisingIdInfo").setStatic(Class.forName(b)).addParam(Context.class, context);
            object2 = ((Reflection.MethodBuilder)object).execute();
        }
        catch (Exception exception) {
            LogUtil.show("Unable to obtain Google AdvertisingIdClient.Info via reflection.");
            return null;
        }
        object = GpsHelper.a(object2, null);
        boolean bl = GpsHelper.a(object2, false);
        return new AdvertisingInfo((String)object, bl);
    }

    private static void a(Context context, GpsHelperListener gpsHelperListener) {
        block4: {
            if (!Reflection.classFound(b)) {
                if (gpsHelperListener != null) {
                    gpsHelperListener.onFetchAdInfoCompleted();
                }
                return;
            }
            try {
                AsyncTasks.safeExecuteOnExecutor(new a(context, gpsHelperListener), new Void[0]);
            }
            catch (Exception exception) {
                LogUtil.show("Error executing FetchAdvertisingInfoTask", exception);
                if (gpsHelperListener == null) break block4;
                gpsHelperListener.onFetchAdInfoCompleted();
            }
        }
    }

    static void a(Context context, Object object) {
        String string = GpsHelper.a(object, null);
        boolean bl = GpsHelper.a(object, false);
        ClientMetadata clientMetadata = ClientMetadata.getInstance(context);
        clientMetadata.setAdvertisingInfo(string, bl);
    }

    static String a(Object object, String string) {
        try {
            return (String)MethodBuilderFactory.create(object, "getId").execute();
        }
        catch (Exception exception) {
            return string;
        }
    }

    static boolean a(Object object, boolean bl) {
        try {
            Boolean bl2 = (Boolean)MethodBuilderFactory.create(object, IS_LIMIT_AD_TRACKING_ENABLED_KEY).execute();
            return bl2 != null ? bl2 : bl;
        }
        catch (Exception exception) {
            return bl;
        }
    }

    @Deprecated
    public static void setClassNamesForTesting() {
        String string;
        a = string = "java.lang.Class";
        b = string;
    }

    private static class a
    extends AsyncTask<Void, Void, Void> {
        private WeakReference<Context> a;
        private WeakReference<GpsHelperListener> b;

        public a(Context context, GpsHelperListener gpsHelperListener) {
            this.a = new WeakReference<Context>(context);
            this.b = new WeakReference<GpsHelperListener>(gpsHelperListener);
        }

        protected Void a(Void ... voidArray) {
            try {
                Context context = (Context)this.a.get();
                if (context == null) {
                    return null;
                }
                Reflection.MethodBuilder methodBuilder = MethodBuilderFactory.create(null, "getAdvertisingIdInfo").setStatic(Class.forName(b)).addParam(Context.class, context);
                Object object = methodBuilder.execute();
                if (object != null) {
                    GpsHelper.a(context, object);
                }
            }
            catch (Exception exception) {
                LogUtil.show("Unable to obtain Google AdvertisingIdClient.Info via reflection.");
            }
            return null;
        }

        protected void a(Void void_) {
            GpsHelperListener gpsHelperListener = (GpsHelperListener)this.b.get();
            if (gpsHelperListener != null) {
                gpsHelperListener.onFetchAdInfoCompleted();
            }
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((Void)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }

    public static interface GpsHelperListener {
        public void onFetchAdInfoCompleted();
    }

    public static class AdvertisingInfo {
        public final String advertisingId;
        public final boolean limitAdTracking;

        public AdvertisingInfo(String string, boolean bl) {
            this.advertisingId = string;
            this.limitAdTracking = bl;
        }
    }
}

