/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.toolbox.ImageLoader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class NativeImageHelper {
    public static void preCacheImages(@NonNull Context context, @NonNull List<String> list, final @NonNull ImageListener imageListener) {
        ImageLoader imageLoader = Networking.getImageLoader(context);
        final AtomicInteger atomicInteger = new AtomicInteger(list.size());
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        ImageLoader.ImageListener imageListener2 = new ImageLoader.ImageListener(){

            @Override
            public void onResponse(ImageLoader.ImageContainer imageContainer, boolean bl) {
                int n2;
                if (imageContainer.getBitmap() != null && (n2 = atomicInteger.decrementAndGet()) == 0 && !atomicBoolean.get()) {
                    imageListener.onImagesCached();
                }
            }

            @Override
            public void onErrorResponse(VolleyError volleyError) {
                LogUtil.show("Failed to download a native ads image:", volleyError);
                boolean bl = atomicBoolean.getAndSet(true);
                atomicInteger.decrementAndGet();
                if (!bl) {
                    imageListener.onImagesFailedToCache(TradPlusErrorCode.IMAGE_DOWNLOAD_FAILURE);
                }
            }
        };
        for (String string : list) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                atomicBoolean.set(true);
                imageListener.onImagesFailedToCache(TradPlusErrorCode.IMAGE_DOWNLOAD_FAILURE);
                return;
            }
            imageLoader.get(string, imageListener2);
        }
    }

    public static void loadImageView(@Nullable String string, final @Nullable ImageView imageView) {
        if (!Preconditions.NoThrow.checkNotNull(imageView, "Cannot load image into null ImageView")) {
            return;
        }
        if (!Preconditions.NoThrow.checkNotNull(string, "Cannot load image with null url")) {
            imageView.setImageDrawable(null);
            return;
        }
        ImageLoader imageLoader = Networking.getImageLoader(imageView.getContext());
        imageLoader.get(string, new ImageLoader.ImageListener(){

            @Override
            public void onResponse(ImageLoader.ImageContainer imageContainer, boolean bl) {
                if (!bl) {
                    LogUtil.show("Image was not loaded immediately into your ad view. You should call preCacheImages as part of your custom event loading process.");
                }
                imageView.setImageBitmap(imageContainer.getBitmap());
            }

            @Override
            public void onErrorResponse(VolleyError volleyError) {
                LogUtil.show("Failed to load image.", volleyError);
                imageView.setImageDrawable(null);
            }
        });
    }

    public static interface ImageListener {
        public void onImagesCached();

        public void onImagesFailedToCache(TradPlusErrorCode var1);
    }
}

