/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.os.Looper;
import com.tradplus.ads.common.util.LogUtil;
import java.util.IllegalFormatException;

public final class Preconditions {
    public static final String EMPTY_ARGUMENTS = "";

    private Preconditions() {
    }

    public static void checkArgument(boolean bl) {
        Preconditions.c(bl, true, "Illegal argument.", EMPTY_ARGUMENTS);
    }

    public static void checkArgument(boolean bl, String string) {
        Preconditions.c(bl, true, string, EMPTY_ARGUMENTS);
    }

    public static void checkArgument(boolean bl, String string, Object ... objectArray) {
        Preconditions.c(bl, true, string, objectArray);
    }

    public static void checkState(boolean bl) {
        Preconditions.d(bl, true, "Illegal state.", EMPTY_ARGUMENTS);
    }

    public static void checkState(boolean bl, String string) {
        Preconditions.d(bl, true, string, EMPTY_ARGUMENTS);
    }

    public static void checkState(boolean bl, String string, Object ... objectArray) {
        Preconditions.d(bl, true, string, objectArray);
    }

    public static void checkNotNull(Object object) {
        Preconditions.b(object, true, "Object can not be null.", EMPTY_ARGUMENTS);
    }

    public static void checkNotNull(Object object, String string) {
        Preconditions.b(object, true, string, EMPTY_ARGUMENTS);
    }

    public static void checkNotNull(Object object, String string, Object ... objectArray) {
        Preconditions.b(object, true, string, objectArray);
    }

    public static void checkUiThread() {
        Preconditions.b(true, "This method must be called from the UI thread.", EMPTY_ARGUMENTS);
    }

    public static void checkUiThread(String string) {
        Preconditions.b(true, string, EMPTY_ARGUMENTS);
    }

    public static void checkUiThread(String string, Object ... objectArray) {
        Preconditions.b(true, string, objectArray);
    }

    private static boolean c(boolean bl, boolean bl2, String string, Object ... objectArray) {
        if (bl) {
            return true;
        }
        String string2 = Preconditions.a(string, objectArray);
        if (bl2) {
            throw new IllegalArgumentException(string2);
        }
        LogUtil.show(string2);
        return false;
    }

    private static boolean d(boolean bl, boolean bl2, String string, Object ... objectArray) {
        if (bl) {
            return true;
        }
        String string2 = Preconditions.a(string, objectArray);
        if (bl2) {
            throw new IllegalStateException(string2);
        }
        LogUtil.show(string2);
        return false;
    }

    private static boolean b(Object object, boolean bl, String string, Object ... objectArray) {
        if (object != null) {
            return true;
        }
        String string2 = Preconditions.a(string, objectArray);
        if (bl) {
            throw new NullPointerException(string2);
        }
        LogUtil.show(string2);
        return false;
    }

    private static boolean b(boolean bl, String string, Object ... objectArray) {
        if (Looper.getMainLooper().equals(Looper.myLooper())) {
            return true;
        }
        String string2 = Preconditions.a(string, objectArray);
        if (bl) {
            throw new IllegalStateException(string2);
        }
        LogUtil.show(string2);
        return false;
    }

    private static String a(String string, Object ... objectArray) {
        string = String.valueOf(string);
        try {
            return String.format(string, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            LogUtil.show("TradPlus preconditions had a format exception: " + illegalFormatException.getMessage());
            return string;
        }
    }

    public static final class NoThrow {
        private static volatile boolean a = false;

        public static void setStrictMode(boolean bl) {
            a = bl;
        }

        public static boolean checkArgument(boolean bl) {
            return Preconditions.c(bl, NoThrow.a, "Illegal argument", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkArgument(boolean bl, String string) {
            return Preconditions.c(bl, NoThrow.a, string, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkArgument(boolean bl, String string, Object ... objectArray) {
            return Preconditions.c(bl, NoThrow.a, string, objectArray);
        }

        public static boolean checkState(boolean bl) {
            return Preconditions.d(bl, NoThrow.a, "Illegal state.", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkState(boolean bl, String string) {
            return Preconditions.d(bl, NoThrow.a, string, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkState(boolean bl, String string, Object ... objectArray) {
            return Preconditions.d(bl, NoThrow.a, string, objectArray);
        }

        public static boolean checkNotNull(Object object) {
            return Preconditions.b(object, NoThrow.a, "Object can not be null.", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkNotNull(Object object, String string) {
            return Preconditions.b(object, NoThrow.a, string, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkNotNull(Object object, String string, Object ... objectArray) {
            return Preconditions.b(object, NoThrow.a, string, objectArray);
        }

        public static boolean checkUiThread() {
            return Preconditions.b(NoThrow.a, "This method must be called from the UI thread.", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkUiThread(String string) {
            return Preconditions.b(NoThrow.a, string, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkUiThread(String string, Object ... objectArray) {
            return Preconditions.b(false, string, objectArray);
        }
    }
}

