/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Views;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class VisibilityTracker {
    @NonNull
    private final ArrayList<View> c;
    private long d = 0L;
    @NonNull
    @VisibleForTesting
    final ViewTreeObserver.OnPreDrawListener a;
    @NonNull
    @VisibleForTesting
    WeakReference<ViewTreeObserver> b;
    @NonNull
    private final Map<View, a> e;
    @NonNull
    private final VisibilityChecker f;
    @Nullable
    private VisibilityTrackerListener g;
    @NonNull
    private final b h;
    @NonNull
    private final Handler i;
    private boolean j;

    public VisibilityTracker(@NonNull Context context) {
        this(context, new WeakHashMap<View, a>(10), new VisibilityChecker(), new Handler());
    }

    @VisibleForTesting
    VisibilityTracker(@NonNull Context context, @NonNull Map<View, a> map, @NonNull VisibilityChecker visibilityChecker, @NonNull Handler handler) {
        this.e = map;
        this.f = visibilityChecker;
        this.i = handler;
        this.h = new b();
        this.c = new ArrayList(50);
        this.a = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                VisibilityTracker.this.scheduleVisibilityCheck();
                return true;
            }
        };
        this.b = new WeakReference<Object>(null);
        this.a(context, null);
    }

    private void a(@Nullable Context context, @Nullable View view) {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.b.get();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            return;
        }
        View view2 = Views.getTopmostView(context, view);
        if (view2 == null) {
            LogUtil.show("Unable to set Visibility Tracker due to no available root view.");
            return;
        }
        ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
        if (!viewTreeObserver2.isAlive()) {
            LogUtil.show("Visibility Tracker was unable to track views because the root view tree observer was not alive");
            return;
        }
        this.b = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
        viewTreeObserver2.addOnPreDrawListener(this.a);
    }

    public void setVisibilityTrackerListener(@Nullable VisibilityTrackerListener visibilityTrackerListener) {
        this.g = visibilityTrackerListener;
    }

    public void addView(@NonNull View view, int n2, @Nullable Integer n3) {
        this.addView(view, view, n2, n3);
    }

    public void addView(@NonNull View view, @NonNull View view2, int n2, @Nullable Integer n3) {
        this.addView(view, view2, n2, n2, n3);
    }

    public void addView(@NonNull View view, @NonNull View view2, int n2, int n3, @Nullable Integer n4) {
        this.a(view2.getContext(), view2);
        a a2 = this.e.get(view2);
        if (a2 == null) {
            a2 = new a();
            this.e.put(view2, a2);
            this.scheduleVisibilityCheck();
        }
        int n5 = Math.min(n3, n2);
        a2.d = view;
        a2.a = n2;
        a2.b = n5;
        a2.c = this.d++;
        a2.e = n4;
        if (this.d % 50L == 0L) {
            this.a(this.d - 50L);
        }
    }

    private void a(long l2) {
        for (Map.Entry<View, a> view : this.e.entrySet()) {
            if (view.getValue().c >= l2) continue;
            this.c.add(view.getKey());
        }
        for (View view : this.c) {
            this.removeView(view);
        }
        this.c.clear();
    }

    public void removeView(@NonNull View view) {
        this.e.remove(view);
    }

    public void clear() {
        this.e.clear();
        this.i.removeMessages(0);
        this.j = false;
    }

    public void destroy() {
        this.clear();
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.b.get();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            viewTreeObserver.removeOnPreDrawListener(this.a);
        }
        this.b.clear();
        this.g = null;
    }

    public void scheduleVisibilityCheck() {
        if (this.j) {
            return;
        }
        this.j = true;
        this.i.postDelayed((Runnable)this.h, 100L);
    }

    public static class VisibilityChecker {
        private final Rect a = new Rect();

        public boolean hasRequiredTimeElapsed(long l2, int n2) {
            return SystemClock.uptimeMillis() - l2 >= (long)n2;
        }

        public boolean isVisible(@Nullable View view, @Nullable View view2, int n2, @Nullable Integer n3) {
            if (view2 == null || view2.getVisibility() != 0 || view.getParent() == null) {
                return false;
            }
            if (!view2.getGlobalVisibleRect(this.a)) {
                return false;
            }
            long l2 = (long)this.a.height() * (long)this.a.width();
            long l3 = (long)view2.getHeight() * (long)view2.getWidth();
            if (l3 <= 0L) {
                return false;
            }
            if (n3 != null && n3 > 0) {
                return l2 >= (long)n3.intValue();
            }
            return 100L * l2 >= (long)n2 * l3;
        }
    }

    class b
    implements Runnable {
        @NonNull
        private final ArrayList<View> b;
        @NonNull
        private final ArrayList<View> c = new ArrayList();

        b() {
            this.b = new ArrayList();
        }

        @Override
        public void run() {
            VisibilityTracker.this.j = false;
            for (Map.Entry entry : VisibilityTracker.this.e.entrySet()) {
                View view = (View)entry.getKey();
                int n2 = ((a)entry.getValue()).a;
                int n3 = ((a)entry.getValue()).b;
                Integer n4 = ((a)entry.getValue()).e;
                View view2 = ((a)entry.getValue()).d;
                if (VisibilityTracker.this.f.isVisible(view2, view, n2, n4)) {
                    this.b.add(view);
                    continue;
                }
                if (VisibilityTracker.this.f.isVisible(view2, view, n3, null)) continue;
                this.c.add(view);
            }
            if (VisibilityTracker.this.g != null) {
                VisibilityTracker.this.g.onVisibilityChanged(this.b, this.c);
            }
            this.b.clear();
            this.c.clear();
        }
    }

    static class a {
        int a;
        int b;
        long c;
        View d;
        @Nullable
        Integer e;

        a() {
        }
    }

    public static interface VisibilityTrackerListener {
        public void onVisibilityChanged(List<View> var1, List<View> var2);
    }
}

