/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class BaseEvent {
    @NonNull
    private final ScribeCategory a;
    @NonNull
    private final Name b;
    @NonNull
    private final Category c;
    @Nullable
    private final SdkProduct d;
    @Nullable
    private final String e;
    @Nullable
    private final String f;
    @Nullable
    private final String g;
    @Nullable
    private final String h;
    @Nullable
    private final Double i;
    @Nullable
    private final Double j;
    @Nullable
    private final String k;
    @Nullable
    private final Integer l;
    @Nullable
    private final Integer m;
    @Nullable
    private final Double n;
    @Nullable
    private final Double o;
    @Nullable
    private final Double p;
    @Nullable
    private final ClientMetadata.MoPubNetworkType q;
    @Nullable
    private final String r;
    @Nullable
    private final String s;
    @Nullable
    private final String t;
    @Nullable
    private final String u;
    @Nullable
    private final String v;
    @Nullable
    private final String w;
    @Nullable
    private final Double x;
    @Nullable
    private final String y;
    @Nullable
    private final Integer z;
    @Nullable
    private final String A;
    @Nullable
    private final Integer B;
    private final long C;
    @Nullable
    private ClientMetadata D;
    private final double E;

    public BaseEvent(@NonNull Builder builder) {
        Preconditions.checkNotNull(builder);
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
        this.d = builder.d;
        this.e = builder.e;
        this.f = builder.f;
        this.g = builder.g;
        this.h = builder.h;
        this.i = builder.i;
        this.j = builder.j;
        this.k = builder.k;
        this.n = builder.l;
        this.o = builder.m;
        this.p = builder.n;
        this.x = builder.o;
        this.y = builder.p;
        this.z = builder.q;
        this.A = builder.r;
        this.B = builder.s;
        this.E = builder.t;
        this.C = System.currentTimeMillis();
        this.D = ClientMetadata.getInstance();
        if (this.D != null) {
            this.l = this.D.getDeviceScreenWidthDip();
            this.m = this.D.getDeviceScreenHeightDip();
            this.q = this.D.getActiveNetworkType();
            this.r = this.D.getNetworkOperator();
            this.s = this.D.getNetworkOperatorName();
            this.t = this.D.getIsoCountryCode();
            this.u = this.D.getSimOperator();
            this.v = this.D.getSimOperatorName();
            this.w = this.D.getSimIsoCountryCode();
        } else {
            this.l = null;
            this.m = null;
            this.q = null;
            this.r = null;
            this.s = null;
            this.t = null;
            this.u = null;
            this.v = null;
            this.w = null;
        }
    }

    @NonNull
    public ScribeCategory getScribeCategory() {
        return this.a;
    }

    @NonNull
    public Name getName() {
        return this.b;
    }

    @NonNull
    public Category getCategory() {
        return this.c;
    }

    @Nullable
    public SdkProduct getSdkProduct() {
        return this.d;
    }

    @Nullable
    public String getSdkVersion() {
        return this.D == null ? null : this.D.getSdkVersion();
    }

    @Nullable
    public String getAdUnitId() {
        return this.e;
    }

    @Nullable
    public String getAdCreativeId() {
        return this.f;
    }

    @Nullable
    public String getDspCreativeId() {
        return this.k;
    }

    @Nullable
    public String getAdType() {
        return this.g;
    }

    @Nullable
    public String getAdNetworkType() {
        return this.h;
    }

    @Nullable
    public Double getAdWidthPx() {
        return this.i;
    }

    @Nullable
    public Double getAdHeightPx() {
        return this.j;
    }

    @Nullable
    public AppPlatform getAppPlatform() {
        return AppPlatform.ANDROID;
    }

    @Nullable
    public String getAppName() {
        return this.D == null ? null : this.D.getAppName();
    }

    @Nullable
    public String getAppPackageName() {
        return this.D == null ? null : this.D.getAppPackageName();
    }

    @Nullable
    public String getAppVersion() {
        return this.D == null ? null : this.D.getAppVersion();
    }

    @Nullable
    public String getClientAdvertisingId() {
        return this.D == null ? null : this.D.getDeviceId();
    }

    @NonNull
    public String getObfuscatedClientAdvertisingId() {
        return "ifa:XXXX";
    }

    @NonNull
    public Boolean getClientDoNotTrack() {
        return this.D == null || this.D.isDoNotTrackSet();
    }

    @Nullable
    public String getDeviceManufacturer() {
        return this.D == null ? null : this.D.getDeviceManufacturer();
    }

    @Nullable
    public String getDeviceModel() {
        return this.D == null ? null : this.D.getDeviceModel();
    }

    @Nullable
    public String getDeviceProduct() {
        return this.D == null ? null : this.D.getDeviceProduct();
    }

    @Nullable
    public String getDeviceOsVersion() {
        return this.D == null ? null : this.D.getDeviceOsVersion();
    }

    @Nullable
    public Integer getDeviceScreenWidthDip() {
        return this.l;
    }

    @Nullable
    public Integer getDeviceScreenHeightDip() {
        return this.m;
    }

    @Nullable
    public Double getGeoLat() {
        return this.n;
    }

    @Nullable
    public Double getGeoLon() {
        return this.o;
    }

    @Nullable
    public Double getGeoAccuracy() {
        return this.p;
    }

    @Nullable
    public Double getPerformanceDurationMs() {
        return this.x;
    }

    @Nullable
    public ClientMetadata.MoPubNetworkType getNetworkType() {
        return this.q;
    }

    @Nullable
    public String getNetworkOperatorCode() {
        return this.r;
    }

    @Nullable
    public String getNetworkOperatorName() {
        return this.s;
    }

    @Nullable
    public String getNetworkIsoCountryCode() {
        return this.t;
    }

    @Nullable
    public String getNetworkSimCode() {
        return this.u;
    }

    @Nullable
    public String getNetworkSimOperatorName() {
        return this.v;
    }

    @Nullable
    public String getNetworkSimIsoCountryCode() {
        return this.w;
    }

    @Nullable
    public String getRequestId() {
        return this.y;
    }

    @Nullable
    public Integer getRequestStatusCode() {
        return this.z;
    }

    @Nullable
    public String getRequestUri() {
        return this.A;
    }

    @Nullable
    public Integer getRequestRetries() {
        return this.B;
    }

    public double getSamplingRate() {
        return this.E;
    }

    @NonNull
    public Long getTimestampUtcMs() {
        return this.C;
    }

    public String toString() {
        return "BaseEvent\nScribeCategory: " + (Object)((Object)this.getScribeCategory()) + "\nName: " + (Object)((Object)this.getName()) + "\nCategory: " + (Object)((Object)this.getCategory()) + "\nSdkProduct: " + (Object)((Object)this.getSdkProduct()) + "\nSdkVersion: " + this.getSdkVersion() + "\nAdUnitId: " + this.getAdUnitId() + "\nAdCreativeId: " + this.getAdCreativeId() + "\nAdType: " + this.getAdType() + "\nAdNetworkType: " + this.getAdNetworkType() + "\nAdWidthPx: " + this.getAdWidthPx() + "\nAdHeightPx: " + this.getAdHeightPx() + "\nDspCreativeId: " + this.getDspCreativeId() + "\nAppPlatform: " + (Object)((Object)this.getAppPlatform()) + "\nAppName: " + this.getAppName() + "\nAppPackageName: " + this.getAppPackageName() + "\nAppVersion: " + this.getAppVersion() + "\nDeviceManufacturer: " + this.getDeviceManufacturer() + "\nDeviceModel: " + this.getDeviceModel() + "\nDeviceProduct: " + this.getDeviceProduct() + "\nDeviceOsVersion: " + this.getDeviceOsVersion() + "\nDeviceScreenWidth: " + this.getDeviceScreenWidthDip() + "\nDeviceScreenHeight: " + this.getDeviceScreenHeightDip() + "\nGeoLat: " + this.getGeoLat() + "\nGeoLon: " + this.getGeoLon() + "\nGeoAccuracy: " + this.getGeoAccuracy() + "\nPerformanceDurationMs: " + this.getPerformanceDurationMs() + "\nNetworkType: " + (Object)((Object)this.getNetworkType()) + "\nNetworkOperatorCode: " + this.getNetworkOperatorCode() + "\nNetworkOperatorName: " + this.getNetworkOperatorName() + "\nNetworkIsoCountryCode: " + this.getNetworkIsoCountryCode() + "\nNetworkSimCode: " + this.getNetworkSimCode() + "\nNetworkSimOperatorName: " + this.getNetworkSimOperatorName() + "\nNetworkSimIsoCountryCode: " + this.getNetworkSimIsoCountryCode() + "\nRequestId: " + this.getRequestId() + "\nRequestStatusCode: " + this.getRequestStatusCode() + "\nRequestUri: " + this.getRequestUri() + "\nRequestRetries: " + this.getRequestRetries() + "\nSamplingRate: " + this.getSamplingRate() + "\nTimestampUtcMs: " + new SimpleDateFormat().format(new Date(this.getTimestampUtcMs())) + "\n";
    }

    public static abstract class Builder {
        @NonNull
        private ScribeCategory a;
        @NonNull
        private Name b;
        @NonNull
        private Category c;
        @Nullable
        private SdkProduct d;
        @Nullable
        private String e;
        @Nullable
        private String f;
        @Nullable
        private String g;
        @Nullable
        private String h;
        @Nullable
        private Double i;
        @Nullable
        private Double j;
        @Nullable
        private String k;
        @Nullable
        private Double l;
        @Nullable
        private Double m;
        @Nullable
        private Double n;
        @Nullable
        private Double o;
        @Nullable
        private String p;
        @Nullable
        private Integer q;
        @Nullable
        private String r;
        @Nullable
        private Integer s;
        private double t;

        public Builder(@NonNull ScribeCategory scribeCategory, @NonNull Name name, @NonNull Category category, double d2) {
            Preconditions.checkNotNull((Object)scribeCategory);
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)category);
            Preconditions.checkArgument(d2 >= 0.0 && d2 <= 1.0);
            this.a = scribeCategory;
            this.b = name;
            this.c = category;
            this.t = d2;
        }

        @NonNull
        public Builder withSdkProduct(@Nullable SdkProduct sdkProduct) {
            this.d = sdkProduct;
            return this;
        }

        @NonNull
        public Builder withAdUnitId(@Nullable String string) {
            this.e = string;
            return this;
        }

        @NonNull
        public Builder withAdCreativeId(@Nullable String string) {
            this.f = string;
            return this;
        }

        @NonNull
        public Builder withAdType(@Nullable String string) {
            this.g = string;
            return this;
        }

        @NonNull
        public Builder withAdNetworkType(@Nullable String string) {
            this.h = string;
            return this;
        }

        @NonNull
        public Builder withAdWidthPx(@Nullable Double d2) {
            this.i = d2;
            return this;
        }

        @NonNull
        public Builder withAdHeightPx(@Nullable Double d2) {
            this.j = d2;
            return this;
        }

        @NonNull
        public Builder withDspCreativeId(@Nullable String string) {
            this.k = string;
            return this;
        }

        @NonNull
        public Builder withGeoLat(@Nullable Double d2) {
            this.l = d2;
            return this;
        }

        @NonNull
        public Builder withGeoLon(@Nullable Double d2) {
            this.m = d2;
            return this;
        }

        @NonNull
        public Builder withGeoAccuracy(@Nullable Double d2) {
            this.n = d2;
            return this;
        }

        @NonNull
        public Builder withPerformanceDurationMs(@Nullable Double d2) {
            this.o = d2;
            return this;
        }

        @NonNull
        public Builder withRequestId(@Nullable String string) {
            this.p = string;
            return this;
        }

        @NonNull
        public Builder withRequestStatusCode(@Nullable Integer n2) {
            this.q = n2;
            return this;
        }

        @NonNull
        public Builder withRequestUri(@Nullable String string) {
            this.r = string;
            return this;
        }

        @NonNull
        public Builder withRequestRetries(@Nullable Integer n2) {
            this.s = n2;
            return this;
        }

        public abstract BaseEvent build();
    }

    public static enum SamplingRate {
        AD_REQUEST(0.1),
        NATIVE_VIDEO(0.1),
        AD_INTERACTIONS(0.1);

        private final double a;

        private SamplingRate(double d2) {
            this.a = d2;
        }

        public double getSamplingRate() {
            return this.a;
        }
    }

    public static enum Category {
        REQUESTS("requests"),
        NATIVE_VIDEO("native_video"),
        AD_INTERACTIONS("ad_interactions");

        @NonNull
        private final String a;

        private Category(@NonNull String string2) {
            this.a = string2;
        }

        @NonNull
        public String getCategory() {
            return this.a;
        }
    }

    public static enum Name {
        AD_REQUEST("ad_request"),
        REQ_REQUEST("req_request"),
        IMPRESSION_REQUEST("impression_request"),
        CLICK_REQUEST("click_request"),
        VIDEOFIN_REQUEST("videoFin_request"),
        DOWNLOAD_START("download_start"),
        DOWNLOAD_VIDEO_READY("download_video_ready"),
        DOWNLOAD_BUFFERING("download_video_buffering"),
        DOWNLOAD_FINISHED("download_finished"),
        ERROR_DURING_PLAYBACK("error_during_playback"),
        ERROR_FAILED_TO_PLAY("error_failed_to_play"),
        AD_DWELL_TIME("clickthrough_dwell_time");

        @NonNull
        private final String a;

        private Name(@NonNull String string2) {
            this.a = string2;
        }

        @NonNull
        public String getName() {
            return this.a;
        }
    }

    public static enum AppPlatform {
        NONE(0),
        IOS(1),
        ANDROID(2),
        MOBILE_WEB(3);

        private final int a;

        private AppPlatform(int n3) {
            this.a = n3;
        }

        public int getType() {
            return this.a;
        }
    }

    public static enum SdkProduct {
        NONE(0),
        WEB_VIEW(1),
        NATIVE(2);

        private final int a;

        private SdkProduct(int n3) {
            this.a = n3;
        }

        public int getType() {
            return this.a;
        }
    }

    public static enum ScribeCategory {
        EXCHANGE_CLIENT_EVENT("exchange_client_event"),
        EXCHANGE_CLIENT_ERROR("exchange_client_error");

        @NonNull
        private final String a;

        private ScribeCategory(@NonNull String string2) {
            this.a = string2;
        }

        @NonNull
        public String getCategory() {
            return this.a;
        }
    }
}

