/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONArray;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.TypeReference;
import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.parser.ParserConfig;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class JSONObject
extends JSON
implements Serializable,
Cloneable,
InvocationHandler,
Map<String, Object> {
    private final Map<String, Object> b;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null.");
        }
        this.b = map;
    }

    public JSONObject(boolean bl) {
        this(16, bl);
    }

    public JSONObject(int n2) {
        this(n2, false);
    }

    public JSONObject(int n2, boolean bl) {
        this.b = bl ? new LinkedHashMap<String, Object>(n2) : new HashMap<String, Object>(n2);
    }

    @Override
    public int size() {
        return this.b.size();
    }

    @Override
    public boolean isEmpty() {
        return this.b.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        boolean bl = this.b.containsKey(object);
        if (!bl && (object instanceof Number || object instanceof Character || object instanceof Boolean || object instanceof UUID)) {
            bl = this.b.containsKey(object.toString());
        }
        return bl;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.b.containsValue(object);
    }

    @Override
    public Object get(Object object) {
        Object object2 = this.b.get(object);
        if (object2 == null && (object instanceof Number || object instanceof Character || object instanceof Boolean || object instanceof UUID)) {
            object2 = this.b.get(object.toString());
        }
        return object2;
    }

    public JSONObject getJSONObject(String string) {
        Object object = this.b.get(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object);
        }
        if (object instanceof String) {
            return JSON.parseObject((String)object);
        }
        return (JSONObject)JSONObject.toJSON(object);
    }

    public JSONArray getJSONArray(String string) {
        Object object = this.b.get(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        if (object instanceof String) {
            return (JSONArray)JSON.parse((String)object);
        }
        return (JSONArray)JSONObject.toJSON(object);
    }

    public <T> T getObject(String string, Class<T> clazz) {
        Object object = this.b.get(string);
        return TypeUtils.castToJavaBean(object, clazz);
    }

    public <T> T getObject(String string, Type type) {
        Object object = this.b.get(string);
        return TypeUtils.cast(object, type, ParserConfig.getGlobalInstance());
    }

    public <T> T getObject(String string, TypeReference typeReference) {
        Object object = this.b.get(string);
        if (typeReference == null) {
            return (T)object;
        }
        return TypeUtils.cast(object, typeReference.getType(), ParserConfig.getGlobalInstance());
    }

    public Boolean getBoolean(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return TypeUtils.castToBoolean(object);
    }

    public byte[] getBytes(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return TypeUtils.castToBytes(object);
    }

    public boolean getBooleanValue(String string) {
        Object object = this.get(string);
        Boolean bl = TypeUtils.castToBoolean(object);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public Byte getByte(String string) {
        Object object = this.get(string);
        return TypeUtils.castToByte(object);
    }

    public byte getByteValue(String string) {
        Object object = this.get(string);
        Byte by = TypeUtils.castToByte(object);
        if (by == null) {
            return 0;
        }
        return by;
    }

    public Short getShort(String string) {
        Object object = this.get(string);
        return TypeUtils.castToShort(object);
    }

    public short getShortValue(String string) {
        Object object = this.get(string);
        Short s2 = TypeUtils.castToShort(object);
        if (s2 == null) {
            return 0;
        }
        return s2;
    }

    public Integer getInteger(String string) {
        Object object = this.get(string);
        return TypeUtils.castToInt(object);
    }

    public int getIntValue(String string) {
        Object object = this.get(string);
        Integer n2 = TypeUtils.castToInt(object);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public Long getLong(String string) {
        Object object = this.get(string);
        return TypeUtils.castToLong(object);
    }

    public long getLongValue(String string) {
        Object object = this.get(string);
        Long l2 = TypeUtils.castToLong(object);
        if (l2 == null) {
            return 0L;
        }
        return l2;
    }

    public Float getFloat(String string) {
        Object object = this.get(string);
        return TypeUtils.castToFloat(object);
    }

    public float getFloatValue(String string) {
        Object object = this.get(string);
        Float f2 = TypeUtils.castToFloat(object);
        if (f2 == null) {
            return 0.0f;
        }
        return f2.floatValue();
    }

    public Double getDouble(String string) {
        Object object = this.get(string);
        return TypeUtils.castToDouble(object);
    }

    public double getDoubleValue(String string) {
        Object object = this.get(string);
        Double d2 = TypeUtils.castToDouble(object);
        if (d2 == null) {
            return 0.0;
        }
        return d2;
    }

    public BigDecimal getBigDecimal(String string) {
        Object object = this.get(string);
        return TypeUtils.castToBigDecimal(object);
    }

    public BigInteger getBigInteger(String string) {
        Object object = this.get(string);
        return TypeUtils.castToBigInteger(object);
    }

    public String getString(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public java.util.Date getDate(String string) {
        Object object = this.get(string);
        return TypeUtils.castToDate(object);
    }

    public Date getSqlDate(String string) {
        Object object = this.get(string);
        return TypeUtils.castToSqlDate(object);
    }

    public Timestamp getTimestamp(String string) {
        Object object = this.get(string);
        return TypeUtils.castToTimestamp(object);
    }

    @Override
    public Object put(String string, Object object) {
        return this.b.put(string, object);
    }

    public JSONObject fluentPut(String string, Object object) {
        this.b.put(string, object);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.b.putAll(map);
    }

    public JSONObject fluentPutAll(Map<? extends String, ?> map) {
        this.b.putAll(map);
        return this;
    }

    @Override
    public void clear() {
        this.b.clear();
    }

    public JSONObject fluentClear() {
        this.b.clear();
        return this;
    }

    @Override
    public Object remove(Object object) {
        return this.b.remove(object);
    }

    public JSONObject fluentRemove(Object object) {
        this.b.remove(object);
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.b.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.b.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.b.entrySet();
    }

    public Object clone() {
        return new JSONObject(this.b instanceof LinkedHashMap ? new LinkedHashMap<String, Object>(this.b) : new HashMap<String, Object>(this.b));
    }

    @Override
    public boolean equals(Object object) {
        return this.b.equals(object);
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 1) {
            if (method.getName().equals("equals")) {
                return this.equals(objectArray[0]);
            }
            Class<?> clazz = method.getReturnType();
            if (clazz != Void.TYPE) {
                throw new JSONException("illegal setter");
            }
            String string = null;
            JSONField jSONField = TypeUtils.getAnnotation(method, JSONField.class);
            if (jSONField != null && jSONField.name().length() != 0) {
                string = jSONField.name();
            }
            if (string == null) {
                string = method.getName();
                if (!string.startsWith("set")) {
                    throw new JSONException("illegal setter");
                }
                if ((string = string.substring(3)).length() == 0) {
                    throw new JSONException("illegal setter");
                }
                string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
            }
            this.b.put(string, objectArray[0]);
            return null;
        }
        if (classArray.length == 0) {
            Class<?> clazz = method.getReturnType();
            if (clazz == Void.TYPE) {
                throw new JSONException("illegal getter");
            }
            String string = null;
            JSONField jSONField = TypeUtils.getAnnotation(method, JSONField.class);
            if (jSONField != null && jSONField.name().length() != 0) {
                string = jSONField.name();
            }
            if (string == null) {
                string = method.getName();
                if (string.startsWith("get")) {
                    if ((string = string.substring(3)).length() == 0) {
                        throw new JSONException("illegal getter");
                    }
                    string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
                } else if (string.startsWith("is")) {
                    if ((string = string.substring(2)).length() == 0) {
                        throw new JSONException("illegal getter");
                    }
                    string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
                } else {
                    if (string.startsWith("hashCode")) {
                        return this.hashCode();
                    }
                    if (string.startsWith("toString")) {
                        return this.toString();
                    }
                    throw new JSONException("illegal getter");
                }
            }
            Object object2 = this.b.get(string);
            return TypeUtils.cast(object2, method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        }
        throw new UnsupportedOperationException(method.toGenericString());
    }

    public Map<String, Object> getInnerMap() {
        return this.b;
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) {
        if (clazz == Map.class || clazz == JSONObject.class || clazz == JSON.class) {
            return (T)this;
        }
        if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
            return (T)this;
        }
        return TypeUtils.castToJavaBean(this, clazz, ParserConfig.getGlobalInstance());
    }

    public <T> T toJavaObject(Class<T> clazz, ParserConfig parserConfig, int n2) {
        if (clazz == Map.class) {
            return (T)this;
        }
        if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
            return (T)this;
        }
        return TypeUtils.castToJavaBean(this, clazz, parserConfig);
    }
}

